/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xindice.core;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xindice.core.Collection;
import org.apache.xindice.core.DBException;
import org.apache.xindice.util.Configurable;
import org.apache.xindice.util.Configuration;
import org.apache.xindice.util.ConfigurationCallback;
import org.apache.xindice.util.XindiceException;

public class CollectionManager
implements Configurable {
    private static final Log log = LogFactory.getLog(CollectionManager.class);
    private static final String COLLECTION = "collection";
    private static final String COLLECTIONS = "collections";
    private static final String[] EMPTY_STRINGS = new String[0];
    private static final String NAME = "name";
    private final Map collections = Collections.synchronizedMap(new HashMap());
    private Configuration config;

    protected CollectionManager() {
    }

    protected void addCollection(Collection collection) {
        this.collections.put(collection.getName(), collection);
    }

    public final long countCollections() throws DBException {
        return this.collections.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection createCollection(String path, Configuration cfg) throws DBException {
        if (path == null || "".equals(path)) {
            throw new DBException(270, "Null or empty collection name");
        }
        if (cfg == null) {
            throw new DBException(270, "Error creating collection '" + path + "': null config");
        }
        if (path.indexOf("/") != -1) {
            CollectionManager cm = this;
            StringTokenizer st = new StringTokenizer(path, "/");
            while (cm != null && st.hasMoreTokens()) {
                path = st.nextToken().trim();
                if (path.length() == 0) continue;
                if (st.hasMoreTokens()) {
                    cm = (CollectionManager)cm.collections.get(path);
                    continue;
                }
                return cm.createCollection(path, cfg);
            }
            throw new DBException(200, "Parent Collection '" + path + "' doesn't exist");
        }
        if (path.indexOf(47) != -1) {
            throw new DBException(270, "Name cannot contain '/'");
        }
        Collection collection = new Collection((Collection)this);
        String n = cfg.getAttribute(NAME);
        if (n == null || n.trim().equals("")) {
            throw new DBException(270, "No name specified in collection configuration");
        }
        if (!n.equals(path)) {
            throw new DBException(270, "Name does not match with path name");
        }
        Map map = this.collections;
        synchronized (map) {
            try {
                if (this.getCollection(n) != null) {
                    throw new DBException(240, "Duplicate Collection '" + n + "'");
                }
                Configuration colConfig = this.config.getChild(COLLECTIONS, true);
                colConfig.add(cfg);
                collection.setConfig(cfg);
                collection.create();
                this.collections.put(n, collection);
                if (log.isInfoEnabled()) {
                    log.info((Object)("Created a new collection named '" + n + "'"));
                }
            }
            catch (DBException e) {
                throw e;
            }
            catch (Exception e) {
                throw new DBException(270, "Error Creating Collection '" + path + "'", e);
            }
            return collection;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean close() throws DBException {
        Map map = this.collections;
        synchronized (map) {
            for (Collection collection : this.collections.values()) {
                try {
                    collection.close();
                }
                catch (DBException e) {
                    if (!log.isWarnEnabled()) continue;
                    log.warn((Object)"ignored exception", (Throwable)e);
                }
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean dropCollection(Collection collection) throws DBException {
        if (collection == null) {
            throw new DBException(200, "Collection Value Null");
        }
        Collection cm = collection.getParentCollection();
        if (cm == null) {
            throw new DBException(570, "You Cannot Drop The Database");
        }
        if (cm != this) {
            return cm.dropCollection(collection);
        }
        final String name = collection.getName();
        Map map = this.collections;
        synchronized (map) {
            boolean dropped = collection.drop();
            if (dropped) {
                this.collections.remove(name);
                Configuration colConfig = this.config.getChild(COLLECTIONS);
                colConfig.processChildren(COLLECTION, new ConfigurationCallback(){

                    public void process(Configuration cfg) {
                        block3: {
                            try {
                                if (cfg.getAttribute(CollectionManager.NAME).equals(name)) {
                                    cfg.delete();
                                }
                            }
                            catch (Exception e) {
                                if (!log.isWarnEnabled()) break block3;
                                log.warn((Object)"ignored exception", (Throwable)e);
                            }
                        }
                    }
                });
            }
            return dropped;
        }
    }

    public Collection getCollection(String path) throws DBException {
        if (path == null) {
            return null;
        }
        if (path.indexOf("/") != -1) {
            CollectionManager cm = this;
            StringTokenizer st = new StringTokenizer(path, "/");
            while (cm != null && st.hasMoreTokens()) {
                path = st.nextToken();
                cm = (CollectionManager)cm.collections.get(path);
            }
            return (Collection)cm;
        }
        return (Collection)this.collections.get(path);
    }

    protected Map getCollections() {
        return this.collections;
    }

    public Configuration getConfig() {
        return this.config;
    }

    public final String[] listCollections() throws DBException {
        return this.collections.keySet().toArray(EMPTY_STRINGS);
    }

    public void setConfig(Configuration config) throws XindiceException {
        this.config = config;
        Configuration colConfig = config.getChild(COLLECTIONS);
        if (colConfig != null) {
            colConfig.processChildren(COLLECTION, new ConfigurationCallback(){

                public void process(Configuration cfg) throws XindiceException {
                    Collection col = (Collection)CollectionManager.this.collections.get(cfg.getAttribute(CollectionManager.NAME));
                    if (col == null) {
                        col = new Collection((Collection)CollectionManager.this);
                        col.setConfig(cfg);
                        CollectionManager.this.collections.put(col.getName(), col);
                    }
                }
            });
        }
    }
}

