/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xindice.core;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xindice.core.Collection;
import org.apache.xindice.core.DBException;
import org.apache.xindice.core.Database;
import org.apache.xindice.util.Configuration;
import org.apache.xindice.xml.SymbolTable;
import org.apache.xindice.xml.SymbolTableSymbols;
import org.apache.xindice.xml.dom.DOMParser;
import org.w3c.dom.Document;

public final class SystemCollection
extends Collection {
    private static final Log log = LogFactory.getLog(SystemCollection.class);
    public static final String SYSCOL = "system";
    public static final String SYMBOLS = "SysSymbols";
    public static final String OBJECTS = "SysObjects";
    public static final String CONFIGS = "SysConfig";
    public static final String USERS = "SysUsers";
    public static final String GROUPS = "SysGroups";
    public static final String ACCESS = "SysAccess";
    private static String SYSCOL_DEFINITION = "<collection name='system'>   <collections>      <collection name='SysSymbols' compressed='true'>         <filer class='org.apache.xindice.core.filer.BTreeFiler'/>" + SymbolTableSymbols.getDefinition() + "         <indexes/>      </collection>      <collection name='" + "SysConfig" + "' compressed='false'>         <filer class='org.apache.xindice.core.filer.BTreeFiler' pagecount='16'/>         <indexes/>      </collection>   </collections></collection>";

    public SystemCollection(Database db) {
        super(db);
    }

    void init() throws DBException {
        try {
            Document sysDoc = DOMParser.toDocument(SYSCOL_DEFINITION);
            Configuration sysCfg = new Configuration(sysDoc, false);
            this.setConfig(sysCfg);
        }
        catch (Exception e) {
            log.fatal((Object)"Failed to generate system collection 'system'", (Throwable)e);
            System.exit(1);
        }
    }

    private String getSymbolTableName(Collection col) {
        String name = col.getCanonicalName();
        int idx = name.indexOf(47, 1);
        name = name.substring(idx + 1);
        return name.replace('/', '_');
    }

    public SymbolTable loadSymbols(Collection collection) throws DBException {
        String name = this.getSymbolTableName(collection);
        Collection symCol = this.getCollection(SYMBOLS);
        SymbolTable symbols = (SymbolTable)symCol.getObject(name);
        if (symbols == null) {
            symbols = new SymbolTable();
        }
        return symbols;
    }

    public void saveSymbols(Collection collection, SymbolTable symbols) throws DBException {
        String name = this.getSymbolTableName(collection);
        Collection symCol = this.getCollection(SYMBOLS);
        if (symbols != null) {
            symCol.setObject(name, symbols);
            symbols.setDirty(false);
        }
    }

    public void dropSymbols(Collection collection) throws DBException {
        String name = this.getSymbolTableName(collection);
        Collection symCol = this.getCollection(SYMBOLS);
        try {
            symCol.remove(name);
        }
        catch (DBException e) {
            if (e.faultCode == 201) {
                return;
            }
            throw e;
        }
    }

    public static String getDefinition() {
        return SYSCOL_DEFINITION;
    }
}

