/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xindice.core.filer;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.File;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xindice.core.DBException;
import org.apache.xindice.core.data.Value;
import org.apache.xindice.core.filer.BTreeCallback;
import org.apache.xindice.core.filer.BTreeCorruptException;
import org.apache.xindice.core.filer.BTreeException;
import org.apache.xindice.core.filer.BTreeNotFoundException;
import org.apache.xindice.core.filer.Paged;
import org.apache.xindice.core.indexer.IndexPattern;
import org.apache.xindice.core.indexer.IndexQuery;
import org.apache.xindice.xml.SymbolTableSymbols;

public class BTree
extends Paged {
    private static final BTreeNotFoundException notFoundException = new BTreeNotFoundException("Value not found");
    private static final Log log = LogFactory.getLog(BTree.class);
    protected static final byte LEAF = 1;
    protected static final byte BRANCH = 2;
    protected static final byte STREAM = 3;
    private final Map<Paged.PageKey, WeakReference<BTreeNode>> cache = new WeakHashMap<Paged.PageKey, WeakReference<BTreeNode>>();
    private BTreeFileHeader fileHeader;
    private BTreeRootInfo rootInfo;
    private BTreeNode rootNode;
    private final ConcurrentLinkedQueue<ByteBuffer> BUFFER_POOL = new ConcurrentLinkedQueue();

    public BTree() {
        this.fileHeader = (BTreeFileHeader)this.getFileHeader();
    }

    public BTree(File file) {
        this();
        this.setFile(file);
    }

    public boolean open() throws DBException {
        if (super.open()) {
            long p = this.fileHeader.getRootPage();
            this.rootInfo = new BTreeRootInfo(p);
            this.rootNode = this.getBTreeNode(p, null);
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean create() throws DBException {
        block6: {
            if (super.create()) {
                try {
                    super.open();
                    Paged.Page p = this.getFreePage();
                    long pn = p.getPageNum();
                    this.fileHeader.setRootPage(pn);
                    this.rootInfo = new BTreeRootInfo(pn);
                    this.rootNode = new BTreeNode(p, null, new Value[0], new long[0]);
                    this.rootNode.ph.setStatus((byte)1);
                    this.rootNode.write();
                    Map<Paged.PageKey, WeakReference<BTreeNode>> map = this.cache;
                    synchronized (map) {
                        this.cache.put(this.rootNode.page, new WeakReference<BTreeNode>(this.rootNode));
                    }
                    this.close();
                    return true;
                }
                catch (Exception e) {
                    if (!log.isWarnEnabled()) break block6;
                    log.warn((Object)"Failed to create BTree, return false", (Throwable)e);
                }
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean close() throws DBException {
        boolean closed = super.close();
        if (closed) {
            Map<Paged.PageKey, WeakReference<BTreeNode>> map = this.cache;
            synchronized (map) {
                this.cache.clear();
            }
        }
        return closed;
    }

    public long addKey(Value value) throws IOException, BTreeException {
        return this.getRootNode().addKey(value);
    }

    public long[] addKeys(Value[] values) throws IOException, DBException {
        return this.getRootNode().addKeys(values);
    }

    public long addValue(Value value, long pointer) throws IOException, BTreeException {
        return this.getRootNode().addValue(value, pointer);
    }

    public long addValue(BTreeRootInfo root, Value value, long pointer) throws IOException, BTreeException {
        return this.getRootNode(root).addValue(value, pointer);
    }

    public long removeValue(Value value) throws IOException, BTreeException {
        return this.getRootNode().removeValue(value);
    }

    public long removeValue(BTreeRootInfo root, Value value) throws IOException, BTreeException {
        return this.getRootNode(root).removeValue(value);
    }

    public long findValue(Value value) throws IOException, BTreeException {
        return this.getRootNode().findValue(value);
    }

    public long findValue(BTreeRootInfo root, Value value) throws IOException, BTreeException {
        return this.getRootNode(root).findValue(value);
    }

    public void query(IndexQuery query, BTreeCallback callback) throws IOException, BTreeException {
        this.getRootNode().query(query, callback);
    }

    public void query(BTreeRootInfo root, IndexQuery query, BTreeCallback callback) throws IOException, BTreeException {
        this.getRootNode(root).query(query, callback);
    }

    protected final BTreeRootInfo createBTreeRoot(Value v) throws IOException, BTreeException {
        BTreeNode n = this.createBTreeNode((byte)1, null);
        n.write();
        long position = n.page.getPageNum();
        this.addValue(v, position);
        return new BTreeRootInfo(v, position);
    }

    protected final BTreeRootInfo createBTreeRoot(BTreeRootInfo root, Value v) throws IOException, BTreeException {
        BTreeNode n = this.createBTreeNode((byte)1, null);
        n.write();
        long position = n.page.getPageNum();
        this.addValue(v, position);
        return new BTreeRootInfo(root, v, position);
    }

    protected final BTreeRootInfo findBTreeRoot(Value v) throws IOException, BTreeException {
        long position = this.findValue(v);
        return new BTreeRootInfo(v, position);
    }

    protected final BTreeRootInfo findBTreeRoot(BTreeRootInfo root, Value v) throws IOException, BTreeException {
        long position = this.findValue(root, v);
        return new BTreeRootInfo(root, v, position);
    }

    protected final void setRootNode(BTreeRootInfo root, BTreeNode newRoot) throws IOException, BTreeException {
        BTreeRootInfo parent = root.getParent();
        if (parent == null) {
            this.rootNode = newRoot;
            long p = this.rootNode.page.getPageNum();
            this.rootInfo.setPage(p);
            this.fileHeader.setRootPage(p);
        } else {
            long p = newRoot.page.getPageNum();
            root.setPage(p);
            this.addValue(parent, root.name, p);
        }
    }

    protected final void setRootNode(BTreeNode rootNode) throws IOException, BTreeException {
        this.setRootNode(this.rootInfo, rootNode);
    }

    protected final BTreeNode getRootNode(BTreeRootInfo root) {
        if (root.page == this.rootInfo.page) {
            return this.rootNode;
        }
        return this.getBTreeNode(root.getPage(), null);
    }

    protected final BTreeNode getRootNode() {
        return this.rootNode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BTreeNode getBTreeNode(long page, BTreeNode parent) {
        try {
            BTreeNode node = null;
            Map<Paged.PageKey, WeakReference<BTreeNode>> map = this.cache;
            synchronized (map) {
                WeakReference<BTreeNode> ref = this.cache.get(new Paged.PageKey(page));
                if (ref != null) {
                    node = (BTreeNode)ref.get();
                }
                if (node == null) {
                    node = new BTreeNode(this.getPage(page), parent);
                } else {
                    node.parent = parent;
                }
                this.cache.put(node.page, new WeakReference<BTreeNode>(node));
                node.read();
            }
            return node;
        }
        catch (Exception e) {
            if (log.isWarnEnabled()) {
                log.warn((Object)"Ignored exception", (Throwable)e);
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BTreeNode createBTreeNode(byte status, BTreeNode parent) throws IOException {
        Paged.Page p = this.getFreePage();
        BTreeNode node = new BTreeNode(p, parent, new Value[0], new long[0]);
        node.ph.setStatus(status);
        Map<Paged.PageKey, WeakReference<BTreeNode>> map = this.cache;
        synchronized (map) {
            this.cache.put(p, new WeakReference<BTreeNode>(node));
        }
        return node;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BTreeNode createBTreeNode(byte status, BTreeNode parent, Value[] values, long[] pointers) throws IOException {
        Paged.Page p = this.getFreePage();
        BTreeNode node = new BTreeNode(p, parent, values, pointers);
        node.ph.setStatus(status);
        Map<Paged.PageKey, WeakReference<BTreeNode>> map = this.cache;
        synchronized (map) {
            this.cache.put(p, new WeakReference<BTreeNode>(node));
        }
        return node;
    }

    protected Paged.FileHeader createFileHeader() {
        return new BTreeFileHeader();
    }

    protected Paged.PageHeader createPageHeader() {
        return new BTreePageHeader();
    }

    protected class BTreePageHeader
    extends Paged.PageHeader {
        private short valueCount;

        public BTreePageHeader() {
        }

        public BTreePageHeader(DataInput dis) throws IOException {
            super(dis);
        }

        public synchronized void read(DataInput dis) throws IOException {
            super.read(dis);
            if (this.getStatus() == 0) {
                return;
            }
            this.valueCount = dis.readShort();
        }

        public synchronized void write(DataOutput dos) throws IOException {
            super.write(dos);
            dos.writeShort(this.valueCount);
        }

        public synchronized void read(ByteBuffer buf) throws IOException {
            super.read(buf);
            if (this.getStatus() == 0) {
                return;
            }
            this.valueCount = buf.getShort();
        }

        public synchronized void write(ByteBuffer buf) throws IOException {
            super.write(buf);
            buf.putShort(this.valueCount);
        }

        public final synchronized void setValueCount(short valueCount) {
            this.valueCount = valueCount;
            this.setDirty();
        }

        public final synchronized short getValueCount() {
            return this.valueCount;
        }

        public final synchronized short getPointerCount() {
            if (this.getStatus() == 2) {
                return (short)(this.valueCount + 1);
            }
            return this.valueCount;
        }
    }

    protected class BTreeFileHeader
    extends Paged.FileHeader {
        private long rootPage;

        public BTreeFileHeader() {
            super(BTree.this);
        }

        protected synchronized void read(ByteBuffer bbf) {
            super.read(bbf);
            this.rootPage = bbf.getLong();
        }

        protected synchronized void write(ByteBuffer bbf) {
            super.write(bbf);
            bbf.putLong(this.rootPage);
        }

        public final synchronized void setRootPage(long rootPage) {
            this.rootPage = rootPage;
            this.setDirty();
        }

        public final synchronized long getRootPage() {
            return this.rootPage;
        }
    }

    private final class BTreeNode {
        private final Paged.Page page;
        private final BTreePageHeader ph;
        private Value[] values;
        private long[] ptrs;
        private BTreeNode parent;
        private volatile boolean loaded;
        private ReadWriteLock rwLock = new ReentrantReadWriteLock();

        public BTreeNode(Paged.Page page, BTreeNode parent) {
            this.page = page;
            this.parent = parent;
            this.ph = (BTreePageHeader)page.getPageHeader();
        }

        public BTreeNode(Paged.Page page, BTreeNode parent, Value[] values, long[] ptrs) {
            this(page, parent);
            this.set(values, ptrs);
        }

        private void set(Value[] values, long[] ptrs) {
            this.values = values;
            this.ph.setValueCount((short)values.length);
            this.ptrs = ptrs;
        }

        private void read() throws IOException {
            if (!this.loaded) {
                int i;
                Value v = BTree.this.readValue(this.page);
                ByteBuffer buf = v.getByteBuffer();
                this.values = new Value[this.ph.getValueCount()];
                for (i = 0; i < this.values.length; ++i) {
                    short valSize = buf.getShort();
                    byte[] b = new byte[valSize];
                    buf.get(b);
                    this.values[i] = new Value(b);
                }
                this.ptrs = new long[this.ph.getPointerCount()];
                for (i = 0; i < this.ptrs.length; ++i) {
                    this.ptrs[i] = buf.getLong();
                }
                this.loaded = true;
            }
        }

        public void write() throws IOException {
            this.rwLock.writeLock().lock();
            ByteBuffer buf = null;
            try {
                int i;
                buf = (ByteBuffer)BTree.this.BUFFER_POOL.poll();
                if (buf == null) {
                    buf = ByteBuffer.allocate(BTree.this.fileHeader.getWorkSize());
                } else {
                    buf.rewind();
                }
                for (i = 0; i < this.values.length; ++i) {
                    buf.putShort((short)this.values[i].getLength());
                    this.values[i].streamTo(buf);
                }
                for (i = 0; i < this.ptrs.length; ++i) {
                    buf.putLong(this.ptrs[i]);
                }
                if (this.ph.getStatus() == 2 && this.ptrs.length == this.values.length) {
                    buf.putLong(-1L);
                }
                Value v = buf.position() == 0 ? Value.EMPTY_VALUE : new Value(buf.array(), 0, buf.position());
                BTree.this.writeValue(this.page, v);
                BTree.this.BUFFER_POOL.add(buf);
            }
            finally {
                this.rwLock.writeLock().unlock();
            }
        }

        private BTreeNode getChildNode(int idx) {
            if (this.ph.getStatus() == 2 && idx >= 0 && idx < this.ptrs.length) {
                return BTree.this.getBTreeNode(this.ptrs[idx], this);
            }
            return null;
        }

        public long removeValue(Value value) throws IOException, BTreeException {
            this.rwLock.writeLock().lock();
            try {
                int idx = Arrays.binarySearch(this.values, value);
                switch (this.ph.getStatus()) {
                    case 2: {
                        idx = idx < 0 ? -(idx + 1) : idx + 1;
                        long l = this.getChildNode(idx).removeValue(value);
                        return l;
                    }
                    case 1: {
                        if (idx < 0) {
                            throw new BTreeNotFoundException("Value '" + value + "' doesn't exist");
                        }
                        long oldPtr = this.ptrs[idx];
                        this.set(Paged.deleteArrayValue(this.values, idx), Paged.deleteArrayLong(this.ptrs, idx));
                        this.write();
                        long l = oldPtr;
                        return l;
                    }
                }
                throw new BTreeCorruptException("Invalid page type '" + this.ph.getStatus() + "' in removeValue");
            }
            finally {
                this.rwLock.writeLock().unlock();
            }
        }

        public long addValue(Value value, long pointer) throws IOException, BTreeException {
            this.rwLock.writeLock().lock();
            try {
                if (value == null) {
                    throw new BTreeException(571, "Can't add a null Value");
                }
                int idx = Arrays.binarySearch(this.values, value);
                switch (this.ph.getStatus()) {
                    case 2: {
                        idx = idx < 0 ? -(idx + 1) : idx + 1;
                        long l = this.getChildNode(idx).addValue(value, pointer);
                        return l;
                    }
                    case 1: {
                        if (idx >= 0) {
                            long oldPtr = this.ptrs[idx];
                            this.ptrs[idx] = pointer;
                            this.set(this.values, this.ptrs);
                            this.write();
                            long l = oldPtr;
                            return l;
                        }
                        idx = -(idx + 1);
                        boolean split = this.needSplit(value);
                        this.set(Paged.insertArrayValue(this.values, value, idx), Paged.insertArrayLong(this.ptrs, pointer, idx));
                        if (split) {
                            this.split();
                        } else {
                            this.write();
                        }
                        long l = -1L;
                        return l;
                    }
                }
                throw new BTreeCorruptException("Invalid Page Type In addValue");
            }
            finally {
                this.rwLock.writeLock().unlock();
            }
        }

        public long addKey(Value value) throws IOException, BTreeException {
            this.rwLock.writeLock().lock();
            try {
                if (value == null) {
                    throw new BTreeException(571, "Can't add a null Value");
                }
                int idx = Arrays.binarySearch(this.values, value);
                switch (this.ph.getStatus()) {
                    case 2: {
                        idx = idx < 0 ? -(idx + 1) : idx + 1;
                        long l = this.getChildNode(idx).addKey(value);
                        return l;
                    }
                    case 1: {
                        if (idx >= 0) {
                            long l = this.ptrs[idx];
                            return l;
                        }
                        idx = -(idx + 1);
                        boolean split = this.needSplit(value);
                        long pointer = BTree.this.getFreePage().getPageNum();
                        this.set(Paged.insertArrayValue(this.values, value, idx), Paged.insertArrayLong(this.ptrs, pointer, idx));
                        if (split) {
                            this.split();
                        } else {
                            this.write();
                        }
                        BTree.this.fileHeader.incRecordCount();
                        long l = pointer;
                        return l;
                    }
                }
                throw new BTreeCorruptException("Invalid Page Type In addValue");
            }
            finally {
                this.rwLock.writeLock().unlock();
            }
        }

        private void insertBranches(BTreeNode[] branches) throws IOException, DBException {
            long[] branchPtrs;
            BTreeNode lastBranch = branches[branches.length - 1];
            Value[] branchKeys = new Value[branches.length];
            if (lastBranch.values.length < lastBranch.ptrs.length) {
                branchPtrs = new long[branches.length + 1];
                branchPtrs[branchPtrs.length - 1] = lastBranch.getChildNode((int)lastBranch.values.length).page.getPageNum();
            } else {
                branchPtrs = new long[branches.length];
            }
            for (int bIdx = 0; bIdx < branches.length; ++bIdx) {
                BTreeNode branch = branches[bIdx];
                Value branchKey = bIdx < branches.length - 1 ? branches[bIdx + 1].getLeftValue() : branch.getChildNode(branch.values.length).getLeftValue();
                branchKeys[bIdx] = branchKey;
                branchPtrs[bIdx] = branch.page.getPageNum();
                branch.parent = this;
                branch.write();
            }
            if (this.values.length < this.ptrs.length) {
                Value rightVal = branches[0].getLeftValue();
                this.set(Paged.insertArrayValue(this.values, rightVal, this.values.length), this.ptrs);
            }
            Value[] newValues = new Value[this.values.length + branchKeys.length];
            long[] newPtrs = new long[this.ptrs.length + branchPtrs.length];
            System.arraycopy(this.values, 0, newValues, 0, this.values.length);
            System.arraycopy(this.ptrs, 0, newPtrs, 0, this.ptrs.length);
            System.arraycopy(branchKeys, 0, newValues, this.values.length, branchKeys.length);
            System.arraycopy(branchPtrs, 0, newPtrs, this.ptrs.length, branchPtrs.length);
            this.set(newValues, newPtrs);
            if (this.needSplit(newValues)) {
                this.split();
            } else {
                this.write();
            }
        }

        private Value getLeftValue() {
            if (this.ph.getStatus() == 2) {
                return this.getChildNode(0).getLeftValue();
            }
            return this.values[0];
        }

        private BTreeNode[] paginate(BTreeNode[] children, int pageSize) throws IOException, BTreeException {
            int numParents = children.length / pageSize;
            if (children.length % pageSize != 0) {
                ++numParents;
            }
            BTreeNode[] parents = new BTreeNode[numParents];
            for (int i = 0; i < parents.length; ++i) {
                int numPtrs;
                int numValues;
                if ((i + 1) * pageSize > children.length) {
                    numPtrs = numValues = children.length - i * pageSize;
                } else {
                    numValues = pageSize;
                    numPtrs = numValues + 1;
                }
                if (i == parents.length - 1) {
                    --numValues;
                }
                Value[] parentValues = new Value[numValues];
                long[] parentPointers = new long[numPtrs];
                for (int pIdx = 0; pIdx < numValues; ++pIdx) {
                    int childIdx = i * pageSize + pIdx;
                    Value[] left = children[childIdx].values;
                    Value[] right = children[childIdx + 1].values;
                    parentValues[pIdx] = this.getSeparator(left[left.length - 1], right[0]);
                    parentPointers[pIdx] = children[childIdx].page.getPageNum();
                }
                parentPointers[numValues] = children[i * pageSize + numValues].page.getPageNum();
                parents[i] = BTree.this.createBTreeNode((byte)2, null, parentValues, parentPointers);
                parents[i].write();
                BTree.this.fileHeader.incRecordCount();
                for (int childIdx = 0; childIdx < numValues; ++childIdx) {
                    children[childIdx + i * pageSize].parent = parents[i];
                    children[childIdx + i * pageSize].write();
                }
            }
            if (parents.length > pageSize) {
                return this.paginate(parents, pageSize);
            }
            return parents;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public long[] addKeys(Value[] bulkValues) throws IOException, DBException {
            this.rwLock.writeLock().lock();
            try {
                int leafSize = (BTree.this.getFileHeader().getWorkSize() - 8) / (8 + bulkValues[0].getLength() + 2);
                int numLeaves = bulkValues.length / leafSize;
                if (bulkValues.length % leafSize != 0) {
                    ++numLeaves;
                }
                if (numLeaves == 1) {
                    long[] result = new long[bulkValues.length];
                    for (int i = 0; i < bulkValues.length; ++i) {
                        result[i] = this.addKey(bulkValues[i]);
                    }
                    long[] i = result;
                    return i;
                }
                BTreeNode rootNode = null;
                boolean mergeWithRoot = false;
                if (this == BTree.this.getRootNode()) {
                    if (this.ph.getStatus() == 1) {
                        if (this.values.length != 0) {
                            rootNode = BTree.this.createBTreeNode((byte)2, null, new Value[0], new long[0]);
                            BTree.this.setRootNode(rootNode);
                            rootNode.write();
                            mergeWithRoot = true;
                        } else {
                            this.ph.setStatus((byte)2);
                            rootNode = this;
                        }
                    } else if (this.values.length != 0) {
                        rootNode = BTree.this.createBTreeNode((byte)2, null, new Value[0], new long[0]);
                        BTree.this.setRootNode(rootNode);
                        rootNode.write();
                        mergeWithRoot = true;
                    } else {
                        rootNode = this;
                    }
                } else {
                    throw new BTreeException(90, "Unsupported Operation");
                }
                long[] result = new long[bulkValues.length];
                BTreeNode[] leaves = new BTreeNode[numLeaves];
                for (int i = 0; i < numLeaves; ++i) {
                    int len = (i + 1) * leafSize > bulkValues.length ? bulkValues.length - i * leafSize : leafSize;
                    Value[] leafValues = new Value[len];
                    long[] leafPtrs = new long[len];
                    System.arraycopy(bulkValues, i * leafSize, leafValues, 0, len);
                    for (int j = 0; j < leafPtrs.length; ++j) {
                        leafPtrs[j] = BTree.this.getFreePage().getPageNum();
                    }
                    System.arraycopy(leafPtrs, 0, result, i * leafSize, leafPtrs.length);
                    BTreeNode leaf = BTree.this.createBTreeNode((byte)1, null, leafValues, leafPtrs);
                    leaf.write();
                    leaves[i] = leaf;
                    BTree.this.fileHeader.incRecordCount();
                }
                BTreeNode[] parents = rootNode.paginate(leaves, leafSize);
                rootNode.insertBranches(parents);
                if (mergeWithRoot) {
                    this.query(new IndexQuery(new IndexPattern(SymbolTableSymbols.getInstance(), -2)), new BTreeInsertCallback(rootNode));
                }
                BTree.this.flush();
                long[] lArray = result;
                return lArray;
            }
            finally {
                this.rwLock.writeLock().unlock();
            }
        }

        private void promoteValue(Value value, long rightPointer) throws IOException, BTreeException {
            boolean split = this.needSplit(value);
            int idx = Arrays.binarySearch(this.values, value);
            idx = idx < 0 ? -(idx + 1) : idx + 1;
            this.set(Paged.insertArrayValue(this.values, value, idx), Paged.insertArrayLong(this.ptrs, rightPointer, idx + 1));
            if (split) {
                this.split();
            } else {
                this.write();
            }
        }

        private Value getSeparator(Value value1, Value value2) {
            if (value1.compareTo(value2) <= 0) {
                return new Value(value2);
            }
            return new Value(value1);
        }

        private boolean needSplit(Value value) {
            return this.ph.getDataLen() + 8 + value.getLength() + 2 > BTree.this.fileHeader.getWorkSize();
        }

        private boolean needSplit(Value[] values) {
            return this.ph.getDataLen() + 8 + (values[0].getLength() + 2) * values.length > BTree.this.fileHeader.getWorkSize();
        }

        private void split() throws IOException, BTreeException {
            Value separator;
            long[] rightPtrs;
            Value[] rightVals;
            long[] leftPtrs;
            Value[] leftVals;
            short vc = this.ph.getValueCount();
            int pivot = vc / 2;
            switch (this.ph.getStatus()) {
                case 2: {
                    leftVals = new Value[pivot];
                    leftPtrs = new long[leftVals.length + 1];
                    rightVals = new Value[vc - (pivot + 1)];
                    rightPtrs = new long[rightVals.length + 1];
                    System.arraycopy(this.values, 0, leftVals, 0, leftVals.length);
                    System.arraycopy(this.ptrs, 0, leftPtrs, 0, leftPtrs.length);
                    System.arraycopy(this.values, leftVals.length + 1, rightVals, 0, rightVals.length);
                    System.arraycopy(this.ptrs, leftPtrs.length, rightPtrs, 0, rightPtrs.length);
                    separator = this.values[leftVals.length];
                    break;
                }
                case 1: {
                    leftVals = new Value[pivot];
                    leftPtrs = new long[leftVals.length];
                    rightVals = new Value[vc - pivot];
                    rightPtrs = new long[rightVals.length];
                    System.arraycopy(this.values, 0, leftVals, 0, leftVals.length);
                    System.arraycopy(this.ptrs, 0, leftPtrs, 0, leftPtrs.length);
                    System.arraycopy(this.values, leftVals.length, rightVals, 0, rightVals.length);
                    System.arraycopy(this.ptrs, leftPtrs.length, rightPtrs, 0, rightPtrs.length);
                    separator = this.getSeparator(leftVals[leftVals.length - 1], rightVals[0]);
                    break;
                }
                default: {
                    throw new BTreeCorruptException("Invalid Page Type In split");
                }
            }
            if (this.parent == null) {
                BTreeNode rNode = BTree.this.createBTreeNode(this.ph.getStatus(), this);
                rNode.set(rightVals, rightPtrs);
                BTreeNode lNode = BTree.this.createBTreeNode(this.ph.getStatus(), this);
                lNode.set(leftVals, leftPtrs);
                this.ph.setStatus((byte)2);
                this.set(new Value[]{separator}, new long[]{lNode.page.getPageNum(), rNode.page.getPageNum()});
                this.write();
                rNode.write();
                lNode.write();
            } else {
                this.set(leftVals, leftPtrs);
                BTreeNode rNode = BTree.this.createBTreeNode(this.ph.getStatus(), this.parent);
                rNode.set(rightVals, rightPtrs);
                this.write();
                rNode.write();
                this.parent.promoteValue(separator, rNode.page.getPageNum());
            }
        }

        public long findValue(Value value) throws IOException, BTreeException {
            this.rwLock.readLock().lock();
            try {
                if (value == null) {
                    throw notFoundException;
                }
                int idx = Arrays.binarySearch(this.values, value);
                switch (this.ph.getStatus()) {
                    case 2: {
                        idx = idx < 0 ? -(idx + 1) : idx + 1;
                        long l = this.getChildNode(idx).findValue(value);
                        return l;
                    }
                    case 1: {
                        if (idx < 0) {
                            throw notFoundException;
                        }
                        long l = this.ptrs[idx];
                        return l;
                    }
                }
                throw new BTreeCorruptException("Invalid page type '" + this.ph.getStatus() + "' in findValue");
            }
            finally {
                this.rwLock.readLock().unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void query(IndexQuery query, BTreeCallback callback) throws IOException, BTreeException {
            block54: {
                this.rwLock.readLock().lock();
                try {
                    if (query != null && query.getOperator() != 0) {
                        Value[] qvals = query.getValues();
                        int leftIdx = Arrays.binarySearch(this.values, qvals[0]);
                        int rightIdx = qvals.length > 1 ? Arrays.binarySearch(this.values, qvals[qvals.length - 1]) : leftIdx;
                        switch (this.ph.getStatus()) {
                            case 2: {
                                leftIdx = leftIdx < 0 ? -(leftIdx + 1) : leftIdx + 1;
                                rightIdx = rightIdx < 0 ? -(rightIdx + 1) : rightIdx + 1;
                                switch (query.getOperator()) {
                                    case 4: 
                                    case 5: 
                                    case 6: 
                                    case 7: {
                                        if (leftIdx < 0) {
                                            leftIdx = 0;
                                        }
                                        if (rightIdx > this.ptrs.length - 1) {
                                            rightIdx = this.ptrs.length - 1;
                                        }
                                        for (int i = leftIdx; i <= rightIdx; ++i) {
                                            this.getChildNode(i).query(query, callback);
                                        }
                                        break block54;
                                    }
                                    case -7: 
                                    case -6: 
                                    case -5: 
                                    case -4: {
                                        int i;
                                        if (leftIdx > this.ptrs.length - 1) {
                                            leftIdx = this.ptrs.length - 1;
                                        }
                                        for (i = 0; i <= leftIdx; ++i) {
                                            this.getChildNode(i).query(query, callback);
                                        }
                                        if (rightIdx < 0) {
                                            rightIdx = 0;
                                        }
                                        for (i = rightIdx; i < this.ptrs.length; ++i) {
                                            this.getChildNode(i).query(query, callback);
                                        }
                                        break block54;
                                    }
                                    case 1: {
                                        this.getChildNode(leftIdx).query(query, callback);
                                        break;
                                    }
                                    case -2: 
                                    case 3: {
                                        if (leftIdx > this.ptrs.length - 1) {
                                            leftIdx = this.ptrs.length - 1;
                                        }
                                        for (int i = 0; i <= leftIdx; ++i) {
                                            this.getChildNode(i).query(query, callback);
                                        }
                                        break block54;
                                    }
                                    case -3: 
                                    case 2: {
                                        if (rightIdx < 0) {
                                            rightIdx = 0;
                                        }
                                        for (int i = rightIdx; i < this.ptrs.length; ++i) {
                                            this.getChildNode(i).query(query, callback);
                                        }
                                        break block54;
                                    }
                                    default: {
                                        for (int i = 0; i < this.ptrs.length; ++i) {
                                            this.getChildNode(i).query(query, callback);
                                        }
                                        break block54;
                                    }
                                }
                                break block54;
                            }
                            case 1: {
                                switch (query.getOperator()) {
                                    case 1: {
                                        if (leftIdx >= 0) {
                                            callback.indexInfo(this.values[leftIdx], this.ptrs[leftIdx]);
                                            break;
                                        }
                                        break block54;
                                    }
                                    case -1: {
                                        for (int i = 0; i < this.ptrs.length; ++i) {
                                            if (i == leftIdx) continue;
                                            callback.indexInfo(this.values[i], this.ptrs[i]);
                                        }
                                        break block54;
                                    }
                                    case 4: 
                                    case 5: 
                                    case 6: 
                                    case 7: {
                                        if (leftIdx < 0) {
                                            leftIdx = -(leftIdx + 1);
                                        }
                                        if (rightIdx < 0) {
                                            rightIdx = -(rightIdx + 1);
                                        }
                                        int n = Math.min(rightIdx + 1, this.ptrs.length);
                                        for (int i = leftIdx; i < n; ++i) {
                                            if (!query.testValue(this.values[i])) continue;
                                            callback.indexInfo(this.values[i], this.ptrs[i]);
                                        }
                                        break block54;
                                    }
                                    case -7: 
                                    case -5: 
                                    case -4: {
                                        if (leftIdx < 0) {
                                            leftIdx = -(leftIdx + 1);
                                        }
                                        if (rightIdx < 0) {
                                            rightIdx = -(rightIdx + 1);
                                        }
                                        for (int i = 0; i < this.ptrs.length; ++i) {
                                            if (i > leftIdx && i < rightIdx || !query.testValue(this.values[i])) continue;
                                            callback.indexInfo(this.values[i], this.ptrs[i]);
                                        }
                                        break block54;
                                    }
                                    case -2: 
                                    case 3: {
                                        if (leftIdx < 0) {
                                            leftIdx = -(leftIdx + 1);
                                        }
                                        int n = Math.min(leftIdx + 1, this.ptrs.length);
                                        for (int i = 0; i < n; ++i) {
                                            if (!query.testValue(this.values[i])) continue;
                                            callback.indexInfo(this.values[i], this.ptrs[i]);
                                        }
                                        break block54;
                                    }
                                    case -3: 
                                    case 2: {
                                        if (rightIdx < 0) {
                                            rightIdx = -(rightIdx + 1);
                                        }
                                        for (int i = rightIdx; i < this.ptrs.length; ++i) {
                                            if (!query.testValue(this.values[i])) continue;
                                            callback.indexInfo(this.values[i], this.ptrs[i]);
                                        }
                                        break block54;
                                    }
                                    default: {
                                        for (int i = 0; i < this.ptrs.length; ++i) {
                                            if (!query.testValue(this.values[i])) continue;
                                            callback.indexInfo(this.values[i], this.ptrs[i]);
                                        }
                                        break block54;
                                    }
                                }
                                break block54;
                            }
                            default: {
                                throw new BTreeCorruptException("Invalid Page Type In query");
                            }
                        }
                    }
                    switch (this.ph.getStatus()) {
                        case 2: {
                            for (int i = 0; i < this.ptrs.length; ++i) {
                                this.getChildNode(i).query(query, callback);
                            }
                            break;
                        }
                        case 1: {
                            for (int i = 0; i < this.values.length; ++i) {
                                callback.indexInfo(this.values[i], this.ptrs[i]);
                            }
                            break;
                        }
                        default: {
                            throw new BTreeCorruptException("Invalid Page Type In query");
                        }
                    }
                }
                finally {
                    this.rwLock.readLock().unlock();
                }
            }
        }

        private class BTreeInsertCallback
        implements BTreeCallback {
            private BTreeNode node;

            public BTreeInsertCallback(BTreeNode rootNode) {
                this.node = rootNode;
            }

            public boolean indexInfo(Value value, long pointer) {
                try {
                    this.node.addValue(value, pointer);
                }
                catch (BTreeException e) {
                    throw new RuntimeException(e);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                return true;
            }
        }
    }

    public final class BTreeRootInfo {
        private final BTreeRootInfo parent;
        private final Value name;
        private long page;

        public BTreeRootInfo(BTreeRootInfo parent, String name, long page) {
            this.parent = parent;
            this.name = new Value(name);
            this.page = page;
        }

        public BTreeRootInfo(BTreeRootInfo parent, Value name, long page) {
            this.parent = parent;
            this.name = name;
            this.page = page;
        }

        public BTreeRootInfo(String name, long page) {
            this.parent = BTree.this.rootInfo;
            this.name = new Value(name);
            this.page = page;
        }

        public BTreeRootInfo(Value name, long page) {
            this.parent = BTree.this.rootInfo;
            this.name = name;
            this.page = page;
        }

        private BTreeRootInfo(long page) {
            this.parent = null;
            this.name = null;
            this.page = page;
        }

        public BTreeRootInfo getParent() {
            return this.parent;
        }

        public Value getName() {
            return this.name;
        }

        public synchronized long getPage() {
            return this.page;
        }

        public synchronized void setPage(long page) {
            this.page = page;
        }
    }
}

