/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xindice.core.indexer;

import java.util.Arrays;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xindice.core.data.Value;
import org.apache.xindice.core.indexer.IndexPattern;

public class IndexQuery {
    private static final Log log = LogFactory.getLog(IndexQuery.class);
    public static final int ANY = 0;
    public static final int EQ = 1;
    public static final int NEQ = -1;
    public static final int GT = 2;
    public static final int LEQ = -2;
    public static final int LT = 3;
    public static final int GEQ = -3;
    public static final int BW = 4;
    public static final int NBW = -4;
    public static final int BWX = 5;
    public static final int NBWX = -5;
    public static final int IN = 6;
    public static final int NIN = -6;
    public static final int SW = 7;
    public static final int NSW = -7;
    protected final IndexPattern pattern;
    protected final int op;
    protected final Value[] vals;

    public IndexQuery(IndexPattern pattern) {
        this.pattern = pattern;
        this.op = 0;
        this.vals = null;
    }

    public IndexQuery(IndexPattern pattern, Value[] vals) {
        this(pattern, 6, vals);
    }

    public IndexQuery(IndexPattern pattern, int op, Value[] vals) {
        this.pattern = pattern;
        this.op = op;
        this.vals = vals;
    }

    public IndexQuery(IndexPattern pattern, int op, Value val) {
        this.pattern = pattern;
        this.op = op;
        if (op == 7 || op == -7) {
            byte[] b = new byte[val.getLength() + 1];
            val.copyTo(b, 0);
            b[b.length - 1] = 127;
            Value val2 = new Value(b);
            this.vals = new Value[]{val, val2};
        } else {
            this.vals = new Value[]{val};
        }
    }

    public IndexQuery(IndexPattern pattern, Value val1) {
        this(pattern, 1, val1);
    }

    public IndexQuery(IndexPattern pattern, int op, Value val1, Value val2) {
        this.pattern = pattern;
        this.op = op;
        this.vals = new Value[]{val1, val2};
    }

    public IndexQuery(IndexPattern pattern, Value val1, Value val2) {
        this(pattern, 6, val1, val2);
    }

    public IndexQuery(IndexPattern pattern, int op, String val1) {
        this(pattern, op, new Value(val1));
    }

    public IndexQuery(IndexPattern pattern, String val1) {
        this(pattern, new Value(val1));
    }

    public IndexQuery(IndexPattern pattern, int op, String val1, String val2) {
        this(pattern, op, new Value(val1), new Value(val2));
    }

    public IndexQuery(IndexPattern pattern, String val1, String val2) {
        this(pattern, new Value(val1), new Value(val2));
    }

    public IndexPattern getPattern() {
        return this.pattern;
    }

    public int getOperator() {
        return this.op;
    }

    public final Value getValue(int index) {
        return this.vals[index];
    }

    public Value[] getValues() {
        return this.vals;
    }

    public final int getLength() {
        return this.vals.length;
    }

    public boolean testValue(Value value) {
        switch (this.op) {
            case 0: {
                return true;
            }
            case 1: {
                return value.equals(this.vals[0]);
            }
            case -1: {
                return !value.equals(this.vals[0]);
            }
            case 2: {
                return value.compareTo(this.vals[0]) > 0;
            }
            case -2: {
                return value.compareTo(this.vals[0]) <= 0;
            }
            case 3: {
                return value.compareTo(this.vals[0]) < 0;
            }
            case -3: {
                return value.compareTo(this.vals[0]) >= 0;
            }
            case 4: {
                return value.compareTo(this.vals[0]) >= 0 && value.compareTo(this.vals[1]) <= 0;
            }
            case -4: {
                return value.compareTo(this.vals[0]) <= 0 || value.compareTo(this.vals[1]) >= 0;
            }
            case 5: {
                return value.compareTo(this.vals[0]) > 0 && value.compareTo(this.vals[1]) < 0;
            }
            case -5: {
                return value.compareTo(this.vals[0]) < 0 || value.compareTo(this.vals[1]) > 0;
            }
            case -6: 
            case 6: {
                return Arrays.binarySearch(this.vals, value) >= 0 ? this.op == 6 : this.op == -6;
            }
            case -7: 
            case 7: {
                return value.startsWith(this.vals[0]) ? this.op == 7 : this.op == -7;
            }
        }
        if (log.isWarnEnabled()) {
            log.warn((Object)("invalid operation : " + this.op));
        }
        return false;
    }

    public final boolean testValue(String value) {
        return this.testValue(new Value(value));
    }
}

