/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xindice.core.indexer;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xindice.core.Collection;
import org.apache.xindice.core.DBException;
import org.apache.xindice.core.data.Key;
import org.apache.xindice.core.data.Value;
import org.apache.xindice.core.filer.BTree;
import org.apache.xindice.core.filer.BTreeCallback;
import org.apache.xindice.core.filer.BTreeCorruptException;
import org.apache.xindice.core.indexer.IndexMatch;
import org.apache.xindice.core.indexer.IndexPattern;
import org.apache.xindice.core.indexer.IndexQuery;
import org.apache.xindice.core.indexer.Indexer;
import org.apache.xindice.util.Configuration;
import org.apache.xindice.xml.SymbolTable;

public final class NameIndexer
extends BTree
implements Indexer {
    private static final Log log = LogFactory.getLog(NameIndexer.class);
    private static final IndexMatch[] EmptyMatches = new IndexMatch[0];
    private static final String NAME = "name";
    private static final String PATTERN = "pattern";
    private Collection collection;
    private SymbolTable symbols;
    private String name;
    private String pattern;
    private boolean wildcard;

    public void setConfig(Configuration config) {
        block2: {
            super.setConfig(config);
            try {
                this.name = config.getAttribute(NAME);
                this.pattern = config.getAttribute(PATTERN);
                this.wildcard = this.pattern.indexOf(42) != -1;
                this.setLocation(this.name);
            }
            catch (Exception e) {
                if (!log.isWarnEnabled()) break block2;
                log.warn((Object)"ignored exception", (Throwable)e);
            }
        }
    }

    public String getName() {
        return this.name;
    }

    public void setLocation(String location) {
        this.setFile(new File(this.collection.getCollectionRoot(), location + ".idx"));
    }

    public void setCollection(Collection collection) {
        block2: {
            try {
                this.collection = collection;
                this.symbols = collection.getSymbols();
            }
            catch (Exception e) {
                if (!log.isWarnEnabled()) break block2;
                log.warn((Object)"ignored exception", (Throwable)e);
            }
        }
    }

    public String getIndexStyle() {
        return "Node:Name";
    }

    public String getPattern() {
        return this.pattern;
    }

    public void remove(String value, Key key, int pos, int len, short elemID, short attrID) throws DBException {
        try {
            this.removeValue(key);
        }
        catch (IOException e) {
            throw new BTreeCorruptException("Corruption detected on remove", e);
        }
    }

    public void add(String value, Key key, int pos, int len, short elemID, short attrID) throws DBException {
        try {
            this.addValue(key, 0L);
        }
        catch (IOException e) {
            throw new BTreeCorruptException("Corruption detected on add", e);
        }
    }

    public IndexMatch[] queryMatches(IndexQuery query) throws DBException {
        ArrayList results;
        block3: {
            results = new ArrayList();
            final IndexPattern pattern = query.getPattern();
            try {
                this.query(query, new BTreeCallback(){

                    public boolean indexInfo(Value value, long pos) {
                        results.add(new IndexMatch(new Key(value), pattern));
                        return true;
                    }
                });
            }
            catch (DBException e) {
                throw e;
            }
            catch (Exception e) {
                if (!log.isWarnEnabled()) break block3;
                log.warn((Object)"ignored exception", (Throwable)e);
            }
        }
        return results.toArray(EmptyMatches);
    }
}

