/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xindice.core.meta.inline;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xindice.core.data.Value;
import org.apache.xindice.core.meta.inline.InlineMetaException;
import org.apache.xindice.core.meta.inline.InlineMetaMap;
import org.apache.xindice.core.meta.inline.InlineMetaReader;

public class ResourceTypeReader
implements InlineMetaReader {
    private static final Log log = LogFactory.getLog(ResourceTypeReader.class);
    public static final Integer XML = new Integer(1);
    public static final Integer BINARY = new Integer(2);

    public int getVersion() {
        return 1;
    }

    public InlineMetaMap read(Value data) throws InlineMetaException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("ResourceTypeReader.read: data length=" + data.getLength()));
        }
        if (data.getLength() != 1) {
            throw new InlineMetaException(243, "Expecting header length of 1");
        }
        Integer type = new Integer(data.byteAt(0));
        if (!XML.equals(type) && !BINARY.equals(type)) {
            throw new InlineMetaException(243, "Unexpected type value: " + type);
        }
        ResourceTypeMap resourceTypeMap = new ResourceTypeMap();
        resourceTypeMap.put("type", type);
        return resourceTypeMap;
    }

    public static class ResourceTypeMap
    implements InlineMetaMap {
        private static String[] keys = new String[]{"type"};
        private Integer type;

        public boolean containsKey(String key) {
            return "type".equals(key);
        }

        public Object get(String key) throws InlineMetaException {
            if ("type".equals(key)) {
                return this.type;
            }
            throw new InlineMetaException(70, "ResourceTypeMap does not accept key '" + key + "'");
        }

        public String[] keys() {
            return keys;
        }

        public void put(String key, Object value) throws InlineMetaException {
            if ("type".equals(key)) {
                if (!(value instanceof Integer)) {
                    throw new InlineMetaException(70, "ResourceTypeMap key 'type' requires an Integer value");
                }
            } else {
                throw new InlineMetaException(70, "ResourceTypeMap does not accept key '" + key + "'");
            }
            this.type = (Integer)value;
        }
    }
}

