/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xindice.core.query;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xindice.core.Collection;
import org.apache.xindice.core.DBException;
import org.apache.xindice.core.Database;
import org.apache.xindice.core.data.Key;
import org.apache.xindice.core.data.NodeSet;
import org.apache.xindice.core.indexer.IndexMatch;
import org.apache.xindice.core.query.Query;
import org.apache.xindice.core.query.QueryException;
import org.apache.xindice.core.query.QueryResolver;
import org.apache.xindice.core.query.StyleNotFoundException;
import org.apache.xindice.util.Configuration;
import org.apache.xindice.util.ConfigurationCallback;
import org.apache.xindice.util.SimpleConfigurable;
import org.apache.xindice.util.XindiceException;
import org.apache.xindice.xml.NamespaceMap;

public class QueryEngine
extends SimpleConfigurable {
    private static final Log log = LogFactory.getLog(QueryEngine.class);
    private static final String[] EmptyStrings = new String[0];
    private static final Key[] EmptyKeys = new Key[0];
    private static final String RESOLVER = "resolver";
    private static final String CLASS = "class";
    private final Database db;
    private final Map resolvers;

    public QueryEngine(Database db) {
        this.db = db;
        this.resolvers = new HashMap();
    }

    public void setConfig(Configuration config) throws XindiceException {
        super.setConfig(config);
        config.processChildren(RESOLVER, new ConfigurationCallback(){

            public void process(Configuration cfg) {
                block2: {
                    String className = cfg.getAttribute(QueryEngine.CLASS);
                    try {
                        QueryResolver res = (QueryResolver)Class.forName(className).newInstance();
                        res.setConfig(cfg);
                        res.setQueryEngine(QueryEngine.this);
                        QueryEngine.this.resolvers.put(res.getQueryStyle(), res);
                    }
                    catch (Exception e) {
                        if (!log.isWarnEnabled()) break block2;
                        log.warn((Object)("Unable to load query resolver: " + className + ". This query resolver will not be available."), (Throwable)e);
                    }
                }
            }
        });
    }

    public Database getDatabase() {
        return this.db;
    }

    public String[] listStyles() {
        return this.resolvers.keySet().toArray(EmptyStrings);
    }

    private QueryResolver getResolver(String style) throws QueryException {
        QueryResolver res = (QueryResolver)this.resolvers.get(style);
        if (res == null) {
            throw new StyleNotFoundException("No Resolver available for '" + style + "' queries");
        }
        return res;
    }

    public NodeSet query(Collection col, String style, String query, NamespaceMap nsMap, Key[] keys) throws DBException, QueryException {
        QueryResolver res = this.getResolver(style);
        return res.query(col, query, nsMap, keys);
    }

    public Query compileQuery(Collection col, String style, String query, NamespaceMap nsMap, Key[] keys) throws DBException, QueryException {
        QueryResolver res = this.getResolver(style);
        return res.compileQuery(col, query, nsMap, keys);
    }

    public static Key[] getUniqueKeys(IndexMatch[] matches) {
        TreeSet<Key> set = new TreeSet<Key>();
        for (int i = 0; i < matches.length; ++i) {
            set.add(matches[i].getKey());
        }
        return set.toArray(EmptyKeys);
    }

    public static Key[] andKeySets(Key[][] keySets) {
        if (keySets.length == 0) {
            return EmptyKeys;
        }
        if (keySets.length == 1) {
            return keySets[0];
        }
        int[] ptrs = new int[keySets.length];
        for (int i = 0; i < keySets.length; ++i) {
            if (keySets[i].length == 0) {
                return EmptyKeys;
            }
            ptrs[i] = 0;
        }
        TreeSet<Key> set = new TreeSet<Key>();
        boolean done = false;
        ArrayList<Integer> highs = new ArrayList<Integer>();
        Key highest = null;
        while (!done) {
            int i;
            boolean eq = true;
            for (i = 0; i < ptrs.length; ++i) {
                Key comp = keySets[i][ptrs[i]];
                if (highest == null) {
                    highest = comp;
                    highs.add(new Integer(i));
                    continue;
                }
                int c = highest.compareTo(comp);
                if (c != 0) {
                    eq = false;
                }
                if (c < 0) {
                    highest = comp;
                    highs.clear();
                    highs.add(new Integer(i));
                    continue;
                }
                if (c != 0) continue;
                highs.add(new Integer(i));
            }
            if (eq) {
                set.add(highest);
                highs.clear();
                highest = null;
            }
            for (i = 0; i < ptrs.length; ++i) {
                if (!highs.contains(new Integer(i))) {
                    int n = i;
                    ptrs[n] = ptrs[n] + 1;
                }
                if (ptrs[i] < keySets[i].length) continue;
                done = true;
            }
            if (eq) continue;
            highs.clear();
        }
        return set.toArray(EmptyKeys);
    }

    public static Key[] orKeySets(Key[][] keySets) {
        if (keySets.length == 0) {
            return EmptyKeys;
        }
        if (keySets.length == 1) {
            return keySets[0];
        }
        if (keySets.length == 2) {
            if (keySets[1].length == 0) {
                return keySets[0];
            }
            if (keySets[0].length == 0) {
                return keySets[1];
            }
        }
        TreeSet<Key> set = new TreeSet<Key>();
        for (int i = 0; i < keySets.length; ++i) {
            for (int j = 0; j < keySets[i].length; ++j) {
                set.add(keySets[i][j]);
            }
        }
        return set.toArray(EmptyKeys);
    }

    public static String normalizeString(String value) {
        char[] c = value.toCharArray();
        char[] n = new char[c.length];
        boolean white = true;
        int pos = 0;
        for (int i = 0; i < c.length; ++i) {
            if (" \t\n\r".indexOf(c[i]) != -1) {
                if (white) continue;
                n[pos++] = 32;
                white = true;
                continue;
            }
            n[pos++] = c[i];
            white = false;
        }
        if (white && pos > 0) {
            --pos;
        }
        return new String(n, 0, pos);
    }

    public static String expandEntities(String value) {
        int idx = value.indexOf(38);
        if (idx == -1) {
            return value;
        }
        StringBuilder sb = new StringBuilder(value.length());
        int pos = 0;
        while (pos < value.length()) {
            if (idx != -1) {
                int end;
                if (idx > pos) {
                    sb.append(value.substring(pos, idx));
                }
                if ((end = value.indexOf(59, idx) + 1) == 0) {
                    return value;
                }
                String token = value.substring(idx + 1, end - 1);
                if (token.equals("apos")) {
                    sb.append("'");
                } else if (token.equals("quot")) {
                    sb.append("\"");
                } else if (token.equals("amp")) {
                    sb.append("&");
                } else if (token.equals("lt")) {
                    sb.append("<");
                } else if (token.equals("gt")) {
                    sb.append(">");
                } else {
                    return value;
                }
                pos = end;
                idx = value.indexOf(38, pos);
                continue;
            }
            sb.append(value.substring(pos));
            break;
        }
        return sb.toString();
    }
}

