/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xindice.core.query;

import java.util.Hashtable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xindice.core.data.NodeSet;
import org.apache.xindice.util.XindiceRuntimeException;
import org.apache.xindice.xml.NamespaceMap;
import org.apache.xindice.xml.TextWriter;
import org.apache.xindice.xml.dom.DBNode;
import org.apache.xindice.xml.dom.DocumentImpl;
import org.w3c.dom.Attr;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.Text;

public class QueryUtil {
    private static final Log log = LogFactory.getLog(QueryUtil.class);

    public static NamespaceMap mapNamespaces(Hashtable namespaces) {
        if (namespaces != null && namespaces.size() > 0) {
            return new NamespaceMap(namespaces);
        }
        return null;
    }

    public static Document queryResultsToDOM(NodeSet nodeSet, boolean expandSource) {
        DocumentImpl doc = new DocumentImpl();
        Element root = doc.createElement("result");
        doc.appendChild(root);
        int count = 0;
        while (nodeSet != null && nodeSet.hasMoreNodes()) {
            Element holder;
            Node n;
            Object element = nodeSet.getNextNode();
            if (element instanceof Attr) {
                n = (Attr)element;
                holder = doc.createElementNS("http://xml.apache.org/xindice/Query", "xq:result");
                holder.setAttribute("xmlns:xq", "http://xml.apache.org/xindice/Query");
                holder.setAttributeNode((Attr)doc.importNode(n, true));
                if (expandSource && n instanceof DBNode) {
                    ((DBNode)((Object)holder)).setSource(((DBNode)n).getSource());
                    ((DBNode)((Object)holder)).expandSource();
                }
                root.appendChild(holder);
            } else if (element instanceof Text || element instanceof Comment) {
                n = (Node)element;
                holder = doc.createElementNS("http://xml.apache.org/xindice/Query", "xq:result");
                holder.setAttribute("xmlns:xq", "http://xml.apache.org/xindice/Query");
                holder.appendChild(doc.importNode(n, true));
                if (expandSource && n instanceof DBNode) {
                    ((DBNode)((Object)holder)).setSource(((DBNode)n).getSource());
                    ((DBNode)((Object)holder)).expandSource();
                }
                root.appendChild(holder);
            } else if (element instanceof ProcessingInstruction) {
                if (log.isWarnEnabled()) {
                    log.warn((Object)"XPath query with ProcessingInstruction result is not supported");
                }
            } else if (element instanceof Node) {
                n = (Node)element;
                if (n.getNodeType() == 9) {
                    n = ((Document)n).getDocumentElement();
                }
                if (expandSource && n instanceof DBNode) {
                    ((DBNode)n).expandSource();
                }
                root.appendChild(doc.importNode(n, true));
            } else {
                throw new XindiceRuntimeException("Unknown result type (" + element.getClass().getName() + ") in nodeset");
            }
            ++count;
        }
        root.setAttribute("count", Integer.toString(count));
        return doc;
    }

    public static Document queryResultsToDOM(NodeSet nodeSet) {
        return QueryUtil.queryResultsToDOM(nodeSet, true);
    }

    public static String queryResultsToString(NodeSet nodeSet, boolean expandSource) {
        return TextWriter.toString(QueryUtil.queryResultsToDOM(nodeSet, expandSource));
    }

    public static String queryResultsToString(NodeSet nodeSet) {
        return TextWriter.toString(QueryUtil.queryResultsToDOM(nodeSet, true));
    }
}

