/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xindice.core.xupdate;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xindice.core.Collection;
import org.apache.xindice.core.data.Key;
import org.apache.xindice.core.data.NodeSet;
import org.apache.xindice.core.query.CompilationException;
import org.apache.xindice.core.query.NodeListSet;
import org.apache.xindice.core.query.ProcessingException;
import org.apache.xindice.core.query.Query;
import org.apache.xindice.core.query.QueryEngine;
import org.apache.xindice.core.query.QueryException;
import org.apache.xindice.core.query.QueryResolver;
import org.apache.xindice.core.xupdate.XUpdateImpl;
import org.apache.xindice.util.Configuration;
import org.apache.xindice.util.SimpleConfigurable;
import org.apache.xindice.util.XindiceException;
import org.apache.xindice.xml.NamespaceMap;
import org.apache.xindice.xml.dom.DocumentImpl;

public class XUpdateQueryResolver
extends SimpleConfigurable
implements QueryResolver {
    private static final Log log = LogFactory.getLog(XUpdateQueryResolver.class);
    private static final String XUPDATE_XPATH_PROP = "org.xmldb.common.xml.queries.XPathQueryFactory";
    private static final String XUPDATE_XPATH_IMPL = "org.apache.xindice.core.xupdate.XPathQueryFactoryImpl";
    public static final String STYLE_XUPDATE = "XUpdate";

    public void setConfig(Configuration config) throws XindiceException {
        super.setConfig(config);
    }

    public String getQueryStyle() {
        return STYLE_XUPDATE;
    }

    public void setQueryEngine(QueryEngine engine) {
    }

    public Query compileQuery(Collection context, String query, NamespaceMap nsMap, Key[] keys) throws QueryException {
        return new XUpdateQuery(context, query, nsMap, keys);
    }

    public NodeSet query(Collection context, String query, NamespaceMap nsMap, Key[] keys) throws QueryException {
        XUpdateQuery xq = new XUpdateQuery(context, query, nsMap, keys);
        return xq.execute();
    }

    static /* synthetic */ Log access$000() {
        return log;
    }

    static {
        System.setProperty(XUPDATE_XPATH_PROP, XUPDATE_XPATH_IMPL);
    }

    private class XUpdateQuery
    implements Query {
        public Collection context;
        public String query;
        public NamespaceMap nsMap;
        public XUpdateImpl xu;
        public Key[] keys;

        public XUpdateQuery(Collection context, String query, NamespaceMap nsMap, Key[] keys) throws QueryException {
            this.context = context;
            this.query = query;
            this.nsMap = nsMap;
            this.keys = keys;
            try {
                this.xu = new XUpdateImpl();
                this.xu.setQString(query);
                this.xu.setNamespaceMap(nsMap);
            }
            catch (Exception e) {
                if (e instanceof QueryException) {
                    throw (QueryException)e.fillInStackTrace();
                }
                throw new CompilationException("Error Compiling XUpdate Query", e);
            }
        }

        public String getQueryStyle() {
            return XUpdateQueryResolver.STYLE_XUPDATE;
        }

        public Collection getQueryContext() {
            return this.context;
        }

        public String getQueryString() {
            return this.query;
        }

        public NamespaceMap getNamespaceMap() {
            return this.nsMap;
        }

        public Key[] getKeySet() {
            return this.keys;
        }

        /*
         * Unable to fully structure code
         */
        public NodeSet execute() throws QueryException {
            try {
                if (this.keys != null) {
                    try {
                        for (i = 0; i < this.keys.length; ++i) {
                            doc = this.context.getDocument(this.keys[i]);
                            this.xu.execute(doc.getDocumentElement());
                            this.context.setDocument(this.keys[i], doc);
                        }
                    }
                    catch (Exception e) {
                        if (!XUpdateQueryResolver.access$000().isWarnEnabled()) ** GOTO lbl15
                        XUpdateQueryResolver.access$000().warn((Object)"ignored exception", (Throwable)e);
                    }
                } else {
                    this.xu.execute(this.context);
                }
lbl15:
                // 4 sources

                doc = new DocumentImpl();
                elem = doc.createElementNS("http://xml.apache.org/xindice/Query", "src:modified");
                elem.setAttribute("xmlns:src", "http://xml.apache.org/xindice/Query");
                doc.appendChild(elem);
                count = doc.createTextNode(Integer.toString(this.xu.getModifiedCount()));
                elem.appendChild(count);
                return new NodeListSet(doc.getChildNodes());
            }
            catch (Exception e) {
                if (e instanceof QueryException) {
                    throw (QueryException)e.fillInStackTrace();
                }
                throw new ProcessingException("Error executing XUpdate query", e);
            }
        }
    }
}

