/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xindice.util;

import java.io.Serializable;

public final class ObjectQueue
implements Serializable {
    static final long serialVersionUID = 2573729619402197579L;
    private ObjectQueueItem first = null;
    private ObjectQueueItem last = null;
    private int size = 0;

    public synchronized void add(Object value) {
        ++this.size;
        ObjectQueueItem q = new ObjectQueueItem(value);
        if (this.last != null) {
            this.last.next = q;
        }
        this.last = q;
        if (this.first == null) {
            this.first = q;
        }
    }

    public synchronized Object remove() {
        ObjectQueueItem q = this.first;
        if (q != null) {
            --this.size;
            this.first = q.next;
            if (this.first == null) {
                this.last = null;
            }
            return q.value;
        }
        return null;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public int size() {
        return this.size;
    }

    public synchronized Object peek() {
        return this.first != null ? this.first.value : null;
    }

    public synchronized void clear() {
        this.size = 0;
        this.first = null;
        this.last = null;
    }

    private class ObjectQueueItem
    implements Serializable {
        public Object value;
        public ObjectQueueItem next;

        public ObjectQueueItem(Object value) {
            this.value = value;
        }
    }
}

