/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xindice.xml;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xindice.xml.SymbolTable;

public class XMLCompressedInput
extends DataInputStream {
    private static final Log log = LogFactory.getLog(XMLCompressedInput.class);
    private byte signature = 0;

    public XMLCompressedInput(InputStream is, SymbolTable st) {
        super(is);
    }

    public final byte readSignature() throws IOException {
        this.signature = this.readByte();
        return this.signature;
    }

    public final byte getSignature() {
        return this.signature;
    }

    public final short getNodeType() {
        byte type = (byte)(this.signature & 0xC0);
        switch (type) {
            case 0: {
                type = (byte)(this.signature & 0x20);
                if (type == 0) {
                    return 3;
                }
                return 5;
            }
            case 64: {
                return 1;
            }
            case -128: {
                return 7;
            }
            case -64: {
                switch ((byte)(this.signature & 0x3C)) {
                    case 16: {
                        return 4;
                    }
                    case 24: {
                        return 6;
                    }
                    case 32: {
                        return 8;
                    }
                    case 40: {
                        return 10;
                    }
                    case 48: {
                        return 12;
                    }
                }
                return -1;
            }
        }
        if (log.isWarnEnabled()) {
            log.warn((Object)("invalid signature : " + type));
        }
        return -1;
    }

    public final int readContentSize() throws IOException {
        int sizeType = 0;
        short nodeType = this.getNodeType();
        switch (nodeType) {
            case 1: 
            case 3: {
                sizeType = (byte)((this.signature & 0xC) >>> 2);
                break;
            }
            case 4: 
            case 7: 
            case 8: {
                sizeType = 1;
                break;
            }
            case 12: {
                sizeType = (byte)(this.signature & 3);
                break;
            }
            default: {
                if (!log.isWarnEnabled()) break;
                log.warn((Object)("invalid node type : " + nodeType));
            }
        }
        switch (sizeType) {
            case 3: {
                return this.readByte();
            }
            case 2: {
                return this.readShort();
            }
            case 1: {
                return this.readInt();
            }
            case 0: {
                break;
            }
            default: {
                if (!log.isWarnEnabled()) break;
                log.warn((Object)("invalid size : " + sizeType));
            }
        }
        return 0;
    }

    public final int readAttributeCount() throws IOException {
        int countType = 0;
        if (this.getNodeType() == 1) {
            countType = (byte)(this.signature & 3);
        }
        switch (countType) {
            case 3: {
                return this.readByte();
            }
            case 2: {
                return this.readShort();
            }
            case 1: {
                return this.readInt();
            }
            case 0: {
                break;
            }
            default: {
                if (!log.isWarnEnabled()) break;
                log.warn((Object)("invalid signature type : " + countType));
            }
        }
        return 0;
    }
}

