/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xindice.xml;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.xindice.xml.SymbolTable;

public class XMLCompressedOutput
extends DataOutputStream {
    protected SymbolTable st;

    public XMLCompressedOutput(OutputStream os, SymbolTable st) {
        super(os);
        this.st = st;
    }

    protected final byte getSizeType(long length) {
        if (length > 32767L) {
            return 1;
        }
        if (length > 127L) {
            return 2;
        }
        if (length > 0L) {
            return 3;
        }
        return 0;
    }

    protected final int getSizeSize(int sizeType) {
        switch (sizeType) {
            case 1: {
                return 4;
            }
            case 2: {
                return 2;
            }
            case 3: {
                return 1;
            }
        }
        return 0;
    }

    protected final int writeSize(int size) throws IOException {
        return this.writeSize(this.getSizeType(size), size);
    }

    protected final int writeSize(int sizeType, int size) throws IOException {
        switch (sizeType) {
            case 1: {
                this.writeInt(size);
                return 4;
            }
            case 2: {
                this.writeShort((short)size);
                return 2;
            }
            case 3: {
                this.writeByte((byte)size);
                return 1;
            }
        }
        return 0;
    }
}

