/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xindice.xml.dom;

import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xindice.util.ByteArrayInput;
import org.apache.xindice.xml.SymbolTable;
import org.apache.xindice.xml.XMLCompressedInput;
import org.apache.xindice.xml.dom.DocumentImpl;
import org.apache.xindice.xml.dom.NodeImpl;
import org.w3c.dom.EntityReference;

public final class EntityReferenceImpl
extends NodeImpl
implements EntityReference {
    private static final Log log = LogFactory.getLog(EntityReferenceImpl.class);
    private short symbolID = (short)-1;

    public EntityReferenceImpl() {
    }

    public EntityReferenceImpl(NodeImpl parentNode, byte[] data, int pos, int len) {
        super(parentNode, data, pos, len);
    }

    public EntityReferenceImpl(NodeImpl parentNode, boolean dirty) {
        super(parentNode, dirty);
    }

    public EntityReferenceImpl(NodeImpl parentNode, String nodeName) {
        super(parentNode, true);
        this.nodeName = nodeName;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void checkLoaded() {
        if (this.loaded) {
            return;
        }
        this.loaded = true;
        try {
            if (this.data == null) return;
            DocumentImpl doc = (DocumentImpl)this.getOwnerDocument();
            SymbolTable st = doc.getSymbols();
            ByteArrayInput bis = new ByteArrayInput(this.data, this.pos, this.len);
            XMLCompressedInput xci = new XMLCompressedInput(bis, st);
            byte signature = xci.readByte();
            byte entityType = (byte)(signature & 0x1F);
            switch (entityType) {
                case 1: {
                    this.symbolID = xci.readShort();
                    this.nodeName = st.getName(this.symbolID);
                    return;
                }
                case 2: {
                    this.nodeName = "&amp;";
                    return;
                }
                case 3: {
                    this.nodeName = "&lt;";
                    return;
                }
                case 4: {
                    this.nodeName = "&gt;";
                    return;
                }
                case 5: {
                    this.nodeName = "&quot;";
                    return;
                }
                case 6: {
                    this.nodeName = "&apos;";
                    return;
                }
                case 31: {
                    this.nodeName = "";
                    return;
                }
                default: {
                    if (!log.isWarnEnabled()) return;
                    log.warn((Object)("invalid entity type : " + entityType));
                }
            }
            return;
        }
        catch (IOException e) {
            if (!log.isWarnEnabled()) return;
            log.warn((Object)"ignored exception", (Throwable)e);
        }
    }

    public short getNodeType() {
        return 5;
    }
}

