/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.data.providers.olap.essbase;

import com.cognos.xqe.data.providers.olap.essbase.EssbaseConnection;
import com.cognos.xqe.data.providers.olap.essbase.EssbaseMessageKeys;
import com.cognos.xqe.data.providers.olap.essbase.EssbaseRuntimeException;
import com.cognos.xqe.data.providers.olap.essbase.EssbaseUtil;
import com.cognos.xqe.exception.IMessageKey;
import com.cognos.xqe.trace.LogLevel;
import com.essbase.api.base.EssException;

public class EssbaseExceptionHandler {
    private EssbaseConnection mEssbaseConnection = null;
    private int mExceptionCallCounter = 0;
    private static boolean mException = false;
    private static final String STR_ENDOFLINE = "\".\n";
    private static final long DEFAULTSTOPTIME = 3000L;
    private static final int DEFAULTMAXWAITTIME = 192000;
    private static final long DEFAULTMAXDBLTIME = 48000L;
    private static final long DEFAULTINCREASETIME = 15000L;
    private static final long EXCEPTIONDIVISOR = 3L;
    private static Long mstoptime = 3000L;
    private static Long mlastexceptiontime = null;

    public EssbaseExceptionHandler(EssbaseConnection essbaseConnection) {
        this.mEssbaseConnection = essbaseConnection;
    }

    public void exceptionHandler(IMessageKey.Param1 messageKey, EssException essException, String methodName, String mdx) {
        int errorCode = essException.getNativeCode();
        if (EssbaseUtil.isLoggedOutError(errorCode)) {
            if (this.mEssbaseConnection.loggerConnect.isOn(LogLevel.WARN)) {
                StringBuilder buf = new StringBuilder();
                buf.append("Recovering after Essbase server \"User Logged Out\" error during Essbase API call: \"");
                buf.append(methodName).append(STR_ENDOFLINE);
                this.mEssbaseConnection.loggerConnect.log(LogLevel.WARN, buf.toString(), (Throwable)essException);
            }
            throw new EssbaseRuntimeException(messageKey, essException, methodName);
        }
        if (!EssbaseUtil.isNetworkError(errorCode)) {
            if (this.mEssbaseConnection.loggerConnect.isOn(LogLevel.ERROR)) {
                StringBuilder buf = new StringBuilder();
                buf.append("Error in Essbase API call: \"");
                buf.append(methodName).append(STR_ENDOFLINE);
                this.mEssbaseConnection.loggerConnect.log(LogLevel.ERROR, buf.toString(), (Throwable)essException);
            }
            if (mdx == null) {
                throw new EssbaseRuntimeException(messageKey, essException, methodName);
            }
            throw new EssbaseRuntimeException(EssbaseMessageKeys.ERR_EXECUTE_MDX_ERROR, essException, mdx);
        }
        ++this.mExceptionCallCounter;
        mException = true;
        if (mstoptime > 192000L && this.mExceptionCallCounter > 2) {
            throw new EssbaseRuntimeException(EssbaseMessageKeys.ERR_API_CALL_ERROR_RECOVERY, essException, methodName, Integer.toString(this.mExceptionCallCounter));
        }
        if (this.mEssbaseConnection.loggerConnect.isOn(LogLevel.WARN)) {
            StringBuilder buf = new StringBuilder();
            buf.append("Recovering after network error during Essbase API call: \"").append(methodName);
            buf.append("\", attempt #: ").append(Integer.toString(this.mExceptionCallCounter));
            buf.append(", sleep time: ").append(mstoptime.toString()).append(" ms.");
            this.mEssbaseConnection.loggerConnect.log(LogLevel.WARN, buf.toString());
        }
        try {
            Thread.sleep(mstoptime);
        }
        catch (InterruptedException e) {
            throw new EssbaseRuntimeException(EssbaseMessageKeys.ERR_EXECUTE_ERROR, e);
        }
        Long currenttime = System.currentTimeMillis();
        if (mlastexceptiontime == null) {
            mlastexceptiontime = currenttime;
        }
        if (currenttime - mlastexceptiontime != 0L && (currenttime - mlastexceptiontime < mstoptime || this.mExceptionCallCounter > 1)) {
            if (mstoptime < 192000L) {
                mstoptime = mstoptime < 48000L ? Long.valueOf(mstoptime * 2L) : Long.valueOf(mstoptime + 15000L);
            }
        } else if (this.mEssbaseConnection.getPoolDisabled()) {
            double newstoptime = mstoptime * 1L;
            mstoptime = (long)newstoptime;
        }
        mlastexceptiontime = System.currentTimeMillis();
    }

    public void updateExceptionHandler() {
        if (!mException && mstoptime != 3000L) {
            this.mExceptionCallCounter = 0;
            Long currenttime = System.currentTimeMillis();
            if (mlastexceptiontime != null && currenttime - mlastexceptiontime > mstoptime / 3L) {
                if (mstoptime > 6000L) {
                    mstoptime = mstoptime / 2L;
                } else {
                    mstoptime = 3000L;
                    mlastexceptiontime = null;
                }
            }
        }
        mException = false;
    }
}

