/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.data.providers.olap.essbase;

import com.cognos.xqe.data.providers.olap.essbase.EssbaseConnection;
import com.cognos.xqe.data.providers.olap.essbase.EssbaseFormatInfo;
import com.cognos.xqe.data.providers.olap.essbase.EssbaseMemberCacheItem;
import com.cognos.xqe.data.providers.olap.essbase.EssbaseMetadataCache;
import com.cognos.xqe.data.providers.olap.essbase.EssbaseWrappers;
import com.cognos.xqe.format.FormatId;
import com.cognos.xqe.format.FormatService;
import com.cognos.xqe.format.XQEFormatService;
import com.cognos.xqe.format.string.IFormatInfo;
import com.cognos.xqe.trace.LogLevel;
import com.cognos.xqe.trace.XQELogger;
import com.essbase.api.dataquery.IEssMdAxis;
import com.essbase.api.dataquery.IEssMdMember;
import java.util.Locale;

public class EssbaseFormatter {
    private static final String STR_QUOTE = "\"";
    private static final String STR_FORMATID = "format ID \"";
    private final EssbaseConnection connection;
    private final Locale formatLocale;
    private FormatEnum formatType = FormatEnum.NONE;
    private FormatId[] measureFormatIds = null;
    private int nColumns = 0;
    private final EssbaseWrappers essbaseAPI;
    private final EssbaseMetadataCache metadataCache;
    private final IEssMdAxis[] essAxes;
    final FormatService service;
    private int indexFirstRealFormatID = -1;
    private final XQELogger logger = XQEFormatService.FSLOGGER_STRING_PARSING;

    EssbaseFormatter(EssbaseConnection theConnection, Locale theFormatLocale, IEssMdAxis[] theAxes) {
        this.connection = theConnection;
        this.formatLocale = theFormatLocale;
        this.essbaseAPI = this.connection.getEssAPI();
        this.metadataCache = this.connection.getMetadataCache();
        this.essAxes = theAxes;
        this.service = FormatService.getInstance();
        int columnAxisNo = 0;
        if (this.essbaseAPI.isSlicerAxis(this.essAxes[0])) {
            ++columnAxisNo;
            if (this.isMeasureFoundOnAxis(0)) {
                this.formatType = FormatEnum.SLICER;
            }
        }
        if (this.formatType == FormatEnum.NONE) {
            int nAxes = this.essAxes.length;
            if (this.isMeasureFoundOnAxis(columnAxisNo)) {
                if (columnAxisNo + 1 < nAxes) {
                    this.formatType = FormatEnum.COLUMNS;
                    this.nColumns = this.essbaseAPI.getTupleCount(this.essAxes[columnAxisNo]);
                } else {
                    this.formatType = FormatEnum.LIST;
                }
            } else if (this.isMeasureFoundOnAxis(columnAxisNo + 1)) {
                this.formatType = FormatEnum.ROWS;
                this.nColumns = this.essbaseAPI.getTupleCount(this.essAxes[columnAxisNo]);
            } else {
                for (int axisInd = columnAxisNo + 2; axisInd < nAxes; ++axisInd) {
                    if (!this.isMeasureFoundOnAxis(axisInd)) continue;
                    this.formatType = FormatEnum.SLICER;
                    break;
                }
            }
        }
    }

    private boolean isMeasureFoundOnAxis(int axisNo) {
        IEssMdAxis essAxis = this.essAxes[axisNo];
        IEssMdMember[] dimensionMembers = this.essbaseAPI.getAllDimensions(essAxis);
        int nDimensions = dimensionMembers.length;
        String measureDimensionName = this.metadataCache.getMeasureDimensionName();
        for (int dimInd = 0; dimInd < nDimensions; ++dimInd) {
            IEssMdMember member = dimensionMembers[dimInd];
            String dimensionName = this.essbaseAPI.getMdMemberName(member);
            if (!measureDimensionName.equals(dimensionName)) continue;
            this.getAllMeasureFormatIds(essAxis, dimInd);
            return true;
        }
        return false;
    }

    private void getAllMeasureFormatIds(IEssMdAxis measureAxis, int measureMemberNo) {
        if (this.service == null) {
            this.formatType = FormatEnum.NONE;
            this.logger.log(LogLevel.ERROR, "Unable to get the Format Service singleton.");
            return;
        }
        int nTuples = this.essbaseAPI.getTupleCount(measureAxis);
        this.measureFormatIds = new FormatId[nTuples];
        for (int tupleInd = 0; tupleInd < nTuples; ++tupleInd) {
            this.setFormatId(measureAxis, measureMemberNo, tupleInd);
        }
    }

    private void setFormatId(IEssMdAxis measureAxis, int measureMemberNo, int tupleInd) {
        IEssMdMember[] essMbrs = this.essbaseAPI.getAllTupleMembers(measureAxis, tupleInd);
        IEssMdMember member = essMbrs[measureMemberNo];
        if (this.essbaseAPI.isCalced(member)) {
            this.setFormatIdCalcMember(member, tupleInd);
        } else {
            this.setFormatIdRegularMember(member, tupleInd);
        }
    }

    private void setFormatIdCalcMember(IEssMdMember member, int tupleInd) {
        this.measureFormatIds[tupleInd] = FormatId.EMPTY_FORMAT_FID;
        this.logInfo("null format ID was generated for calculated member \"", this.essbaseAPI.getMdMemberName(member), STR_QUOTE);
    }

    private void setFormatIdRegularMember(IEssMdMember member, int tupleInd) {
        if (this.essbaseAPI.isDimension(member)) {
            this.setFormatIdDimension(member, tupleInd);
        } else {
            this.setFormatIDRegularCell(member, tupleInd);
        }
    }

    private void setFormatIdDimension(IEssMdMember member, int tupleInd) {
        if (this.indexFirstRealFormatID >= 0) {
            FormatId formatId;
            this.measureFormatIds[tupleInd] = formatId = this.measureFormatIds[this.indexFirstRealFormatID++];
            this.logInfo(STR_FORMATID, formatId.toString(), STR_QUOTE, " was generated for dimension \"", this.essbaseAPI.getMdMemberName(member), STR_QUOTE);
        } else {
            this.measureFormatIds[tupleInd] = FormatId.EMPTY_FORMAT_FID;
            this.logInfo("null format ID was generated for dimension \"", this.essbaseAPI.getMdMemberName(member), STR_QUOTE);
        }
    }

    private void setFormatIDRegularCell(IEssMdMember member, int tupleInd) {
        String memberName = this.essbaseAPI.getMdMemberName(member);
        EssbaseMemberCacheItem cachedMember = this.metadataCache.addMember(null, memberName, null);
        String formatString = cachedMember.getFormatString();
        FormatId formatId = FormatId.EMPTY_FORMAT_FID;
        if (formatString != null) {
            EssbaseFormatInfo info = new EssbaseFormatInfo(formatString);
            formatId = this.service.registerEssbaseCellFormat((IFormatInfo)info, this.formatLocale);
        }
        this.measureFormatIds[tupleInd] = formatId;
        this.logInfo(STR_FORMATID, formatId.toString(), STR_QUOTE, " was generated for measure \"", memberName, STR_QUOTE, " basing on format string \"", formatString, STR_QUOTE);
        if (this.indexFirstRealFormatID < 0) {
            this.indexFirstRealFormatID = tupleInd;
        }
    }

    public FormatId findMeasureFormatID(int cellOrdinal) {
        int nTuples = this.measureFormatIds.length;
        if (this.formatType == FormatEnum.COLUMNS) {
            int index = cellOrdinal % this.nColumns % nTuples;
            return this.measureFormatIds[index];
        }
        if (this.formatType == FormatEnum.ROWS) {
            int index = cellOrdinal / this.nColumns % nTuples;
            return this.measureFormatIds[index];
        }
        if (this.formatType == FormatEnum.LIST) {
            int index = cellOrdinal % nTuples;
            return this.measureFormatIds[index];
        }
        if (this.formatType == FormatEnum.SLICER) {
            return this.measureFormatIds[0];
        }
        return null;
    }

    private void logInfo(String ... arguments) {
        if (this.logger.isOn(LogLevel.INFO)) {
            StringBuilder buf = new StringBuilder("Essbase: ");
            for (String text : arguments) {
                buf.append(text);
            }
            this.logger.log(LogLevel.INFO, buf.toString());
        }
    }

    public static enum FormatEnum {
        NONE,
        SLICER,
        COLUMNS,
        ROWS,
        LIST;

    }
}

