/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.data.providers.olap.essbase;

import com.cognos.xqe.data.providers.olap.essbase.EssbaseConnection;
import com.cognos.xqe.data.providers.olap.essbase.EssbaseMetadataNames;
import com.cognos.xqe.data.providers.olap.essbase.EssbaseWrappers;
import com.cognos.xqe.util.UniqueNameGenerator;
import com.essbase.api.base.IEssValueAny;
import com.essbase.api.dataquery.IEssMdMember;
import com.essbase.api.metadata.IEssMember;

public class EssbaseMemberAncestorsHelper {
    private String[] ancestorNames = null;
    private String parentName = null;
    private String parentUniqueName = null;
    boolean isParentExist = false;
    private String dimensionName = null;

    public EssbaseMemberAncestorsHelper(EssbaseConnection connection, IEssMember essMember, String memberUniqueName) {
        EssbaseWrappers essbaseAPI = connection.getEssAPI();
        this.dimensionName = essbaseAPI.getDimensionName(essMember);
        String memberName = essbaseAPI.getMemberName(essMember);
        if (!this.dimensionName.equals(memberName)) {
            int ancestorCount;
            String[] parts = EssbaseMetadataNames.parseUniqueName(memberUniqueName);
            if (memberName.equals(parts[(ancestorCount = parts.length) - 1])) {
                --ancestorCount;
            }
            this.ancestorNames = new String[ancestorCount];
            for (int i = 0; i < ancestorCount; ++i) {
                this.ancestorNames[i] = parts[i];
            }
            this.isParentExist = true;
            this.parentName = this.ancestorNames[this.ancestorNames.length - 1];
        }
    }

    public EssbaseMemberAncestorsHelper(EssbaseConnection connection, IEssMdMember essMember) {
        String partsString;
        EssbaseWrappers essbaseAPI = connection.getEssAPI();
        this.dimensionName = essbaseAPI.getMdMemberName(essbaseAPI.getDimension(essMember));
        IEssValueAny propertyValue = essbaseAPI.getPropertyValueAny(essMember, "ANCESTOR_NAMES");
        if (propertyValue != null && essbaseAPI.getDataTypeIntValue(propertyValue) != 0 && (partsString = essbaseAPI.getString(propertyValue)) != null) {
            this.ancestorNames = EssbaseMetadataNames.parseAncestorNames(partsString);
            if (this.ancestorNames != null && this.ancestorNames.length > 0) {
                this.isParentExist = true;
                this.parentName = this.ancestorNames[this.ancestorNames.length - 1];
            }
        }
    }

    public String getParentName() {
        return this.parentName;
    }

    public String getParentUniqueName() {
        if (this.isParentExist) {
            if (this.parentUniqueName == null) {
                this.parentUniqueName = UniqueNameGenerator.createUniqueName((String[])this.ancestorNames);
            }
            return this.parentUniqueName;
        }
        return null;
    }

    public boolean isParentExist() {
        return this.isParentExist;
    }

    public String getDimensionName() {
        return this.dimensionName;
    }

    public int getParentNumber() {
        if (this.isParentExist) {
            return this.ancestorNames.length - 1;
        }
        return -1;
    }
}

