/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.data.providers.olap.essbase;

import com.cognos.xqe.ast.olap.util.DescendantsRangeFlagEnum;
import com.cognos.xqe.bibushandler.OperationCanceledException;
import com.cognos.xqe.config.ServiceEnumeration;
import com.cognos.xqe.data.providers.olap.essbase.EssbaseConnection;
import com.cognos.xqe.data.providers.olap.essbase.EssbaseLocalizedString;
import com.cognos.xqe.data.providers.olap.essbase.EssbaseMemberAncestorsHelper;
import com.cognos.xqe.data.providers.olap.essbase.EssbaseMessageKeys;
import com.cognos.xqe.data.providers.olap.essbase.EssbaseMetadataCache;
import com.cognos.xqe.data.providers.olap.essbase.EssbaseMetadataNames;
import com.cognos.xqe.data.providers.olap.essbase.EssbaseMetadataProvider;
import com.cognos.xqe.data.providers.olap.essbase.EssbasePropertyCacheItem;
import com.cognos.xqe.data.providers.olap.essbase.EssbaseRuntimeException;
import com.cognos.xqe.data.providers.olap.essbase.EssbaseUtil;
import com.cognos.xqe.data.providers.olap.essbase.EssbaseWrappers;
import com.cognos.xqe.data.values.Value;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.metadata.MemberTypeEnum;
import com.cognos.xqe.metadata.TreeOperatorEnum;
import com.cognos.xqe.metadata.record.LevelRecord;
import com.cognos.xqe.metadata.record.MemberRecord;
import com.cognos.xqe.trace.LogLevel;
import com.cognos.xqe.trace.XQELog;
import com.cognos.xqe.trace.XQELogger;
import com.cognos.xqe.util.ILocalizedString;
import com.cognos.xqe.util.LocalizedString;
import com.cognos.xqe.util.UniqueNameGenerator;
import com.essbase.api.base.IEssValueAny;
import com.essbase.api.dataquery.IEssMdAxis;
import com.essbase.api.dataquery.IEssMdDataSet;
import com.essbase.api.dataquery.IEssMdMember;
import com.essbase.api.datasource.IEssCube;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class EssbaseMembersAndProperties {
    private static final String STR_SELECT = "SELECT {} on AXIS(0), {[";
    private static final String STR_ENDSELECT = "} ";
    private static final String MDX_COMMA = " , ";
    private static final String STR_PROPERTIES = "DIMENSION PROPERTIES ANCESTOR_NAMES, COMMENTS, MEMBER_UNIQUE_NAME";
    private static final String STR_AXIS_FROM = " ON AXIS(1) FROM [";
    private static final String STR_CHILDREN = ".CHILDREN} ";
    private static final String STR_COMMA_OPEN_BRKT = ", [";
    private static final String STR_OPENING_BRKT = "[";
    private static final String STR_CLOSING_BRKT = "]";
    private static final String STR_FULL_STOP = ".";
    private static final String STR_BRKT_BRKT = "].[";
    private static final String STR_MEMBER = "MEMBER(\"";
    private static final String STR_CLOSING_PRTS = "\")";
    private final EssbaseConnection connection;
    private final EssbaseWrappers essbaseAPI;
    private final EssbaseMetadataCache metadataCache;
    private final EssbaseLocalizedString localizedStringHelper;
    private final String catalogName;
    private final String cubeName;
    private String dimensionName = null;
    private String levelName = null;
    private int levelNumber = -1;
    private String dimensionUN = null;
    private String hierarchyUN = null;
    private String levelUN = null;
    private boolean isCaptionRequested = false;
    private boolean isMeasure = false;
    private final XQELogger logger = XQELog.getLogger((ServiceEnumeration)ServiceEnumeration.XQEODP, (String)"Essbase", (String)"Metadata", (LogLevel)LogLevel.INFO);

    public EssbaseMembersAndProperties(EssbaseConnection theConnection, EssbaseLocalizedString theLocalizedStringHelper) {
        this.connection = theConnection;
        this.essbaseAPI = this.connection.getEssAPI();
        this.metadataCache = this.connection.getMetadataCache();
        IEssCube cube = this.metadataCache.getEssConnectionCube();
        this.catalogName = this.essbaseAPI.getCatalogName(cube);
        this.cubeName = this.essbaseAPI.getCubeName(cube);
        this.localizedStringHelper = theLocalizedStringHelper;
    }

    public void getMemberRecordsWithProperies(String inputLevelName, EssbaseMetadataProvider.QueryParameters parameters, List<MemberRecord> membersFound) {
        String measureDimensionName;
        this.dimensionName = parameters.dimName;
        Map<String, String> aliasTableNames = parameters.aliasTableNames;
        if (aliasTableNames != null && !aliasTableNames.isEmpty()) {
            this.isCaptionRequested = true;
        }
        if (this.dimensionName.equals(measureDimensionName = this.metadataCache.getMeasureDimensionName())) {
            this.isMeasure = true;
        }
        this.runDataQuery(inputLevelName, parameters, membersFound);
    }

    public void runDataQuery(String inputLevelName, EssbaseMetadataProvider.QueryParameters parameters, List<MemberRecord> membersFound) {
        DataMemberRecordHelper recordHelper = new DataMemberRecordHelper(inputLevelName, parameters);
        String mdx = recordHelper.generateCMD();
        IEssMdDataSet dataSet = this.connection.getMdDataSet(this.catalogName, this.cubeName, mdx);
        recordHelper.setDataset(dataSet);
        recordHelper.getMemberRecords(membersFound);
    }

    private class DataMemberRecordHelper
    extends MemberRecordHelper {
        private IEssMdDataSet dataSet;
        private IEssMdMember essMember;
        private int propertyIndex;

        DataMemberRecordHelper(String inputLevelName, EssbaseMetadataProvider.QueryParameters parameters) {
            super(inputLevelName, parameters);
            this.dataSet = null;
            this.essMember = null;
            this.propertyIndex = 1;
        }

        @Override
        protected String generateCMD() {
            String mdx = null;
            if (this.parameters.memberName != null) {
                mdx = this.generateMDXmbr();
            } else if (this.inputLevelName != null) {
                mdx = this.generateMDXlvlName();
            } else if (this.parameters.levelNumber >= 0) {
                mdx = this.generateMDXlvlNumber();
            } else {
                if (EssbaseMembersAndProperties.this.logger.isOn(LogLevel.ERROR)) {
                    EssbaseMembersAndProperties.this.logger.log(LogLevel.ERROR, "For getMembers() metadata API call attribites are requested to be returned with members, but member name or level name/number is not set.");
                }
                throw new EssbaseRuntimeException(EssbaseMessageKeys.ERR_UNSUPPORTED_RESTRICTION_COMBINATION);
            }
            if (EssbaseMembersAndProperties.this.logger.isOn()) {
                StringBuilder buf = new StringBuilder();
                buf.append("Generated MDX: ").append(mdx);
                EssbaseMembersAndProperties.this.logger.log(buf.toString());
            }
            return mdx;
        }

        private String generateMDXmbr() {
            EnumSet<TreeOperatorEnum> treeOpSet = this.parameters.treeOpSet;
            StringBuilder mdx = new StringBuilder("SELECT {} on AXIS(0), {");
            String memberUName = this.getQualifiedMemberName();
            StringBuilder mdxBuffer = new StringBuilder();
            if (treeOpSet != null && !treeOpSet.isEmpty()) {
                if (treeOpSet.contains(TreeOperatorEnum.DESCENDANTS)) {
                    mdxBuffer.append("DESCENDANTS(");
                    mdxBuffer.append(memberUName);
                    if (this.parameters.descendantsleveldistance != null) {
                        mdxBuffer.append(EssbaseMembersAndProperties.MDX_COMMA);
                        mdxBuffer.append(this.parameters.descendantsleveldistance);
                    }
                    if (this.parameters.descendantsopt != null) {
                        mdxBuffer.append(EssbaseMembersAndProperties.MDX_COMMA);
                        mdxBuffer.append(DescendantsRangeFlagEnum.getStringFlag((int)this.parameters.descendantsopt));
                    }
                    mdxBuffer.append(")");
                }
                if (treeOpSet.contains(TreeOperatorEnum.SELF)) {
                    if (mdxBuffer.length() > 0) {
                        mdxBuffer.append(EssbaseMembersAndProperties.MDX_COMMA);
                    }
                    mdxBuffer.append("{");
                    mdxBuffer.append(memberUName);
                    mdxBuffer.append("}");
                }
                if (treeOpSet.contains(TreeOperatorEnum.CHILDREN)) {
                    if (mdxBuffer.length() > 0) {
                        mdxBuffer.append(EssbaseMembersAndProperties.MDX_COMMA);
                    }
                    mdxBuffer.append(memberUName);
                    mdxBuffer.append(".CHILDREN");
                }
            } else {
                mdxBuffer.append(memberUName);
            }
            mdx.append((CharSequence)mdxBuffer);
            mdx.append(EssbaseMembersAndProperties.STR_ENDSELECT);
            mdx.append(EssbaseMembersAndProperties.STR_PROPERTIES);
            this.appendAliasTableNames(this.parameters.aliasTableNames, mdx);
            this.appendPropertyNames(mdx);
            mdx.append(EssbaseMembersAndProperties.STR_AXIS_FROM);
            mdx.append(EssbaseMembersAndProperties.this.catalogName).append(EssbaseMembersAndProperties.STR_FULL_STOP).append(EssbaseMembersAndProperties.this.cubeName).append(EssbaseMembersAndProperties.STR_CLOSING_BRKT);
            return mdx.toString();
        }

        private String getQualifiedMemberName() {
            if (EssbaseMembersAndProperties.this.metadataCache.isDuplicateMembersAllowed()) {
                return this.parameters.memberUniqueName;
            }
            StringBuilder name = new StringBuilder();
            String parentMemberName = EssbaseUtil.extractParentName(this.parameters.memberUniqueName);
            if (parentMemberName != null) {
                name.append(EssbaseMembersAndProperties.STR_OPENING_BRKT).append(parentMemberName).append("].");
            }
            name.append(EssbaseMembersAndProperties.STR_OPENING_BRKT).append(this.parameters.memberName).append(EssbaseMembersAndProperties.STR_CLOSING_BRKT);
            return name.toString();
        }

        private String generateMDXlvlName() {
            StringBuilder mdx = new StringBuilder();
            mdx.append(EssbaseMembersAndProperties.STR_SELECT).append(EssbaseMembersAndProperties.this.dimensionName);
            mdx.append(EssbaseMembersAndProperties.STR_BRKT_BRKT).append(this.inputLevelName).append("].Members} ");
            mdx.append(EssbaseMembersAndProperties.STR_PROPERTIES);
            this.appendAliasTableNames(this.parameters.aliasTableNames, mdx);
            this.appendPropertyNames(mdx);
            mdx.append(EssbaseMembersAndProperties.STR_AXIS_FROM);
            mdx.append(EssbaseMembersAndProperties.this.catalogName).append(EssbaseMembersAndProperties.STR_FULL_STOP).append(EssbaseMembersAndProperties.this.cubeName).append(EssbaseMembersAndProperties.STR_CLOSING_BRKT);
            return mdx.toString();
        }

        private String generateMDXlvlNumber() {
            StringBuilder mdx = new StringBuilder();
            mdx.append(EssbaseMembersAndProperties.STR_SELECT).append(EssbaseMembersAndProperties.this.dimensionName);
            mdx.append("].Generations(").append(this.parameters.levelNumber + 1).append(").Members} ");
            mdx.append(EssbaseMembersAndProperties.STR_PROPERTIES);
            this.appendAliasTableNames(this.parameters.aliasTableNames, mdx);
            this.appendPropertyNames(mdx);
            mdx.append(EssbaseMembersAndProperties.STR_AXIS_FROM);
            mdx.append(EssbaseMembersAndProperties.this.catalogName).append(EssbaseMembersAndProperties.STR_FULL_STOP).append(EssbaseMembersAndProperties.this.cubeName).append(EssbaseMembersAndProperties.STR_CLOSING_BRKT);
            return mdx.toString();
        }

        private void appendAliasTableNames(Map<String, String> aliasTableNames, StringBuilder mdx) {
            if (EssbaseMembersAndProperties.this.isCaptionRequested) {
                for (String name : aliasTableNames.values()) {
                    mdx.append(EssbaseMembersAndProperties.STR_COMMA_OPEN_BRKT).append(name).append(EssbaseMembersAndProperties.STR_CLOSING_BRKT);
                }
            }
        }

        private void appendPropertyNames(StringBuilder mdx) {
            if (EssbaseMembersAndProperties.this.metadataCache.isPropertiesExist(EssbaseMembersAndProperties.this.dimensionName)) {
                List<EssbasePropertyCacheItem> properties = EssbaseMembersAndProperties.this.metadataCache.getCacheProperties(EssbaseMembersAndProperties.this.dimensionName);
                for (EssbasePropertyCacheItem property : properties) {
                    mdx.append(EssbaseMembersAndProperties.STR_COMMA_OPEN_BRKT).append(property.getName()).append(EssbaseMembersAndProperties.STR_CLOSING_BRKT);
                }
            }
        }

        private void setDataset(IEssMdDataSet theDataSet) {
            this.dataSet = theDataSet;
        }

        @Override
        protected void getMemberRecords(List<MemberRecord> membersFound) {
            String currentLevelName = this.inputLevelName;
            if (this.parameters.treeOpSet != null && (this.parameters.treeOpSet.contains(TreeOperatorEnum.CHILDREN) || this.parameters.treeOpSet.contains(TreeOperatorEnum.DESCENDANTS))) {
                currentLevelName = null;
            }
            Map<String, String> aliasTableNames = this.parameters.aliasTableNames;
            IEssMdAxis[] essAxes = EssbaseMembersAndProperties.this.essbaseAPI.getAllAxes(this.dataSet);
            IEssMdAxis essAxis = essAxes[essAxes.length - 1];
            int nTuples = EssbaseMembersAndProperties.this.essbaseAPI.getTupleCount(essAxis);
            for (int tupleInd = 0; tupleInd < nTuples; ++tupleInd) {
                IEssMdMember[] essMbrs;
                IEssMdMember[] iEssMdMemberArray = essMbrs = EssbaseMembersAndProperties.this.essbaseAPI.getAllTupleMembers(essAxis, tupleInd);
                int n = iEssMdMemberArray.length;
                for (int i = 0; i < n; ++i) {
                    IEssMdMember essMbr;
                    this.essMember = essMbr = iEssMdMemberArray[i];
                    this.resetPropertyIndex();
                    EssbaseMemberAncestorsHelper ancestorNames = new EssbaseMemberAncestorsHelper(EssbaseMembersAndProperties.this.connection, this.essMember);
                    if (EssbaseMembersAndProperties.this.dimensionName.compareToIgnoreCase(ancestorNames.getDimensionName()) != 0) {
                        EssbaseMembersAndProperties.this.logger.log(LogLevel.ERROR, EssbaseMessageKeys.ERR_INVALID_DIMENSION_NAME.toString());
                        throw new EssbaseRuntimeException(EssbaseMessageKeys.ERR_INVALID_DIMENSION_NAME, EssbaseMembersAndProperties.this.dimensionName);
                    }
                    this.setNames(currentLevelName, ancestorNames);
                    MemberRecord memberRec = this.generateMemberRecord(ancestorNames, aliasTableNames);
                    membersFound.add(memberRec);
                }
            }
        }

        private void resetPropertyIndex() {
            this.propertyIndex = 1;
        }

        @Override
        protected String getMemberName() {
            return EssbaseMembersAndProperties.this.essbaseAPI.getMdMemberName(this.essMember);
        }

        @Override
        protected String getDescription() {
            IEssValueAny propertyValue = EssbaseMembersAndProperties.this.essbaseAPI.getPropertyValueAny(this.essMember, this.propertyIndex++);
            if (propertyValue != null) {
                return propertyValue.toString();
            }
            return null;
        }

        @Override
        protected void setMemberUniqueness() {
            ++this.propertyIndex;
        }

        @Override
        protected LocalizedString getCaption() {
            String runLocale = EssbaseMembersAndProperties.this.localizedStringHelper.getRunLocaleStr();
            String memberName = EssbaseMembersAndProperties.this.essbaseAPI.getMdMemberName(this.essMember);
            HashMap<String, String> cachedAliasNames = new HashMap<String, String>();
            if (EssbaseMembersAndProperties.this.isCaptionRequested) {
                Map<String, String> aliasTableNames = this.parameters.aliasTableNames;
                for (String language : aliasTableNames.keySet()) {
                    IEssValueAny propertyValue = EssbaseMembersAndProperties.this.essbaseAPI.getPropertyValueAny(this.essMember, this.propertyIndex++);
                    if (propertyValue == null) {
                        cachedAliasNames.put(language, memberName);
                        continue;
                    }
                    String captionName = propertyValue.toString();
                    if (EssbaseUtil.isEmpty(captionName)) {
                        cachedAliasNames.put(language, memberName);
                        continue;
                    }
                    cachedAliasNames.put(language, captionName);
                }
                LocalizedString localizedCaption = null;
                String runLocaleLanguage = EssbaseMembersAndProperties.this.localizedStringHelper.getRunLocaleLanguage();
                String defaultCaption = (String)cachedAliasNames.get(runLocaleLanguage);
                localizedCaption = defaultCaption == null ? new LocalizedString(runLocale, memberName) : new LocalizedString(runLocale, defaultCaption);
                for (String language : aliasTableNames.keySet()) {
                    if (language.equals(runLocaleLanguage)) continue;
                    String captionName = (String)cachedAliasNames.get(language);
                    localizedCaption.put(language, captionName);
                }
                return localizedCaption;
            }
            LocalizedString localizedCaption = new LocalizedString(runLocale, memberName);
            return localizedCaption;
        }

        @Override
        protected MemberTypeEnum getMemberType() {
            boolean isCalced = EssbaseMembersAndProperties.this.essbaseAPI.isCalced(this.essMember);
            if (isCalced) {
                return MemberTypeEnum.CALCULATED;
            }
            return MemberTypeEnum.UNKNOWN;
        }

        @Override
        protected void setAttributeProperies(MemberRecord memberRec) {
            if (EssbaseMembersAndProperties.this.metadataCache.isPropertiesExist(EssbaseMembersAndProperties.this.dimensionName)) {
                List<EssbasePropertyCacheItem> properties = EssbaseMembersAndProperties.this.metadataCache.getCacheProperties(EssbaseMembersAndProperties.this.dimensionName);
                for (EssbasePropertyCacheItem property : properties) {
                    this.setAttributeProperty(property.getName(), memberRec);
                }
            }
        }

        private void setAttributeProperty(String propertyName, MemberRecord memberRec) {
            int currentPropertyIndex = this.propertyIndex++;
            IEssValueAny.EEssDataType type = EssbaseMembersAndProperties.this.essbaseAPI.getPropertyDataType(this.essMember, currentPropertyIndex);
            if (EssbaseMembersAndProperties.this.essbaseAPI.intValue(type) == 0) {
                return;
            }
            IEssValueAny propertyValue = EssbaseMembersAndProperties.this.essbaseAPI.getPropertyValueAny(this.essMember, currentPropertyIndex);
            if (propertyValue == null) {
                return;
            }
            Value v = EssbaseUtil.getPropertyValue(EssbaseMembersAndProperties.this.connection, propertyName, type, propertyValue, null);
            String propertyUNAme = UniqueNameGenerator.createUniqueName((String)EssbaseMembersAndProperties.this.dimensionName, (String)propertyName);
            memberRec.setDynamicFieldAsValue(propertyUNAme, v);
        }
    }

    private abstract class MemberRecordHelper {
        protected final String inputLevelName;
        protected final EssbaseMetadataProvider.QueryParameters parameters;

        MemberRecordHelper(String theInputLevelName, EssbaseMetadataProvider.QueryParameters theParameters) {
            this.inputLevelName = theInputLevelName;
            this.parameters = theParameters;
        }

        protected void setNames(String currentLevelName, EssbaseMemberAncestorsHelper ancestorNames) {
            EssbaseMembersAndProperties.this.levelNumber = ancestorNames.getParentNumber() + 1;
            if (EssbaseMembersAndProperties.this.isMeasure) {
                EssbaseMembersAndProperties.this.levelNumber--;
            }
            if (currentLevelName != null) {
                EssbaseMembersAndProperties.this.levelName = currentLevelName;
            } else {
                Set<LevelRecord> levelCache = EssbaseMembersAndProperties.this.metadataCache.getDimensionLevelCache(ancestorNames.getDimensionName());
                Iterator<LevelRecord> iter = levelCache.iterator();
                LevelRecord levelRecord = null;
                for (int i = 0; i <= EssbaseMembersAndProperties.this.levelNumber; ++i) {
                    levelRecord = iter.next();
                }
                if (levelRecord == null) {
                    throw new XQERuntimeException(XQEMessageKeys.GEN_FoundInternalErrorParam_INTERNAL, "Error during creating and caching cache members: levelRecord here is null");
                }
                EssbaseMembersAndProperties.this.levelName = levelRecord.getName();
            }
            EssbaseMembersAndProperties.this.dimensionUN = EssbaseMetadataNames.createDimensionUniqueName(EssbaseMembersAndProperties.this.dimensionName);
            EssbaseMembersAndProperties.this.hierarchyUN = EssbaseMetadataNames.createHierarchyUniqueName(EssbaseMembersAndProperties.this.dimensionName);
            EssbaseMembersAndProperties.this.levelUN = EssbaseMetadataNames.createLevelUniqueName(EssbaseMembersAndProperties.this.dimensionName, EssbaseMembersAndProperties.this.levelName);
        }

        public MemberRecord generateMemberRecord(EssbaseMemberAncestorsHelper ancestorNames, Map<String, String> aliasTableNames) {
            if (EssbaseMembersAndProperties.this.metadataCache.getCancelManager() != null && EssbaseMembersAndProperties.this.metadataCache.getCancelManager().isRequestCancelled()) {
                throw new OperationCanceledException();
            }
            MemberRecord memberRec = new MemberRecord();
            String memberName = this.getMemberName();
            memberRec.setName(memberName);
            this.setMemberUniqueName(memberName, ancestorNames, memberRec);
            String description = this.getDescription();
            if (!EssbaseUtil.isEmpty(description)) {
                memberRec.setDescription(description);
            }
            this.setMemberUniqueness();
            LocalizedString localizedCaption = this.getCaption();
            memberRec.setCaption((ILocalizedString)localizedCaption);
            memberRec.setLevelNumber(EssbaseMembersAndProperties.this.levelNumber);
            if (EssbaseMembersAndProperties.this.levelNumber <= 0) {
                memberRec.setParentCount(0);
            } else {
                memberRec.setParentCount(1);
            }
            memberRec.setParentLevelNumber(EssbaseMembersAndProperties.this.levelNumber - 1);
            memberRec.setParentUniqueName(ancestorNames.getParentUniqueName());
            memberRec.setCatalogName(EssbaseMembersAndProperties.this.catalogName);
            memberRec.setCubeName(EssbaseMembersAndProperties.this.cubeName);
            memberRec.setDimensionUniqueName(EssbaseMembersAndProperties.this.dimensionUN);
            memberRec.setHierarchyUniqueName(EssbaseMembersAndProperties.this.hierarchyUN);
            memberRec.setLevelUniqueName(EssbaseMembersAndProperties.this.levelUN);
            memberRec.setUniqueId(memberRec.getName());
            MemberTypeEnum memberType = this.getMemberType();
            memberRec.setType(memberType);
            this.setAttributeProperies(memberRec);
            return memberRec;
        }

        private void setMemberUniqueName(String memberName, EssbaseMemberAncestorsHelper ancestorNames, MemberRecord memberRec) {
            String externalMUN = null;
            externalMUN = ancestorNames.isParentExist() ? UniqueNameGenerator.appendUniqueName((String)ancestorNames.getParentUniqueName(), (String)memberName) : (memberName.equals(EssbaseMembersAndProperties.this.dimensionName) ? UniqueNameGenerator.createUniqueName((String)memberName) : UniqueNameGenerator.createUniqueName((String)EssbaseMembersAndProperties.this.dimensionName, (String)memberName));
            memberRec.setUniqueName(externalMUN);
        }

        protected abstract String generateCMD();

        protected abstract void getMemberRecords(List<MemberRecord> var1);

        protected abstract String getMemberName();

        protected abstract String getDescription();

        protected abstract void setMemberUniqueness();

        protected abstract LocalizedString getCaption();

        protected abstract void setAttributeProperies(MemberRecord var1);

        protected abstract MemberTypeEnum getMemberType();
    }
}

