/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.data.providers.olap.essbase;

import com.cognos.xqe.bibushandler.CancelManager;
import com.cognos.xqe.config.ServiceEnumeration;
import com.cognos.xqe.data.providers.olap.essbase.EssbaseConnection;
import com.cognos.xqe.data.providers.olap.essbase.EssbaseDimensionCacheItem;
import com.cognos.xqe.data.providers.olap.essbase.EssbaseMacro;
import com.cognos.xqe.data.providers.olap.essbase.EssbaseMemberCacheItem;
import com.cognos.xqe.data.providers.olap.essbase.EssbaseMemberCacheKey;
import com.cognos.xqe.data.providers.olap.essbase.EssbaseMessageKeys;
import com.cognos.xqe.data.providers.olap.essbase.EssbaseMetadataNames;
import com.cognos.xqe.data.providers.olap.essbase.EssbaseNamedSet;
import com.cognos.xqe.data.providers.olap.essbase.EssbasePropertyCacheItem;
import com.cognos.xqe.data.providers.olap.essbase.EssbaseRuntimeException;
import com.cognos.xqe.data.providers.olap.essbase.EssbaseWrappers;
import com.cognos.xqe.metadata.record.HierarchyRecord;
import com.cognos.xqe.metadata.record.LevelRecord;
import com.cognos.xqe.trace.LogLevel;
import com.cognos.xqe.trace.XQELog;
import com.cognos.xqe.trace.XQELogger;
import com.cognos.xqe.util.UniqueNameGenerator;
import com.essbase.api.base.IEssIterator;
import com.essbase.api.datasource.IEssCube;
import com.essbase.api.datasource.IEssOlapApplication;
import com.essbase.api.metadata.EssGenOrLevel;
import com.essbase.api.metadata.IEssDimension;
import com.essbase.api.metadata.IEssMember;
import com.essbase.api.metadata.IEssMemberSelection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

public class EssbaseMetadataCache {
    static final String STR_CATALOG = "; catalog=";
    static final String STR_CUBE = "; cube=";
    static final String STR_DIMENSION = "; dimension=";
    private static final String STR_LOG_MESS1 = "Metadata cache: dimension \"";
    private static final String STR_LOG_MESS2 = "Metadata cache: member \"";
    private static final String STR_LOG_MESS3 = "\" added to the cache.";
    private static final String STR_LOG_MESS4 = "\" retrieved from the cache.";
    private Map<String, IEssOlapApplication> essCatalogMap = new LinkedHashMap<String, IEssOlapApplication>();
    private Map<String, Map<String, IEssCube>> essCubeMap = new LinkedHashMap<String, Map<String, IEssCube>>();
    private Map<String, IEssDimension> essDimensionMap = new LinkedHashMap<String, IEssDimension>();
    private IEssCube essConnectionCube = null;
    private Map<String, IEssMember> essRootMemberMap = new LinkedHashMap<String, IEssMember>();
    private Map<String, Map<String, String>> rootMemberAliasNames = new HashMap<String, Map<String, String>>();
    private Map<String, EssbaseDimensionCacheItem> dimensionCache = new LinkedHashMap<String, EssbaseDimensionCacheItem>();
    private Map<String, Set<HierarchyRecord>> hierarchyCache = new LinkedHashMap<String, Set<HierarchyRecord>>();
    private Map<String, Set<LevelRecord>> levelCache = new HashMap<String, Set<LevelRecord>>();
    private Map<EssbaseMemberCacheKey, EssbaseMemberCacheItem> memberCache = new HashMap<EssbaseMemberCacheKey, EssbaseMemberCacheItem>();
    private Map<String, List<EssbasePropertyCacheItem>> propertyCache = new HashMap<String, List<EssbasePropertyCacheItem>>();
    private Map<String, EssbaseNamedSet> namedSetCache = null;
    private Map<String, EssbaseMacro> macroCache = null;
    private String measureDimensionName = null;
    private Map<String, Map<String, String>> propertyCaptions = new HashMap<String, Map<String, String>>();
    private String[] essAliasTableNames = null;
    private final EssbaseConnection connection;
    private final EssbaseWrappers essbaseAPI;
    private boolean isDuplicateMembersAllowed = false;
    private final XQELogger logger = XQELog.getLogger((ServiceEnumeration)ServiceEnumeration.XQEODP, (String)"Essbase", (String)"Metadata", (LogLevel)LogLevel.TRACE);
    private CancelManager cancelManager;

    public EssbaseMetadataCache(EssbaseConnection theConnection) {
        this.connection = theConnection;
        this.essbaseAPI = this.connection.getEssAPI();
    }

    public final boolean isDuplicateMembersAllowed() {
        return this.isDuplicateMembersAllowed;
    }

    public final void setDuplicateMembersAllowed(boolean isDuplicateMembersAllowedFlag) {
        this.isDuplicateMembersAllowed = isDuplicateMembersAllowedFlag;
    }

    public Map<String, EssbaseNamedSet> createNamedSetCache() {
        this.namedSetCache = new LinkedHashMap<String, EssbaseNamedSet>();
        return this.namedSetCache;
    }

    public Map<String, EssbaseMacro> createMacroCache() {
        this.macroCache = new LinkedHashMap<String, EssbaseMacro>();
        return this.macroCache;
    }

    public Map<String, IEssOlapApplication> getCatalogMap() {
        return this.essCatalogMap;
    }

    public Map<String, Map<String, IEssCube>> getCubeMap() {
        return this.essCubeMap;
    }

    public Map<String, IEssCube> getCubeMap(String catalogName) {
        return this.essCubeMap.get(catalogName);
    }

    public Map<String, IEssDimension> getEssDimensionMap() {
        return this.essDimensionMap;
    }

    public final IEssCube getEssConnectionCube() {
        return this.essConnectionCube;
    }

    public Map<String, IEssMember> getEssRootMemberMap() {
        return this.essRootMemberMap;
    }

    public Map<String, Map<String, String>> getRootMemberAliasNames() {
        return this.rootMemberAliasNames;
    }

    public Map<String, String> getRootMemberAliasNames(String memberName) {
        return this.rootMemberAliasNames.get(memberName);
    }

    public void setEssConnectionCube(IEssCube cube) {
        this.essConnectionCube = cube;
    }

    public Set<HierarchyRecord> getDimensionHierarchyCache(String dimensionName) {
        return this.hierarchyCache.get(dimensionName);
    }

    public Set<LevelRecord> getDimensionLevelCache(String dimensionName) {
        return this.levelCache.get(dimensionName);
    }

    public Map<String, EssbaseMacro> getMacroCache() {
        return this.macroCache;
    }

    public Map<String, EssbaseNamedSet> getNamedSetCache() {
        return this.namedSetCache;
    }

    public EssbaseDimensionCacheItem findDimension(String dimensionName) {
        return this.dimensionCache.get(dimensionName);
    }

    public EssbaseDimensionCacheItem getDimension(String dimensionName) {
        EssbaseDimensionCacheItem cachedDimension = this.findDimension(dimensionName);
        if (cachedDimension == null) {
            IEssDimension essDimension = this.getEssDimensionMap().get(dimensionName);
            if (essDimension == null) {
                throw new EssbaseRuntimeException(EssbaseMessageKeys.ERR_INVALID_DIMENSION_NAME, dimensionName);
            }
            cachedDimension = this.loadDimension(essDimension);
        }
        return cachedDimension;
    }

    public EssbaseMemberCacheItem findMemberCacheItem(String parentName, String memberName) {
        EssbaseMemberCacheKey searchKey = new EssbaseMemberCacheKey(parentName, memberName);
        return this.memberCache.get(searchKey);
    }

    public void putMemberCacheItem(String parentName, String memberName, EssbaseMemberCacheItem item) {
        EssbaseMemberCacheKey searchKey = new EssbaseMemberCacheKey(parentName, memberName);
        this.memberCache.put(searchKey, item);
    }

    public String getMeasureDimensionName() {
        return this.measureDimensionName;
    }

    public void setMeasureDimensionName(String measureDimName) {
        this.measureDimensionName = measureDimName;
    }

    public String[] getEssAliasTableNames() {
        return this.essAliasTableNames;
    }

    public void setEssAliasTableNames(String[] aliasTableNames) {
        this.essAliasTableNames = aliasTableNames;
    }

    public List<EssbasePropertyCacheItem> getCacheProperties(String dimensionName) {
        return this.propertyCache.get(dimensionName);
    }

    public boolean isDimensionPropertiesCached(String dimensionName) {
        return this.propertyCache.containsKey(dimensionName);
    }

    public boolean isPropertiesExist(String dimensionName) {
        List<EssbasePropertyCacheItem> properties = this.propertyCache.get(dimensionName);
        return properties != null;
    }

    public void addCacheProperties(String dimensionName, List<EssbasePropertyCacheItem> propertyCacheItems) {
        this.propertyCache.put(dimensionName, propertyCacheItems);
    }

    public EssbaseDimensionCacheItem loadDimension(IEssDimension essDim) {
        if (this.logger.isOn()) {
            StringBuilder buf = new StringBuilder();
            buf.append("Metadata cache: loadDimension");
            buf.append(STR_CATALOG).append(this.essbaseAPI.getCatalogName(this.essConnectionCube));
            buf.append(STR_CUBE).append(this.essbaseAPI.getCubeName(this.essConnectionCube));
            buf.append(STR_DIMENSION).append(this.essbaseAPI.getDimensionName(essDim));
            this.logger.log(buf.toString());
        }
        EssbaseDimensionCacheItem dimension = this.addDimension(essDim);
        this.loadHierarchies(dimension);
        return dimension;
    }

    public EssbaseDimensionCacheItem addDimension(IEssDimension essDimension) {
        String dimensionName = this.essbaseAPI.getDimensionName(essDimension);
        EssbaseDimensionCacheItem dimension = this.findDimension(dimensionName);
        if (dimension == null) {
            dimension = new EssbaseDimensionCacheItem(this.connection);
            dimension.setCacheDimension(essDimension);
            this.dimensionCache.put(dimensionName, dimension);
            if (this.logger.isOn()) {
                StringBuilder buf = new StringBuilder();
                buf.append(STR_LOG_MESS1).append(dimensionName).append(STR_LOG_MESS3);
                this.logger.log(buf.toString());
            }
        } else if (this.logger.isOn()) {
            StringBuilder buf = new StringBuilder();
            buf.append(STR_LOG_MESS1).append(dimensionName).append(STR_LOG_MESS4);
            this.logger.log(buf.toString());
        }
        return dimension;
    }

    private void loadHierarchies(EssbaseDimensionCacheItem dimension) {
        if (this.logger.isOn()) {
            StringBuilder buf = new StringBuilder();
            buf.append("Metadata cache: loadHierarchies");
            buf.append(STR_CATALOG).append(this.essbaseAPI.getCatalogName(this.essConnectionCube));
            buf.append(STR_CUBE).append(this.essbaseAPI.getCubeName(this.essConnectionCube));
            buf.append(STR_DIMENSION).append(dimension.getName());
            this.logger.log(buf.toString());
        }
        Set<HierarchyRecord> newCache = this.setHierarchyCache(dimension);
        String dimensionName = dimension.getName();
        this.hierarchyCache.put(dimensionName, newCache);
    }

    private Set<HierarchyRecord> setHierarchyCache(EssbaseDimensionCacheItem dimension) {
        boolean isParentChild = this.loadLevels(dimension);
        HashSet<HierarchyRecord> newCache = new HashSet<HierarchyRecord>(1);
        newCache.add(this.createHierarchyRecord(dimension, null, isParentChild));
        return newCache;
    }

    private HierarchyRecord createHierarchyRecord(EssbaseDimensionCacheItem dimension, Map<String, String> aliasTableNames, boolean isParentChild) {
        HierarchyRecord hierarchyRec = new HierarchyRecord();
        String dimensionName = dimension.getName();
        hierarchyRec.setName(dimensionName.intern());
        String hun = EssbaseMetadataNames.createHierarchyUniqueName(dimensionName);
        hierarchyRec.setUniqueName(hun);
        String description = dimension.getDescription();
        if (description != null) {
            hierarchyRec.setDescription(description);
        }
        hierarchyRec.setCatalogName(dimension.getCatalogName());
        hierarchyRec.setCubeName(dimension.getCubeName());
        hierarchyRec.setDimensionUniqueName(dimension.getUniqueName());
        hierarchyRec.setCardinality(dimension.getCardinality());
        String defaultMUN = UniqueNameGenerator.createUniqueName((String)dimensionName);
        hierarchyRec.setDefaultMemberUniqueName(defaultMUN);
        hierarchyRec.setBalanced(dimension.isBalanced());
        hierarchyRec.setRagged(false);
        hierarchyRec.setParentChild(isParentChild);
        hierarchyRec.setUniqueId(hierarchyRec.getName());
        return hierarchyRec;
    }

    private boolean loadLevels(EssbaseDimensionCacheItem dimension) {
        if (this.logger.isOn()) {
            StringBuilder buf = new StringBuilder();
            buf.append("Metadata cache: loadLevels");
            buf.append(STR_CATALOG).append(dimension.getCatalogName());
            buf.append(STR_CUBE).append(dimension.getCubeName());
            buf.append(STR_DIMENSION).append(dimension.getName());
            this.logger.log(buf.toString());
        }
        TreeSet<LevelRecord> levelRecords = new TreeSet<LevelRecord>(new LevelRecordComparator());
        boolean isParentChild = this.getLevelRecords(dimension, levelRecords);
        String dimensionName = dimension.getName();
        this.levelCache.put(dimensionName, levelRecords);
        return isParentChild;
    }

    public Map<String, String> getPropertyCaptions(String propertName, String aliasTableName) {
        String key = propertName + aliasTableName;
        return this.propertyCaptions.get(key);
    }

    public void addPropertyCaptions(String propertName, String aliasTableName, Map<String, String> captions) {
        String key = propertName + aliasTableName;
        this.propertyCaptions.put(key, captions);
    }

    private boolean getLevelRecords(EssbaseDimensionCacheItem dimension, Set<LevelRecord> levelRecords) {
        String dimensionName = dimension.getName();
        boolean isParentChild = true;
        IEssMemberSelection mbrSel = this.connection.openMbrSel();
        IEssIterator essGenerations = this.essbaseAPI.getGenerations(mbrSel, dimensionName);
        int countEssGenerations = this.essbaseAPI.getCount(essGenerations);
        for (int i = 0; i < countEssGenerations; ++i) {
            EssGenOrLevel generation = (EssGenOrLevel)this.essbaseAPI.getAt(essGenerations, i);
            String name = this.essbaseAPI.getLevelName(generation);
            LevelRecord levelRec = this.createLevelRecord(name, i, dimension);
            levelRecords.add(levelRec);
            String actualName = this.essbaseAPI.getActualName(generation);
            if (actualName == null || actualName.length() <= 0) continue;
            isParentChild = false;
        }
        this.connection.releaseMbrSel(mbrSel);
        return isParentChild;
    }

    private LevelRecord createLevelRecord(String levelName, int levelNumber, EssbaseDimensionCacheItem dimension) {
        LevelRecord levelRec = new LevelRecord();
        levelRec.setName(levelName);
        levelRec.setCaption(levelName);
        String dimensionName = dimension.getName();
        String levelUniqueName = EssbaseMetadataNames.createLevelUniqueName(dimensionName, levelName);
        levelRec.setUniqueName(levelUniqueName);
        levelRec.setCatalogName(dimension.getCatalogName());
        levelRec.setCubeName(dimension.getCubeName());
        levelRec.setDimensionUniqueName(dimension.getUniqueName());
        levelRec.setHierarchyUniqueName(dimension.getDefaultHierarchyUniqueName());
        levelRec.setLevelNumber(levelNumber);
        levelRec.setUniqueId(levelRec.getName());
        levelRec.setUniqueMemberNames(false);
        levelRec.setCardinality(dimension.getCardinality());
        return levelRec;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public EssbaseMemberCacheItem addMember(IEssMember essMember, String memberName, String dimensionName) {
        EssbaseMemberCacheItem member = null;
        boolean isSharedMember = false;
        String parentName = null;
        if (essMember == null) {
            member = this.findMemberCacheItem(null, memberName);
        } else {
            if (this.essbaseAPI.isSharedMember(essMember)) {
                isSharedMember = true;
                parentName = this.essbaseAPI.getParentMemberName(essMember);
            }
            member = this.findMemberCacheItem(parentName, memberName);
        }
        if (member == null) {
            IEssMemberSelection essMbrSelection = this.connection.openMbrSel();
            try {
                member = new EssbaseMemberCacheItem(this.connection);
                member.setCacheMember(essMbrSelection, essMember, memberName, dimensionName);
                if (isSharedMember) {
                    this.putMemberCacheItem(parentName, memberName, member);
                } else {
                    this.putMemberCacheItem(null, memberName, member);
                }
                if (!this.logger.isOn()) return member;
                StringBuilder buf = new StringBuilder();
                buf.append(STR_LOG_MESS2).append(memberName).append(STR_LOG_MESS3);
                this.logger.log(buf.toString());
                return member;
            }
            finally {
                this.connection.releaseMbrSel(essMbrSelection);
            }
        } else {
            if (!this.logger.isOn()) return member;
            StringBuilder buf = new StringBuilder();
            buf.append(STR_LOG_MESS2).append(memberName).append(STR_LOG_MESS4);
            this.logger.log(buf.toString());
        }
        return member;
    }

    public void release() {
        if (null != this.propertyCache) {
            this.propertyCache.clear();
        }
        if (null != this.rootMemberAliasNames) {
            for (Map<String, String> map : this.rootMemberAliasNames.values()) {
                map.clear();
            }
            this.rootMemberAliasNames.clear();
        }
        if (null != this.essRootMemberMap) {
            this.essRootMemberMap.clear();
        }
        if (null != this.essDimensionMap) {
            this.essDimensionMap.clear();
        }
        this.essConnectionCube = null;
        if (null != this.memberCache) {
            this.memberCache.clear();
        }
        if (null != this.namedSetCache) {
            this.namedSetCache.clear();
        }
        if (null != this.macroCache) {
            this.macroCache.clear();
        }
        if (null != this.levelCache) {
            this.levelCache.clear();
        }
        if (null != this.hierarchyCache) {
            this.hierarchyCache.clear();
        }
        if (null != this.dimensionCache) {
            this.dimensionCache.clear();
        }
        if (null != this.essCubeMap) {
            for (Map<String, String> map : this.essCubeMap.values()) {
                map.clear();
            }
            this.essCubeMap.clear();
        }
        if (null != this.essCatalogMap) {
            this.essCatalogMap.clear();
        }
        if (null != this.propertyCaptions) {
            for (Map<String, String> map : this.propertyCaptions.values()) {
                map.clear();
            }
            this.propertyCaptions.clear();
        }
    }

    public void setCancelManager(CancelManager cancelMgr) {
        this.cancelManager = cancelMgr;
    }

    public CancelManager getCancelManager() {
        return this.cancelManager;
    }

    private class LevelRecordComparator
    implements Comparator<LevelRecord> {
        LevelRecordComparator() {
        }

        @Override
        public int compare(LevelRecord rec0, LevelRecord rec1) {
            int level0 = rec0.getLevelNumber();
            int level1 = rec1.getLevelNumber();
            return level0 - level1;
        }
    }
}

