/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.data.providers.olap.essbase;

import com.cognos.xqe.config.ServiceEnumeration;
import com.cognos.xqe.data.providers.olap.essbase.EssbaseExceptionHandler;
import com.cognos.xqe.data.providers.olap.essbase.EssbaseMessageKeys;
import com.cognos.xqe.data.providers.olap.essbase.EssbaseMetadataProvider;
import com.cognos.xqe.data.providers.olap.essbase.EssbaseRuntimeException;
import com.cognos.xqe.data.providers.olap.essbase.EssbaseUtil;
import com.cognos.xqe.metadata.AggregateTypeEnum;
import com.cognos.xqe.trace.LogLevel;
import com.cognos.xqe.trace.XQELog;
import com.cognos.xqe.trace.XQELogger;
import com.essbase.api.base.EssException;
import com.essbase.api.base.IEssBaseObject;
import com.essbase.api.base.IEssIterator;
import com.essbase.api.base.IEssValueAny;
import com.essbase.api.dataquery.IEssMdAxis;
import com.essbase.api.dataquery.IEssMdDataSet;
import com.essbase.api.dataquery.IEssMdMember;
import com.essbase.api.datasource.IEssCube;
import com.essbase.api.datasource.IEssOlapApplication;
import com.essbase.api.datasource.IEssOlapServer;
import com.essbase.api.metadata.EssGenOrLevel;
import com.essbase.api.metadata.IEssDimension;
import com.essbase.api.metadata.IEssMember;
import com.essbase.api.metadata.IEssMemberSelection;

public class EssbaseWrappers {
    static final String STR_EXECUTE_QUERY = "executeQuery";
    static final String STR_FLD_SELECTION = "field selection=";
    static final String STR_MBR_SELECTION = "member selection=";
    static final String STR_SEMICOLON = "\"; ";
    static final String STR_SERVER = "server";
    static final String STR_CATALOG = "catalog";
    static final String STR_CUBE = "cube";
    static final String STR_DIMENSION = "dimension";
    static final String STR_MEMBER = "member";
    static final String STR_PROPERTYVALUE = "propertyValue";
    static final String STR_MBR_NAME = "member=";
    static final String STR_DIM_NAME = "dimension=";
    static final String STR_ASSIGN = "=\"";
    static final String STR_QUOTE = "\"";
    static final String STR_API_CALL = "Essbase API call: \"";
    private final XQELogger logger = XQELog.getLogger((ServiceEnumeration)ServiceEnumeration.XQEODP, (String)"Essbase", (String)"3rdParty", (LogLevel)LogLevel.INFO);
    private EssbaseExceptionHandler mEssbaseExceptionHandler = null;

    public EssbaseWrappers(EssbaseExceptionHandler essbaseExceptionHandler) {
        this.mEssbaseExceptionHandler = essbaseExceptionHandler;
    }

    private void logInfo(String method) {
        StringBuilder buf = new StringBuilder();
        buf.append(STR_API_CALL).append(method).append(STR_QUOTE);
        this.logger.log(buf.toString());
    }

    private void logInfo(String method, String key, String value) {
        StringBuilder buf = new StringBuilder();
        buf.append(STR_API_CALL).append(method).append(STR_SEMICOLON);
        buf.append(key).append(STR_ASSIGN).append(value).append(STR_QUOTE);
        this.logger.log(buf.toString());
    }

    private void logInfo(String method, String key1, String value1, String key2, String value2) {
        StringBuilder buf = new StringBuilder();
        buf.append(STR_API_CALL).append(method).append(STR_SEMICOLON);
        buf.append(key1).append(STR_ASSIGN).append(value1).append(STR_SEMICOLON);
        buf.append(key2).append(STR_ASSIGN).append(value2).append(STR_QUOTE);
        this.logger.log(buf.toString());
    }

    private void logError(String method, EssException e) {
        if (this.logger.isOn(LogLevel.ERROR)) {
            StringBuilder buf = new StringBuilder();
            buf.append("Error in ").append(STR_API_CALL).append(method).append("\": ");
            this.logger.log(LogLevel.ERROR, buf.toString(), (Throwable)e);
        }
    }

    public final String getOlapServerVersion(IEssOlapServer serverConnection) {
        String method = "IEssOlapServer.getOlapServerVersion()";
        try {
            if (this.logger.isOn()) {
                this.logInfo(method, STR_SERVER, serverConnection.getName());
            }
            return serverConnection.getOlapServerVersion();
        }
        catch (EssException e) {
            this.logError(method, e);
            throw new EssbaseRuntimeException(EssbaseMessageKeys.ERR_API_CALL_ERROR, e, method);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final IEssIterator getCatalogs(IEssOlapServer serverConnection) {
        String method = "IEssOlapServer.getApplications()";
        while (true) {
            try {
                if (this.logger.isOn()) {
                    this.logInfo(method, STR_SERVER, serverConnection.getName());
                }
                IEssIterator iEssIterator = serverConnection.getApplications();
                return iEssIterator;
            }
            catch (EssException e) {
                this.mEssbaseExceptionHandler.exceptionHandler(EssbaseMessageKeys.ERR_API_CALL_ERROR, e, method, null);
                continue;
            }
            finally {
                this.mEssbaseExceptionHandler.updateExceptionHandler();
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final String getServerSubstitutionVariableValue(IEssOlapServer serverConnection, String svName) {
        String method = "IEssOlapServer.getSubstitutionVariableValue()";
        while (true) {
            try {
                if (this.logger.isOn()) {
                    this.logInfo(method, STR_SERVER, serverConnection.getName());
                }
                String string = serverConnection.getSubstitutionVariableValue(svName);
                return string;
            }
            catch (EssException e) {
                this.mEssbaseExceptionHandler.exceptionHandler(EssbaseMessageKeys.ERR_API_CALL_ERROR, e, method, null);
                continue;
            }
            finally {
                this.mEssbaseExceptionHandler.updateExceptionHandler();
                continue;
            }
            break;
        }
    }

    public final String getApplicationName(IEssOlapApplication app) {
        String method = "IEssOlapApplication.getName()";
        try {
            return app.getName();
        }
        catch (EssException e) {
            this.logError(method, e);
            throw new EssbaseRuntimeException(EssbaseMessageKeys.ERR_API_CALL_ERROR, e, method);
        }
    }

    public final String getApplicationDescription(IEssOlapApplication app) {
        String method = "IEssOlapApplication.getDescription()";
        try {
            String description = app.getDescription();
            if (EssbaseUtil.isEmpty(description)) {
                return null;
            }
            return description;
        }
        catch (EssException e) {
            this.logError(method, e);
            throw new EssbaseRuntimeException(EssbaseMessageKeys.ERR_API_CALL_ERROR, e, method);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final IEssIterator getCubes(IEssOlapApplication app) {
        String method = "IEssOlapApplication.getCubes()";
        while (true) {
            try {
                if (this.logger.isOn()) {
                    this.logInfo(method, STR_CATALOG, app.getName());
                }
                IEssIterator iEssIterator = app.getCubes();
                return iEssIterator;
            }
            catch (EssException e) {
                this.mEssbaseExceptionHandler.exceptionHandler(EssbaseMessageKeys.ERR_API_CALL_ERROR, e, method, null);
                continue;
            }
            finally {
                this.mEssbaseExceptionHandler.updateExceptionHandler();
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final IEssCube getCube(IEssOlapApplication app, String cubeName) {
        String method = "IEssOlapApplication.getCube()";
        while (true) {
            try {
                if (this.logger.isOn()) {
                    this.logInfo(method, STR_CATALOG, app.getName(), STR_CUBE, cubeName);
                }
                IEssCube iEssCube = app.getCube(cubeName);
                return iEssCube;
            }
            catch (EssException e) {
                this.mEssbaseExceptionHandler.exceptionHandler(EssbaseMessageKeys.ERR_API_CALL_ERROR, e, method, null);
                continue;
            }
            finally {
                this.mEssbaseExceptionHandler.updateExceptionHandler();
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final String getApplicationSubstitutionVariableValue(IEssOlapApplication app, String svName) {
        String method = "IEssOlapApplication.getSubstitutionVariableValue()";
        while (true) {
            try {
                if (this.logger.isOn()) {
                    this.logInfo(method, STR_CATALOG, app.getName());
                }
                String string = app.getSubstitutionVariableValue(svName);
                return string;
            }
            catch (EssException e) {
                this.mEssbaseExceptionHandler.exceptionHandler(EssbaseMessageKeys.ERR_API_CALL_ERROR, e, method, null);
                continue;
            }
            finally {
                this.mEssbaseExceptionHandler.updateExceptionHandler();
                continue;
            }
            break;
        }
    }

    public final String getCubeName(IEssCube cube) {
        String method = "IEssCube.getName()";
        try {
            return cube.getName();
        }
        catch (EssException e) {
            this.logError(method, e);
            throw new EssbaseRuntimeException(EssbaseMessageKeys.ERR_API_CALL_ERROR, e, method);
        }
    }

    public final String getCubeDescription(IEssCube cube) {
        String method = "IEssCube.getDescription()";
        try {
            String description = cube.getDescription();
            if (EssbaseUtil.isEmpty(description)) {
                return null;
            }
            return description;
        }
        catch (EssException e) {
            this.logError(method, e);
            throw new EssbaseRuntimeException(EssbaseMessageKeys.ERR_API_CALL_ERROR, e, method);
        }
    }

    public final IEssOlapApplication getApplication(IEssCube cube) {
        String method = "IEssCube.getApplication()";
        try {
            return cube.getApplication();
        }
        catch (EssException e) {
            this.logError(method, e);
            throw new EssbaseRuntimeException(EssbaseMessageKeys.ERR_API_CALL_ERROR, e, method);
        }
    }

    public final String getCatalogName(IEssCube cube) {
        IEssOlapApplication appl = this.getApplication(cube);
        if (appl != null) {
            return this.getApplicationName(appl);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final String[][] getSubstitutionVariables(IEssCube cube) {
        String method = "IEssCube.getSubstitutionVariables()";
        while (true) {
            try {
                if (this.logger.isOn()) {
                    this.logInfo(method, STR_CUBE, cube.getName());
                }
                String[][] stringArray = cube.getSubstitutionVariables();
                return stringArray;
            }
            catch (EssException e) {
                this.mEssbaseExceptionHandler.exceptionHandler(EssbaseMessageKeys.ERR_API_CALL_ERROR, e, method, null);
                continue;
            }
            finally {
                this.mEssbaseExceptionHandler.updateExceptionHandler();
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final String getCubeSubstitutionVariableValue(IEssCube cube, String svName) {
        String method = "IEssCube.getSubstitutionVariableValue()";
        while (true) {
            try {
                if (this.logger.isOn()) {
                    this.logInfo(method, STR_CUBE, cube.getName());
                }
                String string = cube.getSubstitutionVariableValue(svName);
                return string;
            }
            catch (EssException e) {
                this.mEssbaseExceptionHandler.exceptionHandler(EssbaseMessageKeys.ERR_API_CALL_ERROR, e, method, null);
                continue;
            }
            finally {
                this.mEssbaseExceptionHandler.updateExceptionHandler();
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final IEssMemberSelection openMemberSelection(IEssCube cube) {
        String method = "IEssCube.openMemberSelection()";
        while (true) {
            try {
                if (this.logger.isOn()) {
                    this.logInfo(method, STR_CUBE, cube.getName());
                }
                IEssMemberSelection iEssMemberSelection = cube.openMemberSelection("Member selection");
                return iEssMemberSelection;
            }
            catch (EssException e) {
                this.mEssbaseExceptionHandler.exceptionHandler(EssbaseMessageKeys.ERR_API_CALL_ERROR, e, method, null);
                continue;
            }
            finally {
                this.mEssbaseExceptionHandler.updateExceptionHandler();
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final String[] getAliasTableNames(IEssCube cube) {
        String method = "IEssCube.getAliasTableNames()";
        while (true) {
            try {
                if (this.logger.isOn()) {
                    this.logInfo(method, STR_CUBE, cube.getName());
                }
                String[] stringArray = cube.getAliasTableNames();
                return stringArray;
            }
            catch (EssException e) {
                this.mEssbaseExceptionHandler.exceptionHandler(EssbaseMessageKeys.ERR_API_CALL_ERROR, e, method, null);
                continue;
            }
            finally {
                this.mEssbaseExceptionHandler.updateExceptionHandler();
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final String[][] getAssociatedAttributes(IEssCube cube, String memberName) {
        String method = "IEssCube.getAssociatedAttributes()";
        while (true) {
            try {
                if (this.logger.isOn()) {
                    this.logInfo(method, STR_CUBE, cube.getName(), STR_MEMBER, memberName);
                }
                String[][] stringArray = cube.getAssociatedAttributes(memberName, "");
                return stringArray;
            }
            catch (EssException e) {
                this.mEssbaseExceptionHandler.exceptionHandler(EssbaseMessageKeys.ERR_API_CALL_ERROR, e, method, null);
                continue;
            }
            finally {
                this.mEssbaseExceptionHandler.updateExceptionHandler();
                continue;
            }
            break;
        }
    }

    public final String getDimensionName(IEssDimension dimension) {
        String method = "IEssDimension.getName()";
        try {
            return dimension.getName();
        }
        catch (EssException e) {
            this.logError(method, e);
            throw new EssbaseRuntimeException(EssbaseMessageKeys.ERR_API_CALL_ERROR, e, method);
        }
    }

    public final int getCardinality(IEssDimension dimension) {
        String method = "IEssDimension.getActualSize()";
        try {
            return dimension.getActualSize();
        }
        catch (EssException e) {
            this.logError(method, e);
            throw new EssbaseRuntimeException(EssbaseMessageKeys.ERR_API_CALL_ERROR, e, method);
        }
    }

    public final IEssDimension.EEssDimensionTag getTag(IEssDimension dimension) {
        String method = "IEssDimension.getTag()";
        try {
            return dimension.getTag();
        }
        catch (EssException e) {
            this.logError(method, e);
            throw new EssbaseRuntimeException(EssbaseMessageKeys.ERR_API_CALL_ERROR, e, method);
        }
    }

    public final int intValue(IEssDimension.EEssDimensionTag tag) {
        String method = "IEssDimension.EEssDimensionTag.intValue()";
        try {
            return tag.intValue();
        }
        catch (EssException e) {
            this.logError(method, e);
            throw new EssbaseRuntimeException(EssbaseMessageKeys.ERR_API_CALL_ERROR, e, method);
        }
    }

    public final int getDimensionOrdinal(IEssDimension dimension) {
        String method = "IEssDimension.getDimensionNumber()";
        try {
            return dimension.getDimensionNumber();
        }
        catch (EssException e) {
            this.logError(method, e);
            throw new EssbaseRuntimeException(EssbaseMessageKeys.ERR_API_CALL_ERROR, e, method);
        }
    }

    public final String getLevelName(EssGenOrLevel level) {
        String method = "EssGenOrLevel.getName()";
        try {
            return level.getName();
        }
        catch (EssException e) {
            this.logError(method, e);
            throw new EssbaseRuntimeException(EssbaseMessageKeys.ERR_API_CALL_ERROR, e, method);
        }
    }

    public final String getActualName(EssGenOrLevel level) {
        String method = "EssGenOrLevel.getActualName()";
        try {
            return level.getActualName();
        }
        catch (EssException e) {
            this.logError(method, e);
            throw new EssbaseRuntimeException(EssbaseMessageKeys.ERR_API_CALL_ERROR, e, method);
        }
    }

    public final String getMemberName(IEssMember member) {
        String method = "IEssMember.getName()";
        try {
            return member.getName();
        }
        catch (EssException e) {
            this.logError(method, e);
            throw new EssbaseRuntimeException(EssbaseMessageKeys.ERR_API_CALL_ERROR, e, method);
        }
    }

    public final String getMemberDescription(IEssMember member) {
        String method = "IEssMember.getDescription()";
        try {
            String description = member.getDescription();
            if (EssbaseUtil.isEmpty(description)) {
                return null;
            }
            return description;
        }
        catch (EssException e) {
            this.logError(method, e);
            throw new EssbaseRuntimeException(EssbaseMessageKeys.ERR_API_CALL_ERROR, e, method);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final String getParentMemberName(IEssMember member) {
        String method = "IEssMember.getParentMemberName()";
        while (true) {
            try {
                if (this.logger.isOn()) {
                    this.logInfo(method, STR_MEMBER, member.getName());
                }
                String string = member.getParentMemberName();
                return string;
            }
            catch (EssException e) {
                this.mEssbaseExceptionHandler.exceptionHandler(EssbaseMessageKeys.ERR_API_CALL_ERROR, e, method, null);
                continue;
            }
            finally {
                this.mEssbaseExceptionHandler.updateExceptionHandler();
                continue;
            }
            break;
        }
    }

    public final int getChildCount(IEssMember member) {
        if (member == null) {
            return -1;
        }
        String method = "IEssMember.getChildCount()";
        try {
            return member.getChildCount();
        }
        catch (EssException e) {
            this.logError(method, e);
            throw new EssbaseRuntimeException(EssbaseMessageKeys.ERR_API_CALL_ERROR, e, method);
        }
    }

    public final int getGenerationNumber(IEssMember member) {
        String method = "IEssMember.getGenerationNumber()";
        try {
            return member.getGenerationNumber();
        }
        catch (EssException e) {
            this.logError(method, e);
            throw new EssbaseRuntimeException(EssbaseMessageKeys.ERR_API_CALL_ERROR, e, method);
        }
    }

    public final int getLevelNumber(IEssMember member) {
        String method = "IEssMember.getLevelNumber()";
        try {
            return member.getLevelNumber();
        }
        catch (EssException e) {
            this.logError(method, e);
            throw new EssbaseRuntimeException(EssbaseMessageKeys.ERR_API_CALL_ERROR, e, method);
        }
    }

    public final String getDimensionName(IEssMember member) {
        String method = "IEssMember.getDimensionName()";
        try {
            return member.getDimensionName();
        }
        catch (EssException e) {
            this.logError(method, e);
            throw new EssbaseRuntimeException(EssbaseMessageKeys.ERR_API_CALL_ERROR, e, method);
        }
    }

    public final AggregateTypeEnum getTimeBalanceOption(IEssMember member) {
        String method = "IEssMember.getTimeBalanceOption()";
        try {
            switch (member.getTimeBalanceOption().intValue()) {
                case 1: {
                    return AggregateTypeEnum.FIRST;
                }
                case 2: {
                    return AggregateTypeEnum.LAST;
                }
                case 3: {
                    return AggregateTypeEnum.AVG;
                }
            }
            return AggregateTypeEnum.NONE;
        }
        catch (EssException e) {
            this.logError(method, e);
            throw new EssbaseRuntimeException(EssbaseMessageKeys.ERR_API_CALL_ERROR, e, method);
        }
    }

    public final boolean isFormula(IEssMember member) {
        String method = "IEssMember.getFormula()";
        try {
            String formula = member.getFormula();
            if (formula != null && formula.length() > 0) {
                return true;
            }
        }
        catch (EssException e) {
            this.logError(method, e);
            throw new EssbaseRuntimeException(EssbaseMessageKeys.ERR_API_CALL_ERROR, e, method);
        }
        return false;
    }

    public final String getAlias(IEssMember member, String aliasTableName) {
        String method = "IEssMember.getAlias()";
        try {
            String alias = member.getAlias(aliasTableName);
            if (EssbaseUtil.isEmpty(alias)) {
                return null;
            }
            return alias;
        }
        catch (EssException e) {
            this.logError(method, e);
            throw new EssbaseRuntimeException(EssbaseMessageKeys.ERR_API_CALL_ERROR, e, method);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final String[] getUDAs(IEssMember member) {
        String method = "IEssMember.getUDAs()";
        while (true) {
            try {
                if (this.logger.isOn()) {
                    this.logInfo(method, STR_MEMBER, member.getName());
                }
                String[] stringArray = member.getUDAs();
                return stringArray;
            }
            catch (EssException e) {
                this.mEssbaseExceptionHandler.exceptionHandler(EssbaseMessageKeys.ERR_API_CALL_ERROR, e, method, null);
                continue;
            }
            finally {
                this.mEssbaseExceptionHandler.updateExceptionHandler();
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final int getConsolidationType(IEssMember member) {
        String method = "IEssMember.getConsolidationType()";
        while (true) {
            try {
                if (this.logger.isOn()) {
                    this.logInfo(method, STR_MEMBER, member.getName());
                }
                int n = member.getConsolidationType().intValue();
                return n;
            }
            catch (EssException e) {
                this.mEssbaseExceptionHandler.exceptionHandler(EssbaseMessageKeys.ERR_API_CALL_ERROR, e, method, null);
                continue;
            }
            finally {
                this.mEssbaseExceptionHandler.updateExceptionHandler();
                continue;
            }
            break;
        }
    }

    public final boolean isSharedMember(IEssMember member) {
        String method = "IEssMember.getShareOption()";
        try {
            return member.getShareOption().intValue() == 3;
        }
        catch (EssException e) {
            this.logError(method, e);
            throw new EssbaseRuntimeException(EssbaseMessageKeys.ERR_API_CALL_ERROR, e, method);
        }
    }

    public final String getMdMemberName(IEssMdMember member) {
        String method = "IEssMdMember.getName()";
        try {
            return member.getName();
        }
        catch (EssException e) {
            this.logError(method, e);
            throw new EssbaseRuntimeException(EssbaseMessageKeys.ERR_API_CALL_ERROR, e, method);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final IEssMdMember getDimension(IEssMdMember member) {
        String method = "IEssMdMember.getDimension()";
        while (true) {
            try {
                if (this.logger.isOn()) {
                    this.logInfo(method, STR_MEMBER, member.getName());
                }
                IEssMdMember iEssMdMember = member.getDimension();
                return iEssMdMember;
            }
            catch (EssException e) {
                this.mEssbaseExceptionHandler.exceptionHandler(EssbaseMessageKeys.ERR_API_CALL_ERROR, e, method, null);
                continue;
            }
            finally {
                this.mEssbaseExceptionHandler.updateExceptionHandler();
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final String[] getPropertyNames(IEssMdMember member) {
        String method = "IEssMdMember.getPropertyNames()";
        while (true) {
            try {
                if (this.logger.isOn()) {
                    this.logInfo(method, STR_MEMBER, member.getName());
                }
                String[] stringArray = member.getPropertyNames();
                return stringArray;
            }
            catch (EssException e) {
                this.mEssbaseExceptionHandler.exceptionHandler(EssbaseMessageKeys.ERR_API_CALL_ERROR, e, method, null);
                continue;
            }
            finally {
                this.mEssbaseExceptionHandler.updateExceptionHandler();
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final IEssValueAny getPropertyValueAny(IEssMdMember member, int propertyId) {
        String method = "IEssMdMember.getPropertyValueAny(Id)";
        while (true) {
            try {
                if (this.logger.isOn()) {
                    this.logInfo(method, STR_MEMBER, member.getName());
                }
                IEssValueAny iEssValueAny = member.getPropertyValueAny(propertyId);
                return iEssValueAny;
            }
            catch (EssException e) {
                this.mEssbaseExceptionHandler.exceptionHandler(EssbaseMessageKeys.ERR_API_CALL_ERROR, e, method, null);
                continue;
            }
            finally {
                this.mEssbaseExceptionHandler.updateExceptionHandler();
                continue;
            }
            break;
        }
    }

    public final IEssValueAny getPropertyValueAny(IEssMdMember member, String propertyName) {
        String method = "IEssMdMember.getPropertyValueAny(propName)";
        try {
            if (this.logger.isOn()) {
                this.logInfo(method, STR_MEMBER, member.getName());
            }
            return member.getPropertyValueAny(propertyName);
        }
        catch (EssException e) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final IEssValueAny.EEssDataType getPropertyDataType(IEssMdMember member, int propertyId) {
        String method = "IEssMdMember.getPropertyDataType()";
        while (true) {
            try {
                if (this.logger.isOn()) {
                    this.logInfo(method, STR_MEMBER, member.getName());
                }
                IEssValueAny.EEssDataType eEssDataType = member.getPropertyDataType(propertyId);
                return eEssDataType;
            }
            catch (EssException e) {
                this.mEssbaseExceptionHandler.exceptionHandler(EssbaseMessageKeys.ERR_API_CALL_ERROR, e, method, null);
                continue;
            }
            finally {
                this.mEssbaseExceptionHandler.updateExceptionHandler();
                continue;
            }
            break;
        }
    }

    public final boolean isCalced(IEssMdMember member) {
        String method = "IEssMdMember.isCalced()";
        try {
            return member.isCalced();
        }
        catch (EssException e) {
            this.logError(method, e);
            throw new EssbaseRuntimeException(EssbaseMessageKeys.ERR_API_CALL_ERROR, e, method);
        }
    }

    public final boolean isDimension(IEssMdMember member) {
        String method = "IEssMdMember.isDimension()";
        try {
            return member.isDimension();
        }
        catch (EssException e) {
            this.logError(method, e);
            throw new EssbaseRuntimeException(EssbaseMessageKeys.ERR_API_CALL_ERROR, e, method);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final String getString(IEssValueAny propertyValue) {
        String method = "IEssValueAny.getString()";
        while (true) {
            try {
                if (this.logger.isOn()) {
                    this.logInfo(method);
                }
                String string = propertyValue.getString();
                return string;
            }
            catch (EssException e) {
                this.mEssbaseExceptionHandler.exceptionHandler(EssbaseMessageKeys.ERR_API_CALL_ERROR, e, method, null);
                continue;
            }
            finally {
                this.mEssbaseExceptionHandler.updateExceptionHandler();
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final String[] getStringArr(IEssValueAny propertyValue) {
        String method = "IEssValueAny.getStringArr()";
        while (true) {
            try {
                if (this.logger.isOn()) {
                    this.logInfo(method);
                }
                String[] stringArray = propertyValue.getStringArr();
                return stringArray;
            }
            catch (EssException e) {
                this.mEssbaseExceptionHandler.exceptionHandler(EssbaseMessageKeys.ERR_API_CALL_ERROR, e, method, null);
                continue;
            }
            finally {
                this.mEssbaseExceptionHandler.updateExceptionHandler();
                continue;
            }
            break;
        }
    }

    public final int getDataTypeIntValue(IEssValueAny propertyValue) {
        String method = "IEssValueAny.getDataType()";
        try {
            if (this.logger.isOn()) {
                this.logInfo(method);
            }
            return propertyValue.getDataType().intValue();
        }
        catch (EssException e) {
            this.logError(method, e);
            throw new EssbaseRuntimeException(EssbaseMessageKeys.ERR_API_CALL_ERROR, e, method);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final long getLong(IEssValueAny propertyValue) {
        String method = "IEssValueAny.getLong()";
        while (true) {
            try {
                if (this.logger.isOn()) {
                    this.logInfo(method);
                }
                long l = propertyValue.getLong();
                return l;
            }
            catch (EssException e) {
                this.mEssbaseExceptionHandler.exceptionHandler(EssbaseMessageKeys.ERR_API_CALL_ERROR, e, method, null);
                continue;
            }
            finally {
                this.mEssbaseExceptionHandler.updateExceptionHandler();
                continue;
            }
            break;
        }
    }

    public final int intValue(IEssValueAny.EEssDataType type) {
        String method = "IEssValueAny.intValue()";
        try {
            return type.intValue();
        }
        catch (EssException e) {
            this.logError(method, e);
            throw new EssbaseRuntimeException(EssbaseMessageKeys.ERR_API_CALL_ERROR, e, method);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final IEssMdMember[] getAllDimensions(IEssMdAxis essAxis) {
        String method = "IEssMdAxis.getAllDimensions()";
        while (true) {
            try {
                if (this.logger.isOn()) {
                    this.logInfo(method);
                }
                IEssMdMember[] iEssMdMemberArray = essAxis.getAllDimensions();
                return iEssMdMemberArray;
            }
            catch (EssException e) {
                this.mEssbaseExceptionHandler.exceptionHandler(EssbaseMessageKeys.ERR_API_CALL_ERROR, e, method, null);
                continue;
            }
            finally {
                this.mEssbaseExceptionHandler.updateExceptionHandler();
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final IEssMdMember[] getAllTupleMembers(IEssMdAxis essAxis, int tupleIndex) {
        String method = "IEssMdAxis.getAllTupleMembers()";
        while (true) {
            try {
                if (this.logger.isOn()) {
                    this.logInfo(method);
                }
                IEssMdMember[] iEssMdMemberArray = essAxis.getAllTupleMembers(tupleIndex);
                return iEssMdMemberArray;
            }
            catch (EssException e) {
                this.mEssbaseExceptionHandler.exceptionHandler(EssbaseMessageKeys.ERR_API_CALL_ERROR, e, method, null);
                continue;
            }
            finally {
                this.mEssbaseExceptionHandler.updateExceptionHandler();
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final int getTupleCount(IEssMdAxis essAxis) {
        String method = "IEssMdAxis.getTupleCount()";
        while (true) {
            try {
                if (this.logger.isOn()) {
                    this.logInfo(method);
                }
                int n = essAxis.getTupleCount();
                return n;
            }
            catch (EssException e) {
                this.mEssbaseExceptionHandler.exceptionHandler(EssbaseMessageKeys.ERR_API_CALL_ERROR, e, method, null);
                continue;
            }
            finally {
                this.mEssbaseExceptionHandler.updateExceptionHandler();
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean isSlicerAxis(IEssMdAxis essAxis) {
        while (true) {
            String method = "IEssMdAxis.isSlicerAxis()";
            try {
                if (this.logger.isOn()) {
                    this.logInfo(method);
                }
                boolean bl = essAxis.isSlicerAxis();
                return bl;
            }
            catch (EssException e) {
                this.mEssbaseExceptionHandler.exceptionHandler(EssbaseMessageKeys.ERR_API_CALL_ERROR, e, method, null);
                continue;
            }
            finally {
                this.mEssbaseExceptionHandler.updateExceptionHandler();
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final int getCellCount(IEssMdDataSet dataset) {
        while (true) {
            String method = "IEssMdDataSet.getCellCount()";
            try {
                if (this.logger.isOn()) {
                    this.logInfo(method);
                }
                int n = dataset.getCellCount();
                return n;
            }
            catch (EssException e) {
                this.mEssbaseExceptionHandler.exceptionHandler(EssbaseMessageKeys.ERR_API_CALL_ERROR, e, method, null);
                continue;
            }
            finally {
                this.mEssbaseExceptionHandler.updateExceptionHandler();
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final IEssMdAxis[] getAllAxes(IEssMdDataSet dataset) {
        while (true) {
            String method = "IEssMdDataSet.getAllAxes()";
            try {
                if (this.logger.isOn()) {
                    this.logInfo(method);
                }
                IEssMdAxis[] iEssMdAxisArray = dataset.getAllAxes();
                return iEssMdAxisArray;
            }
            catch (EssException e) {
                this.mEssbaseExceptionHandler.exceptionHandler(EssbaseMessageKeys.ERR_API_CALL_ERROR, e, method, null);
                continue;
            }
            finally {
                this.mEssbaseExceptionHandler.updateExceptionHandler();
                continue;
            }
            break;
        }
    }

    public final boolean isMissingCell(IEssMdDataSet dataset, int cellOrdinal) {
        String method = "IEssMdDataSet.isMissingCell()";
        try {
            return dataset.isMissingCell(cellOrdinal);
        }
        catch (EssException e) {
            this.logError(method, e);
            throw new EssbaseRuntimeException(EssbaseMessageKeys.ERR_API_CALL_ERROR, e, method);
        }
    }

    public final boolean isNoAccessCell(IEssMdDataSet dataset, int cellOrdinal) {
        String method = "IEssMdDataSet.isNoAccessCell()";
        try {
            return dataset.isNoAccessCell(cellOrdinal);
        }
        catch (EssException e) {
            this.logError(method, e);
            throw new EssbaseRuntimeException(EssbaseMessageKeys.ERR_API_CALL_ERROR, e, method);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final double getCellValue(IEssMdDataSet dataset, int cellOrdinal) {
        String method = "IEssMdDataSet.getCellValue()";
        while (true) {
            try {
                if (this.logger.isOn()) {
                    this.logInfo(method);
                }
                double d = dataset.getCellValue(cellOrdinal);
                return d;
            }
            catch (EssException e) {
                this.mEssbaseExceptionHandler.exceptionHandler(EssbaseMessageKeys.ERR_API_CALL_ERROR, e, method, null);
                continue;
            }
            finally {
                this.mEssbaseExceptionHandler.updateExceptionHandler();
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void executeQuery(IEssMemberSelection mbrSel, String memberName, int queryType, String dimName, String input1, String input2) {
        String method = "IEssMemberSelection.executeQuery_1()";
        while (true) {
            try {
                if (this.logger.isOn()) {
                    StringBuilder buf = new StringBuilder();
                    buf.append(STR_API_CALL);
                    buf.append("IEssMemberSelection.executeQuery()(1), parameters: {");
                    buf.append(STR_MBR_NAME).append(memberName).append(STR_SEMICOLON);
                    buf.append(STR_DIM_NAME).append(dimName).append(STR_SEMICOLON);
                    buf.append("input1=").append(input1).append(STR_SEMICOLON);
                    buf.append("input2=").append(input2).append('}');
                    this.logger.log(buf.toString());
                }
                mbrSel.executeQuery(memberName, queryType, 4, dimName, input1, input2);
            }
            catch (EssException e) {
                this.mEssbaseExceptionHandler.exceptionHandler(EssbaseMessageKeys.ERR_API_CALL_ERROR, e, method, null);
                continue;
            }
            finally {
                this.mEssbaseExceptionHandler.updateExceptionHandler();
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void executeQuery(IEssMemberSelection mbrSel, String memberName, int queryType, String dimName, String input, EssbaseMetadataProvider.QueryParameters essQueryParams) {
        String method = "IEssMemberSelection.executeQuery_2()";
        while (true) {
            try {
                if (this.logger.isOn()) {
                    StringBuilder buf = new StringBuilder();
                    buf.append(STR_API_CALL);
                    buf.append("IEssMemberSelection.executeQuery()(2), parameters: {");
                    buf.append(STR_MBR_NAME).append(memberName).append(STR_SEMICOLON);
                    buf.append(STR_DIM_NAME).append(dimName).append(STR_SEMICOLON);
                    buf.append(essQueryParams.toString()).append('}');
                    this.logger.log(buf.toString());
                }
                mbrSel.executeQuery(memberName, queryType, 4, dimName, input, essQueryParams.currentAliasTableName, essQueryParams.from, essQueryParams.size);
            }
            catch (EssException e) {
                this.mEssbaseExceptionHandler.exceptionHandler(EssbaseMessageKeys.ERR_API_CALL_ERROR, e, method, null);
                continue;
            }
            finally {
                this.mEssbaseExceptionHandler.updateExceptionHandler();
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void executeQuery(IEssMemberSelection mbrSel, String fldSelection, String mbrSelection) {
        String method = "IEssMemberSelection.executeQuery_3()";
        while (true) {
            try {
                if (this.logger.isOn()) {
                    StringBuilder buf = new StringBuilder();
                    buf.append(STR_API_CALL);
                    buf.append("IEssMemberSelection.executeQuery()(3), parameters: {");
                    buf.append(STR_FLD_SELECTION).append(fldSelection).append(STR_SEMICOLON);
                    buf.append(STR_MBR_SELECTION).append(mbrSelection).append('}');
                    this.logger.log(buf.toString());
                }
                mbrSel.executeQuery(fldSelection, mbrSelection);
            }
            catch (EssException e) {
                this.mEssbaseExceptionHandler.exceptionHandler(EssbaseMessageKeys.ERR_API_CALL_ERROR, e, method, null);
                continue;
            }
            finally {
                this.mEssbaseExceptionHandler.updateExceptionHandler();
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void executeQuery(IEssMemberSelection mbrSel, String fldSelection, String mbrSelection, int size) {
        String method = "IEssMemberSelection.executeQuery_4()";
        while (true) {
            try {
                if (this.logger.isOn()) {
                    StringBuilder buf = new StringBuilder();
                    buf.append(STR_API_CALL);
                    buf.append("IEssMemberSelection.executeQuery()(4), parameters: {");
                    buf.append(STR_FLD_SELECTION).append(fldSelection).append(STR_SEMICOLON);
                    buf.append(STR_MBR_SELECTION).append(mbrSelection).append(STR_SEMICOLON);
                    buf.append("size=").append(size).append('}');
                    this.logger.log(buf.toString());
                }
                mbrSel.executeQuery(fldSelection, mbrSelection, size);
            }
            catch (EssException e) {
                this.mEssbaseExceptionHandler.exceptionHandler(EssbaseMessageKeys.ERR_API_CALL_ERROR, e, method, null);
                continue;
            }
            finally {
                this.mEssbaseExceptionHandler.updateExceptionHandler();
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final IEssIterator getGenerations(IEssMemberSelection mbrSel, String dimensionName) {
        String method = "IEssMemberSelection.getDimensionGenerations()";
        while (true) {
            try {
                if (this.logger.isOn()) {
                    this.logInfo(method, STR_DIMENSION, dimensionName);
                }
                IEssIterator iEssIterator = mbrSel.getDimensionGenerations(dimensionName);
                return iEssIterator;
            }
            catch (EssException e) {
                this.mEssbaseExceptionHandler.exceptionHandler(EssbaseMessageKeys.ERR_API_CALL_ERROR, e, method, null);
                continue;
            }
            finally {
                this.mEssbaseExceptionHandler.updateExceptionHandler();
                continue;
            }
            break;
        }
    }

    public final IEssIterator getMembers(IEssMemberSelection mbrSel) {
        String method = "IEssMemberSelection.getMembers()";
        try {
            return mbrSel.getMembers();
        }
        catch (EssException e) {
            this.logError(method, e);
            throw new EssbaseRuntimeException(EssbaseMessageKeys.ERR_API_CALL_ERROR, e, method);
        }
    }

    public final boolean isDuplicateMembersAllowed(IEssMemberSelection mbrSel) {
        String method = "IEssMemberSelection.isNonUniqueMemberNameEnabled()";
        try {
            return mbrSel.isNonUniqueMemberNameEnabled();
        }
        catch (EssException e) {
            this.logError(method, e);
            throw new EssbaseRuntimeException(EssbaseMessageKeys.ERR_API_CALL_ERROR, e, method);
        }
    }

    public final void closeMbrSel(IEssMemberSelection mbrSel) {
        String method = "IEssMemberSelection.close()";
        try {
            mbrSel.close();
        }
        catch (EssException e) {
            this.logError(method, e);
            throw new EssbaseRuntimeException(EssbaseMessageKeys.ERR_API_CALL_ERROR, e, method);
        }
    }

    public final IEssBaseObject getAt(IEssIterator list, int pos) {
        String method = "IEssIterator.getAt()";
        try {
            return list.getAt(pos);
        }
        catch (EssException e) {
            this.logError(method, e);
            throw new EssbaseRuntimeException(EssbaseMessageKeys.ERR_API_CALL_ERROR, e, method);
        }
    }

    public final int getCount(IEssIterator list) {
        if (list == null) {
            return -1;
        }
        String method = "IEssIterator.getCount()";
        try {
            return list.getCount();
        }
        catch (EssException e) {
            this.logError(method, e);
            throw new EssbaseRuntimeException(EssbaseMessageKeys.ERR_API_CALL_ERROR, e, method);
        }
    }
}

