/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.data.providers.olap.mdds;

import com.cognos.xqe.bibushandler.CancelRequestSourceEnum;
import com.cognos.xqe.bibushandler.CancelUnsuccessfulException;
import com.cognos.xqe.bibushandler.ICancelable;
import com.cognos.xqe.bibushandler.RequestEnvironment;
import com.cognos.xqe.data.model.LogonFailureException;
import com.cognos.xqe.data.providers.QueryArguments;
import com.cognos.xqe.data.providers.olap.mdds.MDDSDataProvider;
import com.cognos.xqe.data.providers.olap.mdds.util.MDDSLogger;
import com.cognos.xqe.data.providers.qfwbridge.QFWConnection;
import com.cognos.xqe.data.providers.qfwbridge.QFWException;
import com.cognos.xqe.data.providers.qfwbridge.QFWQuery;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.pool.connection.ConnectionParameters;
import com.cognos.xqe.query.engine.ExecutionEnvironment;
import com.cognos.xqe.trace.LogLevel;
import com.cognos.xqe.trace.XQELogger;

public class MDDSCancelListener
implements ICancelable {
    private static final String QFW_CANCEL_BEGIN = "<cancel>";
    private static final String QFW_CANCEL_END = "</cancel>";
    private final String cancelRequest;
    private final QFWConnection qfwConn;
    private final ConnectionParameters resolvedParams;
    private static final XQELogger LOGGER = MDDSLogger.getLogger("DataQuery.Cancel", LogLevel.TRACE);

    public MDDSCancelListener(QFWConnection connObject, ExecutionEnvironment executionEnvironment, QueryArguments theQueryArgument, ConnectionParameters params) {
        this.qfwConn = connObject;
        this.resolvedParams = params;
        this.cancelRequest = this.getCancelQueryString(executionEnvironment, theQueryArgument);
    }

    public void cancel() throws CancelUnsuccessfulException {
        try {
            QFWQuery query = this.qfwConn.createQuery(this.qfwConn.getErrorLocale());
            try {
                LOGGER.log(this.cancelRequest);
                try {
                    query.execute(this.cancelRequest);
                }
                catch (QFWException ex) {
                    LOGGER.log(ex.getLogString());
                    throw new CancelUnsuccessfulException((Throwable)ex);
                }
                catch (Throwable ex) {
                    LOGGER.log(ex.toString());
                    throw new CancelUnsuccessfulException(ex);
                }
            }
            finally {
                query.release();
            }
        }
        catch (LogonFailureException e) {
            throw new CancelUnsuccessfulException();
        }
    }

    public synchronized void cancel(CancelRequestSourceEnum cancelSource) throws CancelUnsuccessfulException {
        throw new CancelUnsuccessfulException();
    }

    private String getCancelQueryString(ExecutionEnvironment execEnv, QueryArguments queryArguments) {
        StringBuilder content = new StringBuilder(QFW_CANCEL_BEGIN);
        RequestEnvironment reqEnv = (RequestEnvironment)execEnv.getRequestEnvironment();
        if (null == reqEnv.getRequestID()) {
            throw new XQERuntimeException(XQEMessageKeys.GEN_RequestIdMissing);
        }
        QFWQuery.appendRequestID((StringBuilder)content, (String)reqEnv.getRequestID());
        content.append(QFW_CANCEL_END);
        return MDDSDataProvider.generateMDQuerySpec(execEnv, this.resolvedParams, reqEnv.getRequestID(), content, false);
    }
}

