/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.data.providers.olap.mdds;

import com.cognos.xqe.bibushandler.CancelRequestSourceEnum;
import com.cognos.xqe.bibushandler.CancelUnsuccessfulException;
import com.cognos.xqe.bibushandler.ICancelable;
import com.cognos.xqe.bibushandler.IRequestEnvironment;
import com.cognos.xqe.bibushandler.content.ContentManager;
import com.cognos.xqe.data.model.IDataSource;
import com.cognos.xqe.data.model.IDataSourceConnection;
import com.cognos.xqe.data.model.LogonFailureException;
import com.cognos.xqe.data.providers.connection.parameters.CAMCryptoHandleParameter;
import com.cognos.xqe.data.providers.connection.parameters.CubeParameter;
import com.cognos.xqe.data.providers.connection.parameters.DataSourceParameter;
import com.cognos.xqe.data.providers.connection.parameters.MissingSecurityContextException;
import com.cognos.xqe.data.providers.connection.parameters.NamespaceParameter;
import com.cognos.xqe.data.providers.connection.parameters.ProductLocaleParameter;
import com.cognos.xqe.data.providers.connection.parameters.UserClassIDsParameter;
import com.cognos.xqe.data.providers.olap.DefaultConnection;
import com.cognos.xqe.data.providers.olap.IOLAPDataProvider;
import com.cognos.xqe.data.providers.olap.mdds.MDDSConfigManager;
import com.cognos.xqe.data.providers.olap.mdds.MDDSDataProvider;
import com.cognos.xqe.data.providers.olap.mdds.MDDSMessageKeys;
import com.cognos.xqe.data.providers.olap.mdds.connection.ConnectionParameterHelper;
import com.cognos.xqe.data.providers.olap.mdds.connection.MDDSConnectionError;
import com.cognos.xqe.data.providers.olap.mdds.connection.MetadataCacheContext;
import com.cognos.xqe.data.providers.olap.mdds.connection.PCSecurityContext;
import com.cognos.xqe.data.providers.olap.mdds.connection.TM1AdminHostParameter;
import com.cognos.xqe.data.providers.olap.mdds.connection.TM1PasswordParameter;
import com.cognos.xqe.data.providers.olap.mdds.connection.TM1ServerNameParameter;
import com.cognos.xqe.data.providers.olap.mdds.connection.TM1ServerSecurityModeEnum;
import com.cognos.xqe.data.providers.olap.mdds.connection.TM1UserNameParameter;
import com.cognos.xqe.data.providers.olap.mdds.metadata.cache.ParentChildLevelsCache;
import com.cognos.xqe.data.providers.olap.mdds.util.MDDSException;
import com.cognos.xqe.data.providers.olap.mdds.util.MDDSLogger;
import com.cognos.xqe.data.providers.olap.mdds.util.MDDSUtils;
import com.cognos.xqe.data.providers.qfwbridge.QFWConnection;
import com.cognos.xqe.data.providers.qfwbridge.QFWException;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.pool.connection.ConnectionParameters;
import com.cognos.xqe.pool.connection.IConnectionParameter;
import com.cognos.xqe.query.engine.ExecutionEnvironment;
import com.cognos.xqe.trace.LogLevel;
import com.cognos.xqe.trace.OperationEnum;
import com.cognos.xqe.util.LocaleConverter;
import com.cognos.xqe.util.concurrent.Gate;
import com.cognos.xqe.util.context.ExecutionEnvironmentContext;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;

public class MDDSConnection
extends DefaultConnection
implements ICancelable {
    private static final long DEFAULT_WAIT_TIME = 10L;
    private static final String TERMINATOR = "].";
    private static final String SEPERATOR = "], ";
    private static final String STR_CUBE = "\"; cube: \"";
    private static final String STR_DOT = "\".";
    private static final String LOG_MSG_LOGON_FAILURE = "MDDSConnection logon failure for user: \"";
    private static final String LOG_MSG_ACQUIRE_USERCLASSIDS = "Acquiring UserClassIDs and reconnect.";
    private static final String LOG_ADMIN_SERVER_PATTERN = "%s\\%s";
    private boolean connected = false;
    private QFWConnection qfwconnection = null;
    private TM1ServerSecurityModeEnum serverSecurityMode = TM1ServerSecurityModeEnum.TM1_SECURITY_MODE_UNKNOWN;
    private final ParentChildLevelsCache pcLevelsCache = new ParentChildLevelsCache();
    private String userGroupList = null;
    private static ConcurrentHashMap<String, TM1ServerSecurityModeEnum> securityModeMapTM1 = new ConcurrentHashMap();
    private MetadataCacheContext metadataCacheContext = new MetadataCacheContext(false);
    private PCSecurityContext pcSecurityContext = null;
    private static final ConcurrentHashMap<String, Gate> SEC_MODE_GATE = new ConcurrentHashMap();
    private long lastValidationTimestamp;
    private static final long VALIDATION_PERIOD = 10000L;

    public MDDSConnection(IOLAPDataProvider theDataProvider) {
        super(theDataProvider);
    }

    public ParentChildLevelsCache getPCLevelsCache() {
        return this.pcLevelsCache;
    }

    public void setConnectionParameter(ConnectionParameters params) {
        this.setConnectionParameters(params);
    }

    void connect(ConnectionParameters connectionParameters) {
        ConnectionParameters mdQuerySpecParams = connectionParameters.duplicate();
        boolean useWinImpersonation = this.isWinImpersonationNeeded(mdQuerySpecParams);
        if (useWinImpersonation) {
            mdQuerySpecParams.put((IConnectionParameter)new CAMCryptoHandleParameter("0"));
        }
        this.setConnectionParameters(connectionParameters);
        if (MDDSLogger.CONN_CREATE.isOn(LogLevel.TRACE)) {
            StringBuilder buf = new StringBuilder();
            buf.append("Connecting with parameters: ");
            buf.append(connectionParameters.toString());
            MDDSLogger.CONN_CREATE.log(LogLevel.TRACE, OperationEnum.START, buf.toString());
        }
        try {
            StringBuilder strBuf = new StringBuilder("<?xml version=\"1.0\" encoding=\"UTF-8\"?><qs:command xmlns:qs=\"http://developer.cognos.com/schemas/qsapi/2/\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\">");
            ConnectionParameterHelper.writeXML(mdQuerySpecParams, strBuf, false);
            strBuf.append("</qs:command>");
            if (MDDSLogger.CONN_3RDPARTY.isOn(LogLevel.TRACE)) {
                StringBuilder buffer = new StringBuilder("<?xml version=\"1.0\" encoding=\"UTF-8\"?><qs:command xmlns:qs=\"http://developer.cognos.com/schemas/qsapi/2/\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\">");
                ConnectionParameterHelper.writeXML(mdQuerySpecParams, buffer, true);
                buffer.append("</qs:command>");
                MDDSLogger.CONN_3RDPARTY.log(LogLevel.TRACE, buffer.toString());
            }
            Locale productLocale = (Locale)connectionParameters.valueOf(ProductLocaleParameter.class, Locale.class);
            this.qfwconnection = new QFWConnection(productLocale);
            if (connectionParameters.contains(TM1AdminHostParameter.class)) {
                this.connectToTM1Server(connectionParameters, strBuf, productLocale, useWinImpersonation);
            } else {
                this.connectToPowerCube(connectionParameters, strBuf);
            }
        }
        catch (XQERuntimeException ex) {
            if (null != this.qfwconnection) {
                this.qfwconnection.release();
            }
            throw ex;
        }
        catch (Throwable connectThrowable) {
            if (null != this.qfwconnection) {
                this.qfwconnection.release();
                throw new MDDSException(MDDSMessageKeys.CON_CONNECT_FAILURE_USER_CUBE, connectThrowable, connectionParameters.valueOf(TM1UserNameParameter.class, String.class), connectionParameters.valueOf(CubeParameter.class, String.class));
            }
            throw new XQERuntimeException(XQEMessageKeys.GEN_UnexpectedException, connectThrowable);
        }
        if (MDDSLogger.CONN_CREATE.isOn(LogLevel.INFO)) {
            StringBuilder builder = new StringBuilder("New MDDSConnection established: ");
            builder.append("Cube[").append((String)connectionParameters.valueOf(CubeParameter.class, String.class)).append(SEPERATOR);
            builder.append("User[").append((String)connectionParameters.valueOf(TM1UserNameParameter.class, String.class)).append(SEPERATOR);
            builder.append("Handle[").append(this.qfwconnection.getNativeHandle()).append(TERMINATOR);
            MDDSLogger.CONN_CREATE.log(LogLevel.INFO, builder.toString());
        }
        this.connected = true;
        this.lastValidationTimestamp = System.currentTimeMillis();
    }

    private boolean isWinImpersonationNeeded(ConnectionParameters params) {
        String serverName;
        String adminHost;
        TM1ServerSecurityModeEnum mode;
        Object namespace;
        String camHandle;
        return MDDSDataProvider.isWindows() && null == (camHandle = (String)params.valueOf(CAMCryptoHandleParameter.class, String.class)) && (namespace = params.valueOf(NamespaceParameter.class, Object.class)) != null && namespace.toString().length() > 0 && ((mode = MDDSConnection.getStaticTM1ServerSecurityMode(adminHost = (String)params.valueOf(TM1AdminHostParameter.class, String.class), serverName = (String)params.valueOf(TM1ServerNameParameter.class, String.class))) == TM1ServerSecurityModeEnum.TM1_SECURITY_MODE_WIA || mode == TM1ServerSecurityModeEnum.TM1_SECURITY_MODE_MIXED);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void connectToTM1Server(ConnectionParameters connectionParameters, StringBuilder strBuf, Locale productLocale, boolean useWinImpersonation) throws Throwable {
        try {
            this.qfwconnection.createTM1Connection(strBuf.toString());
        }
        catch (QFWException ex) {
            this.handleQFWConnectException(connectionParameters, ex);
        }
        if (MDDSLogger.CONN_CREATE.isOn(LogLevel.TRACE)) {
            MDDSLogger.CONN_CREATE.log(LogLevel.TRACE, "Retrieving TM1 server security mode during connect.");
        }
        this.getTM1ServerSecurityMode(this.qfwconnection);
        int runLocaleLCID = Integer.valueOf(LocaleConverter.toLCID((Locale)productLocale));
        try {
            if (useWinImpersonation) {
                String username = (String)connectionParameters.valueOf(TM1UserNameParameter.class, String.class);
                if (username == null) throw new QFWException(true);
                String[] parts = username.split("\\\\");
                if (parts.length != 2) {
                    throw new QFWException(true);
                }
                String domain = parts[0];
                username = parts[1];
                String password = (String)connectionParameters.valueOf(TM1PasswordParameter.class, String.class);
                this.qfwconnection.connectToTM1WithWinImpersonate(domain, username, password, runLocaleLCID);
            } else {
                String ssoDelegationHandle = (String)connectionParameters.valueOf(CAMCryptoHandleParameter.class, String.class);
                if (null != ssoDelegationHandle && MDDSLogger.CONN_CREATE.isOn(LogLevel.TRACE)) {
                    MDDSLogger.CONN_CREATE.log(LogLevel.TRACE, "Delegation handle found=" + ssoDelegationHandle);
                }
                this.qfwconnection.connectToTM1(ssoDelegationHandle, runLocaleLCID);
            }
        }
        catch (QFWException ex) {
            this.handleQFWConnectException(connectionParameters, ex);
        }
        if (MDDSLogger.CONN_CREATE.isOn(LogLevel.TRACE)) {
            MDDSLogger.CONN_CREATE.log(LogLevel.TRACE, "Retrieving User Groups during connect.");
        }
        MDDSConnection.getTM1UserGroups(connectionParameters, this);
    }

    private void connectToPowerCube(ConnectionParameters connectionParameters, StringBuilder strBuf) {
        try {
            this.qfwconnection.connect(strBuf.toString());
        }
        catch (QFWException ex) {
            this.handleQFWConnectException(connectionParameters, ex);
        }
        String namespace = MDDSUtils.getNamespace(connectionParameters);
        PCSecurityContext.PCSecurityModeEnum mode = PCSecurityContext.PCSecurityModeEnum.LDAP;
        Object[] ctx = this.getContext();
        if (ctx != null) {
            for (Object c : ctx) {
                if (!(c instanceof PCSecurityContext)) continue;
                mode = ((PCSecurityContext)c).getSecurityMode();
            }
        }
        String userGroups = MDDSConnection.getPCUserGroups(namespace, mode);
        this.setUsergroupList(userGroups);
        IDataSource ds = (IDataSource)((DataSourceParameter)connectionParameters.get(DataSourceParameter.class)).value();
        IDataSourceConnection dsConn = ds.getDataSourceConnection();
        dsConn.setUserGroups(userGroups);
    }

    private void handleQFWConnectException(ConnectionParameters connectionParameters, QFWException ex) throws LogonFailureException, MDDSException {
        PCSecurityContext.PCSecurityModeEnum mode;
        MDDSConnectionError error = new MDDSConnectionError(ex);
        IDataSource dataSource = (IDataSource)connectionParameters.valueOf(DataSourceParameter.class, IDataSource.class);
        if (error.isPasswordNeeded()) {
            if (MDDSLogger.CONN_CREATE.isOn(LogLevel.ERROR)) {
                StringBuilder buf = new StringBuilder(LOG_MSG_LOGON_FAILURE);
                buf.append((String)connectionParameters.valueOf(TM1UserNameParameter.class, String.class));
                buf.append(STR_CUBE).append((String)connectionParameters.valueOf(CubeParameter.class, String.class)).append(STR_DOT);
                MDDSLogger.CONN_CREATE.log(LogLevel.ERROR, buf.toString());
            }
            IDataSourceConnection dsConnection = dataSource.getDataSourceConnection();
            dsConnection.invalidateResolvedSignon();
            throw new LogonFailureException(dataSource, LogonFailureException.SubCodeEnum.INVALID_CUBE_PWD);
        }
        if (error.isUserClassNeeded() && !connectionParameters.contains(UserClassIDsParameter.class)) {
            MDDSLogger.CONN_CREATE.log(LogLevel.INFO, LOG_MSG_ACQUIRE_USERCLASSIDS);
            mode = PCSecurityContext.PCSecurityModeEnum.LDAP;
            if (error.userSeries7Security()) {
                mode = PCSecurityContext.PCSecurityModeEnum.SERIES7;
            }
        } else {
            if (ex.isLogonFailure()) {
                IDataSourceConnection dsConnection = dataSource.getDataSourceConnection();
                dsConnection.invalidateResolvedSignon();
                throw new LogonFailureException(dataSource, LogonFailureException.SubCodeEnum.INVALID_CREDENTIALS);
            }
            throw new MDDSException(MDDSMessageKeys.CON_CONNECT_FAILURE, error.getErrorMessage());
        }
        this.pcSecurityContext = new PCSecurityContext(mode);
        MDDSConnection.getPCUserAccountAndUserClasses(connectionParameters, mode);
        this.connect(connectionParameters);
    }

    public TM1ServerSecurityModeEnum getTM1ServerSecurityMode(QFWConnection qfwConn) {
        if (this.serverSecurityMode != TM1ServerSecurityModeEnum.TM1_SECURITY_MODE_UNKNOWN) {
            return this.serverSecurityMode;
        }
        String adminHost = (String)this.getConnectionParameters().valueOf(TM1AdminHostParameter.class, String.class);
        String serverName = (String)this.getConnectionParameters().valueOf(TM1ServerNameParameter.class, String.class);
        this.serverSecurityMode = MDDSConnection.getStaticTM1ServerSecurityMode(adminHost, serverName);
        qfwConn.setSecurityMode(this.serverSecurityMode.toTM1Type());
        return this.serverSecurityMode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TM1ServerSecurityModeEnum getStaticTM1ServerSecurityMode(String adminHost, String serverName) {
        TM1ServerSecurityModeEnum securityMode;
        block10: {
            String adminServerKey = String.format(LOG_ADMIN_SERVER_PATTERN, adminHost, serverName);
            securityMode = TM1ServerSecurityModeEnum.TM1_SECURITY_MODE_UNKNOWN;
            if (!securityModeMapTM1.containsKey(adminServerKey)) {
                Gate newGate = new Gate();
                newGate.close();
                Gate gate = SEC_MODE_GATE.putIfAbsent(adminServerKey, newGate);
                if (gate != null) {
                    try {
                        gate.await(10L, TimeUnit.SECONDS);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    if (securityModeMapTM1.containsKey(adminServerKey)) {
                        return securityModeMapTM1.get(adminServerKey);
                    }
                }
                try {
                    int serverMode = QFWConnection.getSecurityMode((String)adminHost, (String)serverName);
                    if (0 != serverMode) {
                        securityMode = TM1ServerSecurityModeEnum.valueOf(serverMode);
                        securityModeMapTM1.putIfAbsent(adminServerKey, securityMode);
                        break block10;
                    }
                    throw new MDDSException(MDDSMessageKeys.CON_CONNECT_FAILURE_SERVER_NOT_STARTED, adminServerKey);
                }
                finally {
                    gate = SEC_MODE_GATE.remove(adminServerKey);
                    if (gate != null) {
                        gate.open();
                    }
                }
            }
            securityMode = securityModeMapTM1.get(adminServerKey);
        }
        return securityMode;
    }

    public static UserClassIDsParameter getTM1UserGroups(ConnectionParameters params, MDDSConnection currConn) {
        StringBuilder buf;
        ExecutionEnvironment env = (ExecutionEnvironment)ExecutionEnvironmentContext.getExecutionEnvironment();
        if (env == null) {
            throw new XQERuntimeException(XQEMessageKeys.GEN_ExecutionEnvironmentMissing_INTERNAL);
        }
        String userGroups = null;
        IDataSource ds = (IDataSource)((DataSourceParameter)params.get(DataSourceParameter.class)).value();
        IDataSourceConnection dsConn = ds.getDataSourceConnection();
        if (null == dsConn) {
            throw new XQERuntimeException(XQEMessageKeys.GEN_FoundInternalErrorParam_INTERNAL, "DataSource missing.");
        }
        userGroups = dsConn.getUserGroups();
        if (null != userGroups) {
            if (MDDSLogger.CONN_CREATE.isOn(LogLevel.TRACE)) {
                buf = new StringBuilder();
                buf.append("Retrieved Cached User Groups=");
                buf.append(userGroups);
                MDDSLogger.CONN_CREATE.log(LogLevel.TRACE, buf.toString());
            }
        } else if (null != currConn) {
            if (currConn.serverHasUserGroups()) {
                userGroups = currConn.getUsergroupList();
                if (null == userGroups) {
                    if (MDDSLogger.CONN_CREATE.isOn(LogLevel.TRACE)) {
                        MDDSLogger.CONN_CREATE.log(LogLevel.TRACE, "Retrieving User Groups with an existing connection.");
                    }
                    QFWConnection qfwConn = currConn.getConnection();
                    userGroups = qfwConn.getUserGroups();
                    currConn.setUsergroupList(userGroups);
                } else if (MDDSLogger.CONN_CREATE.isOn(LogLevel.TRACE)) {
                    MDDSLogger.CONN_CREATE.log(LogLevel.TRACE, "Retrieving Cached User Groups from an existing connection.");
                }
                if (null != userGroups) {
                    dsConn.setUserGroups(userGroups);
                }
            } else if (MDDSLogger.CONN_CREATE.isOn(LogLevel.TRACE)) {
                MDDSLogger.CONN_CREATE.log(LogLevel.TRACE, "Not retrieving User Groups due to security mode.");
            }
            if (MDDSLogger.CONN_CREATE.isOn(LogLevel.TRACE)) {
                buf = new StringBuilder();
                buf.append("Retrieved User Groups=");
                buf.append(userGroups);
                MDDSLogger.CONN_CREATE.log(LogLevel.TRACE, buf.toString());
            }
        } else {
            throw new MissingSecurityContextException();
        }
        UserClassIDsParameter param = null;
        if (null != userGroups) {
            param = new UserClassIDsParameter(userGroups);
            params.put((IConnectionParameter)param);
        }
        return param;
    }

    public static String getPCUserGroups(String namespace, PCSecurityContext.PCSecurityModeEnum mode) {
        ArrayList<String> filter = new ArrayList<String>();
        filter.add("account");
        return MDDSConnection.getPCUserIdentities(namespace, mode, filter);
    }

    public static UserClassIDsParameter getPCUserAccountAndUserClasses(ConnectionParameters params, PCSecurityContext.PCSecurityModeEnum mode) {
        ArrayList<String> filter = new ArrayList<String>();
        String namespace = MDDSUtils.getNamespace(params);
        String identities = MDDSConnection.getPCUserIdentities(namespace, mode, filter);
        UserClassIDsParameter param = new UserClassIDsParameter(identities);
        params.put((IConnectionParameter)param);
        return param;
    }

    public static String getPCUserIdentities(String namespace, PCSecurityContext.PCSecurityModeEnum mode, List<String> filter) {
        ExecutionEnvironment env = (ExecutionEnvironment)ExecutionEnvironmentContext.getExecutionEnvironment();
        if (env == null) {
            throw new XQERuntimeException(XQEMessageKeys.GEN_ExecutionEnvironmentMissing_INTERNAL);
        }
        String identities = null;
        IRequestEnvironment reqEnv = env.getRequestEnvironment();
        if (mode == PCSecurityContext.PCSecurityModeEnum.SERIES7) {
            if (namespace == null) {
                throw new MDDSException(MDDSMessageKeys.CON_MISSING_NAMESPACE);
            }
            identities = ContentManager.getUserClassIDs((IRequestEnvironment)reqEnv, filter, (boolean)true);
        } else if (MDDSConfigManager.instance().getConfig("PC").isNamespaceFilteringEnabled()) {
            if (namespace == null) {
                throw new MDDSException(MDDSMessageKeys.CON_MISSING_NAMESPACE);
            }
            identities = ContentManager.getUserClassIDs((IRequestEnvironment)reqEnv, (String)namespace, filter, (boolean)false);
        } else {
            identities = ContentManager.getUserClassIDs((IRequestEnvironment)reqEnv, filter, (boolean)false);
        }
        return identities;
    }

    public QFWConnection getConnection() {
        return this.qfwconnection;
    }

    public String getUsergroupList() {
        return this.userGroupList;
    }

    public void setUsergroupList(String sUserGroupList) {
        this.userGroupList = sUserGroupList;
    }

    public TM1ServerSecurityModeEnum getServerMode() {
        return this.serverSecurityMode;
    }

    public void disconnect() {
        if (this.qfwconnection != null && this.connected) {
            if (MDDSLogger.CONN_RELEASE.isOn(LogLevel.INFO)) {
                StringBuilder builder = new StringBuilder("Disconnecting MDDSConnection: Handle[ ");
                builder.append(this.qfwconnection.getNativeHandle()).append(SEPERATOR);
                builder.append("Parameters[").append(this.getConnectionParameters().toString()).append(TERMINATOR);
                MDDSLogger.CONN_RELEASE.log(LogLevel.INFO, builder.toString());
            }
            this.qfwconnection.release();
        }
        this.connected = false;
    }

    public void cancel() throws CancelUnsuccessfulException {
        if (MDDSLogger.CONN_CANCEL.isOn(LogLevel.TRACE) && this.qfwconnection != null) {
            MDDSLogger.CONN_CANCEL.log(LogLevel.TRACE, "Cancelling MDDSConnection with handle " + this.qfwconnection.getNativeHandle());
        }
        throw new CancelUnsuccessfulException();
    }

    public synchronized void cancel(CancelRequestSourceEnum cancelSource) throws CancelUnsuccessfulException {
        throw new CancelUnsuccessfulException();
    }

    public boolean isConnected() {
        return this.connected;
    }

    public void setCubeLoaded(boolean isCubeLoaded) {
        this.metadataCacheContext.setCubeLoaded(isCubeLoaded);
    }

    public boolean isCubeLoaded() {
        return this.metadataCacheContext.isCubeLoaded();
    }

    public Object[] getContext() {
        if (null != this.pcSecurityContext) {
            return new Object[]{this.metadataCacheContext, this.pcSecurityContext};
        }
        return new Object[]{this.metadataCacheContext};
    }

    public void checkForInvalidTM1Connection(QFWException ex) {
        boolean isValid = true;
        if (this.getConnectionParameters().contains(TM1AdminHostParameter.class)) {
            try {
                isValid = this.qfwconnection.validate();
            }
            catch (QFWException exc) {
                isValid = false;
            }
            if (!isValid) {
                this.invalidate();
            }
        }
    }

    public boolean serverHasUserGroups() {
        String ssoDelegationHandle;
        return this.serverSecurityMode.isMixedMode() ? (ssoDelegationHandle = (String)this.getConnectionParameters().valueOf(CAMCryptoHandleParameter.class, String.class)) != null : this.getServerMode().hasTM1Security();
    }

    public boolean isValid() {
        return this.qfwconnection != null && this.qfwconnection.validate();
    }

    public boolean needValidation() {
        long current = System.currentTimeMillis();
        if (current - this.lastValidationTimestamp >= 10000L) {
            this.lastValidationTimestamp = current;
            return true;
        }
        return false;
    }
}

