/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.data.providers.olap.mdds.connection;

import com.cognos.xqe.data.providers.olap.mdds.util.MDDSLogger;
import com.cognos.xqe.data.providers.qfwbridge.QFWException;
import com.cognos.xqe.trace.LogLevel;
import com.cognos.xqe.util.pool.XQESAXReaderPool;
import java.io.Reader;
import java.io.StringReader;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;

public class MDDSConnectionError {
    private static final String STR_VALUE = "value";
    private boolean needPassword = false;
    private boolean needUserClass = false;
    private boolean useSeries7Security = false;
    private final QFWException qfwException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MDDSConnectionError(QFWException ex) {
        this.qfwException = ex;
        if (MDDSLogger.CONN_3RDPARTY.isOn(LogLevel.INFO)) {
            MDDSLogger.CONN_3RDPARTY.log(LogLevel.INFO, this.qfwException.getLogString());
        }
        if (null != ex.getDOM() && ex.getDOM().length() > 0) {
            XQESAXReaderPool pool = XQESAXReaderPool.getInstance();
            SAXReader reader = null;
            try {
                String value;
                reader = pool.borrowReader();
                Document doc = reader.read((Reader)new StringReader(ex.getDOM()));
                Element element = doc.getRootElement().element("needPassword");
                if (element != null && (value = element.attributeValue(STR_VALUE)) != null && Boolean.valueOf(value).booleanValue()) {
                    this.needPassword = true;
                }
                if ((element = doc.getRootElement().element("needUserClass")) != null && (value = element.attributeValue(STR_VALUE)) != null && Boolean.valueOf(value).booleanValue()) {
                    this.needUserClass = true;
                }
                if ((element = doc.getRootElement().element("SecurityType")) != null && (value = element.attributeValue(STR_VALUE)) != null && value.equals("Series7")) {
                    this.useSeries7Security = true;
                }
            }
            catch (Throwable connectThrowable) {
                if (MDDSLogger.CONN_CREATE.isOn(LogLevel.INFO)) {
                    MDDSLogger.CONN_CREATE.log(LogLevel.INFO, "Connection Error not in DOM format.");
                }
            }
            finally {
                if (reader != null) {
                    try {
                        pool.returnReader(reader);
                    }
                    catch (Throwable e) {
                        MDDSLogger.CONN_CREATE.log(LogLevel.INFO, "Failed to return SAXReader to pool.");
                    }
                }
            }
        }
    }

    public boolean isPasswordNeeded() {
        return this.needPassword;
    }

    public boolean isUserClassNeeded() {
        return this.needUserClass;
    }

    public String getErrorMessage() {
        Object[] args = this.qfwException.getArguments();
        if (args != null && args.length > 0) {
            return (String)this.qfwException.getArguments()[0];
        }
        return "";
    }

    public boolean userSeries7Security() {
        return this.useSeries7Security;
    }
}

