/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.data.providers.olap.mdds.connection;

import com.cognos.xqe.config.ServiceEnumeration;
import com.cognos.xqe.data.olap.common.CAMPassportParameter;
import com.cognos.xqe.data.olap.common.UserClassIDRetrievalModeParameter;
import com.cognos.xqe.data.providers.connection.parameters.UserClassIDsParameter;
import com.cognos.xqe.data.providers.olap.DefaultConnection;
import com.cognos.xqe.data.providers.olap.mdds.MDDSConnection;
import com.cognos.xqe.data.providers.olap.mdds.connection.MetadataCacheContext;
import com.cognos.xqe.data.providers.olap.mdds.connection.TM1PasswordParameter;
import com.cognos.xqe.data.providers.olap.mdds.connection.TM1UserNameParameter;
import com.cognos.xqe.data.providers.olap.mdds.util.MDDSLogger;
import com.cognos.xqe.pool.connection.ConnectionParameters;
import com.cognos.xqe.pool.connection.IConnectionParameter;
import com.cognos.xqe.pool.connection.IConnectionSelector;
import com.cognos.xqe.pool.connection.IPooledConnection;
import com.cognos.xqe.pool.connection.ISelectorContext;
import com.cognos.xqe.trace.LogLevel;
import com.cognos.xqe.trace.XQELog;
import com.cognos.xqe.trace.XQELogger;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class TM1ConnectionSelector
implements IConnectionSelector {
    private final UserClassIDsParameter userGroups;
    private final long timeout;
    private static final ExecutorService TIMER_SERVICE = Executors.newCachedThreadPool();
    private static final XQELogger LOGGER = XQELog.getLogger((ServiceEnumeration)ServiceEnumeration.XQEODP, (String)"MDDS", (String)"Connection.Selector", (LogLevel)LogLevel.WARN);

    public TM1ConnectionSelector(long selectorTimeout) {
        this.userGroups = null;
        this.timeout = selectorTimeout;
    }

    public TM1ConnectionSelector(Object securityContext, long selectorTimeout) {
        this.userGroups = securityContext instanceof UserClassIDsParameter ? (UserClassIDsParameter)securityContext : null;
        this.timeout = selectorTimeout;
    }

    public IConnectionSelector.ReturnCode selectConnection(ConnectionParameters connectionParameters, ISelectorContext context, IPooledConnection pooledConnection) {
        boolean isValid;
        DefaultConnection connection;
        boolean matches;
        block43: {
            StringBuilder builder;
            matches = false;
            if (this.userGroups != null && !connectionParameters.contains(this.userGroups.getClass())) {
                connectionParameters.put((IConnectionParameter)this.userGroups);
            }
            connection = (DefaultConnection)pooledConnection.getConnection();
            boolean isCubeLoaded = false;
            Object[] ctx = connection.getContext();
            if (ctx != null) {
                for (Object c : ctx) {
                    if (!(c instanceof MetadataCacheContext)) continue;
                    isCubeLoaded = ((MetadataCacheContext)c).isCubeLoaded();
                }
            }
            if (null != context && 1 == context.getSelectionPass() && !isCubeLoaded) {
                if (MDDSLogger.CONN_POOL.isOn(LogLevel.INFO)) {
                    StringBuilder builder2 = new StringBuilder("Cube isn't loaded, push to next pass:");
                    builder2.append(connection.getConnectionParameters());
                    MDDSLogger.CONN_POOL.log(LogLevel.INFO, builder2.toString());
                }
                return IConnectionSelector.ReturnCode.NEXT_PASS;
            }
            ConnectionParameters poolParameters = connection.getConnectionParameters();
            UserClassIDsParameter paramUserGroups = (UserClassIDsParameter)connectionParameters.get(UserClassIDsParameter.class);
            UserClassIDsParameter pooledConnUserGroups = (UserClassIDsParameter)poolParameters.get(UserClassIDsParameter.class);
            if (paramUserGroups == null && pooledConnUserGroups != null) {
                boolean partialMatch = poolParameters.matches(connectionParameters);
                if (partialMatch) {
                    if (connectionParameters.contains(UserClassIDRetrievalModeParameter.class)) {
                        CAMPassportParameter paramCamPassport = (CAMPassportParameter)connectionParameters.get(CAMPassportParameter.class);
                        if (paramCamPassport != null && (matches = poolParameters.contains((IConnectionParameter)paramCamPassport)) && MDDSLogger.CONN_POOL.isOn(LogLevel.INFO)) {
                            builder = new StringBuilder("Connection matches with CAM Passport=");
                            builder.append((String)paramCamPassport.value());
                            MDDSLogger.CONN_POOL.log(LogLevel.INFO, builder.toString());
                        }
                    } else {
                        UserClassIDsParameter param = null;
                        param = MDDSConnection.getTM1UserGroups(connectionParameters, null);
                        if (param.matches((IConnectionParameter)pooledConnUserGroups)) {
                            if (MDDSLogger.CONN_POOL.isOn(LogLevel.INFO)) {
                                builder = new StringBuilder("Connection matches with user groups=");
                                builder.append((String)pooledConnUserGroups.value());
                                MDDSLogger.CONN_POOL.log(LogLevel.INFO, builder.toString());
                            }
                            matches = true;
                        }
                    }
                }
            } else if (paramUserGroups != null) {
                matches = poolParameters.matches(connectionParameters);
                if (matches && null != pooledConnUserGroups) {
                    matches = paramUserGroups.matches((IConnectionParameter)pooledConnUserGroups);
                }
            } else {
                matches = poolParameters.matches(connectionParameters);
                if (matches) {
                    TM1UserNameParameter luid = (TM1UserNameParameter)connectionParameters.get(TM1UserNameParameter.class);
                    TM1UserNameParameter ruid = (TM1UserNameParameter)poolParameters.get(TM1UserNameParameter.class);
                    if (luid == null && ruid != null) {
                        if (MDDSLogger.CONN_POOL.isOn(LogLevel.INFO)) {
                            builder = new StringBuilder("Match failed with connection user name=");
                            builder.append((String)ruid.value());
                            MDDSLogger.CONN_POOL.log(LogLevel.INFO, builder.toString());
                        }
                        matches = false;
                    } else if (luid != null && ruid == null) {
                        if (MDDSLogger.CONN_POOL.isOn(LogLevel.INFO)) {
                            builder = new StringBuilder("Match failed with params user name=");
                            builder.append((String)luid.value());
                            MDDSLogger.CONN_POOL.log(LogLevel.INFO, builder.toString());
                        }
                        matches = false;
                    } else if (luid != null && ruid != null) {
                        if (!luid.matches((IConnectionParameter)ruid)) {
                            if (MDDSLogger.CONN_POOL.isOn(LogLevel.INFO)) {
                                builder = new StringBuilder("Match failed with different user names=");
                                builder.append((String)luid.value());
                                builder.append("!=");
                                builder.append((String)ruid.value());
                                MDDSLogger.CONN_POOL.log(LogLevel.INFO, builder.toString());
                            }
                            matches = false;
                        } else {
                            TM1PasswordParameter lpwd = (TM1PasswordParameter)connectionParameters.get(TM1PasswordParameter.class);
                            TM1PasswordParameter rpwd = (TM1PasswordParameter)poolParameters.get(TM1PasswordParameter.class);
                            if (null != lpwd && null != rpwd) {
                                matches = lpwd.matches((IConnectionParameter)rpwd);
                            }
                        }
                    }
                }
            }
            if (MDDSLogger.CONN_POOL.isOn(LogLevel.INFO)) {
                if (!matches) {
                    StringBuilder builder3 = new StringBuilder("Cannot reuse TM1 connection due to connection parameters ");
                    builder3.append(connectionParameters);
                    builder3.append(" doesn't match with ");
                    builder3.append(connection.getConnectionParameters());
                    MDDSLogger.CONN_POOL.log(LogLevel.INFO, builder3.toString());
                } else {
                    StringBuilder builder4 = new StringBuilder("TM1 connection matches:");
                    builder4.append(connectionParameters);
                    builder4.append(" matches with ");
                    builder4.append(connection.getConnectionParameters());
                    MDDSLogger.CONN_POOL.log(LogLevel.INFO, builder4.toString());
                }
            }
            if (this.timeout > 0L && connection instanceof MDDSConnection) {
                MDDSConnection mddsConn = (MDDSConnection)connection;
                if (mddsConn.needValidation()) {
                    Future<Boolean> task = TIMER_SERVICE.submit(new Callable<Boolean>(){

                        @Override
                        public Boolean call() {
                            return connection.isValid();
                        }
                    });
                    try {
                        isValid = task.get(this.timeout, TimeUnit.MILLISECONDS);
                    }
                    catch (Exception e) {
                        boolean succeed;
                        isValid = false;
                        if (LOGGER.isOn()) {
                            LOGGER.log("Exception occurred during selection. The TM1 connection will be invalidated.", (Throwable)e);
                            try {
                                LOGGER.log(this.toString());
                            }
                            catch (Throwable throwable) {
                                // empty catch block
                            }
                        }
                        if (e instanceof TimeoutException && !(succeed = task.cancel(true)) && LOGGER.isOn(LogLevel.ERROR)) {
                            LOGGER.log(LogLevel.ERROR, "Failed to cancel a hanging TM1 connection selector. Resources could be leaked.");
                        }
                        break block43;
                    }
                }
                isValid = true;
            } else {
                isValid = connection.isValid();
            }
        }
        if (matches && !isValid) {
            connection.invalidate();
            matches = false;
            if (MDDSLogger.CONN_POOL.isOn(LogLevel.INFO)) {
                MDDSLogger.CONN_POOL.log(LogLevel.INFO, "Cannot reuse TM1 connection due to server connection is invalid.");
            }
        }
        if (matches) {
            return IConnectionSelector.ReturnCode.MATCH;
        }
        return IConnectionSelector.ReturnCode.NOT_MATCH;
    }
}

