/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.data.providers.olap.mdds.connection;

import com.cognos.xqe.data.olap.common.CAMPassportParameter;
import com.cognos.xqe.data.providers.olap.mdds.connection.TM1AdminHostParameter;
import com.cognos.xqe.data.providers.olap.mdds.connection.TM1ServerNameParameter;
import com.cognos.xqe.data.providers.olap.mdds.connection.UnixPathParameter;
import com.cognos.xqe.data.providers.olap.mdds.connection.WinPathParameter;
import com.cognos.xqe.pool.connection.ConnectionParameters;
import com.cognos.xqe.util.eviction.ConcurrentSimpleDLinkLRUMap;

public class UserClassIDCache {
    private static final String KEY_PART_DELIMITER = "|";
    private ConcurrentSimpleDLinkLRUMap<String, String> passportToUCIDMap;

    public UserClassIDCache(int retainSize) {
        this.passportToUCIDMap = new ConcurrentSimpleDLinkLRUMap(retainSize, true);
    }

    public void addEntry(ConnectionParameters parameters, String userClassIDs) {
        String key = UserClassIDCache.generateKey(parameters);
        if (key != null) {
            this.passportToUCIDMap.put((Object)key, (Object)userClassIDs);
        }
    }

    public String getEntry(ConnectionParameters parameters) {
        String key = UserClassIDCache.generateKey(parameters);
        if (key != null) {
            return (String)this.passportToUCIDMap.get((Object)key);
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static String generateKey(ConnectionParameters parameters) {
        if (!parameters.contains(CAMPassportParameter.class)) return null;
        String camPassport = parameters.valueOf(CAMPassportParameter.class).toString();
        StringBuilder key = new StringBuilder(camPassport);
        key.append(KEY_PART_DELIMITER);
        if (parameters.contains(TM1AdminHostParameter.class)) {
            String adminHost = parameters.valueOf(TM1AdminHostParameter.class).toString();
            key.append(adminHost);
            key.append(KEY_PART_DELIMITER);
            String serverName = parameters.valueOf(TM1ServerNameParameter.class).toString();
            if (serverName == null) return null;
            key.append(serverName);
            return key.toString();
        } else if (parameters.contains(WinPathParameter.class)) {
            key.append(parameters.valueOf(WinPathParameter.class).toString());
            return key.toString();
        } else {
            if (!parameters.contains(UnixPathParameter.class)) return null;
            key.append(parameters.valueOf(UnixPathParameter.class).toString());
        }
        return key.toString();
    }
}

