/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.data.providers.olap.mdds.metadata;

import com.cognos.xqe.data.providers.olap.mdds.MDDSMessageKeys;
import com.cognos.xqe.data.providers.olap.mdds.metadata.MetadataAttributes;
import com.cognos.xqe.data.providers.olap.mdds.metadata.MetadataResponseEntity;
import com.cognos.xqe.data.providers.olap.mdds.util.MDDSConstants;
import com.cognos.xqe.data.providers.olap.mdds.util.MDDSException;
import com.cognos.xqe.data.types.DataTypeFactory;
import com.cognos.xqe.data.types.DateType;
import com.cognos.xqe.data.types.IDataType;
import com.cognos.xqe.data.values.DataValueFactory;
import com.cognos.xqe.data.values.DateTimeValue;
import com.cognos.xqe.data.values.TimestampValue;
import com.cognos.xqe.metadata.AggregateTypeEnum;
import com.cognos.xqe.metadata.DimensionTypeEnum;
import com.cognos.xqe.metadata.ICube;
import com.cognos.xqe.metadata.MemberTypeEnum;
import com.cognos.xqe.metadata.RoleTypeEnum;
import com.cognos.xqe.metadata.RollupTypeEnum;
import com.cognos.xqe.metadata.record.AliasRecord;
import com.cognos.xqe.metadata.record.CatalogRecord;
import com.cognos.xqe.metadata.record.CubeRecord;
import com.cognos.xqe.metadata.record.DimensionRecord;
import com.cognos.xqe.metadata.record.HierarchyRecord;
import com.cognos.xqe.metadata.record.LevelRecord;
import com.cognos.xqe.metadata.record.MeasureRecord;
import com.cognos.xqe.metadata.record.MemberRecord;
import com.cognos.xqe.metadata.record.MetadataRecord;
import com.cognos.xqe.metadata.record.PropertyRecord;
import com.cognos.xqe.metadata.record.RecordType;
import com.cognos.xqe.util.ILocalizedString;
import com.cognos.xqe.util.LocalizedString;

public class MetadataRecordFactory {
    private final RecordType type;
    private final String catalogName;
    private final String cubeName;

    public MetadataRecordFactory(RecordType theType, String theCatalogName, String theCubeName) {
        this.type = theType;
        this.catalogName = theCatalogName;
        this.cubeName = theCubeName;
    }

    public RecordType getRecordType() {
        return this.type;
    }

    public MetadataRecord createRecord(MetadataResponseEntity entity) {
        switch (this.type) {
            case ALIAS: {
                return this.createAliasRecord(entity);
            }
            case CATALOG: {
                return this.createCatalogRecord(entity);
            }
            case CUBE: {
                return this.createCubeRecord(entity);
            }
            case DIMENSION: {
                return this.createDimensionRecord(entity);
            }
            case HIERARCHY: {
                return this.createHierarchyRecord(entity);
            }
            case LEVEL: {
                return this.createLevelRecord(entity);
            }
            case MEASURE: {
                return this.createMeasureRecord(entity);
            }
            case MEMBER: {
                return this.createMemberRecord(entity);
            }
            case PROPERTY: {
                return this.createPropertyRecord(entity);
            }
        }
        return null;
    }

    public AliasRecord createAliasRecord(MetadataResponseEntity entity) {
        AliasRecord record = new AliasRecord();
        String aliasTableName = entity.getString(MetadataAttributes.Alias_Table_Name, record.getUniqueName());
        record.setUniqueName(aliasTableName);
        record.setName(aliasTableName);
        LocalizedString caption = new LocalizedString(entity.getDefaultLocale(), aliasTableName);
        record.setCaption((ILocalizedString)caption);
        String dun = entity.getString(MetadataAttributes.Dimension_Unique_Name, null);
        if (dun != null) {
            record.setDimensionUniqueName(dun);
        }
        if (this.catalogName != null) {
            record.setCatalogName(this.catalogName);
        }
        record.setCubeName(this.cubeName);
        return record;
    }

    public CatalogRecord createCatalogRecord(MetadataResponseEntity entity) {
        CatalogRecord record = new CatalogRecord();
        record.setName(entity.getString(MetadataAttributes.Catalog_Name, record.getName()));
        record.setUniqueName(entity.getString(MetadataAttributes.Catalog_Name, record.getUniqueName()));
        record.setDescription(entity.getString(MetadataAttributes.Description, record.getDescription()));
        LocalizedString caption = new LocalizedString(entity.getDefaultLocale(), entity.getString(MetadataAttributes.Catalog_Name, record.getName()));
        record.setCaption((ILocalizedString)caption);
        return record;
    }

    public CubeRecord createCubeRecord(MetadataResponseEntity entity) {
        String cubeDefaultMeasure;
        String suppressionType;
        String currentPeriod;
        String timestamp;
        Boolean isOptimized;
        String schemaName;
        CubeRecord record = new CubeRecord();
        record.setName(entity.getString(MetadataAttributes.Cube_Name, record.getName()));
        record.setUniqueName(entity.getString(MetadataAttributes.Cube_Name, record.getUniqueName()));
        LocalizedString caption = entity.getCaption();
        if (caption != null) {
            record.setCaption((ILocalizedString)caption);
        } else {
            LocalizedString cap = new LocalizedString(entity.getDefaultLocale(), entity.getString(MetadataAttributes.Cube_Name, record.getName()));
            record.setCaption((ILocalizedString)cap);
        }
        record.setDescription(entity.getString(MetadataAttributes.Description, record.getDescription()));
        String catalog = entity.getString(MetadataAttributes.Caption, record.getCatalogName());
        if (catalog != null) {
            record.setCatalogName(catalog);
        }
        if ((schemaName = entity.getString(MetadataAttributes.Schema_Name, record.getSchemaName())) != null) {
            record.setSchemaName(schemaName);
        }
        if ((isOptimized = entity.getBoolean(MetadataAttributes.Is_Optimized)) != null) {
            record.setIsOptimized(isOptimized.booleanValue());
        }
        if ((timestamp = entity.getString(MetadataAttributes.Created_On, null)) != null) {
            record.setCreatedDate(MetadataRecordFactory.convertTimestamp(timestamp));
        }
        if ((timestamp = entity.getString(MetadataAttributes.Last_Data_Update, "")) != null) {
            record.setDataUpdateDate(MetadataRecordFactory.convertTimestamp(timestamp));
        }
        if ((timestamp = entity.getString(MetadataAttributes.Last_Schema_Update, "")) != null) {
            record.setSchemaUpdateDate(MetadataRecordFactory.convertTimestamp(timestamp));
        }
        if ((currentPeriod = entity.getString(MetadataAttributes.Current_Period, "")) != null) {
            record.setCurrentPeriod(currentPeriod);
        }
        if ((suppressionType = entity.getString(MetadataAttributes.Suppression, "")) != null) {
            record.setSuppressionType(ICube.CubeSuppressionTypeEnum.fromMDDSTypeString((String)suppressionType));
        }
        if ((cubeDefaultMeasure = entity.getString(MetadataAttributes.Default_Measure, "")) != null) {
            record.setDynamicField(MetadataAttributes.Default_Measure.name(), (Object)cubeDefaultMeasure);
        }
        if (this.catalogName != null) {
            record.setCatalogName(this.catalogName);
        }
        return record;
    }

    public DimensionRecord createDimensionRecord(MetadataResponseEntity entity) {
        DimensionRecord record = new DimensionRecord();
        String dimensionName = entity.getString(MetadataAttributes.Dimension_Name, record.getName());
        if (dimensionName != null) {
            record.setName(dimensionName);
        }
        record.setUniqueName(entity.getString(MetadataAttributes.Dimension_Unique_Name, record.getUniqueName()));
        record.setCaption((ILocalizedString)entity.getCaption());
        record.setDescription(entity.getString(MetadataAttributes.Description, record.getDescription()));
        record.setCardinality(entity.getInteger(MetadataAttributes.Cardinality, record.getCardinality()).intValue());
        record.setDefaultHierarchyUniqueName(entity.getString(MetadataAttributes.Default_Hierarchy, record.getDefaultHierarchyUniqueName()));
        record.setHidden(entity.getBoolean(MetadataAttributes.Is_Hidden, record.isHidden()));
        String aType = entity.getString(MetadataAttributes.Type, record.getType().toMDDSType());
        record.setType(DimensionTypeEnum.fromMDDSTypeString((String)aType));
        record.setUniqueId(entity.getString(MetadataAttributes.PPDS_CODE, record.getName()));
        String ppdsKey = entity.getString(MetadataAttributes.PPDS_KEY, "");
        if (ppdsKey != null) {
            record.setDynamicFieldAsString(MetadataAttributes.PPDS_KEY.toString(), ppdsKey);
        }
        if (this.catalogName != null) {
            record.setCatalogName(this.catalogName);
        }
        record.setCubeName(this.cubeName);
        if (record.getType() == DimensionTypeEnum.ACCOUNT || record.getType() == DimensionTypeEnum.SCENARIO) {
            record.setMembersRollup(false);
        }
        return record;
    }

    public HierarchyRecord createHierarchyRecord(MetadataResponseEntity entity) {
        HierarchyRecord record = new HierarchyRecord();
        String hierarchyName = entity.getString(MetadataAttributes.Hierarchy_Name, record.getName());
        if (hierarchyName != null) {
            record.setName(hierarchyName);
        }
        record.setUniqueName(entity.getString(MetadataAttributes.Hierarchy_Unique_Name, record.getUniqueName()));
        String dun = entity.getString(MetadataAttributes.Dimension_Unique_Name, record.getDimensionUniqueName());
        if (dun != null) {
            record.setDimensionUniqueName(dun);
        }
        record.setCaption((ILocalizedString)entity.getCaption());
        record.setBalanced(entity.getBoolean(MetadataAttributes.Balanced_Hierarchy, record.isBalanced()).booleanValue());
        record.setHidden(entity.getBoolean(MetadataAttributes.Is_Hidden, record.isHidden()));
        String defualtMember = entity.getString(MetadataAttributes.Default_Member, record.getDefaultMemberUniqueName());
        if (defualtMember != null) {
            record.setDefaultMemberUniqueName(defualtMember);
        }
        record.setParentChild(entity.getBoolean(MetadataAttributes.Parent_Child_Hierarchy, record.isParentChild()).booleanValue());
        record.setRagged(entity.getBoolean(MetadataAttributes.Ragged_Hierarchy, record.isRagged()).booleanValue());
        record.setDescription(entity.getString(MetadataAttributes.Description, record.getDescription()));
        record.setCardinality(entity.getInteger(MetadataAttributes.Cardinality, record.getCardinality()).intValue());
        record.setUniqueId(entity.getString(MetadataAttributes.PPDS_CODE, record.getName()));
        record.setHighestRollupMemberUniqueName(entity.getString(MetadataAttributes.Highest_Level_Rollup, record.getHighestRollupMemberUniqueName()));
        String ppdsKey = entity.getString(MetadataAttributes.PPDS_KEY, "");
        if (ppdsKey != null) {
            record.setDynamicFieldAsString(MetadataAttributes.PPDS_KEY.toString(), ppdsKey);
        }
        record.setDisplayPath(entity.getString(MetadataAttributes.Display_Path, record.getDisplayPath()));
        record.setAttributeHierarchy(false);
        if (this.catalogName != null) {
            record.setCatalogName(this.catalogName);
        }
        record.setCubeName(this.cubeName);
        return record;
    }

    public LevelRecord createLevelRecord(MetadataResponseEntity entity) {
        String hun;
        LevelRecord record = new LevelRecord();
        String dun = entity.getString(MetadataAttributes.Dimension_Unique_Name, record.getDimensionUniqueName());
        if (dun != null) {
            record.setDimensionUniqueName(dun);
        }
        if ((hun = entity.getString(MetadataAttributes.Hierarchy_Unique_Name, record.getHierarchyUniqueName())) != null) {
            record.setHierarchyUniqueName(hun);
        }
        record.setUniqueName(entity.getString(MetadataAttributes.Level_Unique_Name, record.getUniqueName()));
        String levelName = entity.getString(MetadataAttributes.Level_Name, record.getName());
        if (levelName != null) {
            record.setName(levelName);
        }
        record.setLevelNumber(entity.getInteger(MetadataAttributes.Level_Number, record.getLevelNumber()).intValue());
        record.setCaption((ILocalizedString)entity.getCaption());
        record.setUniqueMemberNames(entity.getBoolean(MetadataAttributes.Is_Unique, record.hasUniqueMemberNames()).booleanValue());
        record.setDescription(entity.getString(MetadataAttributes.Description, record.getDescription()));
        record.setCardinality(entity.getInteger(MetadataAttributes.Cardinality, record.getCardinality()).intValue());
        record.setUniqueId(entity.getString(MetadataAttributes.PPDS_CODE, record.getName()));
        String ppdsKey = entity.getString(MetadataAttributes.PPDS_KEY, "");
        if (ppdsKey != null) {
            record.setDynamicFieldAsString(MetadataAttributes.PPDS_KEY.toString(), ppdsKey);
        }
        record.setHidden(entity.getBoolean(MetadataAttributes.Is_Hidden, record.isHidden()));
        if (this.catalogName != null) {
            record.setCatalogName(this.catalogName);
        }
        record.setCubeName(this.cubeName);
        return record;
    }

    public MeasureRecord createMeasureRecord(MetadataResponseEntity entity) {
        MeasureRecord record = new MeasureRecord();
        record.setUniqueName(entity.getString(MetadataAttributes.Measure_Unique_Name, record.getUniqueName()));
        record.setName(entity.getString(MetadataAttributes.Measure_Name, record.getName()));
        record.setCaption((ILocalizedString)entity.getCaption());
        record.setDescription(entity.getString(MetadataAttributes.Description, record.getDescription()));
        record.setDisplayPath(entity.getString(MetadataAttributes.Display_Path, record.getDisplayPath()));
        record.setUnits(entity.getString(MetadataAttributes.Units, record.getUnits()));
        record.setMeasureFolder(entity.getBoolean(MetadataAttributes.Measure_Folder, record.getMeasureFolder()));
        String mddsType = entity.getString(MetadataAttributes.Aggregator, record.getRegularAggregate().toMDDSType());
        record.setRegularAggregate(AggregateTypeEnum.valueOfMDDSString((String)mddsType));
        mddsType = entity.getString(MetadataAttributes.Timestate_Aggregator, record.getRegularAggregate().toMDDSType());
        record.setSemiAggregate(AggregateTypeEnum.valueOfMDDSString((String)mddsType));
        String dataType = entity.getString(MetadataAttributes.Data_Type, record.getDataType().getTypeName());
        int precision = entity.getInteger(MetadataAttributes.Precision, 0);
        int scale = entity.getInteger(MetadataAttributes.Scale, 0);
        record.setDataType(MetadataRecordFactory.convertDataType(dataType, precision, scale));
        record.setUniqueId(entity.getString(MetadataAttributes.PPDS_CODE, record.getName()));
        if (this.catalogName != null) {
            record.setCatalogName(this.catalogName);
        }
        record.setCubeName(this.cubeName);
        return record;
    }

    public MemberRecord createMemberRecord(MetadataResponseEntity entity) {
        String lun;
        String hun;
        MemberRecord record = new MemberRecord();
        String dun = entity.getString(MetadataAttributes.Dimension_Unique_Name, record.getDimensionUniqueName());
        if (dun != null) {
            record.setDimensionUniqueName(dun);
        }
        if ((hun = entity.getString(MetadataAttributes.Hierarchy_Unique_Name, record.getHierarchyUniqueName())) != null) {
            record.setHierarchyUniqueName(hun);
        }
        if ((lun = entity.getString(MetadataAttributes.Level_Unique_Name, record.getLevelUniqueName())) != null) {
            record.setLevelUniqueName(lun);
        }
        record.setUniqueName(entity.getString(MetadataAttributes.Member_Unique_Name, record.getUniqueName()));
        String memberName = entity.getString(MetadataAttributes.Member_Name, record.getName());
        if (memberName != null) {
            record.setName(memberName);
        }
        record.setCaption((ILocalizedString)entity.getCaption());
        record.setLevelNumber(entity.getInteger(MetadataAttributes.Level_Number, record.getLevelNumber()).intValue());
        record.setParentLevelNumber(entity.getInteger(MetadataAttributes.Parent_Level, record.getParentLevelNumber()).intValue());
        record.setParentUniqueName(entity.getString(MetadataAttributes.Parent_Unique_Name, record.getParentUniqueName()));
        record.setParentCount(entity.getInteger(MetadataAttributes.Number_Of_Parents, record.getParentCount()).intValue());
        record.setType(MemberTypeEnum.fromMDDSTypeString((String)entity.getString(MetadataAttributes.Type, record.getType().toMDDSType())));
        record.setDescription(entity.getString(MetadataAttributes.Description, record.getDescription()));
        record.setUniqueId(entity.getString(MetadataAttributes.PPDS_CODE, record.getName()));
        String ppdsKey = entity.getString(MetadataAttributes.PPDS_KEY, "");
        if (ppdsKey != null) {
            record.setDynamicFieldAsString(MetadataAttributes.PPDS_KEY.toString(), ppdsKey);
        }
        record.setRollupType(RollupTypeEnum.fromMDDSTypeString((String)entity.getString(MetadataAttributes._rollupType, record.getRollupType().toMDDSType())));
        if (this.catalogName != null) {
            record.setCatalogName(this.catalogName);
        }
        record.setCubeName(this.cubeName);
        return record;
    }

    public PropertyRecord createPropertyRecord(MetadataResponseEntity entity) {
        String hun;
        PropertyRecord record = new PropertyRecord();
        String dun = entity.getString(MetadataAttributes.Dimension_Unique_Name, record.getDimensionUniqueName());
        if (dun != null) {
            record.setDimensionUniqueName(dun);
        }
        if ((hun = entity.getString(MetadataAttributes.Hierarchy_Unique_Name, record.getHierarchyUniqueName())) != null) {
            record.setHierarchyUniqueName(hun);
        }
        record.setLevelUniqueName(entity.getString(MetadataAttributes.Level_Unique_Name, record.getLevelUniqueName()));
        record.setUniqueName(entity.getString(MetadataAttributes.Attribute_Unique_Name, record.getUniqueName()));
        String attributeName = entity.getString(MetadataAttributes.Attribute_Name, record.getName());
        if (attributeName != null) {
            record.setName(attributeName);
        }
        record.setCaption((ILocalizedString)entity.getCaption());
        String dataType = entity.getString(MetadataAttributes.Data_Type, record.getDataType().getTypeName());
        record.setDataType(MetadataRecordFactory.convertDataType(dataType));
        record.setDescription(entity.getString(MetadataAttributes.Description, record.getDescription()));
        String role = entity.getString(MetadataAttributes.Role, record.getRoleType().toV5Keyword());
        record.setRoleType(RoleTypeEnum.fromV5((String)role));
        if (this.catalogName != null) {
            record.setCatalogName(this.catalogName);
        }
        record.setCubeName(this.cubeName);
        return record;
    }

    static DateTimeValue convertTimestamp(String timestamp) {
        if (timestamp != null && !timestamp.equals("")) {
            String isoTimestamp = timestamp.replace("T", " ");
            TimestampValue value = DataValueFactory.createTimestampValue();
            value.set(isoTimestamp);
            return value;
        }
        return null;
    }

    static IDataType convertDataType(String mddsTypeString) {
        return MetadataRecordFactory.convertDataType(mddsTypeString, -1, -1);
    }

    static IDataType convertDataType(String mddsTypeString, int precision, int scale) {
        DateType xqeDataType = null;
        switch (MDDSConstants.MDDSTypes.valueOf(mddsTypeString)) {
            case Bigint: {
                xqeDataType = DataTypeFactory.getLongType((int)precision, (int)scale);
                break;
            }
            case Date: {
                xqeDataType = DataTypeFactory.getDateType();
                break;
            }
            case Datetime: {
                xqeDataType = DataTypeFactory.getTimestampType((int)precision);
                break;
            }
            case Float: {
                xqeDataType = DataTypeFactory.getDoubleType();
                break;
            }
            case Long: {
                xqeDataType = DataTypeFactory.getIntegerType((int)precision, (int)scale);
                break;
            }
            case String: {
                xqeDataType = DataTypeFactory.getStringType();
                break;
            }
            case Time: {
                xqeDataType = DataTypeFactory.getTimeType((int)precision);
                break;
            }
            default: {
                throw new MDDSException(MDDSMessageKeys.MET_INVALID_DATATYPE, mddsTypeString);
            }
        }
        return xqeDataType;
    }
}

