/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.data.providers.olap.mdds.metadata;

import com.cognos.xqe.data.providers.olap.mdds.MDDSMessageKeys;
import com.cognos.xqe.data.providers.olap.mdds.metadata.MetadataRecordFactory;
import com.cognos.xqe.data.providers.olap.mdds.metadata.MetadataResponseEntity;
import com.cognos.xqe.data.providers.olap.mdds.util.MDDSException;
import com.cognos.xqe.metadata.record.MetadataRecord;
import com.cognos.xqe.util.xml.serializer.DefaultProcessor;
import java.util.ArrayList;
import java.util.List;
import javax.xml.stream.XMLStreamWriter;

public class MetadataResponse {
    private List<MetadataRecord> records;
    private List<MetadataResponseEntity> entities = new ArrayList<MetadataResponseEntity>();
    private final MetadataRecordFactory factory;

    public MetadataResponse(MetadataRecordFactory aFactory) {
        this.factory = aFactory;
    }

    public void add(MetadataResponseEntity entity) {
        this.entities.add(entity);
        this.records = null;
    }

    public List<MetadataRecord> getRecords() {
        if (this.records == null) {
            this.records = new ArrayList<MetadataRecord>();
            for (MetadataResponseEntity entity : this.entities) {
                MetadataRecord record = this.factory.createRecord(entity);
                if (record == null) {
                    throw new MDDSException(MDDSMessageKeys.MET_INVALID_RESPONSE);
                }
                this.records.add(record);
            }
        }
        return this.records;
    }

    public void writeXML(XMLStreamWriter writer) throws Exception {
        if (writer != null) {
            DefaultProcessor proc = new DefaultProcessor();
            proc.serialize(this.getRecords(), writer);
        }
    }
}

