/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.data.providers.olap.mdds.metadata.cache;

import com.cognos.xqe.data.providers.olap.IRestrictions;
import com.cognos.xqe.data.providers.olap.RestrictionType;
import com.cognos.xqe.data.providers.olap.mdds.metadata.cache.LevelRecordKey;
import com.cognos.xqe.metadata.record.LevelRecord;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class ParentChildLevelsCache {
    private final Map<String, List<LevelRecord>> levelsInDimensions = new HashMap<String, List<LevelRecord>>();
    private final Map<String, List<LevelRecord>> levelsInHierarchies = new HashMap<String, List<LevelRecord>>();
    private final Map<LevelRecordKey, LevelRecord> allLevels = new HashMap<LevelRecordKey, LevelRecord>();

    public List<LevelRecord> getLevels(IRestrictions restrictions) {
        LinkedList<LevelRecord> levels = new LinkedList<LevelRecord>();
        String dun = (String)restrictions.getValueOf(RestrictionType.DIMENSION_UNIQUE_NAME);
        String hun = (String)restrictions.getValueOf(RestrictionType.HIERARCHY_UNIQUE_NAME);
        String lun = (String)restrictions.getValueOf(RestrictionType.LEVEL_UNIQUE_NAME);
        Integer ln = (Integer)restrictions.getValueOf(RestrictionType.LEVEL_NUMBER);
        if (lun != null || ln != null) {
            if (hun != null && dun != null) {
                LevelRecordKey key = null;
                key = ln != null ? new LevelRecordKey(dun, hun, ln) : new LevelRecordKey(dun, hun, lun);
                LevelRecord record = this.allLevels.get(key);
                if (record != null) {
                    levels.add(record);
                }
            }
        } else if (hun != null) {
            List<LevelRecord> set = this.levelsInHierarchies.get(hun);
            if (set != null) {
                levels.addAll(set);
            }
        } else if (dun != null) {
            List<LevelRecord> set = this.levelsInDimensions.get(dun);
            if (set != null) {
                levels.addAll((Collection<LevelRecord>)this.levelsInDimensions.get(dun));
            }
        } else {
            levels.addAll(this.allLevels.values());
        }
        return levels;
    }

    public List<LevelRecord> getLevelsForHierarchy(String hun) {
        return this.levelsInHierarchies.get(hun);
    }

    private void add(LevelRecord record) {
        int ln;
        String hun;
        String dun;
        LevelRecordKey key;
        if (record != null && !this.allLevels.containsKey(key = new LevelRecordKey(dun = record.getDimensionUniqueName(), hun = record.getHierarchyUniqueName(), ln = record.getLevelNumber()))) {
            this.allLevels.put(key, record);
        }
    }

    public void add(String dun, Map<String, List<LevelRecord>> records) {
        LinkedList<LevelRecord> allLvs = new LinkedList<LevelRecord>();
        for (String hun : records.keySet()) {
            List<LevelRecord> lvs = records.get(hun);
            this.levelsInHierarchies.put(hun, lvs);
            allLvs.addAll(lvs);
            for (LevelRecord lv : lvs) {
                this.add(lv);
            }
        }
        this.levelsInDimensions.put(dun, allLvs);
    }

    public void add(String hun, List<LevelRecord> records) {
        for (LevelRecord lr : records) {
            this.add(lr);
        }
        this.levelsInHierarchies.put(hun, records);
    }

    public boolean isHierarchyLoaded(String hun) {
        return this.levelsInHierarchies.containsKey(hun);
    }

    public boolean isDimensionLoaded(String dun) {
        return this.levelsInDimensions.containsKey(dun);
    }

    public int size() {
        return this.allLevels.size();
    }

    public boolean isEmpty() {
        return this.allLevels.isEmpty();
    }

    public void clear() {
        this.allLevels.clear();
        this.levelsInDimensions.clear();
        this.levelsInHierarchies.clear();
    }
}

