/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.data.providers.olap.mdds.metadata.parser;

import com.cognos.xqe.data.providers.olap.mdds.MDDSMessageKeys;
import com.cognos.xqe.data.providers.olap.mdds.metadata.MetadataRecordFactory;
import com.cognos.xqe.data.providers.olap.mdds.metadata.MetadataResponse;
import com.cognos.xqe.data.providers.olap.mdds.metadata.parser.MetadataAliasHandler;
import com.cognos.xqe.data.providers.olap.mdds.metadata.parser.MetadataEntityHandler;
import com.cognos.xqe.data.providers.olap.mdds.metadata.parser.MetadataResponseHandler;
import com.cognos.xqe.data.providers.olap.mdds.util.MDDSException;
import com.cognos.xqe.data.providers.olap.mdds.util.MDDSLogger;
import com.cognos.xqe.trace.LogLevel;
import com.cognos.xqe.util.pool.XQEXMLInputFactoryPool;
import com.cognos.xqe.util.xml.stax.DocumentHandler;
import com.cognos.xqe.util.xml.stax.IStaxComponentHandler;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ConcurrentModificationException;
import java.util.Locale;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;

public class MetadataResponseParser {
    static final String DEFAULT_NAMESPACE = "";
    static final QName RESPONSE = new QName("", "response");
    static final QName ENTITY = new QName("", "entity");
    static final QName ALIAS = new QName("", "alias");
    private final DocumentHandler docHandler = new DocumentHandler();
    private final MetadataResponseHandler rootHandler;
    private final MetadataEntityHandler entityHandler;
    private final MetadataAliasHandler aliasHandler;
    private AtomicBoolean isInUse = new AtomicBoolean(false);

    public MetadataResponseParser(Locale defaultLocale, MetadataRecordFactory aFactory) {
        this.rootHandler = new MetadataResponseHandler(aFactory);
        this.entityHandler = new MetadataEntityHandler(this.rootHandler);
        this.aliasHandler = new MetadataAliasHandler(this.entityHandler);
        this.rootHandler.registerSubHandler(ENTITY, this.entityHandler);
        this.docHandler.setRootHandler((IStaxComponentHandler)this.rootHandler);
        this.entityHandler.registerSubHandler(ALIAS, this.aliasHandler);
        this.entityHandler.setDefaultLocale(defaultLocale);
    }

    public MetadataResponse parse(InputStream istream) throws MDDSException {
        XMLStreamReader xmlReader = null;
        try {
            xmlReader = MetadataResponseParser.createXMLStreamReader(new BufferedInputStream(istream));
            MetadataResponse metadataResponse = this.parse(xmlReader);
            return metadataResponse;
        }
        catch (Exception e) {
            MetadataResponseParser.handleUnexpectedFailure(e);
            throw new MDDSException(MDDSMessageKeys.MET_INVALID_RESPONSE, e);
        }
        finally {
            if (xmlReader != null) {
                try {
                    xmlReader.close();
                }
                catch (XMLStreamException e) {
                    MDDSLogger.getLogger("Metadata", LogLevel.WARN).log("Error closing XMLInputStream when reading MDDS metadata response.");
                }
            }
            if (istream != null) {
                try {
                    istream.close();
                }
                catch (IOException e) {
                    MDDSLogger.getLogger("Metadata", LogLevel.WARN).log("Error closing InputStream with MDDS metadata response.");
                }
            }
        }
    }

    private static void handleUnexpectedFailure(Throwable throwable) {
        MDDSLogger.getLogger("Metadata", LogLevel.ERROR).log(LogLevel.ERROR, "Unexpected MetadataResponseParser failure: ", throwable);
    }

    public MetadataResponse parse(XMLStreamReader reader) throws MDDSException {
        if (this.isInUse.compareAndSet(false, true)) {
            if (reader != null) {
                try {
                    this.docHandler.consume(reader);
                    return this.rootHandler.getMetadataResponse();
                }
                catch (XMLStreamException e) {
                    MetadataResponseParser.handleUnexpectedFailure(e);
                    throw new MDDSException(MDDSMessageKeys.MET_INVALID_RESPONSE, e);
                }
            }
        } else {
            ConcurrentModificationException e = new ConcurrentModificationException("MetadataResponseParser already in use");
            e.fillInStackTrace();
            MetadataResponseParser.handleUnexpectedFailure(e);
            throw e;
        }
        return null;
    }

    public void reset() {
        this.entityHandler.reset();
        this.isInUse.set(false);
    }

    public boolean isInUse() {
        return this.isInUse.get();
    }

    private static XMLStreamReader createXMLStreamReader(InputStream istream) throws Exception {
        XMLInputFactory inputFactory = null;
        XMLStreamReader result = null;
        try {
            inputFactory = XQEXMLInputFactoryPool.getInstance().borrowXMLInputFactory();
            result = inputFactory.createXMLStreamReader(istream, "UTF-8");
        }
        finally {
            if (null != inputFactory) {
                XQEXMLInputFactoryPool.getInstance().returnXMLInputFactory(inputFactory);
            }
        }
        return result;
    }
}

