/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.data.providers.olap.mdds.resultset;

import com.cognos.xqe.bibushandler.OperationCanceledException;
import com.cognos.xqe.data.providers.ProviderIteratorBase;
import com.cognos.xqe.data.providers.ProviderResultSetBase;
import com.cognos.xqe.data.providers.olap.mdds.resultset.MDDSDimensionalResult;
import com.cognos.xqe.data.providers.olap.mdds.util.MDDSLogger;
import com.cognos.xqe.data.providers.qfwbridge.ColumnInfo;
import com.cognos.xqe.data.providers.qfwbridge.EdgeInfo;
import com.cognos.xqe.data.providers.qfwbridge.QFWException;
import com.cognos.xqe.data.providers.qfwbridge.QFWResultIterator;
import com.cognos.xqe.data.providers.qfwbridge.RowsetInfo;
import com.cognos.xqe.data.values.DataValueFactory;
import com.cognos.xqe.data.values.StringValue;
import com.cognos.xqe.data.values.Value;
import com.cognos.xqe.metadata.ICube;
import com.cognos.xqe.metadata.IDimension;
import com.cognos.xqe.metadata.IHierarchy;
import com.cognos.xqe.metadata.ILevel;
import com.cognos.xqe.metadata.IMember;
import com.cognos.xqe.metadata.MemberTypeEnum;
import com.cognos.xqe.metadata.RoleTypeEnum;
import com.cognos.xqe.metadata.provider.Member;
import com.cognos.xqe.resultsets.md.Tuple;
import com.cognos.xqe.runtree.XDataContext;
import com.cognos.xqe.trace.LogLevel;
import com.cognos.xqe.trace.XQELogger;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Stack;
import org.apache.commons.collections.map.LRUMap;

public class QFWEdgeIteratorAdaptor
extends ProviderIteratorBase {
    private static final int MEMBER_CAPTION_COLUMN_NUMBER = 1;
    private static final int LEVEL_UNIQUE_NAME_COLUMN_NUMBER = 2;
    private static final int LEVEL_INDEX_COLUMN_NUMBER = 3;
    private static final int PARENT_UNIQUE_NAME = 4;
    private static final int LEVEL_LABEL = 5;
    private static final int CURRENCY_CODE = 6;
    private static final int DIMENSION_UNIQUE_NAME_COLUMN_NUMBER = 7;
    private static final int HIERARCHY_UNIQUE_NAME_COLUMN_NUMBER = 8;
    private static final String NOMEMBER_UNIQUE_NAME = "NOMEMBER";
    private static final String MDDS_MEMBER_TYPE_CALCULATED = "CALCULATED";
    private static final int MAX_CACHED_MEMBERS = 10000;
    private QFWResultIterator edgeIterator;
    private Stack<Member> memberStack = new Stack();
    private Map<String, Member> memberCache = new LRUMap(10000);
    private Map<RowsetInfo, ILevel> rowsetInfoToLevelMap = new HashMap<RowsetInfo, ILevel>();
    private Map<Integer, RowsetInfo> rowsetIdToRowsetMap;
    private ICube cube = null;
    private Object[] qfwResultRow = null;
    private Map<String, ILevel> parentChildHierarchyLevelCache = new HashMap<String, ILevel>();
    private static XQELogger logger = MDDSLogger.getLogger("DataQuery.ResultSet", LogLevel.TRACE);

    QFWEdgeIteratorAdaptor(MDDSDimensionalResult resultSet, XDataContext context, EdgeInfo edgeInfo, QFWResultIterator theEdgeIterator, ICube theCube, Integer nodeId, int edgeO) {
        super((ProviderResultSetBase)resultSet, context, nodeId);
        super.setEdgeNumber(edgeO);
        this.edgeIterator = theEdgeIterator;
        this.cube = theCube;
        int numRowSets = edgeInfo.getNumRowsets();
        this.rowsetIdToRowsetMap = new HashMap<Integer, RowsetInfo>(numRowSets);
        for (int k = 0; k < numRowSets; ++k) {
            RowsetInfo rowsetInfo = edgeInfo.getRowsetInfo(k);
            this.rowsetIdToRowsetMap.put(rowsetInfo.getRowsetId(), rowsetInfo);
        }
    }

    public Object nextImpl() {
        try {
            int numColumns = this.edgeIterator.getNumberOfColumns();
            if (numColumns == 0) {
                return null;
            }
            if (this.qfwResultRow == null) {
                this.qfwResultRow = new Object[numColumns];
            }
            while (this.edgeIterator.next()) {
                int detailRowNumber;
                Member aMember;
                RowsetInfo rowsetInfo = this.rowsetIdToRowsetMap.get(this.edgeIterator.getRowsetId());
                if (null == rowsetInfo) {
                    return null;
                }
                if (this.qfwResultRow.length < rowsetInfo.getNumColumns()) {
                    this.qfwResultRow = new Object[rowsetInfo.getNumColumns()];
                }
                this.edgeIterator.getResultRow(this.qfwResultRow, this.edgeIterator.getRowsetId(), false);
                String memberUniqueName = (String)this.qfwResultRow[0];
                if (memberUniqueName == null) {
                    if (this.qfwResultRow[1] == null && this.qfwResultRow[2] == null && this.qfwResultRow[4] == null && this.qfwResultRow[5] == null && this.qfwResultRow[6] == null && this.qfwResultRow[3].toString().compareTo("0") == 0) {
                        memberUniqueName = this.qfwResultRow[8].toString() + ".[" + NOMEMBER_UNIQUE_NAME + "]";
                        this.qfwResultRow[0] = memberUniqueName;
                    } else {
                        return null;
                    }
                }
                if ((aMember = this.memberCache.get(memberUniqueName)) == null) {
                    aMember = this.createMember(rowsetInfo, this.qfwResultRow);
                    this.memberCache.put(memberUniqueName, aMember);
                }
                if ((detailRowNumber = this.edgeIterator.getDetailRowNumber()) == 0) {
                    this.popNecessaryMembers((IMember)aMember);
                    this.memberStack.push(aMember);
                    continue;
                }
                int stackSize = this.memberStack.size();
                IMember[] tupleMembers = new IMember[stackSize + 1];
                Tuple tupleToReturn = new Tuple(tupleMembers);
                for (int i = 0; i < stackSize; ++i) {
                    tupleMembers[i] = (IMember)this.memberStack.get(i);
                }
                tupleMembers[stackSize] = aMember;
                ++this.currentIndex;
                return tupleToReturn;
            }
            return null;
        }
        catch (QFWException e) {
            String msg = e.getLocalizedMessage();
            if (msg.indexOf("RSA-ERR-0007") > 0) {
                throw new OperationCanceledException();
            }
            throw e;
        }
    }

    private Member createMember(RowsetInfo rowsetInfo, Object[] row) {
        ILevel theLevel;
        Member aMember = new Member();
        int numColumns = rowsetInfo.getNumColumns();
        block9: for (int l = 0; l < numColumns; ++l) {
            ColumnInfo columnInfo = rowsetInfo.getColumnInfo(l);
            switch (columnInfo.getDatatype()) {
                case 25: {
                    aMember.setUniqueName((String)row[l]);
                    continue block9;
                }
                case 26: {
                    aMember.setCaption((String)row[l]);
                    aMember.setName((String)row[l]);
                    continue block9;
                }
                case 29: {
                    aMember.setDescription((String)row[l]);
                    continue block9;
                }
                case 28: {
                    aMember.setParentUniqueName((String)row[l]);
                    continue block9;
                }
                case 33: {
                    continue block9;
                }
                case 31: {
                    continue block9;
                }
                case 44: {
                    aMember.setChildrenCardinality(Integer.parseInt(row[l].toString()));
                    continue block9;
                }
                default: {
                    StringValue keyValue;
                    if (columnInfo.getName().equals(RoleTypeEnum.MEMBER_TYPE.toRsapiKeyword())) {
                        MemberTypeEnum type = MemberTypeEnum.REGULAR;
                        if (row[l] != null && row[l].toString().equals(MDDS_MEMBER_TYPE_CALCULATED)) {
                            type = MemberTypeEnum.CALCULATED;
                        }
                        aMember.setType(type);
                        continue block9;
                    }
                    if (row[l] != null && columnInfo.getName().equals("PPDS_KEY")) {
                        keyValue = QFWEdgeIteratorAdaptor.createStringValue((String)row[l]);
                        aMember.setBusinessKey((Value)keyValue);
                        aMember.setProperty("PPDS_KEY", (Object)keyValue);
                        continue block9;
                    }
                    if (row[l] != null && columnInfo.getName().equals("MEMBER_KEY")) {
                        keyValue = QFWEdgeIteratorAdaptor.createStringValue((String)row[l]);
                        aMember.setBusinessKey((Value)keyValue);
                        aMember.setProperty("MEMBER_KEY", (Object)keyValue);
                        continue block9;
                    }
                    if (row[l] != null && columnInfo.getName().equals(RoleTypeEnum.PARENT_LEVEL_NUMBER.toRsapiKeyword())) {
                        if (columnInfo.getDatatype() != 6) continue block9;
                        aMember.setParentLevelNumber(Integer.parseInt(row[l].toString()));
                        continue block9;
                    }
                    if (row[l] != null && columnInfo.getName().equals("description")) {
                        aMember.setDescription((String)row[l]);
                        continue block9;
                    }
                    aMember.setProperty(columnInfo.getName(), row[l]);
                }
            }
        }
        String levelUniqueName = (String)row[2];
        if (levelUniqueName == null) {
            String levelKey = (String)row[8] + (String)row[3];
            theLevel = this.parentChildHierarchyLevelCache.get(levelKey);
            if (theLevel == null) {
                theLevel = this.determineLevel(rowsetInfo, row);
                this.parentChildHierarchyLevelCache.put(levelKey, theLevel);
            }
        } else {
            theLevel = this.rowsetInfoToLevelMap.get(rowsetInfo);
            if (theLevel == null) {
                theLevel = this.determineLevel(rowsetInfo, row);
                this.rowsetInfoToLevelMap.put(rowsetInfo, theLevel);
            }
        }
        aMember.setLevel(theLevel);
        aMember.setConnection(this.cube.getConnection());
        aMember.setInitialised();
        return aMember;
    }

    private static StringValue createStringValue(String val) {
        StringValue keyValue = DataValueFactory.createStringValue();
        keyValue.set(val);
        return keyValue;
    }

    private void popNecessaryMembers(IMember newMember) {
        IMember aMember;
        if (this.memberStack.size() == 0) {
            return;
        }
        IHierarchy newMemberHierarchy = newMember.getLevel().getHierarchy();
        Iterator it = this.memberStack.iterator();
        boolean newMemberInStack = false;
        while (it.hasNext()) {
            aMember = (IMember)it.next();
            if (aMember.getLevel().getHierarchy() != newMemberHierarchy) continue;
            newMemberInStack = true;
            break;
        }
        if (!newMemberInStack) {
            return;
        }
        do {
            if ((aMember = (IMember)this.memberStack.pop()).getLevel().getHierarchy() != newMemberHierarchy) continue;
            return;
        } while (this.memberStack.size() != 0);
    }

    private ILevel determineLevel(RowsetInfo rowsetInfo, Object[] row) throws NumberFormatException {
        String dimensionUniqueName = (String)row[7];
        IDimension aDimension = this.cube.getDimension(dimensionUniqueName);
        IHierarchy aHierarchy = aDimension.getHierarchy((String)row[8]);
        String levelNumberStr = (String)row[3];
        int levelNumber = 0;
        if (levelNumberStr != null && levelNumberStr.length() > 0) {
            try {
                levelNumber = Integer.parseInt(levelNumberStr);
            }
            catch (NumberFormatException nfe) {
                levelNumber = 0;
            }
        }
        if (aHierarchy == null) {
            aHierarchy = aDimension.getDefaultHierarchy();
        }
        return aHierarchy.getLevel(levelNumber);
    }

    public void releaseImpl() {
        if (this.edgeIterator != null) {
            try {
                this.edgeIterator.release();
            }
            catch (Exception ex) {
                if (logger.isOn()) {
                    logger.log((Throwable)ex);
                }
            }
            finally {
                this.edgeIterator = null;
            }
        }
        if (this.memberCache != null) {
            this.memberCache.clear();
            this.memberCache = null;
        }
        if (this.memberStack != null) {
            this.memberStack.clear();
            this.memberStack = null;
        }
        if (this.rowsetIdToRowsetMap != null) {
            this.rowsetIdToRowsetMap.clear();
            this.rowsetIdToRowsetMap = null;
        }
        if (this.rowsetInfoToLevelMap != null) {
            this.rowsetInfoToLevelMap.clear();
            this.rowsetInfoToLevelMap = null;
        }
        this.qfwResultRow = null;
        this.cube = null;
        this.parentChildHierarchyLevelCache = null;
    }
}

