/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.data.providers.olap.mdds.util;

import com.cognos.xqe.data.model.IDataSource;
import com.cognos.xqe.data.model.IDataSourceConnection;
import com.cognos.xqe.data.providers.connection.parameters.DataSourceParameter;
import com.cognos.xqe.pool.connection.ConnectionParameters;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;

public final class MDDSUtils {
    public static final String XML_NAMESPACE_URI = "http://developer.cognos.com/schemas/qsapi/2/";
    public static final String XML_NAMESPACE_PREFIX = "qs";
    public static final String XML_COMMAND_ELEMENT = "command";
    private static final List<String> LANGUAGES = new LinkedList<String>();

    MDDSUtils() {
    }

    private static void init() {
        String[] languages;
        for (String lang : languages = Locale.getISOLanguages()) {
            LANGUAGES.add(lang);
        }
    }

    public static boolean isValidLanguageString(String language) {
        return LANGUAGES.contains(language);
    }

    public static void writeStartMDQuery(XMLStreamWriter writer) throws XMLStreamException {
        writer.writeStartDocument();
        writer.writeStartElement(XML_NAMESPACE_PREFIX, XML_COMMAND_ELEMENT, XML_NAMESPACE_URI);
        writer.writeNamespace(XML_NAMESPACE_PREFIX, XML_NAMESPACE_URI);
    }

    public static void writeEndMDQuery(XMLStreamWriter writer) throws XMLStreamException {
        writer.writeEndElement();
        writer.writeEndDocument();
    }

    public static String getNamespace(ConnectionParameters params) {
        IDataSourceConnection conn;
        IDataSource ds;
        String namespace = null;
        DataSourceParameter param = (DataSourceParameter)params.get(DataSourceParameter.class);
        if (param != null && (ds = param.getDataSource()) != null && (conn = ds.getDataSourceConnection()) != null) {
            namespace = conn.getNamespace();
        }
        return namespace;
    }

    static {
        MDDSUtils.init();
    }
}

