/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.data.providers.olap.odbo;

import com.cognos.xqe.data.olap.common.MSASTypeGroupEnum;
import com.cognos.xqe.data.providers.ProviderResultSetBase;
import com.cognos.xqe.data.providers.ProviderScrollableCellIteratorBase;
import com.cognos.xqe.data.providers.olap.odbo.ODBOCapabilities;
import com.cognos.xqe.data.providers.olap.odbo.ODBOCell;
import com.cognos.xqe.data.providers.olap.odbo.ODBOCellset;
import com.cognos.xqe.data.providers.olap.odbo.ODBOConfig;
import com.cognos.xqe.data.providers.olap.odbo.ODBOConnection;
import com.cognos.xqe.data.providers.olap.odbo.ODBOLog;
import com.cognos.xqe.data.providers.olap.odbo.ODBOLogEnum;
import com.cognos.xqe.data.providers.olap.odbo.ODBOMessageKeys;
import com.cognos.xqe.data.providers.olap.odbo.ODBOResultSet;
import com.cognos.xqe.data.providers.olap.odbo.ODBORuntimeException;
import com.cognos.xqe.data.providers.olap.odbo.concurrent.ODBOThreadContext;
import com.cognos.xqe.data.providers.secbridge.ErrorStatus;
import com.cognos.xqe.data.providers.secbridge.NativeException;
import com.cognos.xqe.data.values.IValue;
import com.cognos.xqe.data.values.Value;
import com.cognos.xqe.resultset.interfaces.ICell;
import com.cognos.xqe.runtree.XDataContext;
import com.cognos.xqe.trace.LogLevel;
import com.cognos.xqe.trace.TraceContext;
import com.cognos.xqe.trace.XQELogger;
import com.cognos.xqe.util.context.ContextTransfer;
import com.cognos.xqe.util.context.ExecutionEnvironmentContext;
import java.util.concurrent.Callable;

public class ODBOCellIterator
extends ProviderScrollableCellIteratorBase {
    private ODBOCell currentCell = null;
    private ODBOCellset iterator;
    private boolean hasNextCalled = false;
    private boolean mHasNext = false;
    private long nextOrdinal = 0L;
    private boolean includeCurrencyUnit = true;
    private String unknownCurr = "*";
    private int valueIndex = -1;
    private int formatStringIndex = -1;
    private int languageIndex = -1;
    private int cellOrdinalIndex = -1;
    private boolean returnNullCells = false;
    private boolean useTabularFormatter = true;
    protected ODBOConnection mODBOConnection;

    public ODBOCellIterator(ODBOResultSet resultSet, XDataContext xDataContext, ODBOCellset cellset, Integer theNodeId, ODBOConfig currConfig, ODBOConnection connection) {
        super((ProviderResultSetBase)resultSet, xDataContext, theNodeId);
        this.mODBOConnection = connection;
        ODBOCapabilities capabilities = this.mODBOConnection.getCapabilities();
        this.iterator = cellset;
        this.returnNullCells = currConfig.getReturnNULLCells();
        this.unknownCurr = currConfig.getUnknownCurrencySymbol();
        this.includeCurrencyUnit = capabilities.canSupportCurrencyUnits();
        this.useTabularFormatter = capabilities.canUseTabularFormtter();
        try {
            this.nativeInitialize();
        }
        catch (NativeException ex) {
            ErrorStatus status = ex.getErrorStatus();
            if (ODBOLog.isOn(ODBOLogEnum.LOG_PROVIDER_DATA_QUERY, LogLevel.ERROR)) {
                StringBuilder msgBuffer = new StringBuilder();
                msgBuffer.append("Error constructing a cell iterator: ").append(status);
                ODBOLog.getLogger(ODBOLogEnum.LOG_PROVIDER_DATA_QUERY).log(LogLevel.ERROR, msgBuffer.toString());
            }
            this.mODBOConnection.checkForLostConnection(status);
            throw new ODBORuntimeException(ODBOMessageKeys.GEN_GENERAL_PROVIDER_ERROR, ex);
        }
        if (ODBOLog.isOn(ODBOLogEnum.LOG_PROVIDER_DATA_QUERY)) {
            ODBOLog.getLogger(ODBOLogEnum.LOG_PROVIDER_DATA_QUERY).log("Constructing cell iterator.");
        }
    }

    private Boolean initializeCellIterator() {
        int columnCount = this.iterator.getColumnCount();
        if (columnCount > 0) {
            this.initializeColumnIndices();
            this.hasNext();
        } else {
            this.mHasNext = false;
        }
        return this.mHasNext;
    }

    private boolean nativeInitialize() throws NativeException {
        if (!ODBOThreadContext.isODBOThread()) {
            final ContextTransfer traceCtxTransfer = TraceContext.createTransfer();
            final ContextTransfer execEnvTransfer = ExecutionEnvironmentContext.createTransfer();
            Callable<Boolean> task = new Callable<Boolean>(){

                @Override
                public Boolean call() throws NativeException {
                    traceCtxTransfer.push();
                    execEnvTransfer.push();
                    try {
                        Boolean bl = ODBOCellIterator.this.initializeCellIterator();
                        return bl;
                    }
                    finally {
                        execEnvTransfer.pop();
                        traceCtxTransfer.pop();
                    }
                }
            };
            return this.mODBOConnection.invokeNativeCall(task);
        }
        return this.initializeCellIterator();
    }

    private void initializeColumnIndices() {
        for (int idx = 0; idx < this.iterator.getColumnCount(); ++idx) {
            String colName = this.iterator.getColumnName(idx);
            if (colName.equals("VALUE")) {
                this.valueIndex = idx;
                continue;
            }
            if (colName.equals("FORMAT_STRING")) {
                this.formatStringIndex = idx;
                continue;
            }
            if (colName.equals("LANGUAGE")) {
                this.languageIndex = idx;
                continue;
            }
            if (!colName.equals("CELL_ORDINAL")) continue;
            this.cellOrdinalIndex = idx;
        }
    }

    public boolean internalHasNext() {
        if (!this.hasNextCalled) {
            if (this.returnNullCells) {
                this.mHasNext = this.iterator.getCellData((int)this.nextOrdinal);
            } else {
                this.findNextNonEmptyCell();
            }
            this.hasNextCalled = true;
        }
        return this.mHasNext;
    }

    public boolean hasNext() {
        try {
            return this.nativeHasNext();
        }
        catch (NativeException ex) {
            ErrorStatus status = ex.getErrorStatus();
            if (ODBOLog.isOn(ODBOLogEnum.LOG_PROVIDER_DATA_QUERY, LogLevel.ERROR)) {
                StringBuilder msgBuffer = new StringBuilder();
                msgBuffer.append("Error determining next cell: ").append(status);
                ODBOLog.getLogger(ODBOLogEnum.LOG_PROVIDER_DATA_QUERY).log(LogLevel.ERROR, msgBuffer.toString());
            }
            this.mODBOConnection.checkForLostConnection(status);
            throw new ODBORuntimeException(ODBOMessageKeys.GEN_GENERAL_PROVIDER_ERROR, ex);
        }
    }

    private boolean nativeHasNext() throws NativeException {
        if (!ODBOThreadContext.isODBOThread()) {
            final ContextTransfer traceCtxTransfer = TraceContext.createTransfer();
            final ContextTransfer execEnvTransfer = ExecutionEnvironmentContext.createTransfer();
            Callable<Boolean> task = new Callable<Boolean>(){

                @Override
                public Boolean call() throws NativeException {
                    traceCtxTransfer.push();
                    execEnvTransfer.push();
                    try {
                        Boolean bl = ODBOCellIterator.this.internalHasNext();
                        return bl;
                    }
                    finally {
                        execEnvTransfer.pop();
                        traceCtxTransfer.pop();
                    }
                }
            };
            return this.mODBOConnection.invokeNativeCall(task);
        }
        return this.internalHasNext();
    }

    private void findNextNonEmptyCell() {
        if (this.iterator.getColumnCount() > 0) {
            while (this.iterator.getCellData((int)this.nextOrdinal)) {
                Value currValue = this.iterator.getColumnValue(this.valueIndex, false);
                if (currValue == null || currValue.isNull()) {
                    ++this.nextOrdinal;
                    continue;
                }
                this.mHasNext = true;
                return;
            }
            this.mHasNext = false;
        }
    }

    private ICell nativeNextImpl() throws NativeException {
        if (!ODBOThreadContext.isODBOThread()) {
            final ContextTransfer traceCtxTransfer = TraceContext.createTransfer();
            final ContextTransfer execEnvTransfer = ExecutionEnvironmentContext.createTransfer();
            Callable<ICell> task = new Callable<ICell>(){

                @Override
                public ICell call() throws NativeException {
                    traceCtxTransfer.push();
                    execEnvTransfer.push();
                    try {
                        ICell iCell = ODBOCellIterator.this.internalNextImpl();
                        return iCell;
                    }
                    finally {
                        execEnvTransfer.pop();
                        traceCtxTransfer.pop();
                    }
                }
            };
            return this.mODBOConnection.invokeNativeCall(task);
        }
        return this.internalNextImpl();
    }

    public ICell nextImpl() {
        try {
            return this.nativeNextImpl();
        }
        catch (NativeException ex) {
            ErrorStatus status = ex.getErrorStatus();
            if (ODBOLog.isOn(ODBOLogEnum.LOG_PROVIDER_DATA_QUERY, LogLevel.ERROR)) {
                StringBuilder msgBuffer = new StringBuilder();
                msgBuffer.append("Error retrieving nextImpl: ").append(status);
                ODBOLog.getLogger(ODBOLogEnum.LOG_PROVIDER_DATA_QUERY).log(LogLevel.ERROR, msgBuffer.toString());
            }
            this.mODBOConnection.checkForLostConnection(status);
            throw new ODBORuntimeException(ODBOMessageKeys.GEN_GENERAL_PROVIDER_ERROR, ex);
        }
    }

    private ICell internalNextImpl() {
        ODBOCell c = null;
        XQELogger logger = ODBOLog.getLogger(ODBOLogEnum.LOG_PROVIDER_DATA_QUERY);
        boolean isLoggerOn = logger.isOn();
        if (isLoggerOn) {
            logger.log("NextImpl called on cell iterator.");
        }
        if (!this.hasNextCalled) {
            this.hasNext();
        }
        if (this.mHasNext) {
            c = this.retrieveCell(this.nextOrdinal);
            this.currentOrdinal = this.nextOrdinal++;
            this.hasNextCalled = false;
            if (c != null && c.getValue() != null) {
                this.currentCell = c;
                if (isLoggerOn) {
                    logger.log("Retrieved  cell value: " + this.currentCell.getValue().toString() + ", format:  " + this.currentCell.getFormatString());
                }
            } else if (isLoggerOn) {
                logger.log("Retrieved null cell value. ");
            }
        }
        return c;
    }

    private ODBOCell retrieveCell(long ord) {
        ODBOCell cell = null;
        Value cellValue = null;
        if (this.valueIndex != -1) {
            cellValue = this.iterator.getColumnValue(this.valueIndex, true);
        }
        if (cellValue != null && (this.returnNullCells || !this.returnNullCells && !cellValue.isNull())) {
            Long langLong;
            cell = new ODBOCell(this.getFormatLocale(), this.useTabularFormatter);
            String formatStringValue = null;
            if (this.formatStringIndex != -1) {
                int formatColStatus = this.iterator.getColumnStatus(this.formatStringIndex);
                if (ODBOLog.getLogger(ODBOLogEnum.LOG_PROVIDER_DATA_QUERY).isOn()) {
                    formatStringValue = this.iterator.getStringColumnWithStatus(this.formatStringIndex, true, formatColStatus);
                    ODBOLog.getLogger(ODBOLogEnum.LOG_PROVIDER_DATA_QUERY).log("Format_string status: " + formatColStatus + ", value=<" + formatStringValue + ">");
                } else {
                    formatStringValue = this.iterator.getStringColumn(this.formatStringIndex, true);
                }
            }
            int languageValue = -1;
            if (this.languageIndex != -1 && (langLong = this.iterator.getLongColumn(this.languageIndex)) != null) {
                languageValue = langLong.intValue();
            }
            int columnCount = this.iterator.getColumnCount();
            for (int i = 0; i < columnCount; ++i) {
                if (i == this.valueIndex) {
                    cell.setValue((IValue)cellValue);
                    continue;
                }
                if (i == this.formatStringIndex) {
                    cell.setFormatString(formatStringValue);
                    continue;
                }
                if (i == this.languageIndex) {
                    cell.setLanguage(languageValue);
                    continue;
                }
                if (i == this.cellOrdinalIndex) {
                    cell.setOrdinal(ord);
                    continue;
                }
                cell.setCellProperty(this.iterator.getColumnName(i), this.iterator.getColumnValue(i, true));
            }
            if (this.formatStringIndex != -1) {
                MSASTypeGroupEnum typeGroup = this.iterator.getColumnTypeGroup(this.valueIndex);
                cell.convertFormat(typeGroup, this.includeCurrencyUnit, this.unknownCurr);
            }
        }
        return cell;
    }

    public boolean absolute(long index) {
        try {
            return this.nativeAbsolute(index);
        }
        catch (NativeException ex) {
            ErrorStatus status = ex.getErrorStatus();
            if (ODBOLog.isOn(ODBOLogEnum.LOG_PROVIDER_DATA_QUERY, LogLevel.ERROR)) {
                StringBuilder msgBuffer = new StringBuilder();
                msgBuffer.append("Error moving to cell: ").append(status);
                ODBOLog.getLogger(ODBOLogEnum.LOG_PROVIDER_DATA_QUERY).log(LogLevel.ERROR, msgBuffer.toString());
            }
            this.mODBOConnection.checkForLostConnection(status);
            throw new ODBORuntimeException(ODBOMessageKeys.GEN_GENERAL_PROVIDER_ERROR, ex);
        }
    }

    private boolean nativeAbsolute(final long index) throws NativeException {
        if (!ODBOThreadContext.isODBOThread()) {
            final ContextTransfer traceCtxTransfer = TraceContext.createTransfer();
            final ContextTransfer execEnvTransfer = ExecutionEnvironmentContext.createTransfer();
            Callable<Boolean> task = new Callable<Boolean>(){

                @Override
                public Boolean call() throws NativeException {
                    traceCtxTransfer.push();
                    execEnvTransfer.push();
                    try {
                        Boolean bl = ODBOCellIterator.this.internalAbsolute(index);
                        return bl;
                    }
                    finally {
                        execEnvTransfer.pop();
                        traceCtxTransfer.pop();
                    }
                }
            };
            return this.mODBOConnection.invokeNativeCall(task);
        }
        return this.internalAbsolute(index);
    }

    private boolean internalAbsolute(long index) {
        ODBOCell cell;
        if (index == this.currentOrdinal) {
            return true;
        }
        boolean found = this.iterator.getCellData((int)index);
        if (!found) {
            return false;
        }
        this.currentCell = cell = this.retrieveCell(index);
        this.currentOrdinal = index;
        this.nextOrdinal = this.currentOrdinal + 1L;
        this.hasNextCalled = false;
        return true;
    }

    public boolean reset() {
        return this.absolute(0L);
    }

    public ICell previous() {
        throw new UnsupportedOperationException();
    }

    public boolean hasPrevious() {
        throw new UnsupportedOperationException();
    }

    public ICell current() {
        return this.currentCell;
    }

    public void releaseImpl() {
        block4: {
            try {
                if (ODBOLog.isOn(ODBOLogEnum.LOG_PROVIDER_DATA_QUERY)) {
                    ODBOLog.getLogger(ODBOLogEnum.LOG_PROVIDER_DATA_QUERY).log("Release called on CellIterator.");
                }
                if (null != this.iterator) {
                    this.iterator.close();
                    this.iterator = null;
                }
                this.mODBOConnection = null;
                this.currentCell = null;
            }
            catch (Exception e) {
                if (!ODBOLog.isOn(LogLevel.ERROR)) break block4;
                ODBOLog.getLogger().log(LogLevel.ERROR, (Throwable)e);
            }
        }
    }
}

