/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.data.providers.olap.odbo;

import com.cognos.xqe.data.providers.olap.odbo.ODBOConnection;
import com.cognos.xqe.data.providers.olap.odbo.ODBOLog;
import com.cognos.xqe.data.providers.olap.odbo.ODBOLogEnum;
import com.cognos.xqe.data.providers.olap.odbo.ODBOMessageKeys;
import com.cognos.xqe.data.providers.olap.odbo.ODBORowset;
import com.cognos.xqe.data.providers.olap.odbo.ODBORuntimeException;
import com.cognos.xqe.data.providers.secbridge.ErrorStatus;
import com.cognos.xqe.data.providers.secbridge.NativeException;
import com.cognos.xqe.data.values.DataValueFactory;
import com.cognos.xqe.data.values.DoubleValue;
import com.cognos.xqe.data.values.Value;
import com.cognos.xqe.data.values.ValueState;
import com.cognos.xqe.trace.LogLevel;

public class ODBOCellset
extends ODBORowset {
    private int currentRowOrdinal = 0;

    private static native boolean cGetCellData(long var0, int var2) throws NativeException;

    public ODBOCellset(ODBOConnection connection, long handle) {
        super(connection, handle);
    }

    public boolean getCellData(int ordinal) {
        this.currentRowOrdinal = ordinal;
        try {
            return ODBOCellset.cGetCellData(this.mRowsetHandle, ordinal);
        }
        catch (NativeException ex) {
            ErrorStatus status = ex.getErrorStatus();
            if (ODBOLog.isOn(ODBOLogEnum.LOG_PROVIDER_DATA_QUERY_RESULTSET, LogLevel.ERROR)) {
                ODBOLog.getLogger(ODBOLogEnum.LOG_PROVIDER_DATA_QUERY_RESULTSET).log(LogLevel.ERROR, "An error occurred while fetching data for cell " + ordinal + ": " + status);
            }
            this.mODBOConnection.checkForLostConnection(status);
            throw new ODBORuntimeException(ODBOMessageKeys.DAT_PROVIDER_ERROR_FETCHING_CELL, Integer.toString(ordinal), ex);
        }
    }

    @Override
    public boolean getNextRow() {
        ++this.currentRowOrdinal;
        return this.getCellData(this.currentRowOrdinal);
    }

    @Override
    public Value getColumnValue(int index, boolean cannotBeTruncated) {
        Value result = super.getColumnValue(index, cannotBeTruncated);
        if (this.getColumnName(index).equals("VALUE")) {
            if (result != null) {
                if (result instanceof DoubleValue) {
                    DoubleValue dblValue = (DoubleValue)result;
                    if (Double.isNaN(dblValue.getDouble())) {
                        dblValue.setState(ValueState.ERROR);
                        result = dblValue;
                    }
                    if (Double.isInfinite(dblValue.getDouble())) {
                        dblValue.setState(ValueState.DIV_BY_ZERO);
                        result = dblValue;
                    }
                }
            } else {
                int status = this.getColumnStatus(index);
                if (status != 0 && status != 4 && status != 3) {
                    DoubleValue doubleValue = DataValueFactory.createDoubleValue();
                    doubleValue.setState(ValueState.ERROR);
                    result = doubleValue;
                }
            }
        }
        return result;
    }
}

