/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.data.providers.olap.odbo;

import com.cognos.xqe.bibushandler.ICancelable;
import com.cognos.xqe.bibushandler.OperationCanceledException;
import com.cognos.xqe.data.model.IDataSource;
import com.cognos.xqe.data.model.IDataSourceCapabilities;
import com.cognos.xqe.data.model.IDataSourceConnection;
import com.cognos.xqe.data.model.LogonFailureException;
import com.cognos.xqe.data.providers.connection.parameters.CAMCryptoHandleParameter;
import com.cognos.xqe.data.providers.connection.parameters.CatalogParameter;
import com.cognos.xqe.data.providers.connection.parameters.CatalogQueryHintParameter;
import com.cognos.xqe.data.providers.connection.parameters.ConnectionTestHintParameter;
import com.cognos.xqe.data.providers.connection.parameters.DataSourceParameter;
import com.cognos.xqe.data.providers.connection.parameters.PasswordParameter;
import com.cognos.xqe.data.providers.connection.parameters.ProviderTypeParameter;
import com.cognos.xqe.data.providers.connection.parameters.ServerParameter;
import com.cognos.xqe.data.providers.connection.parameters.UpperCaseCatalogParameter;
import com.cognos.xqe.data.providers.connection.parameters.UserIDParameter;
import com.cognos.xqe.data.providers.olap.DefaultConnection;
import com.cognos.xqe.data.providers.olap.IOLAPDataProvider;
import com.cognos.xqe.data.providers.olap.MDXQueryArguments;
import com.cognos.xqe.data.providers.olap.odbo.DataSourceLocaleParameter;
import com.cognos.xqe.data.providers.olap.odbo.IsTrustedParameter;
import com.cognos.xqe.data.providers.olap.odbo.ODBOCancelHandler;
import com.cognos.xqe.data.providers.olap.odbo.ODBOCapabilities;
import com.cognos.xqe.data.providers.olap.odbo.ODBOConfig;
import com.cognos.xqe.data.providers.olap.odbo.ODBOConfigManager;
import com.cognos.xqe.data.providers.olap.odbo.ODBODataProvider;
import com.cognos.xqe.data.providers.olap.odbo.ODBOLog;
import com.cognos.xqe.data.providers.olap.odbo.ODBOLogEnum;
import com.cognos.xqe.data.providers.olap.odbo.ODBOMessageKeys;
import com.cognos.xqe.data.providers.olap.odbo.ODBOResultSet;
import com.cognos.xqe.data.providers.olap.odbo.ODBORuntimeException;
import com.cognos.xqe.data.providers.olap.odbo.ProviderNameParameter;
import com.cognos.xqe.data.providers.olap.odbo.concurrent.ODBOThreadContext;
import com.cognos.xqe.data.providers.secbridge.ErrorStatus;
import com.cognos.xqe.data.providers.secbridge.IImpersonator;
import com.cognos.xqe.data.providers.secbridge.ImpersonatorFactory;
import com.cognos.xqe.data.providers.secbridge.NativeException;
import com.cognos.xqe.data.providers.secbridge.WinImpersonate;
import com.cognos.xqe.exception.XQEMessage;
import com.cognos.xqe.metadata.ICube;
import com.cognos.xqe.pool.connection.ConnectionParameters;
import com.cognos.xqe.query.engine.ExecutionEnvironment;
import com.cognos.xqe.runtree.XDataContext;
import com.cognos.xqe.trace.LogLevel;
import com.cognos.xqe.trace.TraceContext;
import com.cognos.xqe.util.IReleasable;
import com.cognos.xqe.util.context.ContextTransfer;
import com.cognos.xqe.util.context.ExecutionEnvironmentContext;
import com.cognos.xqe.util.resource.ReleasableResourceTracker;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;

public class ODBOConnection
extends DefaultConnection {
    private static final String MSAS_CONNECT_ERROR = "Exception caught during new MSAS connect: ";
    private static final String MSAS_DISCONNECT_ERROR = "Exception caught during new MSAS disconnect: ";
    private static final String ERROR_RETURNED_FROM = "Error returned from ";
    private static final String COLON_SPACE = ": ";
    private static final String LINE_SEPARATOR = "line.separator";
    private boolean connected;
    private long mConnectionHandle = 0L;
    private int runLocale = 0;
    private final ODBOCapabilities capabilities = new ODBOCapabilities();
    private ExecutorService comExecutorService;
    private final ReleasableResourceTracker variantArrayTracker = new ReleasableResourceTracker();

    public ODBOConnection(ODBODataProvider theDataProvider, ExecutorService theComExecutorService) {
        super((IOLAPDataProvider)theDataProvider);
        this.comExecutorService = theComExecutorService;
        this.connected = false;
        theDataProvider.getResourceTracker().addNestedTracker(this.variantArrayTracker);
    }

    public ExecutorService getCOMExecutorService() {
        return this.comExecutorService;
    }

    public ODBOCapabilities getCapabilities() {
        return this.capabilities;
    }

    public void connect(ConnectionParameters connectionParameters) {
        String providerType = (String)connectionParameters.valueOf(ProviderTypeParameter.class, String.class);
        String providerName = (String)connectionParameters.valueOf(ProviderNameParameter.class, String.class);
        ODBOConfig currConfig = ODBOConfigManager.getConfig(providerType);
        IDataSource dataSource = (IDataSource)connectionParameters.valueOf(DataSourceParameter.class, IDataSource.class);
        boolean testConnection = connectionParameters.booleanValueOf(ConnectionTestHintParameter.class, false);
        boolean catalogQuery = connectionParameters.booleanValueOf(CatalogQueryHintParameter.class, false);
        if (null == providerName || providerName.length() == 0) {
            throw new IllegalArgumentException("providerName");
        }
        try {
            IDataSourceCapabilities dataSourceCapabilities = dataSource.getCapabilities();
            this.getCapabilities().initializeFrom(dataSourceCapabilities);
        }
        catch (RuntimeException ex) {
            String providerFullName = this.getProviderDisplayName(providerType);
            throw new ODBORuntimeException(ODBOMessageKeys.CON_ERROR_LOADING_CAPABILITIES, providerFullName, ex);
        }
        this.mConnectionHandle = 0L;
        this.setConnectionParameters(connectionParameters);
        providerName = this.getProviderName(currConfig, providerName);
        if (ODBOLog.isOn(ODBOLogEnum.LOG_CONNECTION)) {
            StringBuilder msgBuffer = new StringBuilder();
            msgBuffer.append("Attempting MSAS new connection to provider ").append(providerName);
            msgBuffer.append(" with connection parameters ").append(connectionParameters.toString());
            ODBOLog.getLogger(ODBOLogEnum.LOG_CONNECTION).log(msgBuffer.toString());
        }
        try {
            String sCatalogName;
            this.nativeSetupConnectionProperties(connectionParameters, providerName, currConfig);
            String userName = (String)connectionParameters.valueOf(UserIDParameter.class, String.class);
            String password = (String)connectionParameters.valueOf(PasswordParameter.class, String.class);
            boolean isTrusted = connectionParameters.booleanValueOf(IsTrustedParameter.class, false);
            String ssoDelegationHandle = (String)connectionParameters.valueOf(CAMCryptoHandleParameter.class, String.class);
            if (!isTrusted && null == ssoDelegationHandle) {
                if (null == userName || userName.length() == 0) {
                    throw new LogonFailureException(LogonFailureException.SubCodeEnum.INVALID_CREDENTIALS);
                }
                if (null == password || password.length() == 0) {
                    throw new LogonFailureException(LogonFailureException.SubCodeEnum.INVALID_CREDENTIALS);
                }
            }
            if (this.getCapabilities().canSupportUserImpersonate()) {
                this.nativeSetAuthentication(this.mConnectionHandle, isTrusted, ssoDelegationHandle, userName, password, false);
            } else {
                this.nativeSetAuthentication(this.mConnectionHandle, isTrusted, ssoDelegationHandle, userName, password, true);
            }
            this.nativeUpdateConnectionProperties(this.mConnectionHandle);
            this.updateConnectionTime();
            if (isTrusted) {
                if (!this.getCapabilities().canSupportTrustedConnections()) {
                    throw new ODBORuntimeException(ODBOMessageKeys.CON_TRUSTED_NOT_SUPPORTED);
                }
                this.assertNotSystemService();
                this.nativeInitializeConnection(this.mConnectionHandle);
                this.nativeCreateSource(this.mConnectionHandle);
                this.nativeCreateSession(this.mConnectionHandle);
            } else if (null != ssoDelegationHandle) {
                if (!this.getCapabilities().canSupportCAMAuthentication()) {
                    throw new ODBORuntimeException(ODBOMessageKeys.CON_CAMAUTH_NOT_SUPPORTED);
                }
                Callable<Object> initializeTask = new Callable<Object>(){

                    @Override
                    public Object call() throws Exception {
                        ODBOConnection.cInitializeConnection(ODBOConnection.this.mConnectionHandle);
                        return null;
                    }
                };
                this.invokeNativeCallWithCAMImpersonation(initializeTask, ssoDelegationHandle, this.runLocale);
                this.nativeCreateSource(this.mConnectionHandle);
                this.nativeCreateSession(this.mConnectionHandle);
            } else if (this.getCapabilities().canSupportUserImpersonate()) {
                String domainName = "";
                String userId = userName;
                int slashPos = userName.indexOf(92);
                if (slashPos > 0) {
                    domainName = userName.substring(0, slashPos);
                    userId = userName.substring(slashPos + 1);
                }
                Callable<Object> initializeTask = new Callable<Object>(){

                    @Override
                    public Object call() throws Exception {
                        ODBOConnection.cInitializeConnection(ODBOConnection.this.mConnectionHandle);
                        return null;
                    }
                };
                this.invokeNativeCallWithWinImpersonation(initializeTask, domainName, userId, password, this.runLocale);
                this.nativeCreateSource(this.mConnectionHandle);
                this.nativeCreateSession(this.mConnectionHandle);
            } else {
                this.nativeInitializeConnection(this.mConnectionHandle);
                this.nativeCreateSource(this.mConnectionHandle);
                this.nativeCreateSession(this.mConnectionHandle);
            }
            this.updateConnectionTime();
            String sServerName = (String)connectionParameters.valueOf(ServerParameter.class, String.class);
            if (!this.getCapabilities().canSkipValidateVersion()) {
                this.validateProviderType(sServerName, providerType);
                this.validateVersions(currConfig, sServerName);
            }
            if (null != (sCatalogName = this.getCapabilities().canSupportCaseInsensitiveCatalog() ? (String)connectionParameters.valueOf(UpperCaseCatalogParameter.class, String.class) : (String)connectionParameters.valueOf(CatalogParameter.class, String.class))) {
                this.nativeOpenCatalog(this.mConnectionHandle, sCatalogName);
            } else if (!testConnection && !catalogQuery) {
                throw new ODBORuntimeException(ODBOMessageKeys.CON_ERROR_CATALOG_NAME_MISSING);
            }
        }
        catch (NativeException ex) {
            block40: {
                ErrorStatus status = ex.getErrorStatus();
                if (ODBOLog.isOn(ODBOLogEnum.LOG_CONNECTION, LogLevel.ERROR)) {
                    ODBOLog.getLogger(ODBOLogEnum.LOG_CONNECTION).log(LogLevel.ERROR, MSAS_CONNECT_ERROR + status);
                }
                if (0L != this.mConnectionHandle) {
                    try {
                        this.disconnect();
                    }
                    catch (Throwable ex2) {
                        if (!ODBOLog.isOn(ODBOLogEnum.LOG_CONNECTION, LogLevel.ERROR)) break block40;
                        ODBOLog.getLogger(ODBOLogEnum.LOG_CONNECTION).log(LogLevel.ERROR, MSAS_DISCONNECT_ERROR, ex2);
                    }
                }
            }
            String providerFullName = this.getProviderDisplayName(providerType);
            throw new ODBORuntimeException(ODBOMessageKeys.CON_CONNECT_FAILURE, (Object)providerFullName, connectionParameters.valueOf(ServerParameter.class, String.class), ex.getErrorStatus().getMessage());
        }
        catch (LogonFailureException ex) {
            block41: {
                if (ODBOLog.isOn(ODBOLogEnum.LOG_CONNECTION, LogLevel.ERROR)) {
                    ODBOLog.getLogger(ODBOLogEnum.LOG_CONNECTION).log(LogLevel.ERROR, MSAS_CONNECT_ERROR, (Throwable)ex);
                }
                if (ex.getDataSource() == null) {
                    ex.setDataSource(dataSource);
                }
                IDataSourceConnection connection = dataSource.getDataSourceConnection();
                connection.invalidateResolvedSignon();
                if (0L != this.mConnectionHandle) {
                    try {
                        this.disconnect();
                    }
                    catch (Throwable ex2) {
                        if (!ODBOLog.isOn(ODBOLogEnum.LOG_CONNECTION, LogLevel.ERROR)) break block41;
                        ODBOLog.getLogger(ODBOLogEnum.LOG_CONNECTION).log(LogLevel.ERROR, MSAS_DISCONNECT_ERROR, ex2);
                    }
                }
            }
            throw ex;
        }
        catch (Throwable ex) {
            block42: {
                if (ODBOLog.isOn(ODBOLogEnum.LOG_CONNECTION, LogLevel.ERROR)) {
                    ODBOLog.getLogger(ODBOLogEnum.LOG_CONNECTION).log(LogLevel.ERROR, MSAS_CONNECT_ERROR, ex);
                }
                if (0L != this.mConnectionHandle) {
                    try {
                        this.disconnect();
                    }
                    catch (Throwable ex2) {
                        if (!ODBOLog.isOn(ODBOLogEnum.LOG_CONNECTION, LogLevel.ERROR)) break block42;
                        ODBOLog.getLogger(ODBOLogEnum.LOG_CONNECTION).log(LogLevel.ERROR, MSAS_DISCONNECT_ERROR, ex2);
                    }
                }
            }
            String providerFullName = this.getProviderDisplayName(providerType);
            throw new ODBORuntimeException(ODBOMessageKeys.CON_CONNECT_FAILURE, (Object)providerFullName, connectionParameters.valueOf(ServerParameter.class, String.class), (Object)ex);
        }
        if (ODBOLog.isOn(ODBOLogEnum.LOG_CONNECTION)) {
            ODBOLog.getLogger(ODBOLogEnum.LOG_CONNECTION).log("MSAS connection successful, handle " + this.mConnectionHandle);
        }
        this.connected = true;
    }

    private boolean validateProviderType(String serverName, String providerType) {
        String serverVer = this.getServerVersion();
        String server = serverVer.contains("ANALYSIS SERVER 10.0.") ? "Microsoft Analysis Services 2008" : (serverVer.contains("ANALYSIS SERVER 10.50.") ? "Microsoft Analysis Services 2008 R2" : (serverVer.contains("ANALYSIS SERVER 9.00.") ? "Microsoft Analysis Services 2005" : (serverVer.contains("ANALYSIS SERVER 11.0.") ? "Microsoft Analysis Services 2012" : (serverVer.contains("ANALYSIS SERVER 12.0.") ? "Microsoft Analysis Services 2014" : (serverVer.contains("ANALYSIS SERVER 13.0.") ? "Microsoft Analysis Services 2016" : (serverVer.contains("ANALYSIS SERVER 14.0.") ? "Microsoft Analysis Services 2017" : (serverVer.contains("ANALYSIS SERVER 15.") ? "Microsoft Azure Analysis Services" : "Microsoft Analysis Services Unknown Server")))))));
        String typeName = "";
        boolean valid = true;
        if (providerType.equals("YK")) {
            typeName = "Microsoft Analysis Services 2005";
            if (!server.equals("Microsoft Analysis Services 2005")) {
                valid = false;
            }
        } else if (providerType.equals("M8")) {
            typeName = "Microsoft Analysis Services 2008";
            if (!server.equals("Microsoft Analysis Services 2008") && !server.equals("Microsoft Analysis Services 2008 R2")) {
                valid = false;
            }
        } else if (providerType.equals("M12")) {
            typeName = "Microsoft Analysis Services 2012";
            if (!server.equals("Microsoft Analysis Services 2012")) {
                valid = false;
            }
        } else if (providerType.equals("M14")) {
            typeName = "Microsoft Analysis Services 2014";
            if (!server.equals("Microsoft Analysis Services 2014")) {
                valid = false;
            }
        } else if (providerType.equals("M16")) {
            typeName = "Microsoft Analysis Services 2016";
            if (!server.equals("Microsoft Analysis Services 2016")) {
                valid = false;
            }
        } else if (providerType.equals("M17")) {
            typeName = "Microsoft Analysis Services 2017";
            if (!server.equals("Microsoft Analysis Services 2017")) {
                valid = false;
            }
        } else if (providerType.equals("M19")) {
            typeName = "Microsoft Analysis Services 2019";
            if (!server.equals("Microsoft Azure Analysis Services")) {
                valid = false;
            }
        } else if (providerType.equals("MAZ")) {
            typeName = "Microsoft Azure Analysis Services";
            if (!server.equals("Microsoft Azure Analysis Services")) {
                valid = false;
            }
        }
        if (!valid) {
            throw new ODBORuntimeException(ODBOMessageKeys.CON_TYPE_MISMATCH, (Object)typeName, (Object)serverName, server);
        }
        return valid;
    }

    private String getProviderDisplayName(String providerType) {
        String providerDisplayName = null;
        if ("YK".equals(providerType)) {
            providerDisplayName = "Microsoft Analysis Services 2005";
        } else if ("M8".equals(providerType)) {
            providerDisplayName = "Microsoft Analysis Services 2008";
        } else if ("M12".equals(providerType)) {
            providerDisplayName = "Microsoft Analysis Services 2012";
        } else if ("M14".equals(providerType)) {
            providerDisplayName = "Microsoft Analysis Services 2014";
        } else if ("M16".equals(providerType)) {
            providerDisplayName = "Microsoft Analysis Services 2016";
        } else if ("M17".equals(providerType)) {
            providerDisplayName = "Microsoft Analysis Services 2017";
        } else if ("M19".equals(providerType)) {
            providerDisplayName = "Microsoft Analysis Services 2019";
        } else if ("MAZ".equals(providerType)) {
            providerDisplayName = "Microsoft Azure Analysis Services";
        }
        return providerDisplayName;
    }

    private void nativeSetupConnectionProperties(final ConnectionParameters connectionParameters, final String providerName, final ODBOConfig currConfig) throws NativeException {
        if (!ODBOThreadContext.isODBOThread()) {
            final ContextTransfer traceCtxTransfer = TraceContext.createTransfer();
            final ContextTransfer execEnvTransfer = ExecutionEnvironmentContext.createTransfer();
            Callable<Object> task = new Callable<Object>(){

                @Override
                public Object call() throws NativeException {
                    traceCtxTransfer.push();
                    execEnvTransfer.push();
                    try {
                        ODBOConnection.this.internalSetupConnectionProperties(connectionParameters, providerName, currConfig);
                        Object var1_1 = null;
                        return var1_1;
                    }
                    finally {
                        execEnvTransfer.pop();
                        traceCtxTransfer.pop();
                    }
                }
            };
            this.invokeNativeCall(task);
        } else {
            this.internalSetupConnectionProperties(connectionParameters, providerName, currConfig);
        }
    }

    private void internalSetupConnectionProperties(ConnectionParameters connectionParameters, String providerName, ODBOConfig currConfig) throws NativeException {
        Boolean disablePrefetchFacts;
        this.mConnectionHandle = this.nativeNewConnection();
        this.nativeCreateProvider(this.mConnectionHandle, providerName);
        this.nativeSetAppName(this.mConnectionHandle, this.getApplicationName(currConfig));
        this.nativeSetDefaultMaxStringLength(this.mConnectionHandle, currConfig.getDefaultMaxStringLength());
        this.nativeSetMDXMUNFormat(this.mConnectionHandle, 0);
        String missingMemberMode = currConfig.getMDXMissingMemberMode();
        if (missingMemberMode != null && missingMemberMode.length() > 0) {
            this.nativeSetMDXMissingMemberMode(this.mConnectionHandle, missingMemberMode);
        }
        if ((disablePrefetchFacts = currConfig.getDisablePrefetchFacts()) != null) {
            this.nativeSetDisablePrefetchFacts(this.mConnectionHandle, disablePrefetchFacts);
        }
        this.runLocale = ((DataSourceLocaleParameter)connectionParameters.get(DataSourceLocaleParameter.class)).getLCID();
        this.nativeSetLocale(this.mConnectionHandle, this.runLocale);
        String serverName = (String)connectionParameters.valueOf(ServerParameter.class, String.class);
        this.nativeSetServerName(this.mConnectionHandle, serverName);
        int genericTimeout = currConfig.getGenericTimeout();
        int connectionTimeout = currConfig.getConnectionTimeout();
        this.nativeSetTimeouts(this.mConnectionHandle, genericTimeout, connectionTimeout);
    }

    private String getProviderName(ODBOConfig currConfig, String originalProviderName) {
        String configuredName = currConfig.getConfiguredProviderName();
        if (configuredName != null) {
            return configuredName;
        }
        return originalProviderName;
    }

    private String getApplicationName(ODBOConfig currConfig) {
        String applicationName = currConfig.getApplicationName();
        return applicationName;
    }

    public void disconnect() {
        if (ODBOLog.isOn(ODBOLogEnum.LOG_CONNECTION)) {
            ODBOLog.getLogger(ODBOLogEnum.LOG_CONNECTION).log("Disconnecting from MSAS, handle " + this.mConnectionHandle);
        }
        this.variantArrayTracker.reportAndCleanup(false);
        this.variantArrayTracker.removeFromNestingTracker();
        if (this.mConnectionHandle != 0L) {
            try {
                this.nativeDestroyConnection(this.mConnectionHandle);
            }
            catch (NativeException ex) {
                String providerType = (String)this.getConnectionParameters().valueOf(ProviderTypeParameter.class, String.class);
                String providerFullName = this.getProviderDisplayName(providerType);
                throw new ODBORuntimeException(ODBOMessageKeys.CON_DISCONNECT_FAILURE, (Object)providerFullName, this.getConnectionParameters().valueOf(ServerParameter.class, String.class), ex);
            }
            finally {
                this.mConnectionHandle = 0L;
            }
        }
        this.connected = false;
    }

    public boolean isConnected() {
        return this.connected;
    }

    public ODBOResultSet query(XDataContext xDataContext, MDXQueryArguments theQueryArgument, ICube cube, String mdx, int numExpectedAxes) {
        ODBODataProvider odboDataProvider = (ODBODataProvider)this.getDataProvider();
        ODBOResultSet result = this.queryPrepare(odboDataProvider, xDataContext, theQueryArgument, cube, mdx, numExpectedAxes);
        try {
            this.queryExecute(xDataContext, theQueryArgument, mdx, result);
        }
        catch (RuntimeException ex) {
            result.release();
            throw ex;
        }
        return result;
    }

    public ODBOResultSet queryPrepare(ODBODataProvider provider, XDataContext xDataContext, MDXQueryArguments theQueryArgument, ICube cube, String mdx, int numExpectedAxes) {
        long resultHandle;
        String providerType = (String)this.getConnectionParameters().valueOf(ProviderTypeParameter.class, String.class);
        ODBOConfig currConfig = ODBOConfigManager.getConfig(providerType);
        int timeout = currConfig.getCommandTimeout();
        if (ODBOLog.isOn(ODBOLogEnum.LOG_PROVIDER_DATA_QUERY)) {
            ODBOLog.getLogger(ODBOLogEnum.LOG_PROVIDER_DATA_QUERY).log("Executing MDX:" + System.getProperty(LINE_SEPARATOR) + mdx);
        }
        try {
            resultHandle = this.nativeExecutePrepare(this.mConnectionHandle, mdx, timeout);
        }
        catch (NativeException ex) {
            ErrorStatus status = ex.getErrorStatus();
            if (ODBOLog.isOn(ODBOLogEnum.LOG_PROVIDER_DATA_QUERY, LogLevel.ERROR)) {
                StringBuilder buffer = new StringBuilder();
                buffer.append("ExecutePrepare failed with status  ");
                buffer.append(status);
                ODBOLog.getLogger(ODBOLogEnum.LOG_PROVIDER_DATA_QUERY).log(LogLevel.ERROR, buffer.toString());
            }
            this.checkForLostConnection(status);
            throw new ODBORuntimeException(ODBOMessageKeys.DAT_EXECUTE_ERROR, ex);
        }
        ODBOResultSet result = new ODBOResultSet(provider, this, xDataContext, theQueryArgument, cube, resultHandle, numExpectedAxes);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void queryExecute(XDataContext xDataContext, MDXQueryArguments theQueryArgument, String mdx, ODBOResultSet result) {
        try {
            ODBOCancelHandler ch = new ODBOCancelHandler(result);
            ExecutionEnvironment executionEnvironment = (ExecutionEnvironment)xDataContext.getEnvironment();
            executionEnvironment.getCancelManager().addCancelHandler((ICancelable)ch);
            try {
                this.nativeExecuteMDX(this.mConnectionHandle, result.getHandle());
                result.afterExecute();
            }
            finally {
                executionEnvironment.getCancelManager().removeCancelHandler((ICancelable)ch);
                if (result.isCancelled()) {
                    this.invalidate();
                    if (ODBOLog.isOn(ODBOLogEnum.LOG_CONNECTION, LogLevel.ERROR)) {
                        StringBuilder buffer = new StringBuilder();
                        buffer.append("The MSAS connection was cancelled and invalidated.");
                        ODBOLog.getLogger(ODBOLogEnum.LOG_CONNECTION).log(LogLevel.ERROR, buffer.toString());
                    }
                    throw new OperationCanceledException();
                }
                result.setCancelled(false);
            }
        }
        catch (NativeException ex) {
            ErrorStatus status = ex.getErrorStatus();
            if (ODBOLog.isOn(ODBOLogEnum.LOG_PROVIDER_DATA_QUERY, LogLevel.ERROR)) {
                StringBuilder buffer = new StringBuilder();
                buffer.append("Execute failed with status  ");
                buffer.append(status);
                buffer.append(", MDX: ");
                buffer.append(System.getProperty(LINE_SEPARATOR));
                buffer.append(mdx);
                ODBOLog.getLogger(ODBOLogEnum.LOG_PROVIDER_DATA_QUERY).log(LogLevel.ERROR, buffer.toString());
            }
            this.checkForLostConnection(status);
            throw new ODBORuntimeException(ODBOMessageKeys.DAT_EXECUTE_ERROR, ex);
        }
        if (ODBOLog.isOn(ODBOLogEnum.LOG_PROVIDER_DATA_QUERY)) {
            ODBOLog.getLogger(ODBOLogEnum.LOG_PROVIDER_DATA_QUERY).log("Execute succeeded, result handle: " + result.getHandle());
        }
    }

    public void checkForLostConnection(ErrorStatus status) {
        long causeCode = status.getCauseCode();
        if (causeCode == -1056767999L || causeCode == -1056178166L || causeCode == -1056112631L || causeCode == -1056178127L) {
            this.invalidate();
            if (ODBOLog.isOn(ODBOLogEnum.LOG_CONNECTION, LogLevel.ERROR)) {
                StringBuilder buffer = new StringBuilder();
                buffer.append("The MSAS connection was lost and invalidated.  The cause was ");
                if (causeCode == -1056767999L) {
                    buffer.append("MSAS_OUT_OF_MEMORY");
                } else if (causeCode == -1056178166L) {
                    buffer.append("MSAS_CONNECTION_TIMED_OUT");
                } else if (causeCode == -1056112631L) {
                    buffer.append("MSAS_TRANSPORT_ERROR");
                } else if (causeCode == -1056178127L) {
                    buffer.append("MSAS_SESSION_GONE");
                }
                ODBOLog.getLogger(ODBOLogEnum.LOG_CONNECTION).log(LogLevel.ERROR, buffer.toString());
            }
        }
    }

    protected long getRowset(String type, int restrictionCount, long pRestrictions) throws NativeException {
        try {
            return this.nativeGetRowset(this.mConnectionHandle, type, restrictionCount, pRestrictions);
        }
        catch (NativeException ex) {
            ErrorStatus status = ex.getErrorStatus();
            if (ODBOLog.isOn(ODBOLogEnum.LOG_PROVIDER_METADATA, LogLevel.ERROR)) {
                StringBuilder buffer = new StringBuilder();
                buffer.append("Rowset fetch failed with status ");
                buffer.append(status);
                ODBOLog.getLogger(ODBOLogEnum.LOG_PROVIDER_METADATA).log(LogLevel.ERROR, buffer.toString());
            }
            this.checkForLostConnection(status);
            throw ex;
        }
    }

    private void assertNotSystemService() {
        String accountName = null;
        try {
            accountName = WinImpersonate.getCurrentUserName((int)this.runLocale);
        }
        catch (NativeException ex) {
            ODBORuntimeException.throwInternalError(ex.getErrorStatus());
        }
        if (null != accountName && "SYSTEM".equals(accountName)) {
            throw new ODBORuntimeException(ODBOMessageKeys.CON_LOCAL_SYSTEM_SERVICE);
        }
    }

    public <T> T invokeNativeCall(Callable<T> task) throws NativeException {
        Future<T> future = this.getCOMExecutorService().submit(task);
        try {
            return future.get();
        }
        catch (InterruptedException ex) {
            throw new ODBORuntimeException(ODBOMessageKeys.GEN_INTERRUPTION_ERROR, ex);
        }
        catch (ExecutionException ex) {
            Throwable cause = ex.getCause();
            if (cause instanceof NativeException) {
                throw (NativeException)cause;
            }
            if (cause instanceof RuntimeException) {
                throw (RuntimeException)cause;
            }
            throw new ODBORuntimeException(ODBOMessageKeys.GEN_UNKNOWN_INTERNAL_ERROR, ex);
        }
    }

    public <T> T invokeNativeCallWithWinImpersonation(Callable<T> task, String domainName, String userName, String password, int errorLocale) throws NativeException {
        IImpersonator winImpersonater = ImpersonatorFactory.createWinImpersonater((String)domainName, (String)userName, (String)password, (int)errorLocale, (ExecutorService)this.getCOMExecutorService());
        try {
            Object object = winImpersonater.runPrivilegedTask(task);
            return (T)object;
        }
        catch (InterruptedException ex) {
            throw new ODBORuntimeException(ODBOMessageKeys.GEN_INTERRUPTION_ERROR, ex);
        }
        catch (NativeException ex) {
            throw ex;
        }
        catch (RuntimeException ex) {
            throw ex;
        }
        catch (Throwable ex) {
            throw new ODBORuntimeException(ODBOMessageKeys.GEN_UNKNOWN_INTERNAL_ERROR, ex);
        }
        finally {
            winImpersonater.release();
        }
    }

    public <T> T invokeNativeCallWithCAMImpersonation(Callable<T> task, String ssoDelegationHandle, int errorLocale) throws NativeException {
        IImpersonator camImpersonater = ImpersonatorFactory.createCAMImpersonater((String)ssoDelegationHandle, (int)errorLocale, (ExecutorService)this.getCOMExecutorService());
        try {
            Object object = camImpersonater.runPrivilegedTask(task);
            return (T)object;
        }
        catch (InterruptedException ex) {
            throw new ODBORuntimeException(ODBOMessageKeys.GEN_INTERRUPTION_ERROR, ex);
        }
        catch (NativeException ex) {
            throw ex;
        }
        catch (RuntimeException ex) {
            throw ex;
        }
        catch (Throwable ex) {
            throw new ODBORuntimeException(ODBOMessageKeys.GEN_UNKNOWN_INTERNAL_ERROR, ex);
        }
        finally {
            camImpersonater.release();
        }
    }

    public static native void cInitializeCOMThread() throws NativeException;

    public static native void cTerminateCOMThread() throws NativeException;

    private static native long cNewConnection() throws NativeException;

    private long nativeNewConnection() throws NativeException {
        ODBOThreadContext.assertIsODBOThread();
        return ODBOConnection.cNewConnection();
    }

    private static native void cSetLocale(long var0, int var2) throws NativeException;

    private void nativeSetLocale(long connectionHandle, int locale) throws NativeException {
        ODBOThreadContext.assertIsODBOThread();
        ODBOConnection.cSetLocale(connectionHandle, locale);
    }

    private static native void cCreateProvider(long var0, String var2) throws NativeException;

    private void nativeCreateProvider(long connectionHandle, String providerName) throws NativeException {
        ODBOThreadContext.assertIsODBOThread();
        ODBOConnection.cCreateProvider(connectionHandle, providerName);
    }

    private static native void cSetServerName(long var0, String var2) throws NativeException;

    private void nativeSetServerName(long connectionHandle, String serverName) throws NativeException {
        ODBOThreadContext.assertIsODBOThread();
        ODBOConnection.cSetServerName(connectionHandle, serverName);
    }

    private static native void cSetAppName(long var0, String var2) throws NativeException;

    private void nativeSetAppName(long connectionHandle, String appName) throws NativeException {
        ODBOThreadContext.assertIsODBOThread();
        ODBOConnection.cSetAppName(connectionHandle, appName);
    }

    private static native void cSetMDXMUNFormat(long var0, int var2) throws NativeException;

    private void nativeSetMDXMUNFormat(long connectionHandle, int mdxMUNFormat) throws NativeException {
        ODBOThreadContext.assertIsODBOThread();
        ODBOConnection.cSetMDXMUNFormat(connectionHandle, mdxMUNFormat);
    }

    private static native void cSetMDXMissingMemberMode(long var0, String var2) throws NativeException;

    private void nativeSetMDXMissingMemberMode(long connectionHandle, String missingMemberMode) throws NativeException {
        ODBOThreadContext.assertIsODBOThread();
        ODBOConnection.cSetMDXMissingMemberMode(connectionHandle, missingMemberMode);
    }

    private static native void cSetDisablePrefetchFacts(long var0, boolean var2) throws NativeException;

    private void nativeSetDisablePrefetchFacts(long connectionHandle, boolean disablePrefetchFacts) throws NativeException {
        ODBOThreadContext.assertIsODBOThread();
        ODBOConnection.cSetDisablePrefetchFacts(connectionHandle, disablePrefetchFacts);
    }

    private static native void cSetTimeouts(long var0, int var2, int var3) throws NativeException;

    private void nativeSetTimeouts(long connectionHandle, int genericTimeout, int connectTimeout) throws NativeException {
        ODBOThreadContext.assertIsODBOThread();
        ODBOConnection.cSetTimeouts(connectionHandle, genericTimeout, connectTimeout);
    }

    private static native void cSetDefaultMaxStringLength(long var0, int var2) throws NativeException;

    private void nativeSetDefaultMaxStringLength(long connectionHandle, int maxStringLength) throws NativeException {
        ODBOThreadContext.assertIsODBOThread();
        ODBOConnection.cSetDefaultMaxStringLength(connectionHandle, maxStringLength);
    }

    private static native void cSetAuthentication(long var0, boolean var2, String var3, String var4, String var5, boolean var6) throws NativeException;

    private void nativeSetAuthentication(final long connectionHandle, final boolean trusted, final String delegationHandle, final String user, final String password, final boolean passSignon) throws NativeException {
        if (!ODBOThreadContext.isODBOThread()) {
            final ContextTransfer traceCtxTransfer = TraceContext.createTransfer();
            final ContextTransfer execEnvTransfer = ExecutionEnvironmentContext.createTransfer();
            Callable<Object> task = new Callable<Object>(){

                @Override
                public Object call() throws NativeException {
                    traceCtxTransfer.push();
                    execEnvTransfer.push();
                    try {
                        ODBOConnection.cSetAuthentication(connectionHandle, trusted, delegationHandle, user, password, passSignon);
                        Object var1_1 = null;
                        return var1_1;
                    }
                    finally {
                        execEnvTransfer.pop();
                        traceCtxTransfer.pop();
                    }
                }
            };
            this.invokeNativeCall(task);
        } else {
            ODBOConnection.cSetAuthentication(connectionHandle, trusted, delegationHandle, user, password, passSignon);
        }
    }

    private static native void cUpdateConnectionProperties(long var0) throws NativeException;

    private void nativeUpdateConnectionProperties(final long connectionHandle) throws NativeException {
        if (!ODBOThreadContext.isODBOThread()) {
            final ContextTransfer traceCtxTransfer = TraceContext.createTransfer();
            final ContextTransfer execEnvTransfer = ExecutionEnvironmentContext.createTransfer();
            Callable<Object> task = new Callable<Object>(){

                @Override
                public Object call() throws NativeException {
                    traceCtxTransfer.push();
                    execEnvTransfer.push();
                    try {
                        ODBOConnection.cUpdateConnectionProperties(connectionHandle);
                        Object var1_1 = null;
                        return var1_1;
                    }
                    finally {
                        execEnvTransfer.pop();
                        traceCtxTransfer.pop();
                    }
                }
            };
            this.invokeNativeCall(task);
        } else {
            ODBOConnection.cUpdateConnectionProperties(connectionHandle);
        }
    }

    private static native void cInitializeConnection(long var0) throws NativeException;

    private void nativeInitializeConnection(final long connectionHandle) throws NativeException {
        if (!ODBOThreadContext.isODBOThread()) {
            final ContextTransfer traceCtxTransfer = TraceContext.createTransfer();
            final ContextTransfer execEnvTransfer = ExecutionEnvironmentContext.createTransfer();
            Callable<Object> task = new Callable<Object>(){

                @Override
                public Object call() throws NativeException {
                    traceCtxTransfer.push();
                    execEnvTransfer.push();
                    try {
                        ODBOConnection.cInitializeConnection(connectionHandle);
                        Object var1_1 = null;
                        return var1_1;
                    }
                    finally {
                        execEnvTransfer.pop();
                        traceCtxTransfer.pop();
                    }
                }
            };
            this.invokeNativeCall(task);
        } else {
            ODBOConnection.cInitializeConnection(connectionHandle);
        }
    }

    private static native void cCreateSource(long var0) throws NativeException;

    private void nativeCreateSource(final long connectionHandle) throws NativeException {
        if (!ODBOThreadContext.isODBOThread()) {
            final ContextTransfer traceCtxTransfer = TraceContext.createTransfer();
            final ContextTransfer execEnvTransfer = ExecutionEnvironmentContext.createTransfer();
            Callable<Object> task = new Callable<Object>(){

                @Override
                public Object call() throws NativeException {
                    traceCtxTransfer.push();
                    execEnvTransfer.push();
                    try {
                        ODBOConnection.cCreateSource(connectionHandle);
                        Object var1_1 = null;
                        return var1_1;
                    }
                    finally {
                        execEnvTransfer.pop();
                        traceCtxTransfer.pop();
                    }
                }
            };
            this.invokeNativeCall(task);
        } else {
            ODBOConnection.cCreateSource(connectionHandle);
        }
    }

    private static native void cCreateSession(long var0) throws NativeException;

    private void nativeCreateSession(final long connectionHandle) throws NativeException {
        if (!ODBOThreadContext.isODBOThread()) {
            final ContextTransfer traceCtxTransfer = TraceContext.createTransfer();
            final ContextTransfer execEnvTransfer = ExecutionEnvironmentContext.createTransfer();
            Callable<Object> task = new Callable<Object>(){

                @Override
                public Object call() throws NativeException {
                    traceCtxTransfer.push();
                    execEnvTransfer.push();
                    try {
                        ODBOConnection.cCreateSession(connectionHandle);
                        Object var1_1 = null;
                        return var1_1;
                    }
                    finally {
                        execEnvTransfer.pop();
                        traceCtxTransfer.pop();
                    }
                }
            };
            this.invokeNativeCall(task);
        } else {
            ODBOConnection.cCreateSession(connectionHandle);
        }
    }

    private static native void cOpenCatalog(long var0, String var2) throws NativeException;

    private void nativeOpenCatalog(final long connectionHandle, final String catalogName) throws NativeException {
        if (!ODBOThreadContext.isODBOThread()) {
            final ContextTransfer traceCtxTransfer = TraceContext.createTransfer();
            final ContextTransfer execEnvTransfer = ExecutionEnvironmentContext.createTransfer();
            Callable<Object> task = new Callable<Object>(){

                @Override
                public Object call() throws NativeException {
                    traceCtxTransfer.push();
                    execEnvTransfer.push();
                    try {
                        ODBOConnection.cOpenCatalog(connectionHandle, catalogName);
                        Object var1_1 = null;
                        return var1_1;
                    }
                    finally {
                        execEnvTransfer.pop();
                        traceCtxTransfer.pop();
                    }
                }
            };
            this.invokeNativeCall(task);
        } else {
            ODBOConnection.cOpenCatalog(connectionHandle, catalogName);
        }
    }

    private static native void cDestroyConnection(long var0) throws NativeException;

    private void nativeDestroyConnection(final long connectionHandle) throws NativeException {
        if (!ODBOThreadContext.isODBOThread()) {
            final ContextTransfer traceCtxTransfer = TraceContext.createTransfer();
            final ContextTransfer execEnvTransfer = ExecutionEnvironmentContext.createTransfer();
            Callable<Object> task = new Callable<Object>(){

                @Override
                public Object call() throws NativeException {
                    traceCtxTransfer.push();
                    execEnvTransfer.push();
                    try {
                        ODBOConnection.cDestroyConnection(connectionHandle);
                        Object var1_1 = null;
                        return var1_1;
                    }
                    finally {
                        execEnvTransfer.pop();
                        traceCtxTransfer.pop();
                    }
                }
            };
            this.invokeNativeCall(task);
        } else {
            ODBOConnection.cDestroyConnection(connectionHandle);
        }
    }

    private static native long cGetRowset(long var0, String var2, int var3, long var4) throws NativeException;

    private long nativeGetRowset(long handle, String type, int restrictionCount, long pRestrictions) throws NativeException {
        ODBOThreadContext.assertIsODBOThread();
        return ODBOConnection.cGetRowset(handle, type, restrictionCount, pRestrictions);
    }

    private static native long cExecutePrepare(long var0, String var2, int var3) throws NativeException;

    private long nativeExecutePrepare(final long handle, final String mdx, final int timeout) throws NativeException {
        if (!ODBOThreadContext.isODBOThread()) {
            final ContextTransfer traceCtxTransfer = TraceContext.createTransfer();
            final ContextTransfer execEnvTransfer = ExecutionEnvironmentContext.createTransfer();
            Callable<Long> task = new Callable<Long>(){

                @Override
                public Long call() throws NativeException {
                    traceCtxTransfer.push();
                    execEnvTransfer.push();
                    try {
                        Long l = ODBOConnection.cExecutePrepare(handle, mdx, timeout);
                        return l;
                    }
                    finally {
                        execEnvTransfer.pop();
                        traceCtxTransfer.pop();
                    }
                }
            };
            return this.invokeNativeCall(task);
        }
        return ODBOConnection.cExecutePrepare(handle, mdx, timeout);
    }

    private static native void cExecuteMDX(long var0, long var2) throws NativeException;

    private void nativeExecuteMDX(final long connhandle, final long rshandle) throws NativeException {
        if (!ODBOThreadContext.isODBOThread()) {
            final ContextTransfer traceCtxTransfer = TraceContext.createTransfer();
            final ContextTransfer execEnvTransfer = ExecutionEnvironmentContext.createTransfer();
            Callable<Object> task = new Callable<Object>(){

                @Override
                public Object call() throws NativeException {
                    traceCtxTransfer.push();
                    execEnvTransfer.push();
                    try {
                        ODBOConnection.cExecuteMDX(connhandle, rshandle);
                        Object var1_1 = null;
                        return var1_1;
                    }
                    finally {
                        execEnvTransfer.pop();
                        traceCtxTransfer.pop();
                    }
                }
            };
            this.invokeNativeCall(task);
        } else {
            ODBOConnection.cExecuteMDX(connhandle, rshandle);
        }
    }

    private static native long cAllocVariantArray(int var0) throws NativeException;

    private long nativeAllocVariantArray(int size) throws NativeException {
        ODBOThreadContext.assertIsODBOThread();
        return ODBOConnection.cAllocVariantArray(size);
    }

    private static native void cFreeVariantArray(long var0, int var2) throws NativeException;

    private void nativeFreeVariantArray(final long pArray, final int size) throws NativeException {
        if (!ODBOThreadContext.isODBOThread()) {
            final ContextTransfer traceCtxTransfer = TraceContext.createTransfer();
            final ContextTransfer execEnvTransfer = ExecutionEnvironmentContext.createTransfer();
            Callable<Object> task = new Callable<Object>(){

                @Override
                public Object call() throws NativeException {
                    traceCtxTransfer.push();
                    execEnvTransfer.push();
                    try {
                        ODBOConnection.cFreeVariantArray(pArray, size);
                        Object var1_1 = null;
                        return var1_1;
                    }
                    finally {
                        execEnvTransfer.pop();
                        traceCtxTransfer.pop();
                    }
                }
            };
            this.invokeNativeCall(task);
        } else {
            ODBOConnection.cFreeVariantArray(pArray, size);
        }
    }

    private static native void cSetVariantString(long var0, int var2, String var3) throws NativeException;

    private void nativeSetVariantString(long pArray, int idx, String value) throws NativeException {
        ODBOThreadContext.assertIsODBOThread();
        ODBOConnection.cSetVariantString(pArray, idx, value);
    }

    private static native void cSetVariantInt32(long var0, int var2, int var3) throws NativeException;

    private void nativeSetVariantInt32(long pArray, int idx, int value) throws NativeException {
        ODBOThreadContext.assertIsODBOThread();
        ODBOConnection.cSetVariantInt32(pArray, idx, value);
    }

    private static native void cSetVariantEmpty(long var0, int var2) throws NativeException;

    private void nativeSetVariantEmpty(long pArray, int idx) throws NativeException {
        ODBOThreadContext.assertIsODBOThread();
        ODBOConnection.cSetVariantEmpty(pArray, idx);
    }

    private static native String cGetMSASVersion(long var0, boolean var2) throws NativeException;

    private String nativeGetVersion(final boolean serverVersion) throws NativeException {
        if (!ODBOThreadContext.isODBOThread()) {
            final ContextTransfer traceCtxTransfer = TraceContext.createTransfer();
            final ContextTransfer execEnvTransfer = ExecutionEnvironmentContext.createTransfer();
            Callable<String> task = new Callable<String>(){

                @Override
                public String call() throws NativeException {
                    traceCtxTransfer.push();
                    execEnvTransfer.push();
                    try {
                        String string = ODBOConnection.cGetMSASVersion(ODBOConnection.this.mConnectionHandle, serverVersion);
                        return string;
                    }
                    finally {
                        execEnvTransfer.pop();
                        traceCtxTransfer.pop();
                    }
                }
            };
            return this.invokeNativeCall(task);
        }
        return ODBOConnection.cGetMSASVersion(this.mConnectionHandle, serverVersion);
    }

    public String getClientVersion() {
        String result = null;
        try {
            result = this.nativeGetVersion(false);
            result = result.toUpperCase();
        }
        catch (NativeException ex) {
            ErrorStatus status = ex.getErrorStatus();
            StringBuilder buffer = new StringBuilder();
            buffer.append(ERROR_RETURNED_FROM).append("ODBOConnection.getClientVersionName(): ").append(status);
            if (ODBOLog.isOn(ODBOLogEnum.LOG_PROVIDER_METADATA, LogLevel.ERROR)) {
                ODBOLog.getLogger(ODBOLogEnum.LOG_PROVIDER_METADATA).log(LogLevel.ERROR, buffer.toString());
            }
            ODBORuntimeException.throwInternalError(status);
        }
        return result;
    }

    public String getServerVersion() {
        String result = null;
        try {
            result = this.nativeGetVersion(true);
            result = result.toUpperCase();
        }
        catch (NativeException ex) {
            ErrorStatus status = ex.getErrorStatus();
            StringBuilder buffer = new StringBuilder();
            buffer.append(ERROR_RETURNED_FROM).append("ODBOConnection.getServerVersionName(): ").append(status);
            if (ODBOLog.isOn(ODBOLogEnum.LOG_PROVIDER_METADATA, LogLevel.ERROR)) {
                ODBOLog.getLogger(ODBOLogEnum.LOG_PROVIDER_METADATA).log(LogLevel.ERROR, buffer.toString());
            }
            ODBORuntimeException.throwInternalError(status);
        }
        return result;
    }

    public boolean validateVersions(ODBOConfig currConfig, String serverName) {
        Boolean valid;
        String server;
        if (null != currConfig.getConfiguredProviderName()) {
            return true;
        }
        String clientVer = this.getClientVersion();
        String serverVer = this.getServerVersion();
        String client = clientVer.contains("MSOLAP100.DLL 10.0.") ? "Microsoft Analysis Services 2008" : (clientVer.contains("MSOLAP100.DLL 10.50.") ? "Microsoft Analysis Services 2008 R2" : (clientVer.contains("MSOLAP90.DLL 9.00.") ? "Microsoft Analysis Services 2005" : (clientVer.contains("MSOLAP110.DLL 11.0.") ? "Microsoft Analysis Services 2012" : (clientVer.contains("MSOLAP120.DLL 12.0.") ? "Microsoft Analysis Services 2014" : (clientVer.contains("MSOLAP130.DLL 13.0.") ? "Microsoft Analysis Services 2016" : (clientVer.contains("MSOLAP.DLL 15.") ? "Microsoft Analysis Services 2017" : (clientVer.contains("MSOLAP.DLL 15.") ? "Microsoft Analysis Services 2019" : "Microsoft Analysis Services Unknown Client")))))));
        if (client.equals(server = serverVer.contains("ANALYSIS SERVER 10.0.") ? "Microsoft Analysis Services 2008" : (serverVer.contains("ANALYSIS SERVER 10.50.") ? "Microsoft Analysis Services 2008 R2" : (serverVer.contains("ANALYSIS SERVER 9.00.") ? "Microsoft Analysis Services 2005" : (serverVer.contains("ANALYSIS SERVER 11.0.") ? "Microsoft Analysis Services 2012" : (serverVer.contains("ANALYSIS SERVER 12.0.") ? "Microsoft Analysis Services 2014" : (serverVer.contains("ANALYSIS SERVER 13.0.") ? "Microsoft Analysis Services 2016" : (serverVer.contains("ANALYSIS SERVER 14.0.") ? "Microsoft Analysis Services 2017" : (serverVer.contains("ANALYSIS SERVER 15.0.") ? "Microsoft Analysis Services 2019" : (serverVer.contains("ANALYSIS SERVER 15.") ? "Microsoft Azure Analysis Services" : "Microsoft Analysis Services Unknown Server")))))))))) {
            valid = true;
        } else if (client.equals("Microsoft Analysis Services 2016") && server.equals("Microsoft Analysis Services 2016")) {
            valid = true;
        } else if (client.equals("Microsoft Analysis Services 2017") && server.equals("Microsoft Analysis Services 2017")) {
            valid = true;
        } else if (client.equals("Microsoft Analysis Services 2019") && server.equals("Microsoft Analysis Services 2019")) {
            valid = true;
        } else if (client.equals("Microsoft Analysis Services 2017") && server.equals("Microsoft Analysis Services 2019")) {
            valid = true;
        } else if (client.equals("Microsoft Analysis Services 2014") && server.equals("Microsoft Analysis Services 2014")) {
            valid = true;
        } else if (client.equals("Microsoft Analysis Services 2012") && (server.equals("Microsoft Analysis Services 2008 R2") || server.equals("Microsoft Analysis Services 2008") || server.equals("Microsoft Analysis Services 2005"))) {
            valid = true;
        } else if (client.equals("Microsoft Analysis Services 2012") && (server.equals("Microsoft Analysis Services 2008 R2") || server.equals("Microsoft Analysis Services 2008") || server.equals("Microsoft Analysis Services 2005"))) {
            valid = true;
        } else if (client.equals("Microsoft Analysis Services 2008 R2") && (server.equals("Microsoft Analysis Services 2008") || server.equals("Microsoft Analysis Services 2005"))) {
            valid = true;
        } else if (client.equals("Microsoft Analysis Services 2008") && (server.equals("Microsoft Analysis Services 2008 R2") || server.equals("Microsoft Analysis Services 2005"))) {
            valid = true;
        } else if (client.equals("Microsoft Analysis Services 2017") && server.equals("Microsoft Azure Analysis Services")) {
            valid = true;
        } else if (client.equals("Microsoft Analysis Services Unknown Client") || server.equals("Microsoft Analysis Services Unknown Server")) {
            valid = true;
            if (ODBOLog.isOn(ODBOLogEnum.LOG_EXCEPTION_LOGGER, LogLevel.TRACE)) {
                ODBOLog.getLogger(ODBOLogEnum.LOG_EXCEPTION_LOGGER).log(LogLevel.TRACE, "Potential version mismatch between local " + client + " and " + server + serverName + ". Verify datasource settings in package and connection string, and ensure the correct 3rd party Analysis Services client is installed.");
            }
        } else {
            if (ODBOLog.isOn(ODBOLogEnum.LOG_EXCEPTION_LOGGER, LogLevel.ERROR)) {
                ODBOLog.getLogger(ODBOLogEnum.LOG_EXCEPTION_LOGGER).log(LogLevel.ERROR, "Version mismatch connecting to " + server + " server " + serverName + " with " + client + " client. Verify datasource settings in package and connection string, and ensure accompanying 3rd party Analysis Services client is installed.");
            }
            throw new ODBORuntimeException(ODBOMessageKeys.CON_VERSION_MISMATCH, (Object)client, (Object)serverName, server);
        }
        return valid;
    }

    public List<XQEMessage> getConnectionDetails() {
        return this.checkAndGetDetails("Client property", this.getClientVersion(), "Server property", this.getServerVersion());
    }

    public List<XQEMessage> getConnectionBlackListDetails() {
        return this.checkAndGetBlackListDetails(this.getClientVersion(), this.getServerVersion());
    }

    protected class CRestrictionArray
    implements IReleasable {
        private long pVargs;
        private int size;

        public CRestrictionArray(int sizeOfArray) {
            try {
                this.pVargs = ODBOConnection.this.nativeAllocVariantArray(sizeOfArray);
                this.size = sizeOfArray;
                ODBOConnection.this.variantArrayTracker.addInstance((IReleasable)this, Thread.currentThread().getStackTrace());
            }
            catch (NativeException ex) {
                ErrorStatus status = ex.getErrorStatus();
                StringBuilder buffer = new StringBuilder();
                buffer.append(ODBOConnection.ERROR_RETURNED_FROM).append("CRestrictionArray.<init>(int) [sizeOfArray=");
                buffer.append(sizeOfArray).append(']');
                buffer.append(ODBOConnection.COLON_SPACE).append(status);
                if (ODBOLog.isOn(ODBOLogEnum.LOG_PROVIDER_METADATA, LogLevel.ERROR)) {
                    ODBOLog.getLogger(ODBOLogEnum.LOG_PROVIDER_METADATA).log(LogLevel.ERROR, buffer.toString());
                }
                ODBOConnection.this.checkForLostConnection(status);
                ODBORuntimeException.throwInternalError(status);
            }
        }

        public void releaseImpl() {
            if (this.pVargs != 0L) {
                try {
                    ODBOConnection.this.nativeFreeVariantArray(this.pVargs, this.size);
                    this.pVargs = 0L;
                    this.size = 0;
                }
                catch (NativeException ex) {
                    ErrorStatus status = ex.getErrorStatus();
                    StringBuilder buffer = new StringBuilder();
                    buffer.append(ODBOConnection.ERROR_RETURNED_FROM).append("CRestrictionArray.delete()");
                    buffer.append(ODBOConnection.COLON_SPACE).append(status);
                    if (ODBOLog.isOn(ODBOLogEnum.LOG_PROVIDER_METADATA, LogLevel.ERROR)) {
                        ODBOLog.getLogger(ODBOLogEnum.LOG_PROVIDER_METADATA).log(LogLevel.ERROR, buffer.toString());
                    }
                    ODBOConnection.this.checkForLostConnection(status);
                    ODBORuntimeException.throwInternalError(status);
                }
            }
        }

        public void release() {
            try {
                this.releaseImpl();
            }
            finally {
                ODBOConnection.this.variantArrayTracker.removeInstance((IReleasable)this);
            }
        }

        public long getArgs() {
            return this.pVargs;
        }

        public int getSize() {
            return this.size;
        }

        public void set(int index, String sValue) {
            try {
                ODBOConnection.this.nativeSetVariantString(this.pVargs, index, sValue);
            }
            catch (NativeException ex) {
                ErrorStatus status = ex.getErrorStatus();
                StringBuilder buffer = new StringBuilder();
                buffer.append(ODBOConnection.ERROR_RETURNED_FROM).append("CRestrictionArray.set(int, String) [index=");
                buffer.append(index).append(",sValue=").append(sValue).append(']');
                buffer.append(ODBOConnection.COLON_SPACE).append(status);
                if (ODBOLog.isOn(ODBOLogEnum.LOG_PROVIDER_METADATA, LogLevel.ERROR)) {
                    ODBOLog.getLogger(ODBOLogEnum.LOG_PROVIDER_METADATA).log(LogLevel.ERROR, buffer.toString());
                }
                ODBOConnection.this.checkForLostConnection(status);
                ODBORuntimeException.throwInternalError(status);
            }
        }

        public void set(int index, int nValue) {
            try {
                ODBOConnection.this.nativeSetVariantInt32(this.pVargs, index, nValue);
            }
            catch (NativeException ex) {
                ErrorStatus status = ex.getErrorStatus();
                StringBuilder buffer = new StringBuilder();
                buffer.append(ODBOConnection.ERROR_RETURNED_FROM).append("CRestrictionArray.set(int, int) [index=");
                buffer.append(index).append(",nValue=").append(nValue).append(']');
                buffer.append(ODBOConnection.COLON_SPACE).append(status);
                if (ODBOLog.isOn(ODBOLogEnum.LOG_PROVIDER_METADATA, LogLevel.ERROR)) {
                    ODBOLog.getLogger(ODBOLogEnum.LOG_PROVIDER_METADATA).log(LogLevel.ERROR, buffer.toString());
                }
                ODBOConnection.this.checkForLostConnection(status);
                ODBORuntimeException.throwInternalError(status);
            }
        }

        public void setEmpty(int index) {
            try {
                ODBOConnection.this.nativeSetVariantEmpty(this.pVargs, index);
            }
            catch (NativeException ex) {
                ErrorStatus status = ex.getErrorStatus();
                StringBuilder buffer = new StringBuilder();
                buffer.append(ODBOConnection.ERROR_RETURNED_FROM).append("CRestrictionArray.setEmpty(int) [index=");
                buffer.append(index).append(']');
                buffer.append(ODBOConnection.COLON_SPACE).append(status);
                if (ODBOLog.isOn(ODBOLogEnum.LOG_PROVIDER_METADATA, LogLevel.ERROR)) {
                    ODBOLog.getLogger(ODBOLogEnum.LOG_PROVIDER_METADATA).log(LogLevel.ERROR, buffer.toString());
                }
                ODBOConnection.this.checkForLostConnection(status);
                ODBORuntimeException.throwInternalError(status);
            }
        }
    }
}

