/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.data.providers.olap.odbo;

import com.cognos.xqe.ast.olap.MDXQuery;
import com.cognos.xqe.bibushandler.RequestEnvironment;
import com.cognos.xqe.data.model.ICAMCryptoSignon;
import com.cognos.xqe.data.model.IDataSource;
import com.cognos.xqe.data.model.IDataSourceConnection;
import com.cognos.xqe.data.model.IDataSourceConnectionSignon;
import com.cognos.xqe.data.model.IUsernamePasswordSignon;
import com.cognos.xqe.data.model.LogonFailureException;
import com.cognos.xqe.data.providers.ConnectionTestQueryArguments;
import com.cognos.xqe.data.providers.QueryArguments;
import com.cognos.xqe.data.providers.connection.ConnectionFactoryStatisticsDecorator;
import com.cognos.xqe.data.providers.connection.ConnectionStringParser;
import com.cognos.xqe.data.providers.connection.parameters.CAMCryptoHandleParameter;
import com.cognos.xqe.data.providers.connection.parameters.CatalogParameter;
import com.cognos.xqe.data.providers.connection.parameters.ConnectionTestHintParameter;
import com.cognos.xqe.data.providers.connection.parameters.DataSourceParameter;
import com.cognos.xqe.data.providers.connection.parameters.PasswordParameter;
import com.cognos.xqe.data.providers.connection.parameters.ProviderTypeParameter;
import com.cognos.xqe.data.providers.connection.parameters.ServerParameter;
import com.cognos.xqe.data.providers.connection.parameters.UnmatchableParameter;
import com.cognos.xqe.data.providers.connection.parameters.UpperCaseCatalogParameter;
import com.cognos.xqe.data.providers.connection.parameters.UserIDParameter;
import com.cognos.xqe.data.providers.olap.IOLAPMetadataProvider;
import com.cognos.xqe.data.providers.olap.MDXQueryArguments;
import com.cognos.xqe.data.providers.olap.MetadataQueryArguments;
import com.cognos.xqe.data.providers.olap.OLAPDataProviderBase;
import com.cognos.xqe.data.providers.olap.TracingOLAPMetadataProvider;
import com.cognos.xqe.data.providers.olap.odbo.DataSourceLocaleParameter;
import com.cognos.xqe.data.providers.olap.odbo.IsTrustedParameter;
import com.cognos.xqe.data.providers.olap.odbo.ODBOConfigManager;
import com.cognos.xqe.data.providers.olap.odbo.ODBOConnection;
import com.cognos.xqe.data.providers.olap.odbo.ODBOLog;
import com.cognos.xqe.data.providers.olap.odbo.ODBOLogEnum;
import com.cognos.xqe.data.providers.olap.odbo.ODBOMessageKeys;
import com.cognos.xqe.data.providers.olap.odbo.ODBOMetadataProvider;
import com.cognos.xqe.data.providers.olap.odbo.ODBOResultSet;
import com.cognos.xqe.data.providers.olap.odbo.ODBORuntimeException;
import com.cognos.xqe.data.providers.olap.odbo.ProviderNameParameter;
import com.cognos.xqe.data.providers.olap.odbo.concurrent.ODBOCOMThreadFactoryDecorator;
import com.cognos.xqe.data.providers.olap.odbo.concurrent.ODBOPassThroughExecutor;
import com.cognos.xqe.data.providers.secbridge.ErrorStatus;
import com.cognos.xqe.data.providers.secbridge.NativeException;
import com.cognos.xqe.exception.XQEMessage;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.metadata.ICube;
import com.cognos.xqe.metadata.IHierarchy;
import com.cognos.xqe.metrics.MetricsService;
import com.cognos.xqe.pool.connection.ConnectionParameters;
import com.cognos.xqe.pool.connection.IConnectionFactory;
import com.cognos.xqe.pool.connection.IConnectionParameter;
import com.cognos.xqe.pool.connection.IPooledConnection;
import com.cognos.xqe.query.engine.ExecutionEnvironment;
import com.cognos.xqe.query.engine.IExecutionEnvironment;
import com.cognos.xqe.resultset.interfaces.ICubeResultSet;
import com.cognos.xqe.resultsets.md.CacheHints;
import com.cognos.xqe.resultsets.md.CubeCache;
import com.cognos.xqe.runtree.XDataContext;
import com.cognos.xqe.trace.LogLevel;
import com.cognos.xqe.trace.XQEDebugLog;
import com.cognos.xqe.util.LocaleConverter;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;

public class ODBODataProvider
extends OLAPDataProviderBase {
    private static final ThreadFactory COM_THREAD_FACTORY = new ODBOCOMThreadFactoryDecorator(Executors.defaultThreadFactory());
    private static final String AMPERSAND_SEPARATOR = "].&[";
    private static final String DATAMEMBER_SUFFIX = ".DATAMEMBER]";
    private static final String PROP_USE_MULTITHREADED_COM = "useMultiThreadedCOM";
    private static final boolean DEF_USE_MULTITHREADED_COM = false;
    private static final AtomicLong JNI_INIT_COUNT = new AtomicLong(0L);
    final ODBOConnectionFactory mODBOConnectionFactory;
    final IConnectionFactory mConnectionFactory;
    private final AtomicBoolean mReleased = new AtomicBoolean(false);

    public ODBODataProvider(String instanceName, Properties properties) {
        super(instanceName, properties);
        if (ODBOLog.isOn(ODBOLogEnum.LOG_RESOURCES)) {
            ODBOLog.getLogger(ODBOLogEnum.LOG_RESOURCES).log("Constructing ODBODataProvider.");
        }
        ODBODataProvider.initializeJNI(this.useMultiThreadedCOM());
        this.mODBOConnectionFactory = new ODBOConnectionFactory();
        this.mConnectionFactory = new ConnectionFactoryStatisticsDecorator((IConnectionFactory)this.mODBOConnectionFactory, instanceName);
    }

    public boolean useMultiThreadedCOM() {
        String strValue = this.getProperty(PROP_USE_MULTITHREADED_COM);
        if (null != strValue) {
            return Boolean.parseBoolean(strValue);
        }
        return false;
    }

    public IConnectionFactory getConnectionFactory() {
        return this.mConnectionFactory;
    }

    public IPooledConnection borrowConnection(ConnectionParameters connectionParameters, IExecutionEnvironment executionEnvironment) {
        IPooledConnection pooledConn = executionEnvironment.getConnectionPool().borrowConnection(this.getProviderInstanceName(), connectionParameters, this.selector, this.mConnectionFactory);
        ODBOConnection odboConn = (ODBOConnection)((Object)pooledConn.getConnection());
        odboConn.setPooledConnection(pooledConn);
        return pooledConn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ICubeResultSet query(XDataContext xDataContext, MDXQueryArguments theQueryArgument) {
        try {
            String sFileName;
            ExecutionEnvironment environment = (ExecutionEnvironment)xDataContext.getEnvironment();
            String savedResults = ((RequestEnvironment)environment.getRequestEnvironment()).getResultsetFileName();
            if (!((RequestEnvironment)environment.getRequestEnvironment()).getSaveResultSet() && savedResults != null) {
                if (CubeCache.getMockLoggingEnabled((ExecutionEnvironment)environment)) {
                    XQEDebugLog.out.println("Loading resultSet from file: " + savedResults);
                }
                CubeCache newCache = new CubeCache(xDataContext, Integer.valueOf(1), CacheHints.cacheAll());
                newCache.initializeFromFile((RequestEnvironment)environment.getRequestEnvironment(), xDataContext, savedResults, theQueryArgument);
                return newCache;
            }
            MetricsService.startCollectingMetric((RequestEnvironment)((RequestEnvironment)environment.getRequestEnvironment()), (String)"executeMDXPopulateHResult");
            ODBOResultSet result = null;
            ConnectionParameters connectionParameters = this.createConnectionParameters((IExecutionEnvironment)environment, theQueryArgument);
            ODBOConnection connection = (ODBOConnection)((Object)this.borrowConnection(connectionParameters, (IExecutionEnvironment)environment).getConnection());
            try {
                MDXQuery mdxQuery = theQueryArgument.getMDXQuery();
                String mdxString = mdxQuery.getMDX();
                ICube cube = mdxQuery.getReferencedCube();
                result = connection.query(xDataContext, theQueryArgument, cube, mdxString, mdxQuery.getNumberOfEdges());
            }
            finally {
                if (null == result) {
                    connection.returnToPool();
                }
            }
            result.setManagingConnection(true);
            MetricsService.endCollectingMetric((RequestEnvironment)((RequestEnvironment)environment.getRequestEnvironment()), (String)"executeMDXPopulateHResult");
            if (((RequestEnvironment)environment.getRequestEnvironment()).getSaveResultSet() && (sFileName = ((RequestEnvironment)environment.getRequestEnvironment()).getResultsetFileName()) != null) {
                if (CubeCache.getMockLoggingEnabled((ExecutionEnvironment)environment)) {
                    XQEDebugLog.out.println("Saving resultSet to file: " + sFileName);
                }
                CubeCache.saveResultToFile((RequestEnvironment)((RequestEnvironment)environment.getRequestEnvironment()), (XDataContext)xDataContext, (ICubeResultSet)result, (String)sFileName);
            }
            return result;
        }
        catch (LogonFailureException e) {
            if (e.getDataSource() == null) {
                e.setDataSource(theQueryArgument.getDataSource());
            }
            IDataSource dataSource = theQueryArgument.getDataSource();
            IDataSourceConnection dsConnection = dataSource.getDataSourceConnection();
            dsConnection.invalidateResolvedSignon();
            throw e;
        }
    }

    public ConnectionParameters createConnectionParameters(IExecutionEnvironment env, MDXQueryArguments queryArgs) {
        MDXQuery mdxQuery = queryArgs.getMDXQuery();
        boolean bMetadataQueryIntent = mdxQuery.isQueryIntentMetadata();
        return this.createConnectionParams(env, (QueryArguments)queryArgs, bMetadataQueryIntent, false);
    }

    public List<XQEMessage> testConnection(ConnectionTestQueryArguments theQueryArguments) {
        List<XQEMessage> connectionDetails = null;
        ODBOConnection connection = null;
        try {
            connection = (ODBOConnection)((Object)this.mODBOConnectionFactory.createConnection(this.createConnectionParams(theQueryArguments.getExecutionEnvironment(), (QueryArguments)theQueryArguments, false, true)));
            connectionDetails = connection.getConnectionDetails();
        }
        catch (LogonFailureException e) {
            try {
                if (e.getDataSource() == null) {
                    e.setDataSource(theQueryArguments.getDataSource());
                }
                IDataSource dataSource = theQueryArguments.getDataSource();
                IDataSourceConnection dsConnection = dataSource.getDataSourceConnection();
                dsConnection.invalidateResolvedSignon();
                throw e;
            }
            catch (Throwable throwable) {
                this.mODBOConnectionFactory.destroyConnection(connection);
                throw throwable;
            }
        }
        this.mODBOConnectionFactory.destroyConnection(connection);
        return connectionDetails;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected ConnectionParameters createConnectionParams(IExecutionEnvironment execEnv, QueryArguments theQueryArguments, boolean bMetadataQueryIntent, boolean bTestConnectionIntent) {
        IDataSource dataSource = theQueryArguments.getDataSource();
        IDataSourceConnection connection = dataSource.getDataSourceConnection();
        IDataSourceConnectionSignon signon = connection.getSignon();
        RequestEnvironment reqEnv = (RequestEnvironment)execEnv.getRequestEnvironment();
        String providerType = dataSource.getType();
        String connectionString = connection.getConnectionString(null);
        final boolean upperCaseCatalog = theQueryArguments.getDataSource().getCapabilities().isSupported("olap.metadata.caseInsensitiveCatalog");
        final ConnectionParameters parameters = new ConnectionParameters();
        ConnectionStringParser.parse((String)connectionString, (ConnectionStringParser.TokenHandler)new ConnectionStringParser.TokenHandler(){

            public void onKeyValueToken(String key, String value) {
                if (key.equals("SERVER")) {
                    parameters.put((IConnectionParameter)new ServerParameter(value));
                } else if (key.equals("LCID")) {
                    parameters.put((IConnectionParameter)new DataSourceLocaleParameter(LocaleConverter.strToLocale((String)value)));
                } else if (key.equals("CATALOG")) {
                    if (upperCaseCatalog) {
                        parameters.put((IConnectionParameter)new UpperCaseCatalogParameter(value));
                        if (ODBOLog.isOn(ODBOLogEnum.LOG_CONNECTION)) {
                            ODBOLog.getLogger(ODBOLogEnum.LOG_CONNECTION).log("ODBO Connection string has upper case catalog=" + value);
                        }
                    } else {
                        parameters.put((IConnectionParameter)new CatalogParameter(value));
                        if (ODBOLog.isOn(ODBOLogEnum.LOG_CONNECTION)) {
                            ODBOLog.getLogger(ODBOLogEnum.LOG_CONNECTION).log("ODBO Connection string has catalog=" + value);
                        }
                    }
                } else if (key.equals("Trusted_Connection") && "yes".equals(value)) {
                    parameters.put((IConnectionParameter)new IsTrustedParameter());
                }
            }

            public void onSimpleToken(String value) {
            }
        });
        if ("YK".equals(providerType)) {
            parameters.put((IConnectionParameter)new ProviderNameParameter("MSOLAP.3"));
        } else if ("M8".equals(providerType)) {
            parameters.put((IConnectionParameter)new ProviderNameParameter("MSOLAP.4"));
        } else if ("M12".equals(providerType)) {
            parameters.put((IConnectionParameter)new ProviderNameParameter("MSOLAP.5"));
        } else if ("M14".equals(providerType)) {
            parameters.put((IConnectionParameter)new ProviderNameParameter("MSOLAP.6"));
        } else if ("M16".equals(providerType)) {
            parameters.put((IConnectionParameter)new ProviderNameParameter("MSOLAP.7"));
        } else if ("M17".equals(providerType)) {
            parameters.put((IConnectionParameter)new ProviderNameParameter("MSOLAP.8"));
        } else if ("M19".equals(providerType)) {
            parameters.put((IConnectionParameter)new ProviderNameParameter("MSOLAP.8"));
        } else {
            if (!"MAZ".equals(providerType)) throw new ODBORuntimeException(ODBOMessageKeys.GEN_UNKNOWN_PROVIDER_TYPE, providerType);
            parameters.put((IConnectionParameter)new ProviderNameParameter("MSOLAP.8"));
        }
        parameters.put((IConnectionParameter)new ProviderTypeParameter(providerType));
        parameters.put((IConnectionParameter)new DataSourceParameter(dataSource));
        if (!bMetadataQueryIntent) {
            if (reqEnv == null) throw new ODBORuntimeException(ODBOMessageKeys.GEN_EMPTY_REQUEST_ENVIRONMENT);
            Locale runLocale = theQueryArguments.getRunLocale();
            String localeStr = LocaleConverter.localeToStr((Locale)runLocale);
            if (localeStr == null) {
                throw new ODBORuntimeException(ODBOMessageKeys.GEN_MISSING_LOCALE);
            }
            if (localeStr.length() == 0 || localeStr.equals("-1")) {
                throw new ODBORuntimeException(ODBOMessageKeys.GEN_INVALID_LOCALE, localeStr);
            }
            parameters.put((IConnectionParameter)new DataSourceLocaleParameter(runLocale));
        } else if (!parameters.contains(DataSourceLocaleParameter.class)) {
            throw new ODBORuntimeException(ODBOMessageKeys.CON_MISSING_DATASOURCE_LCID, dataSource.getDataSourceConnection().getConnectionString(null));
        }
        Locale catalogLocale = (Locale)parameters.valueOf(DataSourceLocaleParameter.class, Locale.class);
        String catalog = upperCaseCatalog ? (String)parameters.valueOf(UpperCaseCatalogParameter.class, String.class) : (String)parameters.valueOf(CatalogParameter.class, String.class);
        if (null == catalog) {
            Map metadataProps = theQueryArguments.getDataSource().getMetadataProperties();
            catalog = (String)metadataProps.get("catalog");
            if (catalog != null) {
                if (upperCaseCatalog) {
                    catalog = catalog.toUpperCase(catalogLocale);
                    parameters.put((IConnectionParameter)new UpperCaseCatalogParameter(catalog));
                    if (ODBOLog.isOn(ODBOLogEnum.LOG_CONNECTION)) {
                        ODBOLog.getLogger(ODBOLogEnum.LOG_CONNECTION).log("ODBO upper case catalog from query arguments=" + catalog);
                    }
                } else {
                    parameters.put((IConnectionParameter)new CatalogParameter(catalog));
                    if (ODBOLog.isOn(ODBOLogEnum.LOG_CONNECTION)) {
                        ODBOLog.getLogger(ODBOLogEnum.LOG_CONNECTION).log("ODBO catalog from query arguments=" + catalog);
                    }
                }
            }
        } else if (upperCaseCatalog) {
            catalog = catalog.toUpperCase(catalogLocale);
            parameters.put((IConnectionParameter)new UpperCaseCatalogParameter(catalog));
        } else {
            parameters.put((IConnectionParameter)new CatalogParameter(catalog));
        }
        if (null != signon) {
            if (signon.getType() == IDataSourceConnectionSignon.SignonType.USERNAME_PASSWORD) {
                IUsernamePasswordSignon userPwdSignon = (IUsernamePasswordSignon)signon;
                parameters.put((IConnectionParameter)new UserIDParameter(userPwdSignon.getUserName()));
                parameters.put((IConnectionParameter)new PasswordParameter(userPwdSignon.getPassword()));
            } else if (signon.getType() == IDataSourceConnectionSignon.SignonType.CAMCRYPTO) {
                ICAMCryptoSignon camCryptoSignon = (ICAMCryptoSignon)signon;
                parameters.put((IConnectionParameter)new CAMCryptoHandleParameter(camCryptoSignon.getCryptoHandle()));
            }
        }
        if (!bTestConnectionIntent) return parameters;
        parameters.put((IConnectionParameter)new ConnectionTestHintParameter());
        parameters.put((IConnectionParameter)new UnmatchableParameter());
        return parameters;
    }

    public String cognosUNToNativeUN(String providerType, IHierarchy hierarchy, String cognosUN) {
        if (cognosUN.endsWith(DATAMEMBER_SUFFIX) || cognosUN.indexOf(AMPERSAND_SEPARATOR) >= 0) {
            StringBuilder strBuf = new StringBuilder(cognosUN);
            strBuf.deleteCharAt(strBuf.length() - 1);
            strBuf.deleteCharAt(0);
            int index = strBuf.indexOf("]]");
            while (index != -1) {
                strBuf.deleteCharAt(index);
                if (index >= strBuf.length()) break;
                index = strBuf.indexOf("]]", index);
            }
            return strBuf.toString();
        }
        return cognosUN;
    }

    public String nativeUNToCognosUN(String providerType, String nativeUN) {
        String cognosMun;
        if (nativeUN == null) {
            return null;
        }
        int indexOfAmp = nativeUN.indexOf(AMPERSAND_SEPARATOR);
        if (indexOfAmp < 0 && nativeUN.endsWith("]")) {
            cognosMun = nativeUN;
        } else {
            StringBuilder newUN = new StringBuilder();
            newUN.append("[");
            int len = nativeUN.length();
            for (int i = 0; i < len; ++i) {
                char ch = nativeUN.charAt(i);
                newUN.append(ch);
                if (ch != "]".charAt(0)) continue;
                newUN.append("]");
            }
            newUN.append("]");
            cognosMun = newUN.toString();
        }
        return cognosMun;
    }

    public IOLAPMetadataProvider getMetadataProvider(MetadataQueryArguments theQueryArguments) {
        ConnectionParameters connParams = this.createConnectionParams(theQueryArguments.getExecutionEnvironment(), (QueryArguments)theQueryArguments, true, false);
        ODBOConfigManager.getConfig(theQueryArguments.getDataSource().getType());
        ODBOMetadataProvider provider = new ODBOMetadataProvider(this, theQueryArguments, connParams);
        provider = new TracingOLAPMetadataProvider((IOLAPMetadataProvider)provider, "ODBO", "ODBOMetadataProvider");
        return provider;
    }

    public void releaseImpl() {
        if (!this.mReleased.compareAndSet(false, true)) {
            return;
        }
        ODBODataProvider.terminateJNI();
    }

    private static synchronized void initializeJNI(boolean useMultiThreadedCOM) {
        if (JNI_INIT_COUNT.incrementAndGet() == 1L) {
            ODBOLog.enableCppLogger("InitTerm");
            ODBOLog.enableCppLogger("Exception");
            ODBOLog.enableCppLogger("3rdParty");
            ODBOLog.enableCppLogger("Connection");
            ODBOLog.enableCppLogger("ODBODevEvent");
            ODBOLog.enableCppLogger("ODBOBinding");
            ODBOLog.enableCppLogger("JNI");
            if (ODBOLog.isOn(ODBOLogEnum.LOG_INIT_TERM, LogLevel.INFO)) {
                ODBOLog.getLogger(ODBOLogEnum.LOG_INIT_TERM).log(LogLevel.INFO, "Initializing JNI for ODBODataProvider.");
            }
            try {
                ODBODataProvider.cInitialize(useMultiThreadedCOM);
            }
            catch (NativeException ex) {
                ErrorStatus status = ex.getErrorStatus();
                if (ODBOLog.isOn(ODBOLogEnum.LOG_INIT_TERM, LogLevel.ERROR)) {
                    ODBOLog.getLogger(ODBOLogEnum.LOG_INIT_TERM).log(LogLevel.ERROR, "An error was returned from ODBODataProvider.cInitialize: " + status.toString());
                }
                throw new ODBORuntimeException(ODBOMessageKeys.INI_BRIDGE_INIT_ERROR, ex);
            }
            catch (Throwable ex) {
                if (ODBOLog.isOn(ODBOLogEnum.LOG_INIT_TERM, LogLevel.ERROR)) {
                    ODBOLog.getLogger(ODBOLogEnum.LOG_INIT_TERM).log(LogLevel.ERROR, "Exception caught in ODBODataProvider.cInitialize: ", ex);
                }
                throw new ODBORuntimeException(ODBOMessageKeys.INI_BRIDGE_INIT_ERROR, ex);
            }
        }
    }

    private static synchronized void terminateJNI() {
        if (JNI_INIT_COUNT.decrementAndGet() == 0L) {
            if (ODBOLog.isOn(ODBOLogEnum.LOG_INIT_TERM, LogLevel.INFO)) {
                ODBOLog.getLogger(ODBOLogEnum.LOG_INIT_TERM).log(LogLevel.INFO, "Terminating JNI for ODBODataProvider.");
            }
            try {
                ODBODataProvider.cTerminate();
            }
            catch (NativeException ex) {
                ErrorStatus status = ex.getErrorStatus();
                if (ODBOLog.isOn(ODBOLogEnum.LOG_INIT_TERM, LogLevel.ERROR)) {
                    ODBOLog.getLogger(ODBOLogEnum.LOG_INIT_TERM).log(LogLevel.ERROR, "An error was returned from ODBODataProvider.cTerminate: " + status.toString());
                }
                throw new ODBORuntimeException(ODBOMessageKeys.INI_BRIDGE_TERM_ERROR, ex);
            }
            catch (Throwable ex) {
                if (ODBOLog.isOn(ODBOLogEnum.LOG_INIT_TERM, LogLevel.ERROR)) {
                    ODBOLog.getLogger(ODBOLogEnum.LOG_INIT_TERM).log(LogLevel.ERROR, "Exception caught in ODBODataProvider.cTerminate: ", ex);
                }
                throw new ODBORuntimeException(ODBOMessageKeys.INI_BRIDGE_TERM_ERROR, ex);
            }
        }
    }

    private static native void cInitialize(boolean var0) throws NativeException;

    private static native void cTerminate() throws NativeException;

    static {
        String osname = System.getProperty("os.name");
        if (osname.indexOf("Windows") >= 0) {
            if (ODBOLog.isOn(ODBOLogEnum.LOG_INIT_TERM)) {
                ODBOLog.getLogger(ODBOLogEnum.LOG_INIT_TERM).log("Loading ODBOBridge DLL.");
            }
        } else {
            if (ODBOLog.isOn(ODBOLogEnum.LOG_INIT_TERM)) {
                ODBOLog.getLogger(ODBOLogEnum.LOG_INIT_TERM).log("Unsupported plaform for MSAS, ODBOBridge DLL not loaded.");
            }
            throw new ODBORuntimeException(ODBOMessageKeys.INI_UNSUPPORTED_PLATFORM, osname);
        }
        System.loadLibrary("ODBOBridge");
    }

    protected final class ODBOConnectionFactory
    implements IConnectionFactory {
        protected ODBOConnectionFactory() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object createConnection(ConnectionParameters connectionParameters) {
            ExecutorService comExecutorService = null;
            comExecutorService = ODBODataProvider.this.useMultiThreadedCOM() ? new ODBOPassThroughExecutor() : Executors.newSingleThreadExecutor(COM_THREAD_FACTORY);
            ODBOConnection connection = null;
            try {
                if (ODBOLog.isOn(ODBOLogEnum.LOG_CONNECTION)) {
                    ODBOLog.getLogger(ODBOLogEnum.LOG_CONNECTION).log("ODBOConnectionFactory.createConnection: Attempting to create a new connection with parameters " + connectionParameters.toString());
                }
                connection = new ODBOConnection(ODBODataProvider.this, comExecutorService);
                connection.connect(connectionParameters);
            }
            finally {
                if (null == connection) {
                    if (ODBOLog.isOn(ODBOLogEnum.LOG_CONNECTION)) {
                        ODBOLog.getLogger(ODBOLogEnum.LOG_CONNECTION).log("ODBOConnectionFactory.createConnection: failed. Parameters " + connectionParameters.toString());
                    }
                } else {
                    List<XQEMessage> blackList;
                    if (ODBOLog.isOn(ODBOLogEnum.LOG_CONNECTION)) {
                        ODBOLog.getLogger(ODBOLogEnum.LOG_CONNECTION).log("ODBOConnectionFactory.createConnection: passed. Parameters " + connectionParameters.toString());
                    }
                    if (!(blackList = connection.getConnectionBlackListDetails()).isEmpty()) {
                        this.destroyConnection(connection);
                        connection = null;
                        XQEMessage message = blackList.get(0);
                        if (XQEMessageKeys.DS_DriverBlacklistedTestConnectionUI == message.getMessageKey()) {
                            ODBOLog.getLogger(ODBOLogEnum.LOG_CONNECTION).log("ODBOConnectionFactory.createConnection: The driver version " + message.getParams()[0] + " is black listed.");
                            throw new XQERuntimeException(XQEMessageKeys.DS_DriverBlacklistedTestConnectionUI, message.getParams()[0], message.getParams()[1]);
                        }
                        if (XQEMessageKeys.DS_ServerBlacklistedTestConnectionUI2 == message.getMessageKey()) {
                            ODBOLog.getLogger(ODBOLogEnum.LOG_CONNECTION).log("ODBOConnectionFactory.createConnection: The server version " + message.getParams()[1] + " is grey listed.");
                            throw new XQERuntimeException(XQEMessageKeys.DS_ServerBlacklistedTestConnectionUI2, message.getParams()[0], message.getParams()[1]);
                        }
                        throw new XQERuntimeException(XQEMessageKeys.GEN_FoundInternalError_INTERNAL);
                    }
                }
            }
            return connection;
        }

        public void destroyConnection(IPooledConnection pooledConnection) {
            this.destroyConnection((ODBOConnection)((Object)pooledConnection.getConnection()));
        }

        private void destroyConnection(ODBOConnection connection) {
            if (null == connection) {
                if (ODBOLog.isOn(ODBOLogEnum.LOG_CONNECTION)) {
                    ODBOLog.getLogger(ODBOLogEnum.LOG_CONNECTION).log("ODBOConnectionFactory.destroyConnection: There is no connection to destroy.");
                }
            } else {
                if (ODBOLog.isOn(ODBOLogEnum.LOG_CONNECTION)) {
                    ODBOLog.getLogger(ODBOLogEnum.LOG_CONNECTION).log("ODBOConnectionFactory.destroyConnection: Connection destroyed.");
                }
                connection.disconnect();
            }
        }
    }
}

