/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.data.providers.olap.odbo;

import com.cognos.xqe.data.olap.common.MSASCommonDatatypes;
import com.cognos.xqe.data.olap.common.MSASTypeGroupEnum;
import com.cognos.xqe.data.providers.olap.odbo.ODBOConnection;
import com.cognos.xqe.data.providers.olap.odbo.ODBOLog;
import com.cognos.xqe.data.providers.olap.odbo.ODBOLogEnum;
import com.cognos.xqe.data.providers.olap.odbo.ODBOMessageKeys;
import com.cognos.xqe.data.providers.olap.odbo.ODBORuntimeException;
import com.cognos.xqe.data.providers.olap.odbo.concurrent.ODBOThreadContext;
import com.cognos.xqe.data.providers.secbridge.ErrorStatus;
import com.cognos.xqe.data.providers.secbridge.NativeException;
import com.cognos.xqe.data.types.DataTypeFactory;
import com.cognos.xqe.data.types.IntegerType;
import com.cognos.xqe.data.types.LongType;
import com.cognos.xqe.data.values.BooleanValue;
import com.cognos.xqe.data.values.DataValueFactory;
import com.cognos.xqe.data.values.DoubleValue;
import com.cognos.xqe.data.values.IntegerValue;
import com.cognos.xqe.data.values.LongValue;
import com.cognos.xqe.data.values.StringValue;
import com.cognos.xqe.data.values.TimestampWithTZValue;
import com.cognos.xqe.data.values.Value;
import com.cognos.xqe.data.values.ValueState;
import com.cognos.xqe.trace.LogLevel;
import com.cognos.xqe.trace.TraceContext;
import com.cognos.xqe.util.context.ContextTransfer;
import com.cognos.xqe.util.context.ExecutionEnvironmentContext;
import java.util.Calendar;
import java.util.TimeZone;
import java.util.concurrent.Callable;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ODBORowset {
    private static final String COLON_SPACE = ": ";
    private static final String GMT_SUFFIX = "+00:00";
    protected long mRowsetHandle = 0L;
    protected int mColumnCount = -1;
    private int[] mColumnTypes;
    private String[] mColumnNames;
    protected ODBOConnection mODBOConnection = null;

    private static native void cReleaseRowset(long var0) throws NativeException;

    private void nativeReleaseRowset(final long rowsetHandle) throws NativeException {
        if (!ODBOThreadContext.isODBOThread()) {
            final ContextTransfer traceCtxTransfer = TraceContext.createTransfer();
            final ContextTransfer execEnvTransfer = ExecutionEnvironmentContext.createTransfer();
            Callable<Object> task = new Callable<Object>(){

                @Override
                public Object call() throws NativeException {
                    traceCtxTransfer.push();
                    execEnvTransfer.push();
                    try {
                        ODBORowset.cReleaseRowset(rowsetHandle);
                        Object var1_1 = null;
                        return var1_1;
                    }
                    finally {
                        execEnvTransfer.pop();
                        traceCtxTransfer.pop();
                    }
                }
            };
            this.mODBOConnection.invokeNativeCall(task);
        } else {
            ODBORowset.cReleaseRowset(rowsetHandle);
        }
    }

    private static native int cGetRowsetColumnCount(long var0) throws NativeException;

    private int nativeGetRowsetColumnCount(long rowsetHandle) throws NativeException {
        ODBOThreadContext.assertIsODBOThread();
        return ODBORowset.cGetRowsetColumnCount(rowsetHandle);
    }

    private static native String cGetRowsetColumnName(long var0, int var2) throws NativeException;

    private String nativeGetRowsetColumnName(long rowsetHandle, int index) throws NativeException {
        ODBOThreadContext.assertIsODBOThread();
        return ODBORowset.cGetRowsetColumnName(rowsetHandle, index);
    }

    private int nativeGetRowsetColumnScale(long rowsetHandle, int index) throws NativeException {
        ODBOThreadContext.assertIsODBOThread();
        return ODBORowset.cGetRowsetColumnScale(rowsetHandle, index);
    }

    private static native int cGetRowsetColumnType(long var0, int var2) throws NativeException;

    private Value nativeGetRowsetColumnValue(int index, boolean cannotBeTruncated) throws NativeException {
        ODBOThreadContext.assertIsODBOThread();
        return this.getColumnValueInternal(index, cannotBeTruncated);
    }

    private static native int cGetRowsetColumnStatus(long var0, int var2) throws NativeException;

    private int nativeGetRowsetColumnStatus(long rowsetHandle, int index) throws NativeException {
        ODBOThreadContext.assertIsODBOThread();
        return ODBORowset.cGetRowsetColumnStatus(rowsetHandle, index);
    }

    private static native int cGetRowsetColumnScale(long var0, int var2) throws NativeException;

    private static native String cGetRowsetStringColumn(long var0, int var2) throws NativeException;

    private String nativeGetRowsetStringColumn(long rowsetHandle, int column) throws NativeException {
        ODBOThreadContext.assertIsODBOThread();
        return ODBORowset.cGetRowsetStringColumn(rowsetHandle, column);
    }

    private static native long cGetRowsetIntegerColumn(long var0, int var2) throws NativeException;

    private long nativeGetRowsetIntegerColumn(long rowsetHandle, int column) throws NativeException {
        ODBOThreadContext.assertIsODBOThread();
        return ODBORowset.cGetRowsetIntegerColumn(rowsetHandle, column);
    }

    private static native double cGetRowsetDoubleColumn(long var0, int var2) throws NativeException;

    private static native boolean cGetRowsetNextRow(long var0) throws NativeException;

    private boolean nativeGetRowsetNextRow(long rowsetHandle) throws NativeException {
        ODBOThreadContext.assertIsODBOThread();
        return ODBORowset.cGetRowsetNextRow(rowsetHandle);
    }

    public ODBORowset(ODBOConnection connection, long handle) {
        this.mODBOConnection = connection;
        this.mRowsetHandle = handle;
        this.mColumnTypes = null;
        ODBORowset.assertRowsetHandleIsValid(this.mRowsetHandle);
    }

    public void close() {
        if (this.mRowsetHandle != 0L) {
            try {
                this.nativeReleaseRowset(this.mRowsetHandle);
            }
            catch (NativeException ex) {
                ErrorStatus status = ex.getErrorStatus();
                if (ODBOLog.isOn(ODBOLogEnum.LOG_PROVIDER_DATA_QUERY, LogLevel.ERROR)) {
                    StringBuilder msgBuffer = new StringBuilder();
                    msgBuffer.append("Error closing rowset: ").append(status);
                    ODBOLog.getLogger(ODBOLogEnum.LOG_PROVIDER_DATA_QUERY).log(LogLevel.ERROR, msgBuffer.toString());
                }
                this.mODBOConnection.checkForLostConnection(status);
                throw new ODBORuntimeException(ODBOMessageKeys.ROW_PROVIDER_ERROR_CLOSING_ROWSET, ex);
            }
            finally {
                this.mRowsetHandle = 0L;
                this.mODBOConnection = null;
            }
        }
    }

    public int getColumnCount() {
        ODBORowset.assertRowsetHandleIsValid(this.mRowsetHandle);
        if (this.mColumnCount == -1 && this.mRowsetHandle != 0L) {
            try {
                this.mColumnCount = this.nativeGetRowsetColumnCount(this.mRowsetHandle);
            }
            catch (NativeException ex) {
                ErrorStatus status = ex.getErrorStatus();
                if (ODBOLog.isOn(ODBOLogEnum.LOG_PROVIDER_DATA_QUERY, LogLevel.ERROR)) {
                    StringBuilder msgBuffer = new StringBuilder();
                    msgBuffer.append("Error retrieving rowset column count: ").append(status);
                    ODBOLog.getLogger(ODBOLogEnum.LOG_PROVIDER_DATA_QUERY).log(LogLevel.ERROR, msgBuffer.toString());
                }
                this.mODBOConnection.checkForLostConnection(status);
                throw new ODBORuntimeException(ODBOMessageKeys.GEN_GENERAL_PROVIDER_ERROR, ex);
            }
            this.mColumnTypes = new int[this.mColumnCount];
            this.mColumnNames = new String[this.mColumnCount];
            for (int i = 0; i < this.mColumnCount; ++i) {
                this.mColumnTypes[i] = -1;
                this.mColumnNames[i] = null;
            }
        }
        return this.mColumnCount;
    }

    public String getColumnName(int index) {
        if (this.mColumnNames == null) {
            this.getColumnCount();
        }
        if (index < this.mColumnNames.length) {
            if (this.mColumnNames[index] == null) {
                try {
                    ODBORowset.assertRowsetHandleIsValid(this.mRowsetHandle);
                    this.mColumnNames[index] = this.nativeGetRowsetColumnName(this.mRowsetHandle, index);
                }
                catch (NativeException ex) {
                    ErrorStatus status = ex.getErrorStatus();
                    if (ODBOLog.isOn(ODBOLogEnum.LOG_PROVIDER_DATA_QUERY, LogLevel.ERROR)) {
                        StringBuilder msgBuffer = new StringBuilder();
                        msgBuffer.append("Error retrieving rowset column name for index ").append(index).append(COLON_SPACE).append(status);
                        ODBOLog.getLogger(ODBOLogEnum.LOG_PROVIDER_DATA_QUERY).log(LogLevel.ERROR, msgBuffer.toString());
                    }
                    this.mODBOConnection.checkForLostConnection(status);
                    throw new ODBORuntimeException(ODBOMessageKeys.GEN_GENERAL_PROVIDER_ERROR, ex);
                }
            }
        } else {
            throw new ODBORuntimeException(ODBOMessageKeys.ROW_COLUMN_INDEX_ERROR);
        }
        String name = this.mColumnNames[index];
        return name;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private int getColumnType(int index) {
        if (this.mColumnTypes == null) {
            this.getColumnCount();
        }
        if (index >= this.mColumnTypes.length) throw new ODBORuntimeException(ODBOMessageKeys.ROW_COLUMN_INDEX_ERROR);
        if (this.mColumnTypes[index] != -1) return this.mColumnTypes[index];
        try {
            ODBOThreadContext.assertIsODBOThread();
            ODBORowset.assertRowsetHandleIsValid(this.mRowsetHandle);
            int type = ODBORowset.cGetRowsetColumnType(this.mRowsetHandle, index);
            if (this.mColumnNames[index].equals("VALUE")) return type;
            if (type == 1) return type;
            if (type == -1) return type;
            if (type == 0) return type;
            this.mColumnTypes[index] = type;
            return type;
        }
        catch (NativeException ex) {
            ErrorStatus status = ex.getErrorStatus();
            if (ODBOLog.isOn(ODBOLogEnum.LOG_PROVIDER_DATA_QUERY, LogLevel.ERROR)) {
                StringBuilder msgBuffer = new StringBuilder();
                msgBuffer.append("Error retrieving rowset column type for index ").append(index).append(COLON_SPACE).append(status);
                ODBOLog.getLogger(ODBOLogEnum.LOG_PROVIDER_DATA_QUERY).log(LogLevel.ERROR, msgBuffer.toString());
            }
            this.mODBOConnection.checkForLostConnection(status);
            throw new ODBORuntimeException(ODBOMessageKeys.GEN_GENERAL_PROVIDER_ERROR, ex);
        }
    }

    public boolean getNextRow() {
        ODBORowset.assertRowsetHandleIsValid(this.mRowsetHandle);
        boolean result = false;
        try {
            result = this.nativeGetRowsetNextRow(this.mRowsetHandle);
        }
        catch (NativeException ex) {
            ErrorStatus status = ex.getErrorStatus();
            if (ODBOLog.isOn(ODBOLogEnum.LOG_PROVIDER_DATA_QUERY, LogLevel.ERROR)) {
                StringBuilder msgBuffer = new StringBuilder();
                msgBuffer.append("Error retrieving next row from rowset").append(COLON_SPACE).append(status);
                ODBOLog.getLogger(ODBOLogEnum.LOG_PROVIDER_DATA_QUERY).log(LogLevel.ERROR, msgBuffer.toString());
            }
            this.mODBOConnection.checkForLostConnection(status);
            throw new ODBORuntimeException(ODBOMessageKeys.GEN_GENERAL_PROVIDER_ERROR, ex);
        }
        return result;
    }

    public int getColumnStatus(int index) {
        int colStatus = 12;
        ODBORowset.assertRowsetHandleIsValid(this.mRowsetHandle);
        try {
            colStatus = this.nativeGetRowsetColumnStatus(this.mRowsetHandle, index);
        }
        catch (NativeException ex) {
            ErrorStatus status = ex.getErrorStatus();
            if (ODBOLog.isOn(ODBOLogEnum.LOG_PROVIDER_DATA_QUERY, LogLevel.ERROR)) {
                StringBuilder msgBuffer = new StringBuilder();
                msgBuffer.append("Error retrieving rowset column status for index ").append(index).append(COLON_SPACE).append(status);
                ODBOLog.getLogger(ODBOLogEnum.LOG_PROVIDER_DATA_QUERY).log(LogLevel.ERROR, msgBuffer.toString());
            }
            this.mODBOConnection.checkForLostConnection(status);
            throw new ODBORuntimeException(ODBOMessageKeys.GEN_GENERAL_PROVIDER_ERROR, ex);
        }
        return colStatus;
    }

    private int getColumnScale(int index) {
        ODBORowset.assertRowsetHandleIsValid(this.mRowsetHandle);
        try {
            return this.nativeGetRowsetColumnScale(this.mRowsetHandle, index);
        }
        catch (NativeException ex) {
            ErrorStatus status = ex.getErrorStatus();
            if (ODBOLog.isOn(ODBOLogEnum.LOG_PROVIDER_DATA_QUERY, LogLevel.ERROR)) {
                StringBuilder msgBuffer = new StringBuilder();
                msgBuffer.append("Error retrieving rowset column scale for index ").append(index).append(COLON_SPACE).append(status);
                ODBOLog.getLogger(ODBOLogEnum.LOG_PROVIDER_DATA_QUERY).log(LogLevel.ERROR, msgBuffer.toString());
            }
            this.mODBOConnection.checkForLostConnection(status);
            throw new ODBORuntimeException(ODBOMessageKeys.GEN_GENERAL_PROVIDER_ERROR, ex);
        }
    }

    private Boolean getBooleanColumnWithStatus(int index, int colStatus) {
        ODBORowset.assertRowsetHandleIsValid(this.mRowsetHandle);
        Boolean bValue = null;
        if (colStatus == 0 || colStatus == 4) {
            try {
                long value = this.nativeGetRowsetIntegerColumn(this.mRowsetHandle, index);
                bValue = value != 0L ? Boolean.TRUE : Boolean.FALSE;
            }
            catch (NativeException ex) {
                ErrorStatus status = ex.getErrorStatus();
                if (ODBOLog.isOn(ODBOLogEnum.LOG_PROVIDER_DATA_QUERY, LogLevel.ERROR)) {
                    StringBuilder msgBuffer = new StringBuilder();
                    msgBuffer.append("Error retrieving rowset column integer value for index ").append(index).append(COLON_SPACE).append(status);
                    ODBOLog.getLogger(ODBOLogEnum.LOG_PROVIDER_DATA_QUERY).log(LogLevel.ERROR, msgBuffer.toString());
                }
                this.mODBOConnection.checkForLostConnection(status);
                throw new ODBORuntimeException(ODBOMessageKeys.GEN_GENERAL_PROVIDER_ERROR, ex);
            }
        }
        return bValue;
    }

    public Long getLongColumn(int index) {
        ODBORowset.assertRowsetHandleIsValid(this.mRowsetHandle);
        int colstatus = this.getColumnStatus(index);
        return this.getLongColumnWithStatus(index, colstatus);
    }

    private Double getDoubleColumnWithStatus(int index, int colStatus) {
        ODBORowset.assertRowsetHandleIsValid(this.mRowsetHandle);
        Double doubleValue = null;
        if (colStatus == 0 || colStatus == 4) {
            try {
                ODBOThreadContext.assertIsODBOThread();
                double value = ODBORowset.cGetRowsetDoubleColumn(this.mRowsetHandle, index);
                doubleValue = new Double(value);
            }
            catch (NativeException ex) {
                ErrorStatus status = ex.getErrorStatus();
                if (ODBOLog.isOn(ODBOLogEnum.LOG_PROVIDER_DATA_QUERY, LogLevel.ERROR)) {
                    StringBuilder msgBuffer = new StringBuilder();
                    msgBuffer.append("Error retrieving rowset column double value for index ").append(index).append(COLON_SPACE).append(status);
                    ODBOLog.getLogger(ODBOLogEnum.LOG_PROVIDER_DATA_QUERY).log(LogLevel.ERROR, msgBuffer.toString());
                }
                this.mODBOConnection.checkForLostConnection(status);
                throw new ODBORuntimeException(ODBOMessageKeys.GEN_GENERAL_PROVIDER_ERROR, ex);
            }
        }
        return doubleValue;
    }

    public String getStringColumn(int index, boolean cannotBeTruncated) {
        int colStatus = this.getColumnStatus(index);
        return this.getStringColumnWithStatus(index, cannotBeTruncated, colStatus);
    }

    public Value getColumnValue(int index, boolean cannotBeTruncated) {
        try {
            return this.nativeGetRowsetColumnValue(index, cannotBeTruncated);
        }
        catch (NativeException ex) {
            ErrorStatus status = ex.getErrorStatus();
            if (ODBOLog.isOn(ODBOLogEnum.LOG_PROVIDER_DATA_QUERY, LogLevel.ERROR)) {
                StringBuilder msgBuffer = new StringBuilder();
                msgBuffer.append("Error retrieving rowset column value: ").append(status);
                ODBOLog.getLogger(ODBOLogEnum.LOG_PROVIDER_DATA_QUERY).log(LogLevel.ERROR, msgBuffer.toString());
            }
            this.mODBOConnection.checkForLostConnection(status);
            throw new ODBORuntimeException(ODBOMessageKeys.GEN_GENERAL_PROVIDER_ERROR, ex);
        }
    }

    private Value getColumnValueInternal(int index, boolean cannotBeTruncated) {
        int status = this.getColumnStatus(index);
        BooleanValue result = null;
        if (status == 0 || status == 4 || status == 3) {
            int columnType = this.getColumnType(index);
            switch (columnType) {
                case -1: 
                case 0: {
                    break;
                }
                case 1: {
                    DoubleValue doubleNullValue = DataValueFactory.createDoubleValue();
                    doubleNullValue.setNull();
                    result = doubleNullValue;
                    break;
                }
                case 11: {
                    BooleanValue bValue;
                    result = bValue = DataValueFactory.createBooleanValue();
                    if (status != 3) {
                        Boolean bResult = this.getBooleanColumnWithStatus(index, status);
                        if (bResult != null) {
                            bValue.set(bResult.booleanValue());
                            break;
                        }
                        bValue.setNull();
                        break;
                    }
                    bValue.setNull();
                    break;
                }
                case 2: 
                case 3: 
                case 16: 
                case 17: 
                case 18: 
                case 19: {
                    IntegerValue iValue;
                    int iScale = this.getColumnScale(index);
                    if (255 == iScale) {
                        iValue = DataValueFactory.createIntegerValue((IntegerType)IntegerType.INTEGERTYPE);
                    } else {
                        IntegerType intType = DataTypeFactory.getIntegerType((int)iScale);
                        iValue = DataValueFactory.createIntegerValue((IntegerType)intType);
                    }
                    if (status != 3) {
                        Long iResult = this.getLongColumnWithStatus(index, status);
                        if (iResult != null) {
                            iValue.set(iResult.intValue());
                        } else {
                            iValue.setNull();
                        }
                    } else {
                        iValue.setNull();
                    }
                    result = iValue;
                    break;
                }
                case 20: 
                case 21: {
                    LongValue lValue;
                    int lScale = this.getColumnScale(index);
                    if (255 == lScale) {
                        lValue = DataValueFactory.createLongValue((LongType)LongType.LONGTYPE);
                    } else {
                        LongType longType = DataTypeFactory.getLongType((int)lScale);
                        lValue = DataValueFactory.createLongValue((LongType)longType);
                    }
                    if (status != 3) {
                        Long lResult = this.getLongColumnWithStatus(index, status);
                        if (lResult != null) {
                            lValue.set(lResult.longValue());
                        } else {
                            lValue.setNull();
                        }
                    } else {
                        lValue.setNull();
                    }
                    result = lValue;
                    break;
                }
                case 6: {
                    LongType currencyType = DataTypeFactory.getLongType((int)4);
                    LongValue cValue = DataValueFactory.createLongValue((LongType)currencyType);
                    if (status != 3) {
                        Long cResult = this.getLongColumnWithStatus(index, status);
                        if (cResult != null) {
                            cValue.set(cResult.longValue());
                        } else {
                            cValue.setNull();
                        }
                    } else {
                        cValue.setNull();
                    }
                    result = cValue;
                    break;
                }
                case 4: 
                case 5: 
                case 14: 
                case 131: {
                    DoubleValue dValue = DataValueFactory.createDoubleValue();
                    if (status != 3) {
                        Double dResult = this.getDoubleColumnWithStatus(index, status);
                        if (dResult != null) {
                            dValue.set(dResult.doubleValue());
                        } else {
                            dValue.setNull();
                        }
                    } else {
                        dValue.setNull();
                    }
                    result = dValue;
                    break;
                }
                case 7: {
                    String sDateValue = null;
                    if (status != 3) {
                        sDateValue = this.getStringColumnWithStatus(index, cannotBeTruncated, status);
                    }
                    result = MSASCommonDatatypes.convertTimestampToDateTime((String)sDateValue, (status == 3 ? 1 : 0) != 0);
                    break;
                }
                case 10: {
                    DoubleValue dValue = DataValueFactory.createDoubleValue();
                    dValue.setState(ValueState.ERROR);
                    result = dValue;
                    break;
                }
                default: {
                    StringValue strValue = DataValueFactory.createStringValue();
                    if (status != 3) {
                        String sValue = this.getStringColumnWithStatus(index, cannotBeTruncated, status);
                        if (sValue != null) {
                            strValue.set(sValue);
                        } else {
                            strValue.setNull();
                        }
                    } else {
                        strValue.setNull();
                    }
                    result = strValue;
                }
            }
        }
        return result;
    }

    public String getStringColumnWithStatus(int index, boolean cannotBeTruncated, int colStatus) {
        String value = null;
        if (colStatus == 0 || colStatus == 4) {
            try {
                value = this.nativeGetRowsetStringColumn(this.mRowsetHandle, index);
            }
            catch (NativeException ex) {
                ErrorStatus status = ex.getErrorStatus();
                if (ODBOLog.isOn(ODBOLogEnum.LOG_PROVIDER_DATA_QUERY, LogLevel.ERROR)) {
                    StringBuilder msgBuffer = new StringBuilder();
                    msgBuffer.append("Error retrieving rowset column string value for index ").append(index).append(COLON_SPACE).append(status);
                    ODBOLog.getLogger(ODBOLogEnum.LOG_PROVIDER_DATA_QUERY).log(LogLevel.ERROR, msgBuffer.toString());
                }
                this.mODBOConnection.checkForLostConnection(status);
                throw new ODBORuntimeException(ODBOMessageKeys.GEN_GENERAL_PROVIDER_ERROR, ex);
            }
        }
        if (4 == colStatus) {
            String columnName = this.getColumnName(index);
            if (cannotBeTruncated) {
                throw new ODBORuntimeException(ODBOMessageKeys.ROW_TRUNCATED_COLUMN, columnName, value);
            }
            if (ODBOLog.isOn(ODBOLogEnum.LOG_PROVIDER_DATA_QUERY, LogLevel.ERROR)) {
                StringBuilder msgBuffer = new StringBuilder();
                msgBuffer.append("Error retrieving rowset column due to truncation ");
                msgBuffer.append(index).append(COLON_SPACE).append(columnName);
                msgBuffer.append(", value=").append(value);
                ODBOLog.getLogger(ODBOLogEnum.LOG_PROVIDER_DATA_QUERY).log(LogLevel.ERROR, msgBuffer.toString());
            }
        }
        return value;
    }

    private Long getLongColumnWithStatus(int index, int colStatus) {
        ODBORowset.assertRowsetHandleIsValid(this.mRowsetHandle);
        Long longValue = null;
        if (colStatus == 0 || colStatus == 4) {
            try {
                long value = this.nativeGetRowsetIntegerColumn(this.mRowsetHandle, index);
                longValue = new Long(value);
            }
            catch (NativeException ex) {
                ErrorStatus errStatus = ex.getErrorStatus();
                if (ODBOLog.isOn(ODBOLogEnum.LOG_PROVIDER_DATA_QUERY, LogLevel.ERROR)) {
                    StringBuilder msgBuffer = new StringBuilder();
                    msgBuffer.append("Error retrieving rowset column long value for index ").append(index).append(COLON_SPACE).append(errStatus);
                    ODBOLog.getLogger(ODBOLogEnum.LOG_PROVIDER_DATA_QUERY).log(LogLevel.ERROR, msgBuffer.toString());
                }
                this.mODBOConnection.checkForLostConnection(errStatus);
                throw new ODBORuntimeException(ODBOMessageKeys.GEN_GENERAL_PROVIDER_ERROR, ex);
            }
        }
        return longValue;
    }

    public TimestampWithTZValue convertStringToTimestampWithTZ(String ts, boolean isNull) {
        Pattern expression = Pattern.compile("-[0-9][0-9]:[0-9][0-9]");
        TimestampWithTZValue result = DataValueFactory.createTimestampWithTZValue();
        if (!isNull) {
            if (ts != null) {
                if (ts.indexOf(122) == -1 && ts.indexOf(90) == -1 && ts.indexOf(43) == -1) {
                    int dashIndex = ts.lastIndexOf(45);
                    if (-1 != dashIndex) {
                        Matcher matcher = expression.matcher(ts);
                        if (!matcher.matches()) {
                            ts = ts + GMT_SUFFIX;
                        }
                    } else {
                        ts = ts + GMT_SUFFIX;
                    }
                }
                result.set(ts);
                long millis = result.getMilliseconds();
                long offset = TimeZone.getDefault().getOffset(Calendar.getInstance().getTimeInMillis());
                result.set(millis -= offset);
            } else {
                result.setNull();
            }
        } else {
            result.setNull();
        }
        return result;
    }

    public MSASTypeGroupEnum getColumnTypeGroup(int index) {
        int type = this.getColumnType(index);
        return MSASTypeGroupEnum.getTypeGroup((int)type);
    }

    private static void assertRowsetHandleIsValid(long handle) {
        if (0L == handle) {
            throw new ODBORuntimeException(ODBOMessageKeys.ROW_INVALID_ROWSET_HANDLE);
        }
    }
}

