/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.bibus.rolap.aggregateAdvisor.client;

import com.cognos.developer.schemas.bibus._3.BiBusHeader;
import com.cognos.xqe.bibus.rolap.aggregateAdvisor.AggregateAdvisorOptionName;
import com.cognos.xqe.bibus.rolap.aggregateAdvisor.AggregateAdvisorPropertyName;
import com.cognos.xqe.bibus.rolap.aggregateAdvisor.client.AggregateAdvisorCurrentWorkloadReply;
import com.cognos.xqe.bibus.rolap.aggregateAdvisor.client.AggregateAdvisorOption;
import com.cognos.xqe.bibus.rolap.aggregateAdvisor.client.AggregateAdvisorOptionBoolean;
import com.cognos.xqe.bibus.rolap.aggregateAdvisor.client.AggregateAdvisorOptionInt;
import com.cognos.xqe.bibus.rolap.aggregateAdvisor.client.AggregateAdvisorOptionLong;
import com.cognos.xqe.bibus.rolap.aggregateAdvisor.client.AggregateAdvisorOptionString;
import com.cognos.xqe.bibus.rolap.aggregateAdvisor.client.AggregateAdvisorProperty;
import com.cognos.xqe.bibus.rolap.aggregateAdvisor.client.AggregateAdvisorRecommendations;
import com.cognos.xqe.bibus.rolap.aggregateAdvisor.client.AggregateAdvisorRecommendationsReply;
import com.cognos.xqe.bibus.rolap.aggregateAdvisor.client.AggregateAdvisorReply;
import com.cognos.xqe.bibus.rolap.aggregateAdvisor.client.AggregateAdvisorRetrieveRecommendationsReply;
import com.cognos.xqe.bibus.rolap.aggregateAdvisor.client.AggregateAdvisorStoreRecommendationReply;
import com.cognos.xqe.bibus.rolap.aggregateAdvisor.client.exception.AACMessageKeys;
import com.cognos.xqe.bibus.rolap.aggregateAdvisor.client.exception.AACRuntimeException;
import com.cognos.xqe.bibus.rolap.aggregateAdvisor.client.log.AggregateAdvisorClientLogger;
import com.cognos.xqe.bibus.rolap.aggregateAdvisor.client.util.BiBusHeaderUtility;
import com.cognos.xqe.bibus.rolap.aggregateAdvisor.client.util.SOAPUtility;
import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.logging.Level;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;
import org.apache.axis.message.SOAPHeaderElement;
import org.w3c.dom.DOMException;

public class AggregateAdvisorClient {
    private static AggregateAdvisorClientLogger logger = AggregateAdvisorClientLogger.getSingleInstance();
    private String host;
    private int port;
    private String serverGroup;
    private String namespace;
    private String user;
    private String password;
    private URL dispatcherURL;
    private SOAPMessage lastResponseMessage;
    private BiBusHeader biBusHeader;
    private String productLocale;

    @Deprecated
    public AggregateAdvisorClient(URL theDispatcherURL, String theServerGroup, String theNamespace, String theUser, String thePassword, String theProductLocale) {
        this.dispatcherURL = theDispatcherURL;
        this.initialize(theServerGroup, theNamespace, theUser, thePassword, theProductLocale);
    }

    public AggregateAdvisorClient(URL theDispatcherURL, BiBusHeader theBiBusHeader) {
        this.dispatcherURL = theDispatcherURL;
        this.biBusHeader = theBiBusHeader;
        if (AggregateAdvisorClient.getLogger().isLogging(Level.INFO)) {
            AggregateAdvisorClient.getLogger().log(Level.INFO, String.format("dispatcherURL = %s", this.dispatcherURL));
            AggregateAdvisorClient.getLogger().log(Level.INFO, String.format("biBusHeader = %s", BiBusHeaderUtility.serializeBiBusHeader(this.biBusHeader)));
        }
    }

    @Deprecated
    public void setSecuredBiBusHeader(SOAPHeaderElement biBusHeaderElement) {
        if (biBusHeaderElement != null) {
            this.biBusHeader = BiBusHeaderUtility.getBiBusHeader(biBusHeaderElement);
        }
    }

    private javax.xml.soap.SOAPHeaderElement getBiBusHeader() throws SOAPException {
        javax.xml.soap.SOAPHeaderElement biBusHeaderElement = this.lastResponseMessage == null ? BiBusHeaderUtility.getBiBusHeaderElement(this.biBusHeader) : BiBusHeaderUtility.getBiBusHeaderElement(this.lastResponseMessage);
        return biBusHeaderElement;
    }

    @Deprecated
    public synchronized AggregateAdvisorRecommendationsReply startAggregateAdvisor(String cubeName, List<AggregateAdvisorOption> options) throws SOAPException {
        return this.startAggregateAdvisor(cubeName, null, options);
    }

    public synchronized AggregateAdvisorRecommendationsReply startAggregateAdvisor(String cubeName, List<AggregateAdvisorProperty> properties, List<AggregateAdvisorOption> options) throws SOAPException {
        AggregateAdvisorClient.throwExceptionIfOptionsAreInvalid(options);
        SOAPMessage requestMessage = SOAPUtility.createRequestMessageToStartAggregateAdvisor(this.getBiBusHeader(), cubeName, properties, options);
        SOAPMessage responseMessage = this.sendRequestMessage(requestMessage);
        return SOAPUtility.extractAggregateAdvisorRecommendationsReply(responseMessage, "startAggregateAdvisor");
    }

    public synchronized AggregateAdvisorRecommendationsReply getAggregateAdvisorRecommendations() throws SOAPException {
        try {
            SOAPMessage requestMessage = SOAPUtility.createRequestMessageToGetAggregateAdvisorRecommendations(this.getBiBusHeader());
            SOAPMessage responseMessage = this.sendRequestMessage(requestMessage);
            return SOAPUtility.extractAggregateAdvisorRecommendationsReply(responseMessage, "getAggregateAdvisorRecommendations");
        }
        catch (DOMException e) {
            AggregateAdvisorClient.getLogger().log(Level.SEVERE, "Failed to create the request message to get the aggregate advisor recommendations", e);
            throw AACRuntimeException.wrap(AACMessageKeys.GEN_FailedToCreateRequestToGetAggregateAdvisorRecommendations, e);
        }
    }

    public synchronized AggregateAdvisorCurrentWorkloadReply getCurrentWorkloadForAggregateAdvisor(String cubeName) throws SOAPException {
        SOAPMessage requestMessage = SOAPUtility.createRequestMessageToGetCurrentWorkloadForAggregateAdvisor(this.getBiBusHeader(), cubeName);
        SOAPMessage responseMessage = this.sendRequestMessage(requestMessage);
        return SOAPUtility.extractWorkloadReply(responseMessage);
    }

    public synchronized AggregateAdvisorRecommendationsReply stopAggregateAdvisorRecommendations(boolean getRecommendations) throws SOAPException {
        SOAPMessage requestMessage = SOAPUtility.createRequestMessageToStopAggregateAdvisor(this.getBiBusHeader(), getRecommendations);
        SOAPMessage responseMessage = this.sendRequestMessage(requestMessage);
        return SOAPUtility.extractAggregateAdvisorRecommendationsReply(responseMessage, "stopAggregateAdvisor");
    }

    public synchronized AggregateAdvisorRetrieveRecommendationsReply retrieveInitialAggregateAdvisorRecommendations(List<AggregateAdvisorOption> options) throws SOAPException {
        AggregateAdvisorClient.throwExceptionIfOptionsAreInvalid(options);
        SOAPMessage requestMessage = SOAPUtility.createRequestMessageToRetrieveInitialRecommendations(this.getBiBusHeader(), options);
        SOAPMessage responseMessage = this.sendRequestMessage(requestMessage);
        return SOAPUtility.extractAggregateAdvisorRetrieveRecommendationsReply(responseMessage, "retrieveInitialAggregateAdvisorRecommendations");
    }

    public synchronized AggregateAdvisorRetrieveRecommendationsReply retrieveSubsequentAggregateAdvisorRecommendations() throws SOAPException {
        SOAPMessage requestMessage = SOAPUtility.createRequestMessageToRetrieveSubsequentRecommendations(this.getBiBusHeader());
        SOAPMessage responseMessage = this.sendRequestMessage(requestMessage);
        return SOAPUtility.extractAggregateAdvisorRetrieveRecommendationsReply(responseMessage, "retrieveSubsequentAggregateAdvisorRecommendations");
    }

    public synchronized AggregateAdvisorStoreRecommendationReply storeAggregateAdvisorRecommendation(List<AggregateAdvisorProperty> properties, AggregateAdvisorRecommendations recommendations) throws SOAPException {
        AggregateAdvisorClient.addProperty(AggregateAdvisorProperty.PROPERTY_CLIENT_VERSION, properties);
        SOAPMessage requestMessage = SOAPUtility.createRequestMessageToStoreAggregateAdvisorRecommendation(this.getBiBusHeader(), properties, recommendations);
        SOAPMessage responseMessage = this.sendRequestMessage(requestMessage);
        return SOAPUtility.extractAggregateAdvisorStoreRecommendationReply(responseMessage, "storeAggregateAdvisorRecommendation");
    }

    public synchronized AggregateAdvisorReply migrateAggregateAdvisorRecommendation(AggregateAdvisorRecommendationsReply recommendationsReply) throws SOAPException {
        if (recommendationsReply != null) {
            recommendationsReply.addProperty(AggregateAdvisorPropertyName.CLIENT_VERSION.toString(), "1");
        }
        SOAPMessage requestMessage = SOAPUtility.createRequestMessageToMigrateAggregateAdvisorRecommendation(this.getBiBusHeader(), recommendationsReply);
        SOAPMessage responseMessage = this.sendRequestMessage(requestMessage);
        return SOAPUtility.extractAggregateAdvisorReply(responseMessage, "migrateAggregateAdvisorRecommendation");
    }

    public synchronized AggregateAdvisorReply updateAggregateAdvisorRecommendationName(String cubeName, String recommendationID, String recommendationName) throws SOAPException {
        SOAPMessage requestMessage = SOAPUtility.createRequestMessageToUpdateAggregateAdvisorRecommendationName(this.getBiBusHeader(), cubeName, recommendationID, recommendationName);
        SOAPMessage responseMessage = this.sendRequestMessage(requestMessage);
        return SOAPUtility.extractAggregateAdvisorReply(responseMessage, "updateAggregateAdvisorRecommendationName");
    }

    public synchronized AggregateAdvisorReply deleteAggregateAdvisorRecommendations(String cubeName, List<String> recommendationIDs) throws SOAPException {
        SOAPMessage requestMessage = SOAPUtility.createRequestMessageToDeleteAggregateAdvisorRecommendations(this.getBiBusHeader(), cubeName, recommendationIDs);
        SOAPMessage responseMessage = this.sendRequestMessage(requestMessage);
        return SOAPUtility.extractAggregateAdvisorReply(responseMessage, "deleteAggregateAdvisorRecommendations");
    }

    public synchronized AggregateAdvisorReply replaceAggregateAdvisorSession(String sessionID) throws SOAPException {
        SOAPMessage requestMessage = SOAPUtility.createRequestMessageToReplaceAggregateAdvisorSession(this.getBiBusHeader(), sessionID);
        SOAPMessage responseMessage = this.sendRequestMessage(requestMessage);
        return SOAPUtility.extractAggregateAdvisorReply(responseMessage, "replaceAggregateAdvisorSession");
    }

    private SOAPMessage sendRequestMessage(SOAPMessage requestMessage) throws SOAPException {
        this.lastResponseMessage = SOAPUtility.sendRequestMessage(requestMessage, this.dispatcherURL);
        return this.lastResponseMessage;
    }

    private void initialize(String theServerGroup, String theNamespace, String theUser, String thePassword, String theProductLocale) {
        this.serverGroup = theServerGroup;
        this.namespace = theNamespace;
        this.user = theUser;
        this.password = thePassword;
        if (theProductLocale == null) {
            Locale defaultLocale = Locale.getDefault();
            this.productLocale = LocaleConverter.getLanguage(defaultLocale);
        } else {
            this.productLocale = theProductLocale;
            Locale.setDefault(new Locale(theProductLocale));
        }
        this.logInputParameters();
    }

    private void logInputParameters() {
        if (AggregateAdvisorClient.getLogger().isLogging(Level.FINE)) {
            StringBuilder sb = new StringBuilder();
            sb.append("Input parameters:\n");
            sb.append(String.format("  host = %s%n", this.host));
            sb.append(String.format("  port = %d%n", this.port));
            sb.append(String.format("  server group = %s%n", this.serverGroup));
            sb.append(String.format("  namespace = %s%n", this.namespace));
            sb.append(String.format("  user = %s%n", this.user));
            sb.append(String.format("  dispatcher URL = %s%n", this.dispatcherURL));
            sb.append(String.format("  product locale = %s%n", this.productLocale));
            sb.append(String.format("  default locale = %s%n", LocaleConverter.toString(Locale.getDefault())));
            AggregateAdvisorClient.getLogger().log(Level.FINE, sb.toString());
        }
    }

    private static void addProperty(AggregateAdvisorProperty property, List<AggregateAdvisorProperty> properties) {
        if (properties == null) {
            return;
        }
        String propertyName = property.getName();
        Iterator<AggregateAdvisorProperty> propertiesIterator = properties.iterator();
        while (propertiesIterator.hasNext()) {
            AggregateAdvisorProperty currentProperty = propertiesIterator.next();
            if (!propertyName.equals(currentProperty.getName())) continue;
            propertiesIterator.remove();
        }
        properties.add(property);
    }

    public static AggregateAdvisorClientLogger getLogger() {
        return logger;
    }

    private static void throwExceptionIfOptionsAreInvalid(List<AggregateAdvisorOption> options) {
        if (options == null || options.isEmpty()) {
            return;
        }
        for (AggregateAdvisorOption option : options) {
            String optionName = option.getName();
            AggregateAdvisorOptionName aggregateAdvisorOptionName = AggregateAdvisorOptionName.getOption(optionName);
            Class<?> optionValueType = aggregateAdvisorOptionName.getValueType();
            if (!(optionValueType == Boolean.TYPE ? !(option instanceof AggregateAdvisorOptionBoolean) : (optionValueType == Integer.TYPE ? !(option instanceof AggregateAdvisorOptionInt) : (optionValueType == Long.TYPE ? !(option instanceof AggregateAdvisorOptionLong) : optionValueType == String.class && !(option instanceof AggregateAdvisorOptionString))))) continue;
            throw new AACRuntimeException(AACMessageKeys.OPT_InvalidValueTypeForOption, optionName, optionValueType.toString());
        }
    }

    static class LocaleConverter {
        protected static final Map<String, String> JAVALANGUAGE_ICULANGUAGE_MAP = new HashMap<String, String>(){
            {
                this.put("iw", "he");
                this.put("ji", "yi");
                this.put("in", "id");
            }
        };

        LocaleConverter() {
        }

        public static String getLanguage(Locale locale) {
            String language = locale.getLanguage();
            String icuLanguage = JAVALANGUAGE_ICULANGUAGE_MAP.get(language);
            if (icuLanguage != null) {
                language = icuLanguage;
            }
            return language;
        }

        public static String toString(Locale locale) {
            String toString = locale.toString();
            String language = locale.getLanguage();
            String icuLanguage = JAVALANGUAGE_ICULANGUAGE_MAP.get(language);
            if (icuLanguage != null) {
                toString = toString.replaceFirst(language, icuLanguage);
            }
            return toString;
        }
    }
}

