/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.bibus.rolap.aggregateAdvisor.client.sample;

import com.cognos.developer.schemas.bibus._3.BiBusHeader;
import com.cognos.mfw4j.utilities.ThreadSafeDateFormat;
import com.cognos.xqe.bibus.rolap.aggregateAdvisor.AggregateAdvisorConstants;
import com.cognos.xqe.bibus.rolap.aggregateAdvisor.AggregateAdvisorOptionName;
import com.cognos.xqe.bibus.rolap.aggregateAdvisor.AggregateAdvisorProgressPoint;
import com.cognos.xqe.bibus.rolap.aggregateAdvisor.AggregateAdvisorPropertyName;
import com.cognos.xqe.bibus.rolap.aggregateAdvisor.AggregateAdvisorState;
import com.cognos.xqe.bibus.rolap.aggregateAdvisor.client.AggregateAdvisorClient;
import com.cognos.xqe.bibus.rolap.aggregateAdvisor.client.AggregateAdvisorCurrentWorkloadReply;
import com.cognos.xqe.bibus.rolap.aggregateAdvisor.client.AggregateAdvisorOption;
import com.cognos.xqe.bibus.rolap.aggregateAdvisor.client.AggregateAdvisorOptionFactory;
import com.cognos.xqe.bibus.rolap.aggregateAdvisor.client.AggregateAdvisorProperty;
import com.cognos.xqe.bibus.rolap.aggregateAdvisor.client.AggregateAdvisorRecommendations;
import com.cognos.xqe.bibus.rolap.aggregateAdvisor.client.AggregateAdvisorRecommendationsReply;
import com.cognos.xqe.bibus.rolap.aggregateAdvisor.client.AggregateAdvisorRecommendedAggregate;
import com.cognos.xqe.bibus.rolap.aggregateAdvisor.client.AggregateAdvisorRecommendedAggregates;
import com.cognos.xqe.bibus.rolap.aggregateAdvisor.client.AggregateAdvisorReply;
import com.cognos.xqe.bibus.rolap.aggregateAdvisor.client.AggregateAdvisorRetrieveRecommendationsReply;
import com.cognos.xqe.bibus.rolap.aggregateAdvisor.client.AggregateAdvisorStoreRecommendationReply;
import com.cognos.xqe.bibus.rolap.aggregateAdvisor.client.exception.AACException;
import com.cognos.xqe.bibus.rolap.aggregateAdvisor.client.exception.AACMessageKeys;
import com.cognos.xqe.bibus.rolap.aggregateAdvisor.client.exception.AACRuntimeException;
import com.cognos.xqe.bibus.rolap.aggregateAdvisor.client.sample.AggregateAdvisorCommand;
import com.cognos.xqe.bibus.rolap.aggregateAdvisor.client.sample.AggregateAdvisorCommandLineOption;
import com.cognos.xqe.bibus.rolap.aggregateAdvisor.client.sample.log.LogFormatter;
import com.cognos.xqe.bibus.rolap.aggregateAdvisor.client.sample.util.HeaderUtility;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.URL;
import java.nio.charset.Charset;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.StringTokenizer;
import java.util.logging.FileHandler;
import java.util.logging.Level;
import javax.xml.soap.SOAPException;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;

public class AggregateAdvisorClientApplication {
    private static final String DELIMITER = ";";
    private static final String RESPONSE = "RESPONSE";
    private static final String DS = "  ";
    private static final String RECOMMENDED_AGGREGATES_TYPE_IN_DATABASE = "Database";
    private static final String RECOMMENDED_AGGREGATES_TYPE_IN_MEMORY = "Memory";
    private static final String OUTPUT_STRING_NONE = "None";
    private static final String DEFAULT_WAIT_TIME = "1000";
    public static final ThreadSafeDateFormat DATE_TIME_FORMAT = new ThreadSafeDateFormat(String.format("%s %s", AggregateAdvisorConstants.WORKLOAD_LOG_DATE_FORMAT.toPattern(), AggregateAdvisorConstants.WORKLOAD_LOG_TIME_FORMAT.toPattern()));
    public static final ThreadSafeDateFormat TIME_FORMAT = AggregateAdvisorConstants.WORKLOAD_LOG_TIME_FORMAT;
    private static final String MSG_ARG_IS_INVALID = "Invalid %s: %s";
    private static final String USAGE_PREFIX = "Usage: ";
    private static final int USAGE_DESCRIPTION_PADDING = 1;
    private static final int USAGE_WIDTH = 79;
    private static final Charset CHARSET_UTF8 = Charset.forName("UTF-8");
    private static Options commandLineOptions;
    private static AggregateAdvisorCommand command;
    private static String host;
    private static int port;
    private static String namespace;
    private static String user;
    private static String password;
    private static String locale;
    private static String logLevel;
    private static String logFile;
    private static String cubeName;
    private static String outputDirectoryName;
    private static String inputFileName;
    private static String recommendationIDToUpdate;
    private static String recommendationName;
    private static List<String> recommendationIDsToDelete;
    private static String sessionID;
    private static int waitTime;
    private static List<AggregateAdvisorOption> aggregateAdvisorOptions;
    private static int stopWaitTime;
    private static int cancelWaitTime;
    private static final String DEFAULT_STOP_CANCEL_WAIT_TIME;
    private static final String OUTPUT_STRING_STOP_REQUEST = "stopAggregateAdvisor(%s)";

    public static void main(String[] args) throws Exception {
        AggregateAdvisorClientApplication.parseArgs(args);
        AggregateAdvisorClientApplication.setupLogging();
        URL dispatcherURL = new URL("http", host, port, "/p2pd/servlet/dispatch");
        BiBusHeader biBusHeader = HeaderUtility.getBiBusHeader(dispatcherURL, namespace, user, password, locale);
        AggregateAdvisorClient advisorClient = new AggregateAdvisorClient(dispatcherURL, biBusHeader);
        if (command == AggregateAdvisorCommand.START_ADVISOR) {
            AggregateAdvisorClientApplication.startAdvisorAndGetRecommendations(advisorClient);
        } else if (command == AggregateAdvisorCommand.GET_CURRENT_WORKLOAD) {
            AggregateAdvisorClientApplication.getCurrentWorkloadForAggregateAdvisor(advisorClient);
        } else if (command == AggregateAdvisorCommand.RETRIEVE_RECOMMENDATIONS) {
            AggregateAdvisorClientApplication.retrieveRecommendations(advisorClient);
        } else if (command == AggregateAdvisorCommand.STORE_RECOMMENDATION) {
            AggregateAdvisorClientApplication.storeRecommendation(advisorClient);
        } else if (command == AggregateAdvisorCommand.MIGRATE_RECOMMENDATION) {
            AggregateAdvisorClientApplication.migrateRecommendation(advisorClient);
        } else if (command == AggregateAdvisorCommand.UPDATE_RECOMMENDATION_NAME) {
            AggregateAdvisorClientApplication.updateRecommendationName(advisorClient);
        } else if (command == AggregateAdvisorCommand.DELETE_RECOMMENDATIONS) {
            AggregateAdvisorClientApplication.deleteRecommendations(advisorClient);
        } else if (command == AggregateAdvisorCommand.REPLACE_SESSION) {
            AggregateAdvisorClientApplication.replaceSession(advisorClient);
        }
    }

    private static void setupLogging() throws IOException {
        if (logLevel != null && logLevel.length() > 0) {
            try {
                AggregateAdvisorClient.getLogger().setLevel(Level.parse(logLevel));
            }
            catch (IllegalArgumentException ex) {
                AggregateAdvisorClientApplication.println(String.format(MSG_ARG_IS_INVALID, AggregateAdvisorCommandLineOption.LOGLEVEL.getName(), logLevel));
                AggregateAdvisorClientApplication.println("");
                AggregateAdvisorClientApplication.printUsage();
            }
        }
        if (logFile != null && logFile.length() > 0) {
            FileHandler fileHandler = new FileHandler(logFile);
            fileHandler.setFormatter(new LogFormatter());
            AggregateAdvisorClient.getLogger().setHandler(fileHandler);
        }
    }

    private static void getCurrentWorkloadForAggregateAdvisor(AggregateAdvisorClient advisorClient) throws SOAPException {
        AggregateAdvisorClientApplication.printRequest(String.format("getCurrentWorkloadForAggregateAdvisor(%s)", cubeName));
        AggregateAdvisorCurrentWorkloadReply reply = advisorClient.getCurrentWorkloadForAggregateAdvisor(cubeName);
        AggregateAdvisorClientApplication.printReply(reply);
    }

    private static void startAdvisorAndGetRecommendations(AggregateAdvisorClient advisorClient) throws SOAPException {
        List<AggregateAdvisorProperty> properties = AggregateAdvisorClientApplication.createProperties();
        AggregateAdvisorClientApplication.printRequest(String.format("startAggregateAdvisor(%s, %s, %s)", cubeName, properties, aggregateAdvisorOptions));
        AggregateAdvisorRecommendationsReply reply = advisorClient.startAggregateAdvisor(cubeName, properties, aggregateAdvisorOptions);
        AggregateAdvisorClientApplication.printReply(reply, true);
        AggregateAdvisorClientApplication.getRecommendationsOrStopAdvisor(advisorClient, reply);
    }

    private static void getRecommendationsOrStopAdvisor(AggregateAdvisorClient advisorClient, AggregateAdvisorRecommendationsReply reply) throws SOAPException {
        try {
            long startAdvisorTime = System.currentTimeMillis();
            while (reply == null || !reply.getState().isDone()) {
                Thread.sleep(waitTime);
                long elapsedTime = System.currentTimeMillis() - startAdvisorTime;
                if (elapsedTime > (long)stopWaitTime && reply != null && reply.getState().isOptimizing()) {
                    AggregateAdvisorClientApplication.printRequest(String.format(OUTPUT_STRING_STOP_REQUEST, true));
                    reply = advisorClient.stopAggregateAdvisorRecommendations(true);
                } else if (elapsedTime > (long)cancelWaitTime) {
                    AggregateAdvisorClientApplication.printRequest(String.format(OUTPUT_STRING_STOP_REQUEST, false));
                    reply = advisorClient.stopAggregateAdvisorRecommendations(false);
                } else {
                    AggregateAdvisorClientApplication.printRequest("getAggregateAdvisorRecommendations()");
                    reply = advisorClient.getAggregateAdvisorRecommendations();
                }
                AggregateAdvisorClientApplication.printReply(reply, true);
            }
        }
        catch (InterruptedException ie) {
            AggregateAdvisorClientApplication.println(ie.getMessage());
            AggregateAdvisorClientApplication.println("");
            throw new AACRuntimeException(AACMessageKeys.INT_ThreadSleepFailed);
        }
        AggregateAdvisorClientApplication.saveRecommendations(reply);
    }

    private static void retrieveRecommendations(AggregateAdvisorClient advisorClient) throws Exception {
        if (user != null) {
            aggregateAdvisorOptions.add(AggregateAdvisorOptionFactory.createOption(AggregateAdvisorOptionName.USER_ID, user));
        } else {
            aggregateAdvisorOptions.add(AggregateAdvisorOptionFactory.createOption(AggregateAdvisorOptionName.USER_ID, "Anonymous"));
        }
        AggregateAdvisorClientApplication.printRequest(String.format("retrieveInitialAggregateAdvisorRecommendations(%s)", aggregateAdvisorOptions));
        AggregateAdvisorRetrieveRecommendationsReply reply = advisorClient.retrieveInitialAggregateAdvisorRecommendations(aggregateAdvisorOptions);
        AggregateAdvisorClientApplication.processReply(reply);
        try {
            while (!reply.getState().isDone()) {
                Thread.sleep(waitTime);
                AggregateAdvisorClientApplication.printRequest("retrieveSubsequentAggregateAdvisorRecommendations()");
                reply = advisorClient.retrieveSubsequentAggregateAdvisorRecommendations();
                AggregateAdvisorClientApplication.processReply(reply);
            }
        }
        catch (InterruptedException ie) {
            AggregateAdvisorClientApplication.println(ie.getMessage());
            AggregateAdvisorClientApplication.println("");
            throw new AACRuntimeException(AACMessageKeys.INT_ThreadSleepFailed);
        }
    }

    private static void storeRecommendation(AggregateAdvisorClient advisorClient) throws Exception {
        Element rootElement = AggregateAdvisorClientApplication.getRootElement(inputFileName);
        if (rootElement == null) {
            return;
        }
        List<AggregateAdvisorProperty> properties = AggregateAdvisorClientApplication.extractProperties(rootElement);
        AggregateAdvisorRecommendations recommendations = AggregateAdvisorClientApplication.extractRecommendations(rootElement);
        AggregateAdvisorClientApplication.printRequest(String.format("storeAggregateAdvisorRecommendation(%s)", inputFileName));
        AggregateAdvisorStoreRecommendationReply storeRecommendationReply = advisorClient.storeAggregateAdvisorRecommendation(properties, recommendations);
        AggregateAdvisorClientApplication.processReply(storeRecommendationReply);
    }

    private static void migrateRecommendation(AggregateAdvisorClient advisorClient) throws Exception {
        Element rootElement = AggregateAdvisorClientApplication.getRootElement(inputFileName);
        if (rootElement == null) {
            return;
        }
        AggregateAdvisorState state = AggregateAdvisorClientApplication.extractState(rootElement);
        List<String> messages = AggregateAdvisorClientApplication.extractMessages(rootElement);
        List<AggregateAdvisorOption> options = AggregateAdvisorClientApplication.extractOptions(rootElement);
        List<AggregateAdvisorProperty> properties = AggregateAdvisorClientApplication.extractProperties(rootElement);
        AggregateAdvisorRecommendations recommendations = AggregateAdvisorClientApplication.extractRecommendations(rootElement);
        AggregateAdvisorRecommendationsReply recommendationsReply = AggregateAdvisorClientApplication.createAggregateAdvisorRecommendationsReply(state, messages, options, properties, recommendations);
        AggregateAdvisorClientApplication.printRequest(String.format("migrateAggregateAdvisorRecommendation(%s)", inputFileName));
        AggregateAdvisorReply migrateRecommendationReply = advisorClient.migrateAggregateAdvisorRecommendation(recommendationsReply);
        AggregateAdvisorClientApplication.printAggregateAdvisorReply(migrateRecommendationReply);
    }

    private static Element getRootElement(String fileName) throws Exception {
        File file = new File(fileName);
        if (!file.exists()) {
            AggregateAdvisorClientApplication.println(String.format("The file \"%s\" does not exist.", fileName));
            return null;
        }
        SAXReader saxReader = new SAXReader();
        Document document = saxReader.read(file);
        return document.getRootElement();
    }

    private static AggregateAdvisorRecommendationsReply createAggregateAdvisorRecommendationsReply(AggregateAdvisorState state, List<String> messages, List<AggregateAdvisorOption> options, List<AggregateAdvisorProperty> properties, AggregateAdvisorRecommendations recommendations) {
        AggregateAdvisorRecommendationsReply reply = new AggregateAdvisorRecommendationsReply();
        reply.setState(state);
        for (String message : messages) {
            reply.addMessage(message);
        }
        for (AggregateAdvisorOption option : options) {
            reply.addOption(option);
        }
        for (AggregateAdvisorProperty property : properties) {
            reply.addProperty(property.getName(), property.getValue());
        }
        reply.setRecommendations(recommendations);
        return reply;
    }

    private static AggregateAdvisorState extractState(Element rootElement) {
        AggregateAdvisorState aggregateAdvisorState = null;
        Element stateElement = rootElement.element("state");
        if (stateElement != null) {
            String stateString = stateElement.getText();
            aggregateAdvisorState = AggregateAdvisorState.getValue(stateString);
        }
        return aggregateAdvisorState;
    }

    private static List<String> extractMessages(Element rootElement) {
        ArrayList<String> messages = new ArrayList<String>();
        Element messagesElement = rootElement.element("messages");
        if (messagesElement != null) {
            List messageElements = messagesElement.elements("message");
            for (Element messageElement : messageElements) {
                String message = messageElement.getText();
                messages.add(message);
            }
        }
        return messages;
    }

    private static List<AggregateAdvisorOption> extractOptions(Element rootElement) throws Exception {
        ArrayList<AggregateAdvisorOption> optionsToReturn = new ArrayList<AggregateAdvisorOption>();
        Element optionsElement = rootElement.element("options");
        if (optionsElement != null) {
            List optionElements = optionsElement.elements("option");
            for (Element optionElement : optionElements) {
                String optionName = optionElement.elementText("name");
                String optionValueAsString = optionElement.elementText("value");
                AggregateAdvisorOption aggregateAdvisorOption = null;
                AggregateAdvisorOptionName aggregateAdvisorOptionName = AggregateAdvisorOptionName.getOption(optionName);
                if (aggregateAdvisorOptionName != null) {
                    Class<?> optionValueType = aggregateAdvisorOptionName.getValueType();
                    if (optionValueType == Boolean.TYPE) {
                        boolean optionValueAsBoolean = Boolean.parseBoolean(optionValueAsString);
                        aggregateAdvisorOption = AggregateAdvisorOptionFactory.createOption(aggregateAdvisorOptionName, optionValueAsBoolean);
                    } else if (optionValueType == Integer.TYPE) {
                        int optionValueAsInt = Integer.parseInt(optionValueAsString);
                        aggregateAdvisorOption = AggregateAdvisorOptionFactory.createOption(aggregateAdvisorOptionName, optionValueAsInt);
                    } else if (optionValueType == Long.TYPE) {
                        long optionValueAsLong = Long.parseLong(optionValueAsString);
                        aggregateAdvisorOption = AggregateAdvisorOptionFactory.createOption(aggregateAdvisorOptionName, optionValueAsLong);
                    } else if (optionValueType == String.class) {
                        aggregateAdvisorOption = AggregateAdvisorOptionFactory.createOption(aggregateAdvisorOptionName, optionValueAsString);
                    }
                }
                if (aggregateAdvisorOption == null) continue;
                optionsToReturn.add(aggregateAdvisorOption);
            }
        }
        return optionsToReturn;
    }

    private static List<AggregateAdvisorProperty> extractProperties(Element rootElement) {
        ArrayList<AggregateAdvisorProperty> aggregateAdvisorProperties = new ArrayList<AggregateAdvisorProperty>();
        Element propertiesElement = rootElement.element("properties");
        if (propertiesElement != null) {
            List propertyElements = propertiesElement.elements();
            for (Element propertyElement : propertyElements) {
                String propertyName = propertyElement.elementText("name");
                String propertyValue = propertyElement.elementText("value");
                AggregateAdvisorPropertyName aggregateAdvisorPropertyName = AggregateAdvisorPropertyName.getValue(propertyName);
                AggregateAdvisorProperty aggregateAdvisorProperty = new AggregateAdvisorProperty(aggregateAdvisorPropertyName, propertyValue);
                aggregateAdvisorProperties.add(aggregateAdvisorProperty);
            }
        }
        return aggregateAdvisorProperties;
    }

    private static AggregateAdvisorRecommendations extractRecommendations(Element rootElement) {
        Element recommendationsElement = rootElement.element("recommendations");
        if (recommendationsElement == null) {
            return null;
        }
        AggregateAdvisorRecommendations recommendationsObject = new AggregateAdvisorRecommendations();
        Element recommendedAggregatesInDatabaseElement = recommendationsElement.element("recommendedAggregatesInDatabase");
        AggregateAdvisorRecommendedAggregates recommendedAggregatesInDatabaseObject = AggregateAdvisorClientApplication.extractRecommendedAggregatesInDatabaseOrMemory(recommendedAggregatesInDatabaseElement);
        recommendationsObject.setRecommendedAggregatesInDatabase(recommendedAggregatesInDatabaseObject);
        Element recommendedAggregatesInMemoryElement = recommendationsElement.element("recommendedAggregatesInMemory");
        AggregateAdvisorRecommendedAggregates recommendedAggregatesInMemoryObject = AggregateAdvisorClientApplication.extractRecommendedAggregatesInDatabaseOrMemory(recommendedAggregatesInMemoryElement);
        recommendationsObject.setRecommendedAggregatesInMemory(recommendedAggregatesInMemoryObject);
        return recommendationsObject;
    }

    private static AggregateAdvisorRecommendedAggregates extractRecommendedAggregatesInDatabaseOrMemory(Element recommendedAggregatesInDatabaseOrMemoryElement) {
        if (recommendedAggregatesInDatabaseOrMemoryElement == null) {
            return null;
        }
        AggregateAdvisorRecommendedAggregates recommendedAggregatesInDatabaseOrMemoryObject = new AggregateAdvisorRecommendedAggregates();
        String metaInfoText = recommendedAggregatesInDatabaseOrMemoryElement.elementText("metaInfoText");
        recommendedAggregatesInDatabaseOrMemoryObject.setMetaInfoAsText(metaInfoText);
        String metaInfoXML = recommendedAggregatesInDatabaseOrMemoryElement.elementText("metaInfoXML");
        recommendedAggregatesInDatabaseOrMemoryObject.setMetaInfoAsXML(metaInfoXML);
        int count = Integer.parseInt(recommendedAggregatesInDatabaseOrMemoryElement.elementText("count"));
        recommendedAggregatesInDatabaseOrMemoryObject.setCount(count);
        int coverage = Integer.parseInt(recommendedAggregatesInDatabaseOrMemoryElement.elementText("coverage"));
        recommendedAggregatesInDatabaseOrMemoryObject.setEstimatedCoverage(coverage);
        long spaceRequired = Long.parseLong(recommendedAggregatesInDatabaseOrMemoryElement.elementText("spaceRequired"));
        recommendedAggregatesInDatabaseOrMemoryObject.setEstimatedSpaceRequired(spaceRequired);
        AggregateAdvisorClientApplication.extractRecommendedAggregates(recommendedAggregatesInDatabaseOrMemoryElement, recommendedAggregatesInDatabaseOrMemoryObject);
        return recommendedAggregatesInDatabaseOrMemoryObject;
    }

    private static void extractRecommendedAggregates(Element recommendedAggregatesInDatabaseOrMemoryElement, AggregateAdvisorRecommendedAggregates recommendedAggregatesInDatabaseOrMemoryObject) {
        Element recommendedAggregatesElement = recommendedAggregatesInDatabaseOrMemoryElement.element("recommendedAggregates");
        if (recommendedAggregatesElement == null) {
            return;
        }
        List recommendedAggregateElements = recommendedAggregatesElement.elements();
        for (Element recommendedAggregateElement : recommendedAggregateElements) {
            AggregateAdvisorRecommendedAggregate recommendedAggregateObject = AggregateAdvisorClientApplication.extractRecommendedAggregate(recommendedAggregateElement);
            recommendedAggregatesInDatabaseOrMemoryObject.addRecommendedAggregate(recommendedAggregateObject);
        }
    }

    private static AggregateAdvisorRecommendedAggregate extractRecommendedAggregate(Element recommendedAggregateElement) {
        Element measuresElement;
        AggregateAdvisorRecommendedAggregate recommendedAggregateObject = new AggregateAdvisorRecommendedAggregate();
        String aggregateName = recommendedAggregateElement.elementText("name");
        recommendedAggregateObject.setName(aggregateName);
        long size = Long.parseLong(recommendedAggregateElement.elementText("size"));
        recommendedAggregateObject.setSize(size);
        Element levelsElement = recommendedAggregateElement.element("levels");
        if (levelsElement != null) {
            List levelElements = levelsElement.elements();
            for (Element levelElement : levelElements) {
                String levelName = levelElement.getText();
                recommendedAggregateObject.addLevel(levelName);
            }
        }
        if ((measuresElement = recommendedAggregateElement.element("measures")) != null) {
            List measureElements = measuresElement.elements();
            for (Element measureElement : measureElements) {
                String measureName = measureElement.getText();
                recommendedAggregateObject.addMeasure(measureName);
            }
        }
        return recommendedAggregateObject;
    }

    private static void updateRecommendationName(AggregateAdvisorClient advisorClient) throws Exception {
        AggregateAdvisorClientApplication.printRequest(String.format("updateAggregateAdvisorRecommendationName(%s, %s, %s)", cubeName, recommendationIDToUpdate, recommendationName));
        AggregateAdvisorReply reply = advisorClient.updateAggregateAdvisorRecommendationName(cubeName, recommendationIDToUpdate, recommendationName);
        AggregateAdvisorClientApplication.printAggregateAdvisorReply(reply);
    }

    private static void deleteRecommendations(AggregateAdvisorClient advisorClient) throws Exception {
        AggregateAdvisorClientApplication.printRequest(String.format("deleteAggregateAdvisorRecommendations(%s, %s)", cubeName, recommendationIDsToDelete));
        AggregateAdvisorReply reply = advisorClient.deleteAggregateAdvisorRecommendations(cubeName, recommendationIDsToDelete);
        AggregateAdvisorClientApplication.printAggregateAdvisorReply(reply);
    }

    private static void replaceSession(AggregateAdvisorClient advisorClient) throws Exception {
        AggregateAdvisorClientApplication.printRequest(String.format("replaceAggregateAdvisorSession(%s)", sessionID));
        AggregateAdvisorReply reply = advisorClient.replaceAggregateAdvisorSession(sessionID);
        AggregateAdvisorClientApplication.printAggregateAdvisorReply(reply);
        if (reply.getState().isSucceeded()) {
            AggregateAdvisorClientApplication.getRecommendationsOrStopAdvisor(advisorClient, null);
        }
    }

    private static List<AggregateAdvisorProperty> createProperties() {
        ArrayList<AggregateAdvisorProperty> properties = new ArrayList<AggregateAdvisorProperty>();
        if (user != null && !user.isEmpty()) {
            properties.add(new AggregateAdvisorProperty(AggregateAdvisorPropertyName.USER_ID, user));
        } else {
            properties.add(AggregateAdvisorProperty.PROPERTY_USERID_ANONYMOUS);
        }
        properties.add(new AggregateAdvisorProperty(AggregateAdvisorPropertyName.RECOMMENDATION_NAME, String.format("%s - %s", cubeName, DATE_TIME_FORMAT.format(new Date(System.currentTimeMillis())))));
        return properties;
    }

    private static void parseArgs(String[] args) throws AACException {
        try {
            GnuParser commandLineParser = new GnuParser();
            CommandLine commandLine = commandLineParser.parse(AggregateAdvisorClientApplication.getCommandLineOptions(), args);
            command = AggregateAdvisorClientApplication.parseArgAsAggregateAdvisorCommand(commandLine, AggregateAdvisorCommandLineOption.COMMAND.getName());
            host = AggregateAdvisorClientApplication.parseArgAsString(commandLine, AggregateAdvisorCommandLineOption.HOST.getName());
            port = AggregateAdvisorClientApplication.parseArgAsInt(commandLine, AggregateAdvisorCommandLineOption.PORT.getName());
            cubeName = AggregateAdvisorClientApplication.parseArgAsString(commandLine, AggregateAdvisorCommandLineOption.CUBE.getName());
            outputDirectoryName = AggregateAdvisorClientApplication.parseArgAsString(commandLine, AggregateAdvisorCommandLineOption.OUTPUT_DIRECTORY.getName());
            inputFileName = AggregateAdvisorClientApplication.parseArgAsString(commandLine, AggregateAdvisorCommandLineOption.INPUT_FILE.getName());
            recommendationIDToUpdate = AggregateAdvisorClientApplication.parseArgAsString(commandLine, AggregateAdvisorCommandLineOption.RECOMMENDATION_ID.getName());
            recommendationName = AggregateAdvisorClientApplication.parseArgAsString(commandLine, AggregateAdvisorCommandLineOption.RECOMMENDATION_NAME.getName());
            recommendationIDsToDelete = AggregateAdvisorClientApplication.parseArgAsStringList(commandLine, AggregateAdvisorCommandLineOption.RECOMMENDATION_IDS.getName());
            sessionID = AggregateAdvisorClientApplication.parseArgAsString(commandLine, AggregateAdvisorCommandLineOption.SESSION_ID.getName());
            waitTime = AggregateAdvisorClientApplication.parseArgAsNonNegativeInt(commandLine, AggregateAdvisorCommandLineOption.WAIT_TIME.getName(), DEFAULT_WAIT_TIME);
            stopWaitTime = AggregateAdvisorClientApplication.parseArgAsNonNegativeInt(commandLine, AggregateAdvisorCommandLineOption.STOP_ADVISOR_WAIT_TIME.getName(), DEFAULT_STOP_CANCEL_WAIT_TIME);
            cancelWaitTime = AggregateAdvisorClientApplication.parseArgAsNonNegativeInt(commandLine, AggregateAdvisorCommandLineOption.CANCEL_ADVISOR_WAIT_TIME.getName(), DEFAULT_STOP_CANCEL_WAIT_TIME);
            namespace = AggregateAdvisorClientApplication.parseArgAsString(commandLine, AggregateAdvisorCommandLineOption.NAMESPACE.getName());
            user = AggregateAdvisorClientApplication.parseArgAsString(commandLine, AggregateAdvisorCommandLineOption.USER.getName());
            password = AggregateAdvisorClientApplication.parseArgAsString(commandLine, AggregateAdvisorCommandLineOption.PASSWORD.getName());
            locale = AggregateAdvisorClientApplication.parseArgAsString(commandLine, AggregateAdvisorCommandLineOption.LOCALE.getName());
            logLevel = AggregateAdvisorClientApplication.parseArgAsString(commandLine, AggregateAdvisorCommandLineOption.LOGLEVEL.getName());
            logFile = AggregateAdvisorClientApplication.parseArgAsString(commandLine, AggregateAdvisorCommandLineOption.LOGFILE.getName());
            AggregateAdvisorClientApplication.parseArgAsAggregateAdvisorOptionBoolean(commandLine, AggregateAdvisorCommandLineOption.INCLUDE_WORKLOAD_INFO.getName(), AggregateAdvisorOptionName.INCLUDE_WORKLOAD_INFO);
            AggregateAdvisorClientApplication.parseArgAsAggregateAdvisorOptionBoolean(commandLine, AggregateAdvisorCommandLineOption.USE_WORKLOAD_ONLY.getName(), AggregateAdvisorOptionName.USE_WORKLOAD_ONLY);
            AggregateAdvisorClientApplication.parseArgAsAggregateAdvisorOptionBoolean(commandLine, AggregateAdvisorCommandLineOption.USER_DEFINED_AGGREGATES_ONLY.getName(), AggregateAdvisorOptionName.USER_DEFINED_AGGREGATES_ONLY);
            AggregateAdvisorClientApplication.parseArgAsAggregateAdvisorOptionLong(commandLine, AggregateAdvisorCommandLineOption.IN_MEMORY_AGGREGATES_LIMIT.getName(), AggregateAdvisorOptionName.IN_MEMORY_AGGREGATES_LIMIT);
            AggregateAdvisorClientApplication.parseArgAsAggregateAdvisorOptionLong(commandLine, AggregateAdvisorCommandLineOption.IN_DATABASE_AGGREGATES_LIMIT.getName(), AggregateAdvisorOptionName.IN_DATABASE_AGGREGATES_LIMIT);
            AggregateAdvisorClientApplication.parseArgAsAggregateAdvisorOptionInt(commandLine, AggregateAdvisorCommandLineOption.RUN_TIME_LIMIT.getName(), AggregateAdvisorOptionName.RUN_TIME_LIMIT);
            AggregateAdvisorClientApplication.parseArgAsAggregateAdvisorOptionLong(commandLine, AggregateAdvisorCommandLineOption.START_TIME.getName(), AggregateAdvisorOptionName.START_TIME);
            AggregateAdvisorClientApplication.parseArgAsAggregateAdvisorOptionLong(commandLine, AggregateAdvisorCommandLineOption.END_TIME.getName(), AggregateAdvisorOptionName.END_TIME);
            AggregateAdvisorClientApplication.parseArgAsAggregateAdvisorOptionStringToIntMask(commandLine, AggregateAdvisorCommandLineOption.DAYS_OF_THE_WEEK.getName(), AggregateAdvisorOptionName.DAYS_OF_THE_WEEK);
            AggregateAdvisorClientApplication.parseArgAsAggregateAdvisorOptionString(commandLine, AggregateAdvisorCommandLineOption.PACKAGE_NAMES.getName(), AggregateAdvisorOptionName.PACKAGE_NAMES);
            AggregateAdvisorClientApplication.parseArgAsAggregateAdvisorOptionString(commandLine, AggregateAdvisorCommandLineOption.REPORT_NAMES.getName(), AggregateAdvisorOptionName.REPORT_NAMES);
            AggregateAdvisorClientApplication.parseArgAsAggregateAdvisorOptionString(commandLine, AggregateAdvisorCommandLineOption.USER_NAMES.getName(), AggregateAdvisorOptionName.USER_NAMES);
            AggregateAdvisorClientApplication.parseArgAsAggregateAdvisorOptionInt(commandLine, AggregateAdvisorCommandLineOption.REPORT_USAGE.getName(), AggregateAdvisorOptionName.REPORT_USAGE);
            AggregateAdvisorClientApplication.printUsageIfCommandArgsAreMissing();
        }
        catch (org.apache.commons.cli.ParseException e) {
            AggregateAdvisorClientApplication.println(e.getMessage());
            AggregateAdvisorClientApplication.println("");
            AggregateAdvisorClientApplication.printUsage();
        }
    }

    private static AggregateAdvisorCommand parseArgAsAggregateAdvisorCommand(CommandLine commandLine, String argumentName) {
        AggregateAdvisorCommand[] aggregateAdvisorCommands;
        String argumentValue = AggregateAdvisorClientApplication.parseArgAsString(commandLine, argumentName);
        AggregateAdvisorCommand cmd = null;
        for (AggregateAdvisorCommand aggregateAdvisorCommand : aggregateAdvisorCommands = AggregateAdvisorCommand.values()) {
            if (!aggregateAdvisorCommand.toString().equals(argumentValue)) continue;
            cmd = aggregateAdvisorCommand;
            break;
        }
        if (cmd == null) {
            AggregateAdvisorClientApplication.println(String.format(MSG_ARG_IS_INVALID, argumentName, argumentValue));
            AggregateAdvisorClientApplication.println("");
            AggregateAdvisorClientApplication.printUsage();
        }
        return cmd;
    }

    private static List<String> parseArgAsStringList(CommandLine commandLine, String name) {
        ArrayList<String> stringList = new ArrayList<String>();
        if (commandLine.hasOption(name)) {
            String delimitedString = AggregateAdvisorClientApplication.parseArgAsString(commandLine, name);
            StringTokenizer tokenizer = new StringTokenizer(delimitedString, DELIMITER);
            while (tokenizer.hasMoreTokens()) {
                stringList.add(tokenizer.nextToken());
            }
        }
        return stringList;
    }

    private static String parseArgAsString(CommandLine commandLine, String name) {
        return commandLine.getOptionValue(name);
    }

    private static int parseArgAsInt(CommandLine commandLine, String name) {
        String stringValue = AggregateAdvisorClientApplication.parseArgAsString(commandLine, name);
        return AggregateAdvisorClientApplication.parseArgAsInt(name, stringValue);
    }

    private static int parseArgAsNonNegativeInt(CommandLine commandLine, String name, String defaultValue) {
        String stringValue = commandLine.getOptionValue(name, defaultValue);
        int intValue = AggregateAdvisorClientApplication.parseArgAsInt(name, stringValue);
        if (intValue < 0) {
            AggregateAdvisorClientApplication.println(String.format(MSG_ARG_IS_INVALID, name, stringValue));
            System.exit(1);
        }
        return intValue;
    }

    private static int parseArgAsInt(String name, String value) {
        int intValue = 0;
        try {
            intValue = Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            AggregateAdvisorClientApplication.println(String.format(MSG_ARG_IS_INVALID, name, value));
            System.exit(1);
        }
        return intValue;
    }

    private static long parseArgAsLong(CommandLine commandLine, String name) {
        String stringValue = AggregateAdvisorClientApplication.parseArgAsString(commandLine, name);
        Date dateValue = null;
        try {
            dateValue = DATE_TIME_FORMAT.parse(stringValue);
        }
        catch (ParseException e) {
            try {
                dateValue = TIME_FORMAT.parse(stringValue);
            }
            catch (ParseException pe) {
                try {
                    long longValue = Long.parseLong(stringValue);
                    return longValue;
                }
                catch (NumberFormatException nfe) {
                    AggregateAdvisorClientApplication.println(String.format(MSG_ARG_IS_INVALID, name, stringValue));
                    System.exit(1);
                }
            }
        }
        return dateValue.getTime();
    }

    private static void parseArgAsAggregateAdvisorOptionBoolean(CommandLine commandLine, String commandLineOptionName, AggregateAdvisorOptionName aggregateAdvisorOptionName) {
        if (commandLine.hasOption(commandLineOptionName)) {
            aggregateAdvisorOptions.add(AggregateAdvisorOptionFactory.createOption(aggregateAdvisorOptionName, true));
        }
    }

    private static void parseArgAsAggregateAdvisorOptionInt(CommandLine commandLine, String commandLineOptionName, AggregateAdvisorOptionName aggregateAdvisorOptionName) throws AACException {
        if (commandLine.hasOption(commandLineOptionName)) {
            int value = AggregateAdvisorClientApplication.parseArgAsInt(commandLine, commandLineOptionName);
            aggregateAdvisorOptions.add(AggregateAdvisorOptionFactory.createOption(aggregateAdvisorOptionName, value));
        }
    }

    private static void parseArgAsAggregateAdvisorOptionLong(CommandLine commandLine, String commandLineOptionName, AggregateAdvisorOptionName aggregateAdvisorOptionName) {
        if (commandLine.hasOption(commandLineOptionName)) {
            long value = AggregateAdvisorClientApplication.parseArgAsLong(commandLine, commandLineOptionName);
            aggregateAdvisorOptions.add(AggregateAdvisorOptionFactory.createOption(aggregateAdvisorOptionName, value));
        }
    }

    private static void parseArgAsAggregateAdvisorOptionString(CommandLine commandLine, String commandLineOptionName, AggregateAdvisorOptionName aggregateAdvisorOptionName) throws AACException {
        if (commandLine.hasOption(commandLineOptionName)) {
            String value = AggregateAdvisorClientApplication.parseArgAsString(commandLine, commandLineOptionName);
            aggregateAdvisorOptions.add(AggregateAdvisorOptionFactory.createOption(aggregateAdvisorOptionName, value));
        }
    }

    private static int getMaskedValue(int mask, String flag) {
        if (flag.compareToIgnoreCase("Monday") == 0) {
            mask |= 1;
        } else if (flag.compareToIgnoreCase("Tuesday") == 0) {
            mask |= 2;
        } else if (flag.compareToIgnoreCase("Wednesday") == 0) {
            mask |= 4;
        } else if (flag.compareToIgnoreCase("Thursday") == 0) {
            mask |= 8;
        } else if (flag.compareToIgnoreCase("Friday") == 0) {
            mask |= 0x10;
        } else if (flag.compareToIgnoreCase("Saturday") == 0) {
            mask |= 0x20;
        } else if (flag.compareToIgnoreCase("Sunday") == 0) {
            mask |= 0x40;
        }
        return mask;
    }

    private static void parseArgAsAggregateAdvisorOptionStringToIntMask(CommandLine commandLine, String commandLineOptionName, AggregateAdvisorOptionName aggregateAdvisorOptionName) throws AACException {
        if (commandLine.hasOption(commandLineOptionName)) {
            int value = 0;
            String listOfFlags = AggregateAdvisorClientApplication.parseArgAsString(commandLine, commandLineOptionName);
            StringTokenizer tokenizer = new StringTokenizer(listOfFlags, DELIMITER);
            while (tokenizer.hasMoreTokens()) {
                value = AggregateAdvisorClientApplication.getMaskedValue(value, tokenizer.nextToken());
            }
            aggregateAdvisorOptions.add(AggregateAdvisorOptionFactory.createOption(aggregateAdvisorOptionName, value));
        }
    }

    private static void printUsageIfCommandArgsAreMissing() {
        if (command == AggregateAdvisorCommand.START_ADVISOR) {
            AggregateAdvisorClientApplication.printUsageIfCommandArgsAreMissingForStart();
        } else if (command == AggregateAdvisorCommand.GET_CURRENT_WORKLOAD) {
            AggregateAdvisorClientApplication.printUsageIfCommandArgsAreMissingForGetCurrentWorkload();
        } else if (command == AggregateAdvisorCommand.RETRIEVE_RECOMMENDATIONS) {
            AggregateAdvisorClientApplication.printUsageIfCommandArgsAreMissingForRetrieveRecommendations();
        } else if (command == AggregateAdvisorCommand.STORE_RECOMMENDATION) {
            AggregateAdvisorClientApplication.printUsageIfCommandArgsAreMissingForStoreRecommendation();
        } else if (command == AggregateAdvisorCommand.MIGRATE_RECOMMENDATION) {
            AggregateAdvisorClientApplication.printUsageIfCommandArgsAreMissingForMigrateRecommendation();
        } else if (command == AggregateAdvisorCommand.UPDATE_RECOMMENDATION_NAME) {
            AggregateAdvisorClientApplication.printUsageIfCommandArgsAreMissingForUpdateRecommendationName();
        } else if (command == AggregateAdvisorCommand.DELETE_RECOMMENDATIONS) {
            AggregateAdvisorClientApplication.printUsageIfCommandArgsAreMissingForDeleteRecommendations();
        } else if (command == AggregateAdvisorCommand.REPLACE_SESSION) {
            AggregateAdvisorClientApplication.printUsageIfCommandArgsAreMissingForReplaceSession();
        }
    }

    private static void printUsageIfCommandArgsAreMissingForStart() {
        if (cubeName == null) {
            AggregateAdvisorClientApplication.printUsageAsCommandArgIsMissing(AggregateAdvisorCommandLineOption.CUBE);
        }
        if (outputDirectoryName == null) {
            AggregateAdvisorClientApplication.printUsageAsCommandArgIsMissing(AggregateAdvisorCommandLineOption.OUTPUT_DIRECTORY);
        }
    }

    private static void printUsageIfCommandArgsAreMissingForGetCurrentWorkload() {
        if (cubeName == null) {
            AggregateAdvisorClientApplication.printUsageAsCommandArgIsMissing(AggregateAdvisorCommandLineOption.CUBE);
        }
    }

    private static void printUsageIfCommandArgsAreMissingForRetrieveRecommendations() {
        if (outputDirectoryName == null) {
            AggregateAdvisorClientApplication.printUsageAsCommandArgIsMissing(AggregateAdvisorCommandLineOption.OUTPUT_DIRECTORY);
        }
    }

    private static void printUsageIfCommandArgsAreMissingForStoreRecommendation() {
        if (inputFileName == null) {
            AggregateAdvisorClientApplication.printUsageAsCommandArgIsMissing(AggregateAdvisorCommandLineOption.INPUT_FILE);
        }
        if (outputDirectoryName == null) {
            AggregateAdvisorClientApplication.printUsageAsCommandArgIsMissing(AggregateAdvisorCommandLineOption.OUTPUT_DIRECTORY);
        }
    }

    private static void printUsageIfCommandArgsAreMissingForMigrateRecommendation() {
        if (inputFileName == null) {
            AggregateAdvisorClientApplication.printUsageAsCommandArgIsMissing(AggregateAdvisorCommandLineOption.INPUT_FILE);
        }
    }

    private static void printUsageIfCommandArgsAreMissingForUpdateRecommendationName() {
        if (cubeName == null) {
            AggregateAdvisorClientApplication.printUsageAsCommandArgIsMissing(AggregateAdvisorCommandLineOption.CUBE);
        }
        if (recommendationIDToUpdate == null) {
            AggregateAdvisorClientApplication.printUsageAsCommandArgIsMissing(AggregateAdvisorCommandLineOption.RECOMMENDATION_ID);
        }
        if (recommendationName == null) {
            AggregateAdvisorClientApplication.printUsageAsCommandArgIsMissing(AggregateAdvisorCommandLineOption.RECOMMENDATION_NAME);
        }
    }

    private static void printUsageIfCommandArgsAreMissingForDeleteRecommendations() {
        if (cubeName == null) {
            AggregateAdvisorClientApplication.printUsageAsCommandArgIsMissing(AggregateAdvisorCommandLineOption.CUBE);
        }
        if (recommendationIDsToDelete.isEmpty()) {
            AggregateAdvisorClientApplication.printUsageAsCommandArgIsMissing(AggregateAdvisorCommandLineOption.RECOMMENDATION_IDS);
        }
    }

    private static void printUsageIfCommandArgsAreMissingForReplaceSession() {
        if (sessionID == null) {
            AggregateAdvisorClientApplication.printUsageAsCommandArgIsMissing(AggregateAdvisorCommandLineOption.SESSION_ID);
        }
        if (outputDirectoryName == null) {
            AggregateAdvisorClientApplication.printUsageAsCommandArgIsMissing(AggregateAdvisorCommandLineOption.OUTPUT_DIRECTORY);
        }
    }

    private static void printUsageAsCommandArgIsMissing(AggregateAdvisorCommandLineOption commandLineOption) {
        AggregateAdvisorClientApplication.println(String.format("The %s option must be specified with the %s command.", commandLineOption.getName(), command.toString()));
        AggregateAdvisorClientApplication.println("");
        AggregateAdvisorClientApplication.printUsage();
    }

    private static void printUsage() {
        HelpFormatter helpFormatter = new HelpFormatter();
        Comparator<Option> optionComparator = AggregateAdvisorClientApplication.createCommandLineOptionComparator();
        helpFormatter.setOptionComparator(optionComparator);
        helpFormatter.setSyntaxPrefix(USAGE_PREFIX);
        helpFormatter.setDescPadding(1);
        helpFormatter.setWidth(79);
        helpFormatter.printHelp(AggregateAdvisorClientApplication.class.getSimpleName(), AggregateAdvisorClientApplication.getCommandLineOptions(), true);
        System.exit(1);
    }

    private static Comparator<Option> createCommandLineOptionComparator() {
        Comparator<Option> optionComparator = new Comparator<Option>(){

            @Override
            public int compare(Option option1, Option option2) {
                String optionName2;
                int optionIndex2;
                String optionName1 = option1.getOpt();
                int optionIndex1 = AggregateAdvisorClientApplication.getCommandLineOptionIndex(optionName1);
                if (optionIndex1 < (optionIndex2 = AggregateAdvisorClientApplication.getCommandLineOptionIndex(optionName2 = option2.getOpt()))) {
                    return -1;
                }
                if (optionIndex1 == optionIndex2) {
                    return 0;
                }
                return 1;
            }
        };
        return optionComparator;
    }

    private static int getCommandLineOptionIndex(String optionName) {
        AggregateAdvisorCommandLineOption commandLineOption = AggregateAdvisorCommandLineOption.getValue(optionName);
        if (commandLineOption != null) {
            return commandLineOption.getUsageIndex();
        }
        return -1;
    }

    private static Options getCommandLineOptions() {
        AggregateAdvisorCommandLineOption[] aggregateAdvisorCommandLineOptions;
        if (commandLineOptions != null) {
            return commandLineOptions;
        }
        commandLineOptions = new Options();
        for (AggregateAdvisorCommandLineOption aggregateAdvisorCommandLineOption : aggregateAdvisorCommandLineOptions = AggregateAdvisorCommandLineOption.values()) {
            Option option = AggregateAdvisorClientApplication.createCommandLineOption(aggregateAdvisorCommandLineOption.getName(), aggregateAdvisorCommandLineOption.getDescription(), aggregateAdvisorCommandLineOption.isRequired(), aggregateAdvisorCommandLineOption.hasArgument(), aggregateAdvisorCommandLineOption.getArgumentName());
            commandLineOptions.addOption(option);
        }
        return commandLineOptions;
    }

    private static Option createCommandLineOption(String optionName, String description, boolean required, boolean hasArgument, String argumentName) {
        Option option = new Option(optionName, hasArgument, description);
        option.setArgName(argumentName);
        option.setRequired(required);
        return option;
    }

    private static void printRequest(String request) {
        AggregateAdvisorClientApplication.println("===========================================");
        AggregateAdvisorClientApplication.println("");
        AggregateAdvisorClientApplication.println("REQUEST");
        AggregateAdvisorClientApplication.println("");
        AggregateAdvisorClientApplication.println(request);
        AggregateAdvisorClientApplication.println("");
    }

    private static void printReply(AggregateAdvisorRecommendationsReply reply, boolean printResponseHeader) {
        if (printResponseHeader) {
            AggregateAdvisorClientApplication.println(RESPONSE);
            AggregateAdvisorClientApplication.println("");
        }
        AggregateAdvisorClientApplication.printState(reply);
        AggregateAdvisorClientApplication.printMessages(reply);
        AggregateAdvisorClientApplication.printOptions(reply);
        AggregateAdvisorClientApplication.printProperties(reply);
        AggregateAdvisorClientApplication.printProgressPoints(reply);
        AggregateAdvisorClientApplication.printRecommendations(reply);
    }

    private static void printState(AggregateAdvisorReply reply) {
        AggregateAdvisorClientApplication.println("State:");
        AggregateAdvisorState state = reply.getState();
        AggregateAdvisorClientApplication.println(DS + (Object)((Object)state));
        AggregateAdvisorClientApplication.println("");
    }

    private static void printMessages(AggregateAdvisorReply reply) {
        AggregateAdvisorClientApplication.println("Messages:");
        List<String> messages = reply.getMessages();
        for (String message : messages) {
            AggregateAdvisorClientApplication.println(DS + message);
        }
        AggregateAdvisorClientApplication.println("");
    }

    private static void printOptions(AggregateAdvisorRecommendationsReply reply) {
        AggregateAdvisorClientApplication.println("Options:");
        List<AggregateAdvisorOption> options = reply.getOptions();
        for (AggregateAdvisorOption option : options) {
            AggregateAdvisorClientApplication.println(DS + String.format("%s = %s", option.getName(), option.getValue()));
        }
        AggregateAdvisorClientApplication.println("");
    }

    private static void printProperties(AggregateAdvisorRecommendationsReply reply) {
        AggregateAdvisorClientApplication.println("Properties:");
        for (AggregateAdvisorPropertyName propertyName : AggregateAdvisorPropertyName.values()) {
            AggregateAdvisorClientApplication.printProperty(reply, propertyName);
        }
        AggregateAdvisorClientApplication.println("");
    }

    private static void printProperty(AggregateAdvisorRecommendationsReply reply, AggregateAdvisorPropertyName propertyName) {
        String value = reply.getPropertyValue(propertyName);
        AggregateAdvisorClientApplication.println(DS + propertyName.toString() + " = " + value);
    }

    private static void printProgressPoints(AggregateAdvisorRecommendationsReply reply) {
        AggregateAdvisorClientApplication.println("Progress points:");
        List<AggregateAdvisorProgressPoint> progress = reply.getProgress();
        for (AggregateAdvisorProgressPoint point : progress) {
            AggregateAdvisorClientApplication.println(DS + point.getProgressTime() + ", " + point.getProgressValue());
        }
        AggregateAdvisorClientApplication.println("");
    }

    private static void printRecommendations(AggregateAdvisorRecommendationsReply reply) {
        AggregateAdvisorRecommendations recommendations = reply.getRecommendations();
        if (recommendations == null) {
            return;
        }
        AggregateAdvisorRecommendedAggregates recommendedAggregatesInMemory = recommendations.getRecommendedAggregatesInMemory();
        AggregateAdvisorClientApplication.println("Recommended in-memory aggregates:");
        AggregateAdvisorClientApplication.println("---------------------------------");
        AggregateAdvisorClientApplication.printRecommendedAggregatesInDatabaseOrMemory(recommendedAggregatesInMemory);
        AggregateAdvisorRecommendedAggregates recommendedAggregatesInDatabase = recommendations.getRecommendedAggregatesInDatabase();
        AggregateAdvisorClientApplication.println("Recommended in-database aggregates:");
        AggregateAdvisorClientApplication.println("-----------------------------------");
        AggregateAdvisorClientApplication.printRecommendedAggregatesInDatabaseOrMemory(recommendedAggregatesInDatabase);
    }

    private static void printRecommendedAggregatesInDatabaseOrMemory(AggregateAdvisorRecommendedAggregates recommendedAggregatesInDatabaseOrMemory) {
        if (recommendedAggregatesInDatabaseOrMemory == null) {
            AggregateAdvisorClientApplication.println(OUTPUT_STRING_NONE);
            AggregateAdvisorClientApplication.println("");
            return;
        }
        AggregateAdvisorClientApplication.println("Summary:");
        int count = recommendedAggregatesInDatabaseOrMemory.getCount();
        AggregateAdvisorClientApplication.println("  Count: " + count);
        int estimatedCoverage = recommendedAggregatesInDatabaseOrMemory.getEstimatedCoverage();
        AggregateAdvisorClientApplication.println("  Estimated coverage: " + estimatedCoverage);
        long estimatedSpaceRequired = recommendedAggregatesInDatabaseOrMemory.getEstimatedSpaceRequired();
        AggregateAdvisorClientApplication.println("  Estimated space required: " + estimatedSpaceRequired);
        AggregateAdvisorClientApplication.println("");
        AggregateAdvisorClientApplication.println("Details:");
        AggregateAdvisorClientApplication.println("  Name, Size, Levels, Measures");
        AggregateAdvisorClientApplication.println("  ++++++++++++++++++++++++++++");
        List<AggregateAdvisorRecommendedAggregate> recommendedAggregates = recommendedAggregatesInDatabaseOrMemory.getRecommendedAggregates();
        for (AggregateAdvisorRecommendedAggregate recommendedAggregate : recommendedAggregates) {
            String name = recommendedAggregate.getName();
            long size = recommendedAggregate.getSize();
            List<String> levels = recommendedAggregate.getLevels();
            List<String> measures = recommendedAggregate.getMeasures();
            AggregateAdvisorClientApplication.println(DS + String.format("%s, %s, %s, %s", name, size, levels, measures));
        }
        AggregateAdvisorClientApplication.println("");
    }

    private static void saveRecommendations(AggregateAdvisorRecommendationsReply reply) {
        AggregateAdvisorRecommendations recommendations = reply.getRecommendations();
        if (recommendations == null) {
            return;
        }
        String cube = reply.getPropertyValue(AggregateAdvisorPropertyName.CUBE_NAME);
        String recommendationID = reply.getPropertyValue(AggregateAdvisorPropertyName.RECOMMENDATION_ID);
        AggregateAdvisorRecommendedAggregates recommendedAggregatesInDatabase = recommendations.getRecommendedAggregatesInDatabase();
        AggregateAdvisorClientApplication.saveRecommendedAggregates(recommendedAggregatesInDatabase, cube, recommendationID, RECOMMENDED_AGGREGATES_TYPE_IN_DATABASE);
        AggregateAdvisorRecommendedAggregates recommendedAggregatesInMemory = recommendations.getRecommendedAggregatesInMemory();
        AggregateAdvisorClientApplication.saveRecommendedAggregates(recommendedAggregatesInMemory, cube, recommendationID, RECOMMENDED_AGGREGATES_TYPE_IN_MEMORY);
    }

    private static void saveRecommendedAggregates(AggregateAdvisorRecommendedAggregates recommendedAggregates, String cube, String recommendationID, String recommendedAggregatesType) {
        if (recommendedAggregates == null) {
            return;
        }
        try {
            String metaInfoAsXML;
            String metaInfoAsText = recommendedAggregates.getMetaInfoAsText();
            if (metaInfoAsText != null && metaInfoAsText.length() > 0) {
                AggregateAdvisorClientApplication.saveRecommendedAggregatesToFile(cube, recommendationID, recommendedAggregatesType, "txt", "text", CHARSET_UTF8, metaInfoAsText);
            }
            if ((metaInfoAsXML = recommendedAggregates.getMetaInfoAsXML()) != null && metaInfoAsXML.length() > 0) {
                AggregateAdvisorClientApplication.saveRecommendedAggregatesToFile(cube, recommendationID, recommendedAggregatesType, "xml", "XML", CHARSET_UTF8, metaInfoAsXML);
            }
            String metaInfo = recommendedAggregates.getMetaInfo();
            if (RECOMMENDED_AGGREGATES_TYPE_IN_DATABASE.equals(recommendedAggregatesType)) {
                if (metaInfo.equals(metaInfoAsText)) {
                    AggregateAdvisorClientApplication.println("The information to create the recommended in-database aggregates is text by default.");
                } else {
                    AggregateAdvisorClientApplication.println("The information to create the recommended in-database aggregates is not text by default.");
                }
            } else if (metaInfo.equals(metaInfoAsXML)) {
                AggregateAdvisorClientApplication.println("The information to create the recommended in-memory aggregates is XML by default.");
            } else {
                AggregateAdvisorClientApplication.println("The information to create the recommended in-memory aggregates is not XML by default.");
            }
            AggregateAdvisorClientApplication.println("");
        }
        catch (IOException io) {
            AggregateAdvisorClientApplication.println(String.format("The recommended in-%s aggregates could not be saved due to the error: %s", recommendedAggregatesType.toLowerCase(), io.getMessage()));
            AggregateAdvisorClientApplication.println("");
        }
    }

    private static void saveRecommendedAggregatesToFile(String cube, String recommendationID, String recommendedAggregatesType, String fileExtension, String fileType, Charset fileCharset, String recommendedAggregatesInfo) throws IOException {
        String fileName = String.format("%s_%s_RecommendedAggregatesIn%s.%s", cube, recommendationID, recommendedAggregatesType, fileExtension);
        File file = new File(outputDirectoryName, fileName);
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)new FileOutputStream(file), fileCharset);
        outputStreamWriter.write(recommendedAggregatesInfo);
        outputStreamWriter.close();
        AggregateAdvisorClientApplication.println(String.format("Saved the information to create the recommended in-%s aggregates as %s to %s.", recommendedAggregatesType.toLowerCase(), fileType, file.getCanonicalPath()));
    }

    private static void printReply(AggregateAdvisorCurrentWorkloadReply reply) {
        AggregateAdvisorClientApplication.println(RESPONSE);
        AggregateAdvisorClientApplication.println("");
        long startTime = reply.getStartTime();
        AggregateAdvisorClientApplication.println("Start Time of the workload:");
        AggregateAdvisorClientApplication.println(DS + DATE_TIME_FORMAT.format(new Date(startTime)));
        AggregateAdvisorClientApplication.println("");
        long endTime = reply.getEndTime();
        AggregateAdvisorClientApplication.println("End Time of the workload:");
        AggregateAdvisorClientApplication.println(DS + DATE_TIME_FORMAT.format(new Date(endTime)));
        AggregateAdvisorClientApplication.println("");
        List<String> packageNames = reply.getPackageNames();
        AggregateAdvisorClientApplication.println("Package names in the workload:");
        for (String string : packageNames) {
            AggregateAdvisorClientApplication.println(DS + string);
        }
        AggregateAdvisorClientApplication.println("");
        List<String> reportNames = reply.getReportNames();
        AggregateAdvisorClientApplication.println("Report names in the workload:");
        for (String name : reportNames) {
            AggregateAdvisorClientApplication.println(DS + name);
        }
        AggregateAdvisorClientApplication.println("");
        List<String> list = reply.getUserNames();
        AggregateAdvisorClientApplication.println("User names in the workload:");
        for (String name : list) {
            AggregateAdvisorClientApplication.println(DS + name);
        }
        AggregateAdvisorClientApplication.println("");
    }

    private static void processReply(AggregateAdvisorRetrieveRecommendationsReply reply) {
        AggregateAdvisorClientApplication.printAggregateAdvisorReply(reply);
        List<AggregateAdvisorRecommendationsReply> recommendationsReplies = reply.getRecommendations();
        AggregateAdvisorClientApplication.println(String.format("Recommendations from the server (count = %,d):", recommendationsReplies.size()));
        AggregateAdvisorClientApplication.println("");
        for (AggregateAdvisorRecommendationsReply recommendationsReply : recommendationsReplies) {
            String recommendationID = recommendationsReply.getPropertyValue(AggregateAdvisorPropertyName.RECOMMENDATION_ID);
            AggregateAdvisorClientApplication.println(String.format("Recommendation %s", recommendationID));
            AggregateAdvisorClientApplication.println("............................");
            AggregateAdvisorClientApplication.printReply(recommendationsReply, false);
            AggregateAdvisorClientApplication.saveRecommendations(recommendationsReply);
        }
    }

    private static void processReply(AggregateAdvisorStoreRecommendationReply storeRecommendationReply) {
        AggregateAdvisorClientApplication.printAggregateAdvisorReply(storeRecommendationReply);
        AggregateAdvisorRecommendationsReply recommendationsReply = storeRecommendationReply.getRecommendation();
        AggregateAdvisorClientApplication.println("Recommendation from the server");
        AggregateAdvisorClientApplication.println("..............................");
        if (recommendationsReply == null) {
            AggregateAdvisorClientApplication.println(OUTPUT_STRING_NONE);
        } else {
            AggregateAdvisorClientApplication.printReply(recommendationsReply, false);
            AggregateAdvisorClientApplication.saveRecommendations(recommendationsReply);
        }
    }

    private static void printAggregateAdvisorReply(AggregateAdvisorReply reply) {
        AggregateAdvisorClientApplication.println(RESPONSE);
        AggregateAdvisorClientApplication.println("");
        AggregateAdvisorClientApplication.printState(reply);
        AggregateAdvisorClientApplication.printMessages(reply);
    }

    private static void println(String s) {
        System.out.println(s);
    }

    static {
        locale = null;
        logLevel = null;
        logFile = null;
        aggregateAdvisorOptions = new ArrayList<AggregateAdvisorOption>();
        DEFAULT_STOP_CANCEL_WAIT_TIME = String.valueOf(Integer.MAX_VALUE);
    }
}

