/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.bibus.rolap.aggregateAdvisor.client.sample;

import com.cognos.xqe.bibus.rolap.aggregateAdvisor.AggregateAdvisorOptionName;
import com.cognos.xqe.bibus.rolap.aggregateAdvisor.client.sample.AggregateAdvisorClientApplication;
import com.cognos.xqe.bibus.rolap.aggregateAdvisor.client.sample.AggregateAdvisorCommand;
import java.util.logging.Level;

public enum AggregateAdvisorCommandLineOption {
    COMMAND("command", String.format("The command that should be sent to the server: %s.", AggregateAdvisorCommand.getValuesString()), true, true),
    HOST("host", "The machine that the Cognos dispatcher is running on.", true, true),
    PORT("port", "The port that the Cognos dispatcher is listening to.", true, true),
    CUBE("cube", "The cube that should be optimized.", false, true),
    OUTPUT_DIRECTORY("outputDirectory", "The directory where the aggregate recommendations should be output.", false, true),
    INPUT_FILE("inputFile", "The file containing the input to the command.", false, true),
    RECOMMENDATION_ID("recommendationID", "The recommendation ID.", false, true),
    RECOMMENDATION_NAME("recommendationName", "The recommendation name.", false, true),
    RECOMMENDATION_IDS("recommendationIDs", "The recommendation IDs, separated by semicolons.", false, true),
    SESSION_ID("sessionID", "The session ID.", false, true),
    WAIT_TIME("waitTime", "The time to wait before sending a request to the server, in ms.", false, true),
    NAMESPACE("namespace", "The namespace to use while logging into Cognos.", false, true),
    USER("user", "The user to use while logging into Cognos.", false, true),
    PASSWORD("password", "The password to use while logging into Cognos.", false, true),
    LOCALE("locale", "The locale to be used for messages. If missing, the VM default locale will be used. Usage: -locale fr", false, true),
    LOGLEVEL("logLevel", String.format("The level to use for logging: %s.", AggregateAdvisorCommandLineOption.getLogLevelValuesString()), false, true),
    LOGFILE("logFile", "The file to use for logging.", false, true),
    INCLUDE_WORKLOAD_INFO(AggregateAdvisorOptionName.INCLUDE_WORKLOAD_INFO.toString(), "The flag that indicates that the advisor should include workload info in its analysis of the cube.", false, false),
    USE_WORKLOAD_ONLY(AggregateAdvisorOptionName.USE_WORKLOAD_ONLY.toString(), "The flag that indicates that the advisor should use only workload info in its analysis of the cube.", false, false),
    USER_DEFINED_AGGREGATES_ONLY(AggregateAdvisorOptionName.USER_DEFINED_AGGREGATES_ONLY.toString(), "The flag that indicates that the advisor should use only user defined in-memory aggregates in its analysis.", false, false),
    IN_MEMORY_AGGREGATES_LIMIT(AggregateAdvisorOptionName.IN_MEMORY_AGGREGATES_LIMIT.toString(), "The maximum amount of memory that in-memory aggregates should consume, in bytes.", false, true),
    IN_DATABASE_AGGREGATES_LIMIT(AggregateAdvisorOptionName.IN_DATABASE_AGGREGATES_LIMIT.toString(), "The maximum amount of memory that in-database aggregates should consume, in bytes.", false, true),
    RUN_TIME_LIMIT(AggregateAdvisorOptionName.RUN_TIME_LIMIT.toString(), "The maximum amount of time that the advisor should run, in minutes.", false, true),
    START_TIME(AggregateAdvisorOptionName.START_TIME.toString(), String.format("The starting time of entries in the workload logs that the advisor should analyze, in the format \"%s\" for start date and time. Or, in the format \"%s\" for start time if \"%s\" option is specified.", AggregateAdvisorClientApplication.DATE_TIME_FORMAT.toPattern(), AggregateAdvisorClientApplication.TIME_FORMAT.toPattern(), AggregateAdvisorOptionName.DAYS_OF_THE_WEEK.toString()), false, true),
    END_TIME(AggregateAdvisorOptionName.END_TIME.toString(), String.format("The ending time of entries in the workload logs that the advisor should analyze, in the format \"%s\" for end date and time. Or, in the format \"%s\" for end time if \"%s\" option is specified.", AggregateAdvisorClientApplication.DATE_TIME_FORMAT.toPattern(), AggregateAdvisorClientApplication.TIME_FORMAT.toPattern(), AggregateAdvisorOptionName.DAYS_OF_THE_WEEK.toString()), false, true),
    DAYS_OF_THE_WEEK(AggregateAdvisorOptionName.DAYS_OF_THE_WEEK.toString(), "The days of the week of entries in the workload logs that the advisor should analyze, separated by semi-colons. For example: Monday;Tuesday;Wednesday;Thursday;Friday;Saturday;Sunday.", false, true),
    PACKAGE_NAMES(AggregateAdvisorOptionName.PACKAGE_NAMES.toString(), "The names of the packages that the advisor should analyze, separated by semi-colons.", false, true),
    REPORT_NAMES(AggregateAdvisorOptionName.REPORT_NAMES.toString(), "The names of the reports that the advisor should analyze, separated by semi-colons.", false, true),
    USER_NAMES(AggregateAdvisorOptionName.USER_NAMES.toString(), "The names of the users whose reports should be analyzed by the advisor, separated by semi-colons.", false, true),
    REPORT_USAGE(AggregateAdvisorOptionName.REPORT_USAGE.toString(), "The top number of reports in the workload sorted by number of times run, in descending order, that the advisor should analyze.", false, true),
    STOP_ADVISOR_WAIT_TIME("stopAdvisorWaitTime", "The time to wait after starting advisor to send a Stop request to the server, in ms.", false, true),
    CANCEL_ADVISOR_WAIT_TIME("cancelAdvisorWaitTime", "The time to wait after starting advisor to send a Cancel request to the server, in ms.", false, true);

    private String name;
    private String description;
    private boolean isRequired;
    private boolean hasArgument;
    private String argumentName;

    private AggregateAdvisorCommandLineOption(String theName, String theDescription, boolean required, boolean hasArg, String theArgumentName) {
        this.name = theName;
        this.description = theDescription;
        this.isRequired = required;
        this.hasArgument = hasArg;
        this.argumentName = theArgumentName;
    }

    private AggregateAdvisorCommandLineOption(String theName, String theDescription, boolean required, boolean hasArg) {
        this(theName, theDescription, required, hasArg, theName);
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public boolean isRequired() {
        return this.isRequired;
    }

    public boolean hasArgument() {
        return this.hasArgument;
    }

    public String getArgumentName() {
        return this.argumentName;
    }

    public int getUsageIndex() {
        return this.ordinal();
    }

    public static AggregateAdvisorCommandLineOption getValue(String optionName) {
        AggregateAdvisorCommandLineOption[] values;
        for (AggregateAdvisorCommandLineOption value : values = AggregateAdvisorCommandLineOption.values()) {
            if (!value.getName().equals(optionName)) continue;
            return value;
        }
        return null;
    }

    private static String getLogLevelValuesString() {
        StringBuilder sb = new StringBuilder();
        Level[] levels = new Level[]{Level.OFF, Level.SEVERE, Level.WARNING, Level.INFO, Level.FINE, Level.FINER, Level.FINEST, Level.ALL};
        for (int i = 0; i < levels.length; ++i) {
            Level level = levels[i];
            sb.append(level);
            if (i + 1 >= levels.length) continue;
            sb.append(", ");
        }
        return sb.toString();
    }
}

