/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.bibus.rolap.aggregateAdvisor.client.sample;

import com.cognos.xqe.bibus.rolap.aggregateAdvisor.client.util.SelectedAggregatesUtility;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.dom4j.Document;
import org.dom4j.io.SAXReader;

public class SelectedAggregatesUtilityApplication {
    private static final int NUM_BYTES = 1024;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        if (args.length < 3 || args.length % 2 == 0) {
            System.out.println("Takes at least 3 input parameters: ");
            System.out.println("\n outputDirectory \t Directory where resulting XML output file (output_SelectedAggregatesUtility.xml) will be written");
            System.out.println("\n inMemoryAggrXMLFile \t File path to in-memory aggregate XML");
            System.out.println("\n selectionsFile \t File containing list of selected in-memory aggregate names separated by newlines");
            System.out.println("\nOptionally, can specify more pairs of in-memory XML and selections as input");
            System.out.println("\n\nExamples:");
            System.out.println("\n\t SelectedAggregatesUtilityApplication D:\\temp D:\\inMem.xml D:\\inMem.txt");
            System.out.println("\n\t SelectedAggregatesUtilityApplication D:\\temp D:\\inMem1.xml D:\\inMem1.txt D:\\inMem2.xml D:\\inMem2.txt");
            return;
        }
        String outputDirectory = args[0];
        HashMap<String, List<String>> selectedMap = new HashMap<String, List<String>>();
        for (int i = 1; i < args.length; i += 2) {
            try (BufferedReader bufReader = null;){
                SAXReader saxReader = new SAXReader();
                Document document = saxReader.read(new File(args[i]));
                String documentString = document.asXML();
                ArrayList<String> selectedAggregates = new ArrayList<String>();
                bufReader = new BufferedReader(new FileReader(args[i + 1]));
                String aLine = null;
                while ((aLine = bufReader.readLine()) != null) {
                    selectedAggregates.add(aLine);
                }
                selectedMap.put(documentString, selectedAggregates);
                continue;
            }
        }
        String selectedAggregatesXML = SelectedAggregatesUtility.getInMemoryAggregateXML(selectedMap);
        ByteArrayInputStream contents = null;
        OutputStream os = null;
        try {
            contents = new ByteArrayInputStream(selectedAggregatesXML.getBytes("UTF-8"));
            os = new FileOutputStream(new File(outputDirectory + File.separator + "output_SelectedAggregatesUtility.xml"));
            int read = 0;
            byte[] bytes = new byte[1024];
            while ((read = contents.read(bytes)) != -1) {
                os.write(bytes, 0, read);
            }
        }
        finally {
            if (os != null) {
                os.close();
            }
            if (contents != null) {
                contents.close();
            }
        }
    }
}

