/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.bibus.rolap.aggregateAdvisor.client.sample.util;

import com.cognos.developer.schemas.bibus._3.BaseClass;
import com.cognos.developer.schemas.bibus._3.BiBusHeader;
import com.cognos.developer.schemas.bibus._3.CAM;
import com.cognos.developer.schemas.bibus._3.ContentManagerService_PortType;
import com.cognos.developer.schemas.bibus._3.ContentManagerService_ServiceLocator;
import com.cognos.developer.schemas.bibus._3.ConversationContext;
import com.cognos.developer.schemas.bibus._3.Dispatcher_Type;
import com.cognos.developer.schemas.bibus._3.EncodingEnum;
import com.cognos.developer.schemas.bibus._3.FormFieldVar;
import com.cognos.developer.schemas.bibus._3.FormatEnum;
import com.cognos.developer.schemas.bibus._3.HdrSession;
import com.cognos.developer.schemas.bibus._3.PropEnum;
import com.cognos.developer.schemas.bibus._3.QueryOptions;
import com.cognos.developer.schemas.bibus._3.SearchPathMultipleObject;
import com.cognos.developer.schemas.bibus._3.Tracking;
import com.cognos.developer.schemas.bibus._3.UserPreferenceVar;
import com.cognos.p2plb.model.NodeID;
import com.cognos.xqe.bibus.rolap.aggregateAdvisor.client.AggregateAdvisorClient;
import com.cognos.xqe.bibus.rolap.aggregateAdvisor.client.exception.AACMessageKeys;
import com.cognos.xqe.bibus.rolap.aggregateAdvisor.client.exception.AACRuntimeException;
import com.cognos.xqe.bibus.rolap.aggregateAdvisor.client.util.BiBusHeaderUtility;
import java.math.BigInteger;
import java.net.InetAddress;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import org.apache.axis.client.Stub;
import org.apache.axis.message.SOAPHeaderElement;

public class HeaderUtility {
    private static final String COLON = ":";
    private static final String PROTOCOL_HOST_SEPARATOR = "://";
    private static final String LOCALHOST = "localhost";
    private static final int FORM_FIELD_VAR_SIZE = 3;

    private static BiBusHeader createBiBusHeader(String camNamespace, String camUser, String camPassword, String productLocale) {
        BiBusHeader biBusHeader = new BiBusHeader();
        CAM cam = new CAM();
        if (camNamespace != null && camNamespace.length() > 0 && camUser != null && camUser.length() > 0) {
            cam.setAction("logonAs");
            HdrSession hdrSession = new HdrSession();
            FormFieldVar[] vars = new FormFieldVar[3];
            vars[0] = new FormFieldVar();
            vars[0].setName("CAMNamespace");
            vars[0].setValue(camNamespace);
            vars[0].setFormat(FormatEnum.not_encrypted);
            vars[1] = new FormFieldVar();
            vars[1].setName("CAMUsername");
            vars[1].setValue(camUser);
            vars[1].setFormat(FormatEnum.not_encrypted);
            vars[2] = new FormFieldVar();
            vars[2].setName("CAMPassword");
            if (camPassword != null && camPassword.length() > 0) {
                vars[2].setValue(camPassword);
            }
            vars[2].setFormat(FormatEnum.not_encrypted);
            hdrSession.setFormFieldVars(vars);
            biBusHeader.setHdrSession(hdrSession);
        } else {
            cam.setAction("logon");
        }
        biBusHeader.setCAM(cam);
        HeaderUtility.setUserPreference(biBusHeader, "productLocale", productLocale);
        return biBusHeader;
    }

    private static void setUserPreference(BiBusHeader biBusHeader, String varName, String varValue) {
        if (biBusHeader == null || varName == null || varName.length() == 0 || varValue == null || varValue.length() == 0) {
            return;
        }
        UserPreferenceVar[] vars = biBusHeader.getUserPreferenceVars();
        List<UserPreferenceVar> newList = vars == null ? new ArrayList<UserPreferenceVar>() : Arrays.asList(vars);
        boolean addUserPref = true;
        Iterator<UserPreferenceVar> ii = newList.iterator();
        while (ii.hasNext()) {
            UserPreferenceVar anUserPref = ii.next();
            if (!anUserPref.getName().equals(varName)) continue;
            if (!anUserPref.getValue().equals(varValue)) {
                ii.remove();
                break;
            }
            addUserPref = false;
        }
        if (addUserPref) {
            newList.add(new UserPreferenceVar(varName, varValue));
            vars = new UserPreferenceVar[newList.size()];
            newList.toArray(vars);
            biBusHeader.setUserPreferenceVars(vars);
        }
    }

    public static BiBusHeader getBiBusHeader(URL dispatcherURL, String camNamespace, String camUser, String camPassword, String productLocale) {
        BiBusHeader biBusHeader = null;
        try {
            biBusHeader = HeaderUtility.createBiBusHeader(camNamespace, camUser, camPassword, productLocale);
            ContentManagerService_ServiceLocator cmServiceLocator = new ContentManagerService_ServiceLocator();
            ContentManagerService_PortType cmService = cmServiceLocator.getcontentManagerService(dispatcherURL);
            ((Stub)cmService).setHeader(BiBusHeaderUtility.BI_BUS_HEADER_QNAME.getNamespaceURI(), BiBusHeaderUtility.BI_BUS_HEADER_QNAME.getLocalPart(), (Object)biBusHeader);
            ((Stub)cmService)._setProperty("sendMultiRefs", (Object)Boolean.FALSE);
            SearchPathMultipleObject searchPathMultipleObject = new SearchPathMultipleObject("~");
            PropEnum[] props = new PropEnum[]{PropEnum.defaultName};
            QueryOptions queryOptions = new QueryOptions();
            queryOptions.setSchemaInfo(false);
            queryOptions.setPermission("read");
            queryOptions.setMaxObjects(BigInteger.ZERO);
            queryOptions.setSkipObjects(BigInteger.ZERO);
            queryOptions.setDataEncoding(EncodingEnum.base64);
            queryOptions.setMaxDataBytes(BigInteger.ZERO);
            queryOptions.setSkipDataBytes(BigInteger.ZERO);
            cmService.query(searchPathMultipleObject, props, null, queryOptions);
            SOAPHeaderElement soapHeaderElement = ((Stub)cmService).getResponseHeader(BiBusHeaderUtility.BI_BUS_HEADER_QNAME.getNamespaceURI(), BiBusHeaderUtility.BI_BUS_HEADER_QNAME.getLocalPart());
            if (soapHeaderElement != null) {
                biBusHeader = (BiBusHeader)soapHeaderElement.getObjectValue(BiBusHeader.class);
            }
            HeaderUtility.setDispatcherGuidInBiBusHeader(dispatcherURL, biBusHeader, cmService);
        }
        catch (Exception e) {
            AggregateAdvisorClient.getLogger().log(Level.SEVERE, String.format("Failed to get the BiBusHeader from CM: URL=%s, namespace=%s, user=%s", dispatcherURL, camNamespace, camUser), e);
            throw AACRuntimeException.wrap(AACMessageKeys.GEN_FailedToQueryCM, e);
        }
        return biBusHeader;
    }

    private static void setDispatcherGuidInBiBusHeader(URL dispatcherURL, BiBusHeader biBusHeader, ContentManagerService_PortType cmService) throws Exception {
        String nodeID = HeaderUtility.getDispatcherGuidFromCM(dispatcherURL, cmService);
        ConversationContext conversationContext = new ConversationContext();
        conversationContext.setNodeID(nodeID);
        Tracking tracking = new Tracking();
        tracking.setConversationContext(conversationContext);
        biBusHeader.setTracking(tracking);
    }

    private static String getDispatcherGuidFromCM(URL dispatcherURL, ContentManagerService_PortType cmService) throws Exception {
        String dispatcherURI = dispatcherURL.toString();
        AggregateAdvisorClient.getLogger().log(Level.FINE, String.format("Getting guid of dispatcher \"%s\" from CM", dispatcherURI));
        NodeID dispatcherNodeID = NodeID.getNodeID((String)dispatcherURI);
        InetAddress dispatcherInetAddress = null;
        String dispatcherHostFromNodeID = dispatcherNodeID.getHost();
        dispatcherInetAddress = LOCALHOST.equalsIgnoreCase(dispatcherHostFromNodeID) ? InetAddress.getLocalHost() : dispatcherNodeID.getHostInetAddress();
        String dispatcherHostName = dispatcherInetAddress.getHostName();
        String dispatcherCanonicalHostName = dispatcherInetAddress.getCanonicalHostName();
        String dispatcherHostAddress = dispatcherInetAddress.getHostAddress();
        int dispatcherPort = dispatcherNodeID.getPort();
        String dispatcherContext = dispatcherNodeID.getContext();
        String dispatcherHostNamePortContext = dispatcherHostName + COLON + dispatcherPort + dispatcherContext;
        String dispatcherCanonicalHostNamePortContext = dispatcherCanonicalHostName + COLON + dispatcherPort + dispatcherContext;
        String dispatcherHostAddressPortContext = dispatcherHostAddress + COLON + dispatcherPort + dispatcherContext;
        AggregateAdvisorClient.getLogger().log(Level.FINE, String.format("Searching for dispatcherPath containing \"%s\" or \"%s\" or \"%s\"", dispatcherHostNamePortContext, dispatcherCanonicalHostNamePortContext, dispatcherHostAddressPortContext));
        SearchPathMultipleObject searchPathMultipleObject = new SearchPathMultipleObject("/configuration/descendant::dispatcher");
        PropEnum[] props = new PropEnum[]{PropEnum.dispatcherPath, PropEnum.dispatcherID};
        BaseClass[] baseClasses = cmService.query(searchPathMultipleObject, props, null, null);
        String dispatcherGuid = null;
        for (BaseClass baseClass : baseClasses) {
            if (!(baseClass instanceof Dispatcher_Type)) continue;
            Dispatcher_Type dispatcherType = (Dispatcher_Type)baseClass;
            String currentDispatcherPath = dispatcherType.getDispatcherPath().getValue();
            AggregateAdvisorClient.getLogger().log(Level.FINE, String.format("Processing dispatcherPath \"%s\"", currentDispatcherPath));
            int indexOfHostPortContext = currentDispatcherPath.indexOf(PROTOCOL_HOST_SEPARATOR) + PROTOCOL_HOST_SEPARATOR.length();
            String currentDispatcherHostPortContext = currentDispatcherPath.substring(indexOfHostPortContext);
            if (!currentDispatcherHostPortContext.equalsIgnoreCase(dispatcherHostNamePortContext) && !currentDispatcherHostPortContext.equalsIgnoreCase(dispatcherCanonicalHostNamePortContext) && !currentDispatcherHostPortContext.equalsIgnoreCase(dispatcherHostAddressPortContext)) continue;
            dispatcherGuid = dispatcherType.getDispatcherID().getValue().get_value();
            break;
        }
        AggregateAdvisorClient.getLogger().log(Level.FINE, String.format("Returning guid of dispatcher \"%s\": %s", dispatcherURI, dispatcherGuid));
        return dispatcherGuid;
    }
}

