/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.bibus.rolap.aggregateAdvisor.client.util;

import com.cognos.accman.jcam.crypto.CAMFactory;
import com.cognos.xqe.bibus.rolap.aggregateAdvisor.AggregateAdvisorOptionName;
import com.cognos.xqe.bibus.rolap.aggregateAdvisor.AggregateAdvisorState;
import com.cognos.xqe.bibus.rolap.aggregateAdvisor.client.AggregateAdvisorClient;
import com.cognos.xqe.bibus.rolap.aggregateAdvisor.client.AggregateAdvisorCurrentWorkloadReply;
import com.cognos.xqe.bibus.rolap.aggregateAdvisor.client.AggregateAdvisorOption;
import com.cognos.xqe.bibus.rolap.aggregateAdvisor.client.AggregateAdvisorOptionFactory;
import com.cognos.xqe.bibus.rolap.aggregateAdvisor.client.AggregateAdvisorProperty;
import com.cognos.xqe.bibus.rolap.aggregateAdvisor.client.AggregateAdvisorRecommendations;
import com.cognos.xqe.bibus.rolap.aggregateAdvisor.client.AggregateAdvisorRecommendationsReply;
import com.cognos.xqe.bibus.rolap.aggregateAdvisor.client.AggregateAdvisorRecommendedAggregate;
import com.cognos.xqe.bibus.rolap.aggregateAdvisor.client.AggregateAdvisorRecommendedAggregates;
import com.cognos.xqe.bibus.rolap.aggregateAdvisor.client.AggregateAdvisorReply;
import com.cognos.xqe.bibus.rolap.aggregateAdvisor.client.AggregateAdvisorRetrieveRecommendationsReply;
import com.cognos.xqe.bibus.rolap.aggregateAdvisor.client.AggregateAdvisorStoreRecommendationReply;
import com.cognos.xqe.bibus.rolap.aggregateAdvisor.client.exception.AACMessageKeys;
import com.cognos.xqe.bibus.rolap.aggregateAdvisor.client.exception.AACRuntimeException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import javax.xml.soap.MessageFactory;
import javax.xml.soap.MimeHeaders;
import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPConnection;
import javax.xml.soap.SOAPConnectionFactory;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPEnvelope;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPFault;
import javax.xml.soap.SOAPHeader;
import javax.xml.soap.SOAPHeaderElement;
import javax.xml.soap.SOAPMessage;
import javax.xml.soap.SOAPPart;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.w3c.dom.CDATASection;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class SOAPUtility {
    private static final String RESPONSE = "Response";
    private static final String SOAP_ACTION = "SOAPAction";
    private static final String UTF8 = "UTF-8";
    private static final String QUERY_SERVICE = "http://www.ibm.com/xmlns/prod/cognos/queryService/201404/.absolute";
    private static final String CAM_INITIALIZE = "<initializeDocument><serviceID>AGGREGATEADVISOR</serviceID></initializeDocument>";
    private static final String HTTP_PROTOCOL = "http";
    private static CAMFactory camFactory = null;
    private static SOAPConnectionFactory soapConnectionFactory;
    private static MessageFactory messageFactory;

    private static SOAPConnection createConnection() throws SOAPException {
        if (soapConnectionFactory == null) {
            soapConnectionFactory = SOAPConnectionFactory.newInstance();
        }
        return soapConnectionFactory.createConnection();
    }

    public static SOAPMessage createMessage() throws SOAPException {
        if (messageFactory == null) {
            messageFactory = MessageFactory.newInstance();
        }
        return messageFactory.createMessage();
    }

    public static SOAPMessage createRequestMessageToStartAggregateAdvisor(SOAPHeaderElement biBusHeader, String cubeName, List<AggregateAdvisorProperty> properties, List<AggregateAdvisorOption> options) throws SOAPException {
        SOAPMessage requestMessage = SOAPUtility.createMessage();
        SOAPUtility.addHeader(requestMessage, biBusHeader);
        SOAPUtility.addBodyToStartAggregateAdvisor(requestMessage, cubeName, properties, options);
        requestMessage.saveChanges();
        return requestMessage;
    }

    public static SOAPMessage createRequestMessageToGetAggregateAdvisorRecommendations(SOAPHeaderElement biBusHeader) throws SOAPException, DOMException {
        SOAPMessage requestMessage = SOAPUtility.createMessage();
        SOAPUtility.addHeader(requestMessage, biBusHeader);
        SOAPUtility.addBodyToExecuteCommand(requestMessage, "getAggregateAdvisorRecommendations");
        requestMessage.saveChanges();
        return requestMessage;
    }

    public static SOAPMessage createRequestMessageToGetCurrentWorkloadForAggregateAdvisor(SOAPHeaderElement biBusHeader, String cubeName) throws SOAPException {
        SOAPMessage requestMessage = SOAPUtility.createMessage();
        SOAPUtility.addHeader(requestMessage, biBusHeader);
        SOAPUtility.addBodyToGetCurrentWorkloadForAggregateAdvisor(requestMessage, cubeName);
        requestMessage.saveChanges();
        return requestMessage;
    }

    public static SOAPMessage createRequestMessageToStopAggregateAdvisor(SOAPHeaderElement biBusHeader, boolean getRecommendations) throws SOAPException {
        SOAPMessage requestMessage = SOAPUtility.createMessage();
        SOAPUtility.addHeader(requestMessage, biBusHeader);
        SOAPUtility.addBodyToStopAggregateAdvisor(requestMessage, getRecommendations);
        requestMessage.saveChanges();
        return requestMessage;
    }

    public static SOAPMessage createRequestMessageToRetrieveInitialRecommendations(SOAPHeaderElement biBusHeader, List<AggregateAdvisorOption> options) throws SOAPException {
        SOAPMessage requestMessage = SOAPUtility.createMessage();
        SOAPUtility.addHeader(requestMessage, biBusHeader);
        SOAPUtility.addBodyToRetrieveInitialRecommendations(requestMessage, options);
        requestMessage.saveChanges();
        return requestMessage;
    }

    public static SOAPMessage createRequestMessageToRetrieveSubsequentRecommendations(SOAPHeaderElement biBusHeader) throws SOAPException {
        SOAPMessage requestMessage = SOAPUtility.createMessage();
        SOAPUtility.addHeader(requestMessage, biBusHeader);
        SOAPUtility.addBodyToExecuteCommand(requestMessage, "retrieveSubsequentAggregateAdvisorRecommendations");
        requestMessage.saveChanges();
        return requestMessage;
    }

    public static SOAPMessage createRequestMessageToStoreAggregateAdvisorRecommendation(SOAPHeaderElement biBusHeader, List<AggregateAdvisorProperty> properties, AggregateAdvisorRecommendations recommendations) throws SOAPException {
        SOAPMessage requestMessage = SOAPUtility.createMessage();
        SOAPUtility.addHeader(requestMessage, biBusHeader);
        SOAPUtility.addBodyToStoreAggregateAdvisorRecommendation(requestMessage, properties, recommendations);
        requestMessage.saveChanges();
        return requestMessage;
    }

    public static SOAPMessage createRequestMessageToMigrateAggregateAdvisorRecommendation(SOAPHeaderElement biBusHeader, AggregateAdvisorRecommendationsReply recommendationsReply) throws SOAPException {
        SOAPMessage requestMessage = SOAPUtility.createMessage();
        SOAPUtility.addHeader(requestMessage, biBusHeader);
        SOAPUtility.addBodyToMigrateAggregateAdvisorRecommendation(requestMessage, recommendationsReply);
        requestMessage.saveChanges();
        return requestMessage;
    }

    public static SOAPMessage createRequestMessageToUpdateAggregateAdvisorRecommendationName(SOAPHeaderElement biBusHeader, String cubeName, String recommendationID, String recommendationName) throws SOAPException {
        SOAPMessage requestMessage = SOAPUtility.createMessage();
        SOAPUtility.addHeader(requestMessage, biBusHeader);
        SOAPUtility.addBodyToUpdateAggregateAdvisorRecommendationName(requestMessage, cubeName, recommendationID, recommendationName);
        requestMessage.saveChanges();
        return requestMessage;
    }

    public static SOAPMessage createRequestMessageToDeleteAggregateAdvisorRecommendations(SOAPHeaderElement biBusHeader, String cubeName, List<String> recommendationIDs) throws SOAPException {
        SOAPMessage requestMessage = SOAPUtility.createMessage();
        SOAPUtility.addHeader(requestMessage, biBusHeader);
        SOAPUtility.addBodyToDeleteAggregateAdvisorRecommendations(requestMessage, cubeName, recommendationIDs);
        requestMessage.saveChanges();
        return requestMessage;
    }

    public static SOAPMessage createRequestMessageToReplaceAggregateAdvisorSession(SOAPHeaderElement biBusHeader, String sessionID) throws SOAPException {
        SOAPMessage requestMessage = SOAPUtility.createMessage();
        SOAPUtility.addHeader(requestMessage, biBusHeader);
        SOAPUtility.addBodyToReplaceAggregateAdvisorSession(requestMessage, sessionID);
        requestMessage.saveChanges();
        return requestMessage;
    }

    public static SOAPMessage createResponseMessage(byte[] response) throws SOAPException {
        SOAPMessage message = SOAPUtility.createMessage();
        SOAPPart soapPart = message.getSOAPPart();
        ByteArrayInputStream stream = new ByteArrayInputStream(response);
        StreamSource source = new StreamSource(stream);
        soapPart.setContent((Source)source);
        return message;
    }

    private static CAMFactory getCamFactory() throws SOAPException {
        if (camFactory == null) {
            AggregateAdvisorClient.getLogger().log(Level.SEVERE, "CAM was not initialized.");
            throw new AACRuntimeException(AACMessageKeys.GEN_FailedToInitializeCAM);
        }
        return camFactory;
    }

    private static void addHeader(SOAPMessage soapMessage, SOAPHeaderElement biBusHeader) throws SOAPException, DOMException {
        SOAPUtility.addBiBusHeader(soapMessage, biBusHeader);
        SOAPUtility.addQueryServiceSoapAction(soapMessage);
    }

    private static void addBiBusHeader(SOAPMessage soapMessage, SOAPHeaderElement biBusHeader) throws SOAPException, DOMException {
        SOAPHeader soapHeader;
        SOAPEnvelope soapEnvelope;
        if (soapMessage == null || biBusHeader == null) {
            return;
        }
        SOAPPart soapPart = soapMessage.getSOAPPart();
        if (soapPart != null && (soapEnvelope = soapPart.getEnvelope()) != null && (soapHeader = soapEnvelope.getHeader()) != null) {
            soapHeader.getOwnerDocument().adoptNode((Node)biBusHeader);
            soapHeader.addChildElement((SOAPElement)biBusHeader);
        }
    }

    private static void addQueryServiceSoapAction(SOAPMessage soapMessage) {
        if (soapMessage == null) {
            return;
        }
        MimeHeaders mimeHeaders = soapMessage.getMimeHeaders();
        if (mimeHeaders != null) {
            mimeHeaders.addHeader(SOAP_ACTION, QUERY_SERVICE);
        }
    }

    private static void addBodyToStartAggregateAdvisor(SOAPMessage requestMessage, String cubeName, List<AggregateAdvisorProperty> properties, List<AggregateAdvisorOption> options) throws SOAPException {
        SOAPBody soapBody;
        SOAPEnvelope soapEnvelope;
        if (requestMessage == null) {
            return;
        }
        SOAPPart soapPart = requestMessage.getSOAPPart();
        if (soapPart != null && (soapEnvelope = soapPart.getEnvelope()) != null && (soapBody = soapEnvelope.getBody()) != null) {
            SOAPElement commandElement = soapBody.addChildElement(soapEnvelope.createName("startAggregateAdvisor"));
            SOAPElement cubeNameElement = commandElement.addChildElement("cubeName");
            cubeNameElement.addTextNode(cubeName);
            SOAPUtility.addProperties(commandElement, properties);
            SOAPUtility.addOptions(commandElement, options);
        }
    }

    private static void addProperties(SOAPElement parentElement, List<AggregateAdvisorProperty> properties) throws SOAPException {
        if (properties == null || properties.isEmpty() || parentElement == null) {
            return;
        }
        SOAPElement propertiesElement = parentElement.addChildElement("properties");
        for (AggregateAdvisorProperty property : properties) {
            if (property == null) continue;
            String name = property.getName();
            String value = property.getValue();
            SOAPElement propertyElement = propertiesElement.addChildElement("property");
            SOAPElement nameElement = propertyElement.addChildElement("name");
            nameElement.addTextNode(name);
            SOAPElement valueElement = propertyElement.addChildElement("value");
            valueElement.addTextNode(value);
        }
    }

    private static void addOptions(SOAPElement parentElement, List<AggregateAdvisorOption> options) throws SOAPException {
        if (options == null || options.isEmpty() || parentElement == null) {
            return;
        }
        SOAPElement optionsElement = parentElement.addChildElement("options");
        for (AggregateAdvisorOption option : options) {
            String name = option.getName();
            String value = option.getValue();
            SOAPElement optionElement = optionsElement.addChildElement("option");
            SOAPElement nameElement = optionElement.addChildElement("name");
            nameElement.addTextNode(name);
            SOAPElement valueElement = optionElement.addChildElement("value");
            valueElement.addTextNode(value);
        }
    }

    private static void addBodyToGetCurrentWorkloadForAggregateAdvisor(SOAPMessage requestMessage, String cubeName) throws SOAPException {
        SOAPBody soapBody;
        SOAPEnvelope soapEnvelope;
        if (requestMessage == null) {
            return;
        }
        SOAPPart soapPart = requestMessage.getSOAPPart();
        if (soapPart != null && (soapEnvelope = soapPart.getEnvelope()) != null && (soapBody = soapEnvelope.getBody()) != null) {
            SOAPElement commandElement = soapBody.addChildElement(soapEnvelope.createName("getCurrentWorkloadForAggregateAdvisor"));
            SOAPElement cubeNameElement = commandElement.addChildElement("cubeName");
            cubeNameElement.addTextNode(cubeName);
        }
    }

    private static void addBodyToStopAggregateAdvisor(SOAPMessage requestMessage, boolean getRecommendations) throws SOAPException {
        SOAPPart soapPart = requestMessage.getSOAPPart();
        SOAPEnvelope soapEnvelope = soapPart.getEnvelope();
        SOAPBody soapBody = soapEnvelope.getBody();
        SOAPElement commandElement = soapBody.addChildElement(soapEnvelope.createName("stopAggregateAdvisor"));
        SOAPElement getRecommendationsElement = commandElement.addChildElement("getRecommendations");
        getRecommendationsElement.addTextNode(String.valueOf(getRecommendations));
    }

    private static void addBodyToRetrieveInitialRecommendations(SOAPMessage requestMessage, List<AggregateAdvisorOption> options) throws SOAPException {
        SOAPBody soapBody;
        SOAPEnvelope soapEnvelope;
        if (requestMessage == null) {
            return;
        }
        SOAPPart soapPart = requestMessage.getSOAPPart();
        if (soapPart != null && (soapEnvelope = soapPart.getEnvelope()) != null && (soapBody = soapEnvelope.getBody()) != null) {
            SOAPElement commandElement = soapBody.addChildElement(soapEnvelope.createName("retrieveInitialAggregateAdvisorRecommendations"));
            SOAPUtility.addOptions(commandElement, options);
        }
    }

    private static void addBodyToStoreAggregateAdvisorRecommendation(SOAPMessage requestMessage, List<AggregateAdvisorProperty> properties, AggregateAdvisorRecommendations recommendations) throws SOAPException {
        SOAPPart soapPart = requestMessage.getSOAPPart();
        SOAPEnvelope soapEnvelope = soapPart.getEnvelope();
        SOAPBody soapBody = soapEnvelope.getBody();
        SOAPElement commandElement = soapBody.addChildElement(soapEnvelope.createName("storeAggregateAdvisorRecommendation"));
        SOAPUtility.addProperties(commandElement, properties);
        SOAPUtility.addRecommendations(commandElement, recommendations);
    }

    private static void addBodyToMigrateAggregateAdvisorRecommendation(SOAPMessage requestMessage, AggregateAdvisorRecommendationsReply recommendationsReply) throws SOAPException {
        SOAPPart soapPart = requestMessage.getSOAPPart();
        SOAPEnvelope soapEnvelope = soapPart.getEnvelope();
        SOAPBody soapBody = soapEnvelope.getBody();
        SOAPElement commandElement = soapBody.addChildElement(soapEnvelope.createName("migrateAggregateAdvisorRecommendation"));
        if (recommendationsReply != null) {
            SOAPUtility.addState(commandElement, recommendationsReply.getState());
            SOAPUtility.addMessages(commandElement, recommendationsReply.getMessages());
            SOAPUtility.addOptions(commandElement, recommendationsReply.getOptions());
            SOAPUtility.addProperties(commandElement, recommendationsReply.getProperties());
            SOAPUtility.addRecommendations(commandElement, recommendationsReply.getRecommendations());
        }
    }

    private static void addState(SOAPElement parentElement, AggregateAdvisorState state) throws SOAPException {
        if (state != null) {
            SOAPUtility.addChildText(parentElement, "state", state.toString());
        }
    }

    private static void addMessages(SOAPElement parentElement, List<String> messages) throws SOAPException {
        if (messages == null || messages.isEmpty()) {
            return;
        }
        SOAPElement messagesElement = parentElement.addChildElement("messages");
        for (String message : messages) {
            SOAPUtility.addChildText(messagesElement, "message", message);
        }
    }

    private static void addRecommendations(SOAPElement parentElement, AggregateAdvisorRecommendations recommendationsObject) throws SOAPException {
        if (recommendationsObject == null) {
            return;
        }
        SOAPElement recommendationsElement = parentElement.addChildElement("recommendations");
        AggregateAdvisorRecommendedAggregates recommendedAggregatesInDatabaseObject = recommendationsObject.getRecommendedAggregatesInDatabase();
        SOAPUtility.addRecommendedAggregatesInDatabaseOrMemory(recommendationsElement, "recommendedAggregatesInDatabase", recommendedAggregatesInDatabaseObject);
        AggregateAdvisorRecommendedAggregates recommendedAggregatesInMemoryObject = recommendationsObject.getRecommendedAggregatesInMemory();
        SOAPUtility.addRecommendedAggregatesInDatabaseOrMemory(recommendationsElement, "recommendedAggregatesInMemory", recommendedAggregatesInMemoryObject);
    }

    private static void addRecommendedAggregatesInDatabaseOrMemory(SOAPElement recommendationsElement, String recommendedAggregatesInDatabaseOrMemoryElementName, AggregateAdvisorRecommendedAggregates recommendedAggregatesInDatabaseOrMemoryObject) throws SOAPException {
        if (recommendedAggregatesInDatabaseOrMemoryObject == null) {
            return;
        }
        SOAPElement recommendedAggregatesInDatabaseOrMemoryElement = recommendationsElement.addChildElement(recommendedAggregatesInDatabaseOrMemoryElementName);
        String metaInfoAsText = recommendedAggregatesInDatabaseOrMemoryObject.getMetaInfoAsText();
        SOAPUtility.addChildCDATA(recommendedAggregatesInDatabaseOrMemoryElement, "metaInfoText", metaInfoAsText);
        String metaInfoAsXML = recommendedAggregatesInDatabaseOrMemoryObject.getMetaInfoAsXML();
        SOAPUtility.addChildText(recommendedAggregatesInDatabaseOrMemoryElement, "metaInfoXML", metaInfoAsXML);
        int count = recommendedAggregatesInDatabaseOrMemoryObject.getCount();
        SOAPUtility.addChildText(recommendedAggregatesInDatabaseOrMemoryElement, "count", String.valueOf(count));
        int coverage = recommendedAggregatesInDatabaseOrMemoryObject.getEstimatedCoverage();
        SOAPUtility.addChildText(recommendedAggregatesInDatabaseOrMemoryElement, "coverage", String.valueOf(coverage));
        long spaceRequired = recommendedAggregatesInDatabaseOrMemoryObject.getEstimatedSpaceRequired();
        SOAPUtility.addChildText(recommendedAggregatesInDatabaseOrMemoryElement, "spaceRequired", String.valueOf(spaceRequired));
        SOAPUtility.addRecommendedAggregates(recommendedAggregatesInDatabaseOrMemoryElement, recommendedAggregatesInDatabaseOrMemoryObject);
    }

    private static void addRecommendedAggregates(SOAPElement recommendedAggregatesInDatabaseOrMemoryElement, AggregateAdvisorRecommendedAggregates recommendedAggregatesInDatabaseOrMemoryObject) throws SOAPException {
        List<AggregateAdvisorRecommendedAggregate> recommendedAggregateObjects = recommendedAggregatesInDatabaseOrMemoryObject.getRecommendedAggregates();
        if (recommendedAggregateObjects == null || recommendedAggregateObjects.isEmpty()) {
            return;
        }
        SOAPElement recommendedAggregatesElement = recommendedAggregatesInDatabaseOrMemoryElement.addChildElement("recommendedAggregates");
        for (AggregateAdvisorRecommendedAggregate recommendedAggregateObject : recommendedAggregateObjects) {
            SOAPElement recommendedAggregateElement = recommendedAggregatesElement.addChildElement("recommendedAggregate");
            String name = recommendedAggregateObject.getName();
            SOAPUtility.addChildText(recommendedAggregateElement, "name", name);
            long size = recommendedAggregateObject.getSize();
            SOAPUtility.addChildText(recommendedAggregateElement, "size", String.valueOf(size));
            SOAPUtility.addLevels(recommendedAggregateElement, recommendedAggregateObject);
            SOAPUtility.addMeasures(recommendedAggregateElement, recommendedAggregateObject);
        }
    }

    private static void addLevels(SOAPElement recommendedAggregateElement, AggregateAdvisorRecommendedAggregate recommendedAggregateObject) throws SOAPException {
        List<String> levels = recommendedAggregateObject.getLevels();
        if (levels == null || levels.isEmpty()) {
            return;
        }
        SOAPElement levelsElement = recommendedAggregateElement.addChildElement("levels");
        for (String level : levels) {
            SOAPUtility.addChildText(levelsElement, "level", level);
        }
    }

    private static void addMeasures(SOAPElement recommendedAggregateElement, AggregateAdvisorRecommendedAggregate recommendedAggregateObject) throws SOAPException {
        List<String> measures = recommendedAggregateObject.getMeasures();
        if (measures == null || measures.isEmpty()) {
            return;
        }
        SOAPElement measuresElement = recommendedAggregateElement.addChildElement("measures");
        for (String measure : measures) {
            SOAPUtility.addChildText(measuresElement, "measure", measure);
        }
    }

    private static void addChildText(SOAPElement parentElement, String childElementName, String grandchildNodeValue) throws SOAPException {
        if (grandchildNodeValue != null && !grandchildNodeValue.isEmpty()) {
            SOAPElement childElement = parentElement.addChildElement(childElementName);
            childElement.addTextNode(grandchildNodeValue);
        }
    }

    private static void addChildCDATA(SOAPElement parentElement, String childElementName, String grandchildNodeValue) throws SOAPException {
        if (grandchildNodeValue != null && !grandchildNodeValue.isEmpty()) {
            SOAPElement childElement = parentElement.addChildElement(childElementName);
            Document document = childElement.getOwnerDocument();
            CDATASection grandchildNode = document.createCDATASection(grandchildNodeValue);
            childElement.appendChild((Node)grandchildNode);
        }
    }

    private static void addBodyToUpdateAggregateAdvisorRecommendationName(SOAPMessage requestMessage, String cubeName, String recommendationID, String recommendationName) throws SOAPException {
        SOAPPart soapPart = requestMessage.getSOAPPart();
        SOAPEnvelope soapEnvelope = soapPart.getEnvelope();
        SOAPBody soapBody = soapEnvelope.getBody();
        SOAPElement commandElement = soapBody.addChildElement(soapEnvelope.createName("updateAggregateAdvisorRecommendationName"));
        SOAPUtility.addChildText(commandElement, "cubeName", cubeName);
        SOAPUtility.addChildText(commandElement, "recommendationID", recommendationID);
        SOAPUtility.addChildText(commandElement, "recommendationName", recommendationName);
    }

    private static void addBodyToDeleteAggregateAdvisorRecommendations(SOAPMessage requestMessage, String cubeName, List<String> recommendationIDs) throws SOAPException {
        SOAPPart soapPart = requestMessage.getSOAPPart();
        SOAPEnvelope soapEnvelope = soapPart.getEnvelope();
        SOAPBody soapBody = soapEnvelope.getBody();
        SOAPElement commandElement = soapBody.addChildElement(soapEnvelope.createName("deleteAggregateAdvisorRecommendations"));
        SOAPUtility.addChildText(commandElement, "cubeName", cubeName);
        if (recommendationIDs != null && !recommendationIDs.isEmpty()) {
            SOAPElement recommendationIDsElement = commandElement.addChildElement("recommendationIDs");
            for (String recommendationID : recommendationIDs) {
                SOAPUtility.addChildText(recommendationIDsElement, "recommendationID", recommendationID);
            }
        }
    }

    private static void addBodyToReplaceAggregateAdvisorSession(SOAPMessage requestMessage, String sessionID) throws SOAPException {
        SOAPPart soapPart = requestMessage.getSOAPPart();
        SOAPEnvelope soapEnvelope = soapPart.getEnvelope();
        SOAPBody soapBody = soapEnvelope.getBody();
        SOAPElement commandElement = soapBody.addChildElement(soapEnvelope.createName("replaceAggregateAdvisorSession"));
        SOAPUtility.addChildText(commandElement, "sessionID", sessionID);
    }

    private static void addBodyToExecuteCommand(SOAPMessage requestMessage, String commandName) throws SOAPException {
        SOAPBody soapBody;
        SOAPEnvelope soapEnvelope;
        if (requestMessage == null) {
            return;
        }
        SOAPPart soapPart = requestMessage.getSOAPPart();
        if (soapPart != null && (soapEnvelope = soapPart.getEnvelope()) != null && (soapBody = soapEnvelope.getBody()) != null) {
            soapBody.addChildElement(soapEnvelope.createName(commandName));
        }
    }

    private static SOAPMessage sendSOAPRequestMessage(SOAPMessage soapRequest, URL dispatcherURL) throws SOAPException {
        SOAPConnection soapConnection = SOAPUtility.createConnection();
        SOAPMessage responseMessage = soapConnection.call(soapRequest, (Object)dispatcherURL);
        soapConnection.close();
        return responseMessage;
    }

    private static SOAPMessage sendCAMRequestMessage(SOAPMessage soapRequest, URL dispatcherURL) throws SOAPException {
        HttpClient httpClient = null;
        int methodResponseCode = 0;
        byte[] response = null;
        PostMethod post = null;
        SOAPMessage soapResponse = null;
        try {
            httpClient = SOAPUtility.getCamFactory().createHttpClient(dispatcherURL);
            post = new PostMethod();
            post.setPath(dispatcherURL.getFile());
            post.setRequestHeader("Content-Type", "text/xml; charset=utf-8");
            post.setRequestHeader(SOAP_ACTION, QUERY_SERVICE);
            String request = SOAPUtility.toString(soapRequest);
            post.setRequestBody(request);
            methodResponseCode = httpClient.executeMethod((HttpMethod)post);
            if (methodResponseCode == 200) {
                response = post.getResponseBody();
                soapResponse = SOAPUtility.createResponseMessage(response);
            }
        }
        catch (Exception e1) {
            AggregateAdvisorClient.getLogger().log(Level.SEVERE, String.format("Failed to send the request to the Query Service at %s", dispatcherURL), e1);
            AACRuntimeException ex = new AACRuntimeException(AACMessageKeys.GEN_FailedToSendSOAPRequest, e1, dispatcherURL.toString());
            throw AACRuntimeException.wrap(ex);
        }
        finally {
            if (post != null) {
                post.releaseConnection();
            }
        }
        return soapResponse;
    }

    public static SOAPMessage sendRequestMessage(SOAPMessage requestMessage, URL dispatcherURL) throws SOAPException {
        if (AggregateAdvisorClient.getLogger().isLogging(Level.FINE)) {
            try {
                AggregateAdvisorClient.getLogger().log(Level.FINE, String.format("SOAP request: %s", SOAPUtility.toString(requestMessage)));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        SOAPMessage responseMessage = null;
        responseMessage = HTTP_PROTOCOL.equalsIgnoreCase(dispatcherURL.getProtocol()) ? SOAPUtility.sendSOAPRequestMessage(requestMessage, dispatcherURL) : SOAPUtility.sendCAMRequestMessage(requestMessage, dispatcherURL);
        if (AggregateAdvisorClient.getLogger().isLogging(Level.FINE)) {
            try {
                AggregateAdvisorClient.getLogger().log(Level.FINE, String.format("SOAP response: %s", SOAPUtility.toString(responseMessage)));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return responseMessage;
    }

    public static AggregateAdvisorRecommendationsReply extractAggregateAdvisorRecommendationsReply(SOAPMessage responseMessage, String requestType) throws SOAPException {
        AggregateAdvisorRecommendationsReply replyObject = null;
        SOAPBody soapBody = SOAPUtility.getBody(responseMessage);
        SOAPElement responseElement = SOAPUtility.getChildElement((SOAPElement)soapBody, requestType + RESPONSE);
        if (responseElement != null) {
            SOAPElement replyElement = SOAPUtility.getChildElement(responseElement, "aggregateAdvisorRecommendationsReply");
            replyObject = SOAPUtility.extractAggregateAdvisorRecommendationsReply(replyElement);
        }
        return replyObject;
    }

    private static AggregateAdvisorRecommendationsReply extractAggregateAdvisorRecommendationsReply(SOAPElement replyElement) {
        AggregateAdvisorRecommendationsReply replyObject = null;
        if (replyElement != null) {
            replyObject = new AggregateAdvisorRecommendationsReply();
            SOAPUtility.extractState(replyElement, replyObject);
            SOAPUtility.extractMessages(replyElement, replyObject);
            SOAPUtility.extractOptions(replyElement, replyObject);
            SOAPUtility.extractProperties(replyElement, replyObject);
            SOAPUtility.extractProgress(replyElement, replyObject);
            SOAPUtility.extractRecommendations(replyElement, replyObject);
        }
        return replyObject;
    }

    private static void extractProperties(SOAPElement replyElement, AggregateAdvisorRecommendationsReply replyObject) {
        SOAPElement propertiesElement = SOAPUtility.getChildElement(replyElement, "properties");
        if (propertiesElement != null) {
            Iterator propertyIterator = propertiesElement.getChildElements();
            while (propertyIterator.hasNext()) {
                SOAPElement propertyElement = (SOAPElement)propertyIterator.next();
                String propertyName = SOAPUtility.getChildValueAsString(propertyElement, "name");
                String propertyValue = SOAPUtility.getChildValueAsString(propertyElement, "value");
                replyObject.addProperty(propertyName, propertyValue);
            }
        }
    }

    private static void extractState(SOAPElement replyElement, AggregateAdvisorReply replyObject) {
        String stateString = SOAPUtility.getChildValueAsString(replyElement, "state");
        if (stateString != null && stateString.length() > 0) {
            AggregateAdvisorState state = AggregateAdvisorState.getValue(stateString);
            replyObject.setState(state);
        }
    }

    private static void extractMessages(SOAPElement replyElement, AggregateAdvisorReply replyObject) {
        SOAPElement messagesElement = SOAPUtility.getChildElement(replyElement, "messages");
        if (messagesElement != null) {
            Iterator messageIterator = messagesElement.getChildElements();
            while (messageIterator.hasNext()) {
                SOAPElement messageElement = (SOAPElement)messageIterator.next();
                String messageString = messageElement.getValue();
                replyObject.addMessage(messageString);
            }
        }
    }

    private static void extractOptions(SOAPElement replyElement, AggregateAdvisorRecommendationsReply replyObject) {
        SOAPElement optionsElement = SOAPUtility.getChildElement(replyElement, "options");
        if (optionsElement != null) {
            Iterator optionIterator = optionsElement.getChildElements();
            while (optionIterator.hasNext()) {
                SOAPElement optionElement = (SOAPElement)optionIterator.next();
                String optionName = SOAPUtility.getChildValueAsString(optionElement, "name");
                String optionValueAsString = SOAPUtility.getChildValueAsString(optionElement, "value");
                try {
                    AggregateAdvisorOption aggregateAdvisorOption = null;
                    AggregateAdvisorOptionName aggregateAdvisorOptionName = AggregateAdvisorOptionName.getOption(optionName);
                    if (aggregateAdvisorOptionName != null) {
                        Class<?> optionValueType = aggregateAdvisorOptionName.getValueType();
                        if (optionValueType == Boolean.TYPE) {
                            boolean optionValueAsBoolean = Boolean.parseBoolean(optionValueAsString);
                            aggregateAdvisorOption = AggregateAdvisorOptionFactory.createOption(aggregateAdvisorOptionName, optionValueAsBoolean);
                        } else if (optionValueType == Integer.TYPE) {
                            int optionValueAsInt = Integer.parseInt(optionValueAsString);
                            aggregateAdvisorOption = AggregateAdvisorOptionFactory.createOption(aggregateAdvisorOptionName, optionValueAsInt);
                        } else if (optionValueType == Long.TYPE) {
                            long optionValueAsLong = Long.parseLong(optionValueAsString);
                            aggregateAdvisorOption = AggregateAdvisorOptionFactory.createOption(aggregateAdvisorOptionName, optionValueAsLong);
                        } else if (optionValueType == String.class) {
                            aggregateAdvisorOption = AggregateAdvisorOptionFactory.createOption(aggregateAdvisorOptionName, optionValueAsString);
                        }
                    }
                    if (aggregateAdvisorOption == null) continue;
                    replyObject.addOption(aggregateAdvisorOption);
                }
                catch (Exception ex) {
                    AggregateAdvisorClient.getLogger().log(Level.WARNING, String.format("An exception occurred while processing the option with the name \"%s\" and value \"%s\": %s", optionName, optionValueAsString, ex), ex);
                }
            }
        }
    }

    private static void extractProgress(SOAPElement replyElement, AggregateAdvisorRecommendationsReply replyObject) {
        SOAPElement progressElement = SOAPUtility.getChildElement(replyElement, "progress");
        if (progressElement != null) {
            Iterator progressIterator = progressElement.getChildElements();
            while (progressIterator.hasNext()) {
                SOAPElement pointElement = (SOAPElement)progressIterator.next();
                int time = SOAPUtility.getChildValueAsInt(pointElement, "progressTime");
                int value = SOAPUtility.getChildValueAsInt(pointElement, "progressValue");
                replyObject.addProgress(time, value);
            }
        }
    }

    private static void extractRecommendations(SOAPElement replyElement, AggregateAdvisorRecommendationsReply replyObject) {
        SOAPElement recommendationsElement = SOAPUtility.getChildElement(replyElement, "recommendations");
        if (recommendationsElement == null) {
            return;
        }
        AggregateAdvisorRecommendations recommendationsObject = new AggregateAdvisorRecommendations();
        replyObject.setRecommendations(recommendationsObject);
        SOAPUtility.extractRecommendedAggregatesInDatabase(recommendationsElement, recommendationsObject);
        SOAPUtility.extractRecommendedAggregatesInMemory(recommendationsElement, recommendationsObject);
    }

    private static void extractRecommendedAggregatesInDatabase(SOAPElement recommendationsElement, AggregateAdvisorRecommendations recommendationsObject) {
        AggregateAdvisorRecommendedAggregates inDatabaseObject = SOAPUtility.getRecommendedAggregatesInDatabaseOrMemory(recommendationsElement, "recommendedAggregatesInDatabase");
        recommendationsObject.setRecommendedAggregatesInDatabase(inDatabaseObject);
    }

    private static void extractRecommendedAggregatesInMemory(SOAPElement recommendationsElement, AggregateAdvisorRecommendations recommendationsObject) {
        AggregateAdvisorRecommendedAggregates inMemoryObject = SOAPUtility.getRecommendedAggregatesInDatabaseOrMemory(recommendationsElement, "recommendedAggregatesInMemory");
        recommendationsObject.setRecommendedAggregatesInMemory(inMemoryObject);
    }

    private static AggregateAdvisorRecommendedAggregates getRecommendedAggregatesInDatabaseOrMemory(SOAPElement recommendationsElement, String childElementName) {
        SOAPElement inDatabaseOrMemoryElement = SOAPUtility.getChildElement(recommendationsElement, childElementName);
        if (inDatabaseOrMemoryElement == null) {
            return null;
        }
        AggregateAdvisorRecommendedAggregates inDatabaseOrMemoryObject = new AggregateAdvisorRecommendedAggregates();
        SOAPUtility.extractMetaInfo(inDatabaseOrMemoryElement, inDatabaseOrMemoryObject);
        SOAPUtility.extractSummaryInfo(inDatabaseOrMemoryElement, inDatabaseOrMemoryObject);
        SOAPUtility.extractDetailedInfo(inDatabaseOrMemoryElement, inDatabaseOrMemoryObject);
        return inDatabaseOrMemoryObject;
    }

    private static void extractMetaInfo(SOAPElement inDatabaseOrMemoryElement, AggregateAdvisorRecommendedAggregates inDatabaseOrMemoryObject) {
        String metaInfoTextString = SOAPUtility.getChildValueAsString(inDatabaseOrMemoryElement, "metaInfoText");
        inDatabaseOrMemoryObject.setMetaInfoAsText(metaInfoTextString);
        String metaInfoXMLString = SOAPUtility.getChildValueAsString(inDatabaseOrMemoryElement, "metaInfoXML");
        inDatabaseOrMemoryObject.setMetaInfoAsXML(metaInfoXMLString);
    }

    private static void extractSummaryInfo(SOAPElement inDatabaseOrMemoryElement, AggregateAdvisorRecommendedAggregates inDatabaseOrMemoryObject) {
        int count = SOAPUtility.getChildValueAsInt(inDatabaseOrMemoryElement, "count");
        inDatabaseOrMemoryObject.setCount(count);
        int coverage = SOAPUtility.getChildValueAsInt(inDatabaseOrMemoryElement, "coverage");
        inDatabaseOrMemoryObject.setEstimatedCoverage(coverage);
        long spaceRequired = SOAPUtility.getChildValueAsLong(inDatabaseOrMemoryElement, "spaceRequired");
        inDatabaseOrMemoryObject.setEstimatedSpaceRequired(spaceRequired);
    }

    private static void extractDetailedInfo(SOAPElement inDatabaseOrMemoryElement, AggregateAdvisorRecommendedAggregates inDatabaseOrMemoryObject) {
        SOAPElement recommendedAggregatesElement = SOAPUtility.getChildElement(inDatabaseOrMemoryElement, "recommendedAggregates");
        if (recommendedAggregatesElement != null) {
            Iterator recommendedAggregateIterator = recommendedAggregatesElement.getChildElements();
            while (recommendedAggregateIterator.hasNext()) {
                SOAPElement measuresElement;
                SOAPElement recommendedAggregateElement = (SOAPElement)recommendedAggregateIterator.next();
                AggregateAdvisorRecommendedAggregate recommendedAggregateObject = new AggregateAdvisorRecommendedAggregate();
                inDatabaseOrMemoryObject.addRecommendedAggregate(recommendedAggregateObject);
                String name = SOAPUtility.getChildValueAsString(recommendedAggregateElement, "name");
                recommendedAggregateObject.setName(name);
                long size = SOAPUtility.getChildValueAsLong(recommendedAggregateElement, "size");
                recommendedAggregateObject.setSize(size);
                SOAPElement levelsElement = SOAPUtility.getChildElement(recommendedAggregateElement, "levels");
                if (levelsElement != null) {
                    Iterator levelIterator = levelsElement.getChildElements();
                    while (levelIterator.hasNext()) {
                        SOAPElement levelElement = (SOAPElement)levelIterator.next();
                        String level = levelElement.getValue();
                        recommendedAggregateObject.addLevel(level);
                    }
                }
                if ((measuresElement = SOAPUtility.getChildElement(recommendedAggregateElement, "measures")) == null) continue;
                Iterator measureIterator = measuresElement.getChildElements();
                while (measureIterator.hasNext()) {
                    SOAPElement measureElement = (SOAPElement)measureIterator.next();
                    String measure = measureElement.getValue();
                    recommendedAggregateObject.addMeasure(measure);
                }
            }
        }
    }

    public static AggregateAdvisorCurrentWorkloadReply extractWorkloadReply(SOAPMessage responseMessage) throws SOAPException {
        SOAPElement replyElement;
        AggregateAdvisorCurrentWorkloadReply replyObject = new AggregateAdvisorCurrentWorkloadReply();
        SOAPBody soapBody = SOAPUtility.getBody(responseMessage);
        SOAPElement responseElement = SOAPUtility.getChildElement((SOAPElement)soapBody, "getCurrentWorkloadForAggregateAdvisorResponse");
        if (responseElement != null && (replyElement = SOAPUtility.getChildElement(responseElement, "aggregateAdvisorCurrentWorkloadReply")) != null) {
            SOAPUtility.extractTimeFrame(replyElement, replyObject);
            SOAPUtility.extractPackageNames(replyElement, replyObject);
            SOAPUtility.extractReportNames(replyElement, replyObject);
            SOAPUtility.extractUserNames(replyElement, replyObject);
        }
        return replyObject;
    }

    private static void extractTimeFrame(SOAPElement replyElement, AggregateAdvisorCurrentWorkloadReply replyObject) {
        if (replyElement == null || replyObject == null) {
            return;
        }
        SOAPElement timeFrameElement = SOAPUtility.getChildElement(replyElement, "timeFrame");
        if (timeFrameElement != null) {
            long startTime = SOAPUtility.getChildValueAsLong(timeFrameElement, "startTime");
            replyObject.setStartTime(startTime);
            long endTime = SOAPUtility.getChildValueAsLong(timeFrameElement, "endTime");
            replyObject.setEndTime(endTime);
        }
    }

    private static void extractPackageNames(SOAPElement replyElement, AggregateAdvisorCurrentWorkloadReply replyObject) {
        if (replyElement == null || replyObject == null) {
            return;
        }
        SOAPElement namesElement = SOAPUtility.getChildElement(replyElement, "packageNames");
        if (namesElement != null) {
            Iterator nameIterator = namesElement.getChildElements();
            while (nameIterator.hasNext()) {
                SOAPElement nameElement = (SOAPElement)nameIterator.next();
                String nameString = nameElement.getValue();
                replyObject.addPackageName(nameString);
            }
        }
    }

    private static void extractReportNames(SOAPElement replyElement, AggregateAdvisorCurrentWorkloadReply replyObject) {
        if (replyElement == null || replyObject == null) {
            return;
        }
        SOAPElement namesElement = SOAPUtility.getChildElement(replyElement, "reportNames");
        if (namesElement != null) {
            Iterator nameIterator = namesElement.getChildElements();
            while (nameIterator.hasNext()) {
                SOAPElement nameElement = (SOAPElement)nameIterator.next();
                String nameString = nameElement.getValue();
                replyObject.addReportName(nameString);
            }
        }
    }

    private static void extractUserNames(SOAPElement replyElement, AggregateAdvisorCurrentWorkloadReply replyObject) {
        if (replyElement == null || replyObject == null) {
            return;
        }
        SOAPElement namesElement = SOAPUtility.getChildElement(replyElement, "userNames");
        if (namesElement != null) {
            Iterator nameIterator = namesElement.getChildElements();
            while (nameIterator.hasNext()) {
                SOAPElement nameElement = (SOAPElement)nameIterator.next();
                String nameString = nameElement.getValue();
                replyObject.addUserName(nameString);
            }
        }
    }

    public static AggregateAdvisorRetrieveRecommendationsReply extractAggregateAdvisorRetrieveRecommendationsReply(SOAPMessage responseMessage, String requestType) throws SOAPException {
        SOAPElement replyElement;
        AggregateAdvisorRetrieveRecommendationsReply replyObject = null;
        SOAPBody soapBody = SOAPUtility.getBody(responseMessage);
        SOAPElement responseElement = SOAPUtility.getChildElement((SOAPElement)soapBody, requestType + RESPONSE);
        if (responseElement != null && (replyElement = SOAPUtility.getChildElement(responseElement, "aggregateAdvisorRetrieveRecommendationsReply")) != null) {
            replyObject = new AggregateAdvisorRetrieveRecommendationsReply();
            SOAPUtility.extractState(replyElement, replyObject);
            SOAPUtility.extractMessages(replyElement, replyObject);
            SOAPUtility.extractAggregateAdvisorRecommendationsReplies(replyElement, replyObject);
        }
        return replyObject;
    }

    private static void extractAggregateAdvisorRecommendationsReplies(SOAPElement retrieveRecommendationsReplyElement, AggregateAdvisorRetrieveRecommendationsReply retrieveRecommendationsReplyObject) {
        SOAPElement aggregateAdvisorRecommendationsRepliesElement = SOAPUtility.getChildElement(retrieveRecommendationsReplyElement, "aggregateAdvisorRecommendationsReplies");
        if (aggregateAdvisorRecommendationsRepliesElement != null) {
            Iterator aggregateAdvisorRecommendationsReplyIterator = aggregateAdvisorRecommendationsRepliesElement.getChildElements();
            while (aggregateAdvisorRecommendationsReplyIterator.hasNext()) {
                SOAPElement aggregateAdvisorRecommendationsReplyElement = (SOAPElement)aggregateAdvisorRecommendationsReplyIterator.next();
                AggregateAdvisorRecommendationsReply aggregateAdvisorRecommendationsReplyObject = SOAPUtility.extractAggregateAdvisorRecommendationsReply(aggregateAdvisorRecommendationsReplyElement);
                if (aggregateAdvisorRecommendationsReplyObject == null) continue;
                retrieveRecommendationsReplyObject.addRecommendation(aggregateAdvisorRecommendationsReplyObject);
            }
        }
    }

    public static AggregateAdvisorStoreRecommendationReply extractAggregateAdvisorStoreRecommendationReply(SOAPMessage responseMessage, String requestType) throws SOAPException {
        SOAPElement storeRecommendationReplyElement;
        AggregateAdvisorStoreRecommendationReply storeRecommendationReplyObject = null;
        SOAPBody soapBody = SOAPUtility.getBody(responseMessage);
        SOAPElement responseElement = SOAPUtility.getChildElement((SOAPElement)soapBody, requestType + RESPONSE);
        if (responseElement != null && (storeRecommendationReplyElement = SOAPUtility.getChildElement(responseElement, "aggregateAdvisorStoreRecommendationReply")) != null) {
            storeRecommendationReplyObject = new AggregateAdvisorStoreRecommendationReply();
            SOAPUtility.extractState(storeRecommendationReplyElement, storeRecommendationReplyObject);
            SOAPUtility.extractMessages(storeRecommendationReplyElement, storeRecommendationReplyObject);
            SOAPElement recommendationsReplyElement = SOAPUtility.getChildElement(storeRecommendationReplyElement, "aggregateAdvisorRecommendationsReply");
            AggregateAdvisorRecommendationsReply recommendationsReplyObject = SOAPUtility.extractAggregateAdvisorRecommendationsReply(recommendationsReplyElement);
            storeRecommendationReplyObject.setRecommendation(recommendationsReplyObject);
        }
        return storeRecommendationReplyObject;
    }

    public static AggregateAdvisorReply extractAggregateAdvisorReply(SOAPMessage responseMessage, String requestType) throws SOAPException {
        SOAPElement replyElement;
        AggregateAdvisorReply replyObject = null;
        SOAPBody soapBody = SOAPUtility.getBody(responseMessage);
        SOAPElement responseElement = SOAPUtility.getChildElement((SOAPElement)soapBody, requestType + RESPONSE);
        if (responseElement != null && (replyElement = SOAPUtility.getChildElement(responseElement, "aggregateAdvisorReply")) != null) {
            replyObject = new AggregateAdvisorReply();
            SOAPUtility.extractState(replyElement, replyObject);
            SOAPUtility.extractMessages(replyElement, replyObject);
        }
        return replyObject;
    }

    private static String getChildValueAsString(SOAPElement parentElement, String childName) {
        if (parentElement == null || childName == null || childName.length() == 0) {
            return null;
        }
        SOAPElement childElement = SOAPUtility.getChildElement(parentElement, childName);
        if (childElement == null) {
            return "";
        }
        String stringValue = childElement.getTextContent();
        return stringValue;
    }

    private static int getChildValueAsInt(SOAPElement parentElement, String childName) {
        if (parentElement == null || childName == null || childName.length() == 0) {
            return 0;
        }
        String stringValue = SOAPUtility.getChildValueAsString(parentElement, childName);
        int intValue = Integer.parseInt(stringValue);
        return intValue;
    }

    private static long getChildValueAsLong(SOAPElement parentElement, String childName) {
        if (parentElement == null || childName == null || childName.length() == 0) {
            return 0L;
        }
        String stringValue = SOAPUtility.getChildValueAsString(parentElement, childName);
        long longValue = Long.parseLong(stringValue);
        return longValue;
    }

    private static SOAPElement getChildElement(SOAPElement parentElement, String childName) {
        if (parentElement == null || childName == null || childName.length() == 0) {
            return null;
        }
        Iterator childIterator = parentElement.getChildElements();
        while (childIterator.hasNext()) {
            SOAPElement childElement;
            Object childObject = childIterator.next();
            if (!(childObject instanceof SOAPElement) || !childName.equals((childElement = (SOAPElement)childObject).getLocalName())) continue;
            return childElement;
        }
        return null;
    }

    private static String toString(SOAPMessage message) throws Exception {
        if (message != null) {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            message.writeTo((OutputStream)baos);
            return baos.toString(UTF8);
        }
        return null;
    }

    private static SOAPBody getBody(SOAPMessage message) throws SOAPException {
        if (message != null) {
            SOAPBody soapBody = message.getSOAPBody();
            SOAPUtility.throwExceptionIfBodyContainsFault(soapBody);
            return soapBody;
        }
        return null;
    }

    private static void throwExceptionIfBodyContainsFault(SOAPBody soapBody) throws SOAPException {
        if (soapBody == null || !soapBody.hasFault()) {
            return;
        }
        SOAPFault soapFault = soapBody.getFault();
        String faultString = soapFault.getFaultString();
        AggregateAdvisorClient.getLogger().log(Level.SEVERE, String.format("Throwing an exception because the SOAP body contains the fault: %s", faultString));
        throw new SOAPException(faultString);
    }

    static {
        if (camFactory == null) {
            camFactory = new CAMFactory();
            try {
                camFactory.initialize(CAM_INITIALIZE.getBytes(UTF8));
            }
            catch (Throwable e) {
                AggregateAdvisorClient.getLogger().log(Level.WARNING, "Failed to initialize CAM", e);
            }
        }
    }
}

