/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.data.providers.olap.sbwodp;

import com.cognos.xqe.config.ConfigException;
import com.cognos.xqe.config.ServiceEnumeration;
import com.cognos.xqe.config.XQECCLConfigurationAdapter;
import com.cognos.xqe.config.XQEConfiguration;
import com.cognos.xqe.config.XQEConfigurationEvent;
import com.cognos.xqe.config.XQEConfigurationListener;
import com.cognos.xqe.config.XQEConfigurationManager;
import com.cognos.xqe.config.XQESubConfiguration;
import com.cognos.xqe.data.providers.olap.sbwodp.SBWODPLog;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.trace.LogLevel;
import com.cognos.xqe.util.SingletonHelper;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.configuration.ConversionException;

public final class SBWODPConfig
implements XQEConfigurationListener {
    private static final String STR_LOAD_ERR = "Error loading XQEODP configuration: ";
    private boolean isRegistered = false;
    private static final boolean DEF_CHK_RTN_CD = Boolean.TRUE;
    private static final boolean DEF_DETECT_VAR_UNIQUE = Boolean.TRUE;
    private static final boolean DEF_UC_PWD = Boolean.FALSE;
    private static final boolean DEF_USE_FAST_GETMEM = Boolean.TRUE;
    private static final boolean DEF_TRACE_RFC = Boolean.FALSE;
    private static final boolean DEF_USE_RSOB = Boolean.FALSE;
    private static final boolean DEF_INVALIDATE_CONN_ON_SIDS_ERR = Boolean.FALSE;
    private static final boolean DEF_FUSH_CACHE_ON_SIDS_ERR = Boolean.FALSE;
    private static final int DEF_USE_MDX_RETRIEVE_MEMBERS_LIMIT = 500;
    private static final int DEF_SAP_CACHE_RESET = 0;
    private static final int DEF_MAX_TAB_ROWS = 50;
    private static final int DEF_SSO_CACHE_SIZE = 100;
    private static final int DEF_SSO_CACHE_TIMEOUT = 60;
    private static final int DEF_MAX_TDS_RANGES = 16;
    private static final int DEF_MAX_TDS_CARD = 1000000;
    private static final String DEF_DISPLAY_PROP = "Caption";
    private boolean checkReturnCode = DEF_CHK_RTN_CD;
    private boolean detectSAPVariableUniqueness = DEF_DETECT_VAR_UNIQUE;
    private boolean uppercasePwd = DEF_UC_PWD;
    private boolean useFastGetMembers = DEF_USE_FAST_GETMEM;
    private boolean traceRFC = DEF_TRACE_RFC;
    private boolean useRSOB = DEF_USE_RSOB;
    private boolean invalidateConnectionOnSIDSError = DEF_INVALIDATE_CONN_ON_SIDS_ERR;
    private boolean flushCacheOnSIDSError = DEF_FUSH_CACHE_ON_SIDS_ERR;
    private List<String> useFastGetMembersFor = null;
    private List<String> useReplacementVariablesFor = null;
    private int serverCacheReset = 0;
    private String displayProperty = "Caption";
    private int useMDXToRetrieveMembersLimit = 500;
    private int maxTableDumpRows = 50;
    private List<String> useMDXToRetrieveMembersFor = null;
    private List<String> unsecuredDimensions = null;
    private List<String> unsecuredVariables = null;
    private String bapiHTTPSSO = null;
    private int bapiSSOValidTime = 60;
    private int bapiSSOCacheSize = 100;
    private int maxTDSRanges = 16;
    private int maxTDSCard = 16;
    private static SingletonHelper<SBWODPConfig> singletonHelper = new SingletonHelper<SBWODPConfig>(){

        protected SBWODPConfig newInstance() {
            return new SBWODPConfig();
        }

        protected void releaseImpl(SBWODPConfig theInstance) {
        }

        protected void initializeImpl(SBWODPConfig theInstance) {
        }
    };

    private SBWODPConfig() {
        if (SBWODPLog.isOn("Configuration", LogLevel.TRACE).booleanValue()) {
            SBWODPLog.getLogger("Configuration").log(LogLevel.TRACE, "Constructing SBWODPConfig");
        }
        this.reload();
    }

    public static SBWODPConfig instance() {
        return (SBWODPConfig)singletonHelper.getInstance();
    }

    public void configurationChanged(XQEConfigurationEvent e) {
        if (e.isBeforeUpdate() || e.getType() != 20) {
            return;
        }
        this.reload();
    }

    public void reload() {
        XQEConfiguration config;
        if (SBWODPLog.isOn("Configuration", LogLevel.TRACE).booleanValue()) {
            SBWODPLog.getLogger("Configuration").log(LogLevel.TRACE, "Loading SBWODPConfig");
        }
        if ((config = XQEConfigurationManager.getInstance().getConfiguration(ServiceEnumeration.XQEODP)) == null) {
            if (SBWODPLog.isOn("Configuration", LogLevel.TRACE).booleanValue()) {
                SBWODPLog.getLogger("Configuration").log(LogLevel.TRACE, "Constructing new XQEConfiguration instance for XQEODP");
            }
            try {
                config = XQECCLConfigurationAdapter.createDefaultConfigurationForService((ServiceEnumeration)ServiceEnumeration.XQEODP);
                XQEConfigurationManager.getInstance().add(ServiceEnumeration.XQEODP, config);
                config.registerConfigurationListener((XQEConfigurationListener)this);
                this.isRegistered = true;
            }
            catch (ConfigException ce) {
                if (XQEMessageKeys.CFG_FileExistError == ce.getMessageKey()) {
                    if (SBWODPLog.isOn("Configuration", LogLevel.WARN).booleanValue()) {
                        SBWODPLog.getLogger("Configuration").log(LogLevel.WARN, STR_LOAD_ERR, (Throwable)ce);
                    }
                } else {
                    SBWODPLog.getLogger("Configuration").log(LogLevel.ERROR, STR_LOAD_ERR, (Throwable)ce);
                }
                return;
            }
        } else if (!this.isRegistered) {
            config.registerConfigurationListener((XQEConfigurationListener)this);
            this.isRegistered = true;
        }
        XQESubConfiguration sapConfig = config.getConfigForXQEODPComponent("SBWODP");
        if (sapConfig != null) {
            int i;
            String[] tmpArray;
            sapConfig.next();
            try {
                this.detectSAPVariableUniqueness = sapConfig.getBoolean("detectSAPVariableUniqueness[@value]", Boolean.valueOf(DEF_CHK_RTN_CD));
            }
            catch (ConversionException ce) {
                SBWODPLog.getLogger("Configuration").log(LogLevel.ERROR, "Error converting value of configuration parameter: detectSAPVariableUniqueness: ", (Throwable)ce);
            }
            try {
                this.checkReturnCode = sapConfig.getBoolean("checkReturnCode[@value]", Boolean.valueOf(DEF_CHK_RTN_CD));
            }
            catch (ConversionException ce) {
                SBWODPLog.getLogger("Configuration").log(LogLevel.ERROR, "Error converting value of configuration parameter: checkReturnCode: ", (Throwable)ce);
            }
            try {
                this.uppercasePwd = sapConfig.getBoolean("uppercasePwd[@value]", Boolean.valueOf(DEF_UC_PWD));
            }
            catch (ConversionException ce) {
                SBWODPLog.getLogger("Configuration").log(LogLevel.ERROR, "Error converting value of configuration parameter: uppercasePwd: ", (Throwable)ce);
            }
            try {
                this.useFastGetMembers = sapConfig.getBoolean("useFastGetMembers[@value]", Boolean.valueOf(DEF_USE_FAST_GETMEM));
            }
            catch (ConversionException ce) {
                SBWODPLog.getLogger("Configuration").log(LogLevel.ERROR, "Error converting value of configuration parameter: useFastGetMembers: ", (Throwable)ce);
            }
            try {
                this.traceRFC = sapConfig.getBoolean("traceRFC[@value]", Boolean.valueOf(DEF_TRACE_RFC));
            }
            catch (ConversionException ce) {
                SBWODPLog.getLogger("Configuration").log(LogLevel.ERROR, "Error converting value of configuration parameter: traceRFC: ", (Throwable)ce);
            }
            try {
                this.useRSOB = sapConfig.getBoolean("useRSOB[@value]", Boolean.valueOf(DEF_USE_RSOB));
            }
            catch (ConversionException ce) {
                SBWODPLog.getLogger("Configuration").log(LogLevel.ERROR, "Error converting value of configuration parameter: useRSOB: ", (Throwable)ce);
            }
            try {
                this.invalidateConnectionOnSIDSError = sapConfig.getBoolean("invalidateConnectionOnSIDSError[@value]", Boolean.valueOf(DEF_INVALIDATE_CONN_ON_SIDS_ERR));
            }
            catch (ConversionException ce) {
                SBWODPLog.getLogger("Configuration").log(LogLevel.ERROR, "Error converting value of configuration parameter: invalidateConnectionOnSIDSError: ", (Throwable)ce);
            }
            try {
                this.flushCacheOnSIDSError = sapConfig.getBoolean("flushCacheOnSIDSError[@value]", Boolean.valueOf(DEF_FUSH_CACHE_ON_SIDS_ERR));
            }
            catch (ConversionException ce) {
                SBWODPLog.getLogger("Configuration").log(LogLevel.ERROR, "Error converting value of configuration parameter: flushCacheOnSIDSError: ", (Throwable)ce);
            }
            try {
                this.serverCacheReset = sapConfig.getInteger("serverCacheReset[@value]", Integer.valueOf(0));
            }
            catch (ConversionException ce) {
                SBWODPLog.getLogger("Configuration").log(LogLevel.ERROR, "Error converting value of configuration parameter: serverCacheReset: ", (Throwable)ce);
            }
            try {
                tmpArray = sapConfig.getStringArray("unsecuredDimensions");
                if (tmpArray != null && tmpArray.length > 0) {
                    this.unsecuredDimensions = new ArrayList<String>(tmpArray.length);
                    for (i = 0; i < tmpArray.length; ++i) {
                        this.unsecuredDimensions.add(tmpArray[i].trim());
                    }
                } else {
                    this.unsecuredDimensions = null;
                }
            }
            catch (ConversionException ce) {
                SBWODPLog.getLogger("Configuration").log(LogLevel.ERROR, "Error converting value of configuration parameter: unsecuredDimensions: ", (Throwable)ce);
            }
            try {
                tmpArray = sapConfig.getStringArray("unsecuredVariables");
                if (tmpArray != null && tmpArray.length > 0) {
                    this.unsecuredVariables = new ArrayList<String>(tmpArray.length);
                    for (i = 0; i < tmpArray.length; ++i) {
                        this.unsecuredVariables.add(tmpArray[i].trim());
                    }
                } else {
                    this.unsecuredVariables = null;
                }
            }
            catch (ConversionException ce) {
                SBWODPLog.getLogger("Configuration").log(LogLevel.ERROR, "Error converting value of configuration parameter: unsecuredVariables: ", (Throwable)ce);
            }
            try {
                if (this.useFastGetMembers) {
                    tmpArray = sapConfig.getStringArray("useFastGetMembersFor");
                    if (tmpArray != null && tmpArray.length > 0) {
                        this.useFastGetMembersFor = new ArrayList<String>(tmpArray.length);
                        for (i = 0; i < tmpArray.length; ++i) {
                            this.useFastGetMembersFor.add(tmpArray[i].trim());
                        }
                    } else {
                        this.useFastGetMembersFor = null;
                    }
                } else {
                    this.useFastGetMembersFor = null;
                }
            }
            catch (ConversionException ce) {
                SBWODPLog.getLogger("Configuration").log(LogLevel.ERROR, "Error converting value of configuration parameter: useFastGetMembersFor: ", (Throwable)ce);
            }
            try {
                tmpArray = sapConfig.getStringArray("useReplacementVariablesFor");
                if (tmpArray != null && tmpArray.length > 0) {
                    this.useReplacementVariablesFor = new ArrayList<String>(tmpArray.length);
                    for (i = 0; i < tmpArray.length; ++i) {
                        this.useReplacementVariablesFor.add(tmpArray[i].trim());
                    }
                } else {
                    this.useReplacementVariablesFor = null;
                }
            }
            catch (ConversionException ce) {
                SBWODPLog.getLogger("Configuration").log(LogLevel.ERROR, "Error converting value of configuration parameter: useReplacementVariablesFor: ", (Throwable)ce);
            }
            try {
                this.displayProperty = sapConfig.getString("displayProperty[@value]", DEF_DISPLAY_PROP);
            }
            catch (ConversionException ce) {
                SBWODPLog.getLogger("Configuration").log(LogLevel.ERROR, "Error converting value of configuration parameter: displayProperty: ", (Throwable)ce);
            }
            try {
                this.useMDXToRetrieveMembersLimit = sapConfig.getInteger("useMDXToRetrieveMembersLimit[@value]", Integer.valueOf(500));
            }
            catch (ConversionException ce) {
                SBWODPLog.getLogger("Configuration").log(LogLevel.ERROR, "Error converting value of configuration parameter: useMDXToRetrieveMembersLimit: ", (Throwable)ce);
            }
            try {
                tmpArray = sapConfig.getStringArray("useMDXToRetrieveMembersFor");
                if (tmpArray != null && tmpArray.length > 0) {
                    this.useMDXToRetrieveMembersFor = new ArrayList<String>(tmpArray.length);
                    for (i = 0; i < tmpArray.length; ++i) {
                        this.useMDXToRetrieveMembersFor.add(tmpArray[i].trim());
                    }
                } else {
                    this.useMDXToRetrieveMembersFor = null;
                }
            }
            catch (ConversionException ce) {
                SBWODPLog.getLogger("Configuration").log(LogLevel.ERROR, "Error converting value of configuration parameter: useMDXToRetrieveMembersFor: ", (Throwable)ce);
            }
            try {
                this.maxTableDumpRows = sapConfig.getInteger("maxTableDumpRows[@value]", Integer.valueOf(50));
            }
            catch (ConversionException ce) {
                SBWODPLog.getLogger("Configuration").log(LogLevel.ERROR, "Error converting value of configuration parameter: maxTableDumpRows: ", (Throwable)ce);
            }
            try {
                this.bapiHTTPSSO = sapConfig.getString("bapiHTTPSSO[@value]", null);
            }
            catch (ConversionException ce) {
                SBWODPLog.getLogger("Configuration").log(LogLevel.ERROR, "Error converting value of configuration parameter: bapiHTTPSSO: ", (Throwable)ce);
            }
            try {
                this.bapiSSOValidTime = sapConfig.getInteger("bapiSSOValidTime[@value]", Integer.valueOf(60));
            }
            catch (ConversionException ce) {
                SBWODPLog.getLogger("Configuration").log(LogLevel.ERROR, "Error converting value of configuration parameter: bapiSSOValidTime: ", (Throwable)ce);
            }
            try {
                this.bapiSSOCacheSize = sapConfig.getInteger("bapiSSOCacheSize[@value]", Integer.valueOf(100));
            }
            catch (ConversionException ce) {
                SBWODPLog.getLogger("Configuration").log(LogLevel.ERROR, "Error converting value of configuration parameter: bapiSSOCacheSize: ", (Throwable)ce);
            }
            try {
                this.maxTDSRanges = sapConfig.getInteger("maxTDSRanges[@value]", Integer.valueOf(16));
            }
            catch (ConversionException ce) {
                SBWODPLog.getLogger("Configuration").log(LogLevel.ERROR, "Error converting value of configuration parameter: maxTDSRanges: ", (Throwable)ce);
            }
            try {
                this.maxTDSCard = sapConfig.getInteger("maxTDSCard[@value]", Integer.valueOf(1000000));
            }
            catch (ConversionException ce) {
                SBWODPLog.getLogger("Configuration").log(LogLevel.ERROR, "Error converting value of configuration parameter: maxTDSCard: ", (Throwable)ce);
            }
        } else if (SBWODPLog.isOn("Configuration", LogLevel.WARN).booleanValue()) {
            SBWODPLog.getLogger("Configuration").log(LogLevel.WARN, "Configuration for SBWODP provider not found");
        }
        this.writeToLog();
    }

    public boolean getCheckReturnCode() {
        return this.checkReturnCode;
    }

    public boolean getDetectSAPVariableUniqueness() {
        return this.detectSAPVariableUniqueness;
    }

    public boolean getUppercasePwd() {
        return this.uppercasePwd;
    }

    public boolean getUseFastGetMembers() {
        return this.useFastGetMembers;
    }

    public boolean getTraceRFC() {
        return this.traceRFC;
    }

    public boolean getUseRSOB() {
        return this.useRSOB;
    }

    public boolean getInvalidateConnectionOnSIDSError() {
        return this.invalidateConnectionOnSIDSError;
    }

    public boolean getFlushCacheOnSIDSError() {
        return this.flushCacheOnSIDSError;
    }

    public String getDisplayProperty() {
        return this.displayProperty;
    }

    public List<String> getUseFastGetMembersFor() {
        return this.useFastGetMembersFor;
    }

    public List<String> getUseReplacementVariablesFor() {
        return this.useReplacementVariablesFor;
    }

    public int getServerCacheReset() {
        return this.serverCacheReset;
    }

    public int getMDXToRetrieveMembersLimit() {
        return this.useMDXToRetrieveMembersLimit;
    }

    public List<String> getMDXToRetrieveMembersFor() {
        return this.useMDXToRetrieveMembersFor;
    }

    public int getMaxTableDumpRows() {
        return this.maxTableDumpRows;
    }

    public List<String> getUnsecuredDimensions() {
        return this.unsecuredDimensions;
    }

    public List<String> getUnsecuredVariables() {
        return this.unsecuredVariables;
    }

    public String getBapiHTTPSSO() {
        return this.bapiHTTPSSO;
    }

    public int getBapiSSOValidTime() {
        return this.bapiSSOValidTime;
    }

    public int getBapiSSOCacheSize() {
        return this.bapiSSOCacheSize;
    }

    public int getMaxTDSRanges() {
        return this.maxTDSRanges;
    }

    public int getMaxTDSCard() {
        return this.maxTDSCard;
    }

    public void writeToLog() {
        if (SBWODPLog.isOn("Configuration", LogLevel.WARN).booleanValue()) {
            int i;
            StringBuilder tmp;
            SBWODPLog.getLogger("Configuration").log(LogLevel.WARN, "SBWODPConfig: checkReturnCode: " + this.checkReturnCode);
            SBWODPLog.getLogger("Configuration").log(LogLevel.WARN, "SBWODPConfig: uppercasePwd: " + this.uppercasePwd);
            SBWODPLog.getLogger("Configuration").log(LogLevel.WARN, "SBWODPConfig: traceRFC: " + this.traceRFC);
            SBWODPLog.getLogger("Configuration").log(LogLevel.WARN, "SBWODPConfig: useRSOB: " + this.useRSOB);
            SBWODPLog.getLogger("Configuration").log(LogLevel.WARN, "SBWODPConfig: maxTableDumpRows: " + this.maxTableDumpRows);
            SBWODPLog.getLogger("Configuration").log(LogLevel.WARN, "SBWODPConfig: useFastGetMembers: " + this.useFastGetMembers);
            SBWODPLog.getLogger("Configuration").log(LogLevel.WARN, "SBWODPConfig: bapiHTTPSSO: " + this.bapiHTTPSSO);
            SBWODPLog.getLogger("Configuration").log(LogLevel.WARN, "SBWODPConfig: bapiSSOValidTime: " + this.bapiSSOValidTime);
            SBWODPLog.getLogger("Configuration").log(LogLevel.WARN, "SBWODPConfig: bapiSSOCacheSize: " + this.bapiSSOCacheSize);
            SBWODPLog.getLogger("Configuration").log(LogLevel.WARN, "SBWODPConfig: maxTDSRanges: " + this.maxTDSRanges);
            SBWODPLog.getLogger("Configuration").log(LogLevel.WARN, "SBWODPConfig: maxTDSCard: " + this.maxTDSCard);
            String bp = "SBWODPConfig: useFastGetMembersFor: ";
            if (this.useFastGetMembersFor == null) {
                SBWODPLog.getLogger("Configuration").log(LogLevel.WARN, bp);
            } else {
                tmp = new StringBuilder(this.useFastGetMembersFor.get(0));
                for (i = 1; i < this.useFastGetMembersFor.size(); ++i) {
                    tmp.append(",");
                    tmp.append(" ");
                    tmp.append(this.useFastGetMembersFor.get(i));
                }
                SBWODPLog.getLogger("Configuration").log(LogLevel.WARN, bp + tmp);
            }
            SBWODPLog.getLogger("Configuration").log(LogLevel.WARN, "SBWODPConfig: serverCacheReset: " + this.serverCacheReset);
            bp = "SBWODPConfig: unSecuredDimensions: ";
            if (this.unsecuredDimensions == null) {
                SBWODPLog.getLogger("Configuration").log(LogLevel.WARN, bp);
            } else {
                tmp = new StringBuilder(this.unsecuredDimensions.get(0));
                for (i = 1; i < this.unsecuredDimensions.size(); ++i) {
                    tmp.append(",");
                    tmp.append(" ");
                    tmp.append(this.unsecuredDimensions.get(i));
                }
                SBWODPLog.getLogger("Configuration").log(LogLevel.WARN, bp + tmp);
            }
            SBWODPLog.getLogger("Configuration").log(LogLevel.WARN, "SBWODPConfig: displayProperty: " + this.displayProperty);
            SBWODPLog.getLogger("Configuration").log(LogLevel.WARN, "SBWODPConfig: useMDXToRetrieveMembersLimit: " + this.useMDXToRetrieveMembersLimit);
            bp = "SBWODPConfig: useMDXToRetrieveMembersFor: ";
            if (this.useMDXToRetrieveMembersFor == null) {
                SBWODPLog.getLogger("Configuration").log(LogLevel.WARN, bp);
            } else {
                tmp = new StringBuilder(this.useMDXToRetrieveMembersFor.get(0));
                for (i = 1; i < this.useMDXToRetrieveMembersFor.size(); ++i) {
                    tmp.append(",");
                    tmp.append(" ");
                    tmp.append(this.useMDXToRetrieveMembersFor.get(i));
                }
                SBWODPLog.getLogger("Configuration").log(LogLevel.WARN, bp + tmp);
            }
            bp = "SBWODPConfig: useReplacementVariablesFor: ";
            if (this.useReplacementVariablesFor == null) {
                SBWODPLog.getLogger("Configuration").log(LogLevel.WARN, bp);
            } else {
                tmp = new StringBuilder(this.useReplacementVariablesFor.get(0));
                for (i = 1; i < this.useReplacementVariablesFor.size(); ++i) {
                    tmp.append(",");
                    tmp.append(" ");
                    tmp.append(this.useReplacementVariablesFor.get(i));
                }
                SBWODPLog.getLogger("Configuration").log(LogLevel.WARN, bp + tmp);
            }
            bp = "SBWODPConfig: unSecuredVariables: ";
            if (this.unsecuredVariables == null) {
                SBWODPLog.getLogger("Configuration").log(LogLevel.WARN, bp);
            } else {
                tmp = new StringBuilder(this.unsecuredVariables.get(0));
                for (i = 1; i < this.unsecuredVariables.size(); ++i) {
                    tmp.append(",");
                    tmp.append(" ");
                    tmp.append(this.unsecuredVariables.get(i));
                }
                SBWODPLog.getLogger("Configuration").log(LogLevel.WARN, bp + tmp);
            }
        }
    }
}

