/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.data.providers.olap.sbwodp;

import com.cognos.xqe.data.model.LogonFailureException;
import com.cognos.xqe.data.providers.olap.sbwodp.SBWODPConfig;
import com.cognos.xqe.data.providers.olap.sbwodp.SBWODPConnection;
import com.cognos.xqe.data.providers.olap.sbwodp.SBWODPException;
import com.cognos.xqe.data.providers.olap.sbwodp.SBWODPFunctionHandler;
import com.cognos.xqe.data.providers.olap.sbwodp.SBWODPLog;
import com.cognos.xqe.data.providers.olap.sbwodp.SBWODPMessageKeys;
import com.cognos.xqe.data.providers.olap.sbwodp.SBWODPSAPData;
import com.cognos.xqe.data.providers.olap.sbwodp.bapi.JBapiClient;
import com.cognos.xqe.data.providers.olap.sbwodp.bapi.JBapiException;
import com.cognos.xqe.data.providers.olap.sbwodp.bapi.JBapiTable;
import com.cognos.xqe.trace.LogLevel;

public class SBWODPDataHandler
extends SBWODPFunctionHandler {
    private static final int MAX_MDX_LINE_LEN = 75;
    private Object dataSetID = null;

    public SBWODPDataHandler(SBWODPConnection connection, JBapiClient client, String functionName) throws SBWODPException, LogonFailureException {
        super(connection, client, functionName);
        if (SBWODPLog.isOn("DataQuery", LogLevel.TRACE).booleanValue()) {
            SBWODPLog.getLogger("DataQuery").log(LogLevel.TRACE, "Constructing SBWODPDataHandler for BAPI: " + functionName);
        }
    }

    public void setDataSetID(Object dataID) throws SBWODPException {
        this.checkForCancel();
        try {
            this.setImportParameter("DATASETID", dataID);
        }
        catch (JBapiException e) {
            throw new SBWODPException(SBWODPMessageKeys.ERR_SET_DATASET_ID, e);
        }
        this.dataSetID = dataID;
    }

    public void setAxisDataParams(Object dataID, int axis, int iStartTuple, int iEndTuple) throws SBWODPException {
        this.setDataSetID(dataID);
        this.setImportParameter("AXIS", axis);
        this.setImportParameter("START_TUPLE", iStartTuple);
        this.setImportParameter("END_TUPLE", iEndTuple);
    }

    public void setCellDataParams(Object dataID, int iStartCell, int iEndCell) throws SBWODPException {
        this.setDataSetID(dataID);
        this.setImportParameter("START_CELL", iStartCell);
        this.setImportParameter("END_CELL", iEndCell);
    }

    public void clearAxisInfoTables() throws SBWODPException {
        this.clearTable("AXIS_INFO");
        this.clearTable("AXIS_DIMENSIONS");
        this.clearTable("AXIS_LEVELS");
        this.clearTable("DIM_PRPTYS");
        this.clearTable("FLTCOLINFO");
    }

    public void clearAxisDataTables() throws SBWODPException {
        this.clearTable("MNDTRY_PRPTYS");
        this.clearTable("OPTION_PRPTYS_KEYS");
        this.clearTable("OPTION_PRPTYS_VALS");
    }

    public void clearCellTables() throws SBWODPException {
        this.clearTable("CELL_DATA");
        this.clearTable("CELL_PROPS");
    }

    public void extractDataSetID() throws SBWODPException {
        this.checkForCancel();
        try {
            this.dataSetID = this.function.getExportParameterValue("DATASETID");
        }
        catch (JBapiException e) {
            throw new SBWODPException(SBWODPMessageKeys.ERR_GET_DATASET_ID_FAILED, e);
        }
    }

    public Object getDataSetID() {
        return this.dataSetID;
    }

    public void createObject(String sMDX) throws SBWODPException {
        JBapiTable mdxTab = null;
        String mdxPart = null;
        int nStart = 0;
        int nEnd = 75;
        int nLast = sMDX.length();
        if (SBWODPConfig.instance().getServerCacheReset() == 2) {
            this.clearSAPUserCache();
        }
        if ((mdxTab = this.getTable("COMMAND_TEXT")) == null) {
            throw new SBWODPException(SBWODPMessageKeys.ERR_TABLE_NOT_FOUND, "COMMAND_TEXT");
        }
        try {
            mdxTab.clear();
            while (nStart < nLast) {
                this.checkForCancel();
                mdxTab.appendRow();
                mdxPart = sMDX.substring(nStart, nEnd);
                if (mdxPart.length() > 0) {
                    mdxTab.setValue(0, mdxPart);
                }
                nStart = nEnd;
                if ((nEnd += 75) <= nLast) continue;
                nEnd = nLast;
            }
        }
        catch (JBapiException e) {
            throw new SBWODPException(SBWODPMessageKeys.ERR_SET_MDX_TEXT, e);
        }
        finally {
            mdxTab.release();
        }
    }

    public SBWODPSAPData getAxisTables(SBWODPSAPData sapData) throws SBWODPException {
        this.checkForCancel();
        sapData.setData(0, this.getTable("AXIS_INFO"));
        sapData.setData(1, this.getTable("AXIS_DIMENSIONS"));
        sapData.setData(2, this.getTable("AXIS_LEVELS"));
        sapData.setData(3, this.getTable("DIM_PRPTYS"));
        sapData.setData(4, this.getTable("FLTCOLINFO"));
        return sapData;
    }

    public SBWODPSAPData getCellTables(SBWODPSAPData sapData) throws SBWODPException {
        this.checkForCancel();
        sapData.setData(0, this.getTable("CELL_DATA"));
        sapData.setData(1, this.getTable("CELL_PROPS"));
        return sapData;
    }

    public SBWODPSAPData getAxisDataTables(SBWODPSAPData sapData) throws SBWODPException {
        this.checkForCancel();
        sapData.setData(2, this.getTable("MNDTRY_PRPTYS"));
        sapData.setData(1, this.getTable("OPTION_PRPTYS_KEYS"));
        sapData.setData(0, this.getTable("OPTION_PRPTYS_VALS"));
        return sapData;
    }
}

