/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.data.providers.olap.sbwodp;

import com.cognos.xqe.data.providers.olap.IRestrictions;
import com.cognos.xqe.data.providers.olap.RestrictionType;
import com.cognos.xqe.data.providers.olap.sbwodp.SBWODPConfig;
import com.cognos.xqe.data.providers.olap.sbwodp.SBWODPUtility;
import com.cognos.xqe.metadata.ICube;
import com.cognos.xqe.metadata.IDimension;
import com.cognos.xqe.metadata.IHierarchy;
import com.cognos.xqe.metadata.ILevel;
import com.cognos.xqe.metadata.IProperty;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;

public class SBWODPDimensionProperties {
    private TreeSet<String> dimProperties = null;
    private String allProperies = "";

    public SBWODPDimensionProperties(IRestrictions restrictions) {
        this.loadDimensionProperties(restrictions);
    }

    private void loadDimensionProperties(IRestrictions restrictions) {
        this.dimProperties = new TreeSet();
        ICube cube = (ICube)restrictions.getValueOf(RestrictionType.CUBE_OBJECT, null);
        String dimUname = (String)restrictions.getValueOf(RestrictionType.DIMENSION_UNIQUE_NAME, null);
        String theDimensionProperties = (String)restrictions.getValueOf(RestrictionType.DIMENSION_PROPERTIES, null);
        if (theDimensionProperties != null && theDimensionProperties.length() != 0) {
            this.dimProperties = this.getProperties(theDimensionProperties);
        }
        if (dimUname != null) {
            SBWODPUtility.DisplayPropertiesForCaption displayProperty;
            String prefix;
            String captionProperty;
            String configPropertyName = SBWODPConfig.instance().getDisplayProperty().toUpperCase();
            if (!configPropertyName.equals(SBWODPUtility.DisplayPropertiesForCaption.CAPTION.getPropertyName()) && !this.dimProperties.contains(captionProperty = SBWODPUtility.SBWODPNameUtils.makeDimPropertyName(prefix = (displayProperty = SBWODPUtility.DisplayPropertiesForCaption.getDisplayProperty(configPropertyName)).getDimensionPrefix(), dimUname))) {
                this.dimProperties.add(captionProperty);
            }
            String key = SBWODPUtility.SBWODPNameUtils.getPropertyKeyName(dimUname);
            TreeSet<String> properties = null;
            if (cube != null) {
                properties = this.getDimensionProperties(cube, dimUname);
            }
            if (cube != null && properties != null && properties.contains(key)) {
                if (!this.dimProperties.contains(key)) {
                    this.dimProperties.add(key);
                }
            } else if (cube == null && !this.dimProperties.contains(key)) {
                this.dimProperties.add(key);
            }
        }
        if (this.dimProperties.size() > 0) {
            this.allProperies = "S";
        }
    }

    public String printProperties() {
        StringBuilder properies = new StringBuilder();
        if (this.dimProperties != null && this.dimProperties.size() != 0) {
            Iterator<String> propertyIt = this.dimProperties.iterator();
            while (propertyIt.hasNext()) {
                properies.append(", ");
                properies.append(propertyIt.next());
            }
        }
        return properies.toString();
    }

    public TreeSet<String> getDimensionProperties() {
        return this.dimProperties;
    }

    private TreeSet<String> getProperties(String theDimensionProperties) {
        String[] tokens = theDimensionProperties.split(",");
        TreeSet<String> properties = new TreeSet<String>();
        for (String prop : tokens) {
            properties.add(prop.trim());
        }
        return properties;
    }

    public TreeSet<String> getPropertiesName() {
        TreeSet<String> properties = new TreeSet<String>();
        for (String prop : this.dimProperties) {
            properties.add(this.getPropertyName(prop));
        }
        return properties;
    }

    private String getPropertyName(String property) {
        int index = property.lastIndexOf("[");
        String propertyName = property;
        if (index > 0) {
            propertyName = property.substring(index + 1, property.length() - 1);
        }
        return propertyName;
    }

    private TreeSet<String> getDimensionProperties(ICube cube, String dimName) {
        IDimension dimension = cube.getDimension(dimName);
        IHierarchy hierarchy = dimension.getDefaultHierarchy();
        if (hierarchy == null) {
            hierarchy = dimension.getHierarchy(0);
        }
        ILevel level = hierarchy.getLevel(0);
        List propertyList = level.getMemberProperties();
        TreeSet<String> properties = new TreeSet<String>();
        for (IProperty property : propertyList) {
            if (!property.isCustomProperty()) continue;
            properties.add(property.getUniqueName());
        }
        return properties;
    }

    public String getAllProperies() {
        return this.allProperies;
    }
}

