/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.data.providers.olap.sbwodp;

import com.cognos.xqe.bibushandler.RequestEnvironment;
import com.cognos.xqe.data.model.LogonFailureException;
import com.cognos.xqe.data.providers.olap.sbwodp.SBWODPConnection;
import com.cognos.xqe.data.providers.olap.sbwodp.SBWODPException;
import com.cognos.xqe.data.providers.olap.sbwodp.SBWODPInfoObjDetails;
import com.cognos.xqe.data.providers.olap.sbwodp.SBWODPLog;
import com.cognos.xqe.data.providers.olap.sbwodp.SBWODPMetadataHandler;
import com.cognos.xqe.data.providers.olap.sbwodp.SBWODPMetadataProvider;
import com.cognos.xqe.data.providers.olap.sbwodp.SBWODPUtility;
import com.cognos.xqe.data.providers.olap.sbwodp.bapi.JBapiException;
import com.cognos.xqe.data.providers.olap.sbwodp.bapi.JBapiSAPException;
import com.cognos.xqe.data.providers.olap.sbwodp.bapi.JBapiStructure;
import com.cognos.xqe.data.providers.olap.sbwodp.bapi.JBapiTable;
import com.cognos.xqe.query.engine.ExecutionEnvironment;
import com.cognos.xqe.trace.LogLevel;
import java.util.TreeMap;

public final class SBWODPInfoObjectCache {
    private TreeMap<SBWODPInfoObjectKey, Object> cubeMD = new TreeMap();
    private static SBWODPInfoObjectCache theCache = null;
    private SBWODPMetadataProvider provider;
    private static final Object LOCK = new Object();
    private static final String STR_NOT_FOUND = "Not Found";
    private static final String BAPI_EXCP_CUBE_DETAIL = "BAPI Exception while executing getCubeDetails: ";
    private static final String SBWODP_EXCP_CUBE_DETAIL = "Exception while executing getCubeDetails: ";
    private static final String LOGON_EXCP_CUBE_DETAIL = "Logon Failure while executing getCubeDetails: ";
    private static final String BAPI_EXCP_ODSO_DETAIL = "BAPI Exception while executing getODSObjectDetails: ";
    private static final String SBWODP_EXCP_ODSO_DETAIL = "Exception while executing getODSObjectDetails: ";
    private static final String LOGON_EXCP_ODSO_DETAIL = "Logon Failure while executing getODSObjectDetails: ";
    private static final String BAPI_EXCP_ISET_DETAIL = "BAPI Exception while executing getInfoSetDetails: ";
    private static final String SBWODP_EXCP_ISET_DETAIL = "Exception while executing getInfoSetDetails: ";
    private static final String LOGON_EXCP_ISET_DETAIL = "Logon Failure while executing getInfoSetDetails: ";
    public static final String DATA_PACKET_ATTRIBUTE = "DPA";
    private static final String BAPI_EXCP_IOBJ_DETAIL = "BAPI Exception while executing getIOBJDetails: ";
    private static final String SBWODP_EXCP_IOBJ_DETAIL = "Exception while executing getIOBJDetails: ";
    private static final String LOGON_EXCP_IOBJ_DETAIL = "Logon Failure while executing getIOBJDetails: ";
    public static final String ATTRIBUTES = "ATTRIBUTES";
    public static final String ATTRINM = "ATTRINM";

    private SBWODPInfoObjectCache(SBWODPMetadataProvider mdProvider) {
        this.provider = mdProvider;
        SBWODPLog.getLogger("Metadata").log(LogLevel.TRACE, "Initializing SBWODPInfoObjectCache");
    }

    public static SBWODPInfoObjectCache getInstance(SBWODPMetadataProvider mdProvider) {
        if (null == theCache) {
            theCache = new SBWODPInfoObjectCache(mdProvider);
        }
        return theCache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SBWODPInfoObjDetails getDimensionDetails(SBWODPConnection connection, String systemKey, String cubeName, String dimName, ExecutionEnvironment executionEnvironment) {
        if (!this.getCubeType(connection, systemKey, cubeName = SBWODPUtility.SBWODPNameUtils.extractCubeName(cubeName), executionEnvironment).equals("Infoset")) {
            dimName = SBWODPUtility.SBWODPNameUtils.extractIObjFromNavAttrName(dimName);
        }
        String language = ((RequestEnvironment)executionEnvironment.getRequestEnvironment()).getRunLocale().getLanguage().toUpperCase();
        SBWODPInfoObjectKey srchKey = new SBWODPInfoObjectKey(systemKey, cubeName, language);
        Object object = LOCK;
        synchronized (object) {
            Object o = this.cubeMD.get(srchKey);
            if (null == o && this.loadCubeAndDimMetadata(connection, srchKey, executionEnvironment)) {
                o = this.cubeMD.get(srchKey);
            }
            if (o != null && o instanceof SBWODPInfoObjectItem) {
                SBWODPInfoObjDetails infoObjDetail;
                TreeMap<String, SBWODPInfoObjDetails> map = ((SBWODPInfoObjectItem)o).getInfoObjectMap();
                if (map == null) {
                    map = new TreeMap();
                }
                if ((infoObjDetail = map.get(dimName)) == null) {
                    this.loadDimensionMetadata(connection, srchKey, dimName, map, executionEnvironment);
                    infoObjDetail = map.get(dimName);
                }
                if (infoObjDetail != null) {
                    ((SBWODPInfoObjectItem)o).setInfoObjectMap(map);
                    return infoObjDetail;
                }
                SBWODPLog.getLogger("Metadata").log(LogLevel.TRACE, "Could not find Dimension Data: " + dimName + " from Cached Cube: " + cubeName);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getCubeType(SBWODPConnection connection, String systemKey, String cubeName, ExecutionEnvironment executionEnvironment) {
        String language = ((RequestEnvironment)executionEnvironment.getRequestEnvironment()).getRunLocale().getLanguage().toUpperCase();
        SBWODPInfoObjectKey srchKey = new SBWODPInfoObjectKey(systemKey, cubeName, language);
        Object object = LOCK;
        synchronized (object) {
            Object o = this.cubeMD.get(srchKey);
            if (null == o) {
                String type = this.loadCubeType(connection, srchKey, executionEnvironment);
                if (type.equals("Unknown Cube Type")) {
                    this.cubeMD.put(srchKey, STR_NOT_FOUND);
                } else {
                    this.cubeMD.put(srchKey, new SBWODPInfoObjectItem(type, null));
                }
                return type;
            }
            if (o instanceof SBWODPInfoObjectItem) {
                return ((SBWODPInfoObjectItem)o).getCubeType();
            }
        }
        return "Unknown Cube Type";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String loadCubeType(SBWODPConnection connection, SBWODPInfoObjectKey srchKey, ExecutionEnvironment executionEnvironment) {
        SBWODPMetadataHandler fnh = null;
        JBapiTable infoObj = null;
        JBapiTable odso = null;
        JBapiTable fObj = null;
        JBapiTable attrib = null;
        JBapiStructure details = null;
        try {
            fnh = new SBWODPMetadataHandler(this.provider, connection, "BAPI_CUBE_GETDETAIL");
            this.provider.addCancelListener(fnh, executionEnvironment);
            fnh.setImportParameter("INFOCUBE", srchKey.getName());
            fnh.setImportParameter("OBJVERS", "A");
            fnh.executeFunctionNoCheck();
            infoObj = fnh.getTable("INFOOBJECTS");
            if (infoObj.getNumRows() > 0) {
                details = fnh.getExportStructure("DETAILS");
                String sapType = details.getString("CUBETYPE");
                if (sapType.equals("A")) {
                    String string = "Aggregate Cube";
                    return string;
                }
                if (sapType.equals("B")) {
                    String string = "Basic Cube";
                    return string;
                }
                if (sapType.equals("R")) {
                    String string = "Remote Cube";
                    return string;
                }
                if (sapType.equals("M")) {
                    String string = "Multi-Provider";
                    return string;
                }
                if (sapType.equals("V")) {
                    String string = "Virtual Cube";
                    return string;
                }
                String string = "Unknown Cube Type";
                return string;
            }
        }
        catch (JBapiSAPException be) {
            SBWODPLog.getLogger("Metadata").log(LogLevel.ERROR, BAPI_EXCP_CUBE_DETAIL, (Throwable)be);
            String string = "Unknown Cube Type";
            return string;
        }
        catch (JBapiException be) {
            SBWODPLog.getLogger("Metadata").log(LogLevel.ERROR, BAPI_EXCP_CUBE_DETAIL, (Throwable)be);
            String string = "Unknown Cube Type";
            return string;
        }
        catch (SBWODPException e) {
            SBWODPLog.getLogger("Metadata").log(LogLevel.ERROR, SBWODP_EXCP_CUBE_DETAIL, (Throwable)((Object)e));
            String string = "Unknown Cube Type";
            return string;
        }
        catch (LogonFailureException lfe) {
            SBWODPLog.getLogger("Metadata").log(LogLevel.ERROR, LOGON_EXCP_CUBE_DETAIL, (Throwable)lfe);
            String string = "Unknown Cube Type";
            return string;
        }
        finally {
            if (details != null) {
                details.release();
            }
            if (infoObj != null) {
                infoObj.release();
            }
            if (fnh != null) {
                this.provider.removeCancelListener(fnh, executionEnvironment);
                fnh.release();
            }
        }
        try {
            fnh = new SBWODPMetadataHandler(this.provider, connection, "BAPI_ODSO_GETDETAIL");
            this.provider.addCancelListener(fnh, executionEnvironment);
            fnh.setImportParameter("ODSOBJECT", srchKey.getName());
            fnh.setImportParameter("OBJVERS", "A");
            fnh.executeFunctionNoCheck();
            odso = fnh.getTable("INFOOBJECTS");
            if (odso.getNumRows() > 0) {
                String lfe = "Operational Data Store Item";
                return lfe;
            }
        }
        catch (JBapiSAPException be) {
            SBWODPLog.getLogger("Metadata").log(LogLevel.ERROR, BAPI_EXCP_ODSO_DETAIL, (Throwable)be);
            String string = "Unknown Cube Type";
            return string;
        }
        catch (JBapiException be) {
            SBWODPLog.getLogger("Metadata").log(LogLevel.ERROR, BAPI_EXCP_ODSO_DETAIL, (Throwable)be);
            String string = "Unknown Cube Type";
            return string;
        }
        catch (SBWODPException e) {
            SBWODPLog.getLogger("Metadata").log(LogLevel.ERROR, SBWODP_EXCP_ODSO_DETAIL, (Throwable)((Object)e));
            String string = "Unknown Cube Type";
            return string;
        }
        catch (LogonFailureException lfe) {
            SBWODPLog.getLogger("Metadata").log(LogLevel.ERROR, LOGON_EXCP_ODSO_DETAIL, (Throwable)lfe);
            String string = "Unknown Cube Type";
            return string;
        }
        finally {
            if (odso != null) {
                odso.release();
            }
            if (fnh != null) {
                this.provider.removeCancelListener(fnh, executionEnvironment);
                fnh.release();
            }
        }
        try {
            fnh = new SBWODPMetadataHandler(this.provider, connection, "BAPI_ISET_GETDETAIL");
            this.provider.addCancelListener(fnh, executionEnvironment);
            fnh.setImportParameter("INFOSET", srchKey.getName());
            fnh.setImportParameter("OBJVERS", "A");
            fnh.executeFunctionNoCheck();
            fObj = fnh.getTable("FIELDOBJECTS");
            if (fObj.getNumRows() > 0) {
                String lfe = "Infoset";
                return lfe;
            }
        }
        catch (JBapiSAPException be) {
            SBWODPLog.getLogger("Metadata").log(LogLevel.ERROR, BAPI_EXCP_ISET_DETAIL, (Throwable)be);
            String string = "Unknown Cube Type";
            return string;
        }
        catch (JBapiException be) {
            SBWODPLog.getLogger("Metadata").log(LogLevel.ERROR, BAPI_EXCP_ISET_DETAIL, (Throwable)be);
            String string = "Unknown Cube Type";
            return string;
        }
        catch (SBWODPException e) {
            SBWODPLog.getLogger("Metadata").log(LogLevel.ERROR, SBWODP_EXCP_ISET_DETAIL, (Throwable)((Object)e));
            String string = "Unknown Cube Type";
            return string;
        }
        catch (LogonFailureException lfe) {
            SBWODPLog.getLogger("Metadata").log(LogLevel.ERROR, LOGON_EXCP_ISET_DETAIL, (Throwable)lfe);
            String string = "Unknown Cube Type";
            return string;
        }
        finally {
            if (fObj != null) {
                fObj.release();
            }
            if (fnh != null) {
                this.provider.removeCancelListener(fnh, executionEnvironment);
                fnh.release();
            }
        }
        try {
            fnh = new SBWODPMetadataHandler(this.provider, connection, "BAPI_IOBJ_GETDETAIL");
            this.provider.addCancelListener(fnh, executionEnvironment);
            fnh.setImportParameter("INFOOBJECT", srchKey.getName());
            fnh.setImportParameter("VERSION", "A");
            fnh.executeFunctionNoCheck();
            attrib = fnh.getTable(ATTRIBUTES);
            if (attrib.getNumRows() > 0) {
                String lfe = "Infoobject";
                return lfe;
            }
        }
        catch (JBapiSAPException be) {
            SBWODPLog.getLogger("Metadata").log(LogLevel.ERROR, BAPI_EXCP_IOBJ_DETAIL, (Throwable)be);
            String string = "Unknown Cube Type";
            return string;
        }
        catch (JBapiException be) {
            SBWODPLog.getLogger("Metadata").log(LogLevel.ERROR, BAPI_EXCP_IOBJ_DETAIL, (Throwable)be);
            String string = "Unknown Cube Type";
            return string;
        }
        catch (SBWODPException e) {
            SBWODPLog.getLogger("Metadata").log(LogLevel.ERROR, SBWODP_EXCP_IOBJ_DETAIL, (Throwable)((Object)e));
            String string = "Unknown Cube Type";
            return string;
        }
        catch (LogonFailureException lfe) {
            SBWODPLog.getLogger("Metadata").log(LogLevel.ERROR, LOGON_EXCP_IOBJ_DETAIL, (Throwable)lfe);
            String string = "Unknown Cube Type";
            return string;
        }
        finally {
            if (attrib != null) {
                attrib.release();
            }
            if (fnh != null) {
                this.provider.removeCancelListener(fnh, executionEnvironment);
                fnh.release();
            }
        }
        return "Unknown Cube Type";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean loadCubeAndDimMetadata(SBWODPConnection connection, SBWODPInfoObjectKey srchKey, ExecutionEnvironment executionEnvironment) {
        int rowCount;
        SBWODPInfoObjDetails data = null;
        SBWODPMetadataHandler fnh = null;
        JBapiTable infoObj = null;
        JBapiTable dio = null;
        JBapiTable dims = null;
        JBapiTable odso = null;
        JBapiTable iobj = null;
        JBapiTable fObj = null;
        JBapiTable tObj = null;
        JBapiStructure details = null;
        String cubeType = "Unknown Cube Type";
        TreeMap<String, SBWODPInfoObjDetails> map = new TreeMap<String, SBWODPInfoObjDetails>();
        boolean found = false;
        boolean abort = false;
        if (SBWODPLog.isOn("Metadata", LogLevel.TRACE).booleanValue()) {
            SBWODPLog.getLogger("Metadata").log(LogLevel.TRACE, "Loading cube and dimension metadata");
        }
        try {
            fnh = new SBWODPMetadataHandler(this.provider, connection, "BAPI_CUBE_GETDETAIL");
            this.provider.addCancelListener(fnh, executionEnvironment);
            fnh.setImportParameter("INFOCUBE", srchKey.getName());
            fnh.setImportParameter("OBJVERS", "A");
            fnh.executeFunctionNoCheck();
            infoObj = fnh.getTable("INFOOBJECTS");
            dio = fnh.getTable("DIMENSIONINFOOBJECTS");
            dims = fnh.getTable("DIMENSIONS");
            rowCount = infoObj.getNumRows();
            for (int ioIdx = 0; ioIdx < rowCount; ++ioIdx) {
                String ioName = "";
                String dimName = "";
                String dimText = "";
                data = new SBWODPInfoObjDetails();
                infoObj.setRow(ioIdx);
                ioName = infoObj.getString(3, false);
                if (infoObj.getString(5, false).equals("X")) {
                    ioName = SBWODPUtility.SBWODPNameUtils.extractIObjFromNavAttrName(ioName);
                }
                int rowCount2 = dio.getNumRows();
                for (int dioIdx = 0; dioIdx < rowCount2; ++dioIdx) {
                    dio.setRow(dioIdx);
                    String dioName = dio.getString(4, false);
                    if (!ioName.equals(dioName) && !ioName.equals(SBWODPUtility.SBWODPNameUtils.extractIObjFromNavAttrName(dioName))) continue;
                    dimName = dio.getString(2, false);
                    break;
                }
                data.setName(ioName);
                if (!dimName.equals("")) {
                    rowCount2 = dims.getNumRows();
                    for (int dIdx = 0; dIdx < rowCount2; ++dIdx) {
                        dims.setRow(dIdx);
                        if (!dimName.equals(dims.getString(2, false))) continue;
                        dimText = dims.getString(3);
                        data.setOlapType(dims.getString(4, false));
                        break;
                    }
                }
                data.setDimGroup(dimName);
                data.setDimGroupDescription(dimText);
                found = true;
                if (this.setInfoObjectDetails(map, data, connection, executionEnvironment)) continue;
                abort = true;
                break;
            }
            SBWODPInfoObjectItem item = null;
            if (found) {
                details = fnh.getExportStructure("DETAILS");
                String sapType = details.getString("CUBETYPE");
                if (sapType.equals("A")) {
                    cubeType = "Aggregate Cube";
                } else if (sapType.equals("B")) {
                    cubeType = "Basic Cube";
                } else if (sapType.equals("R")) {
                    cubeType = "Remote Cube";
                } else if (sapType.equals("M")) {
                    cubeType = "Multi-Provider";
                } else if (sapType.equals("V")) {
                    cubeType = "Virtual Cube";
                }
                item = abort ? new SBWODPInfoObjectItem(cubeType, new TreeMap<String, SBWODPInfoObjDetails>()) : new SBWODPInfoObjectItem(cubeType, map);
                this.cubeMD.put(srchKey, item);
                boolean dimName = true;
                return dimName;
            }
        }
        catch (JBapiSAPException be) {
            SBWODPLog.getLogger("Metadata").log(LogLevel.ERROR, BAPI_EXCP_CUBE_DETAIL, (Throwable)be);
        }
        catch (JBapiException be) {
            SBWODPLog.getLogger("Metadata").log(LogLevel.ERROR, BAPI_EXCP_CUBE_DETAIL, (Throwable)be);
        }
        catch (SBWODPException e) {
            SBWODPLog.getLogger("Metadata").log(LogLevel.ERROR, SBWODP_EXCP_CUBE_DETAIL, (Throwable)((Object)e));
        }
        catch (LogonFailureException lfe) {
            SBWODPLog.getLogger("Metadata").log(LogLevel.ERROR, LOGON_EXCP_CUBE_DETAIL, (Throwable)lfe);
        }
        finally {
            if (infoObj != null) {
                infoObj.release();
            }
            if (dio != null) {
                dio.release();
            }
            if (dims != null) {
                dims.release();
            }
            if (details != null) {
                details.release();
            }
            if (fnh != null) {
                this.provider.removeCancelListener(fnh, executionEnvironment);
                fnh.release();
            }
        }
        try {
            found = false;
            fnh = new SBWODPMetadataHandler(this.provider, connection, "BAPI_ODSO_GETDETAIL");
            this.provider.addCancelListener(fnh, executionEnvironment);
            fnh.setImportParameter("ODSOBJECT", srchKey.getName());
            fnh.setImportParameter("OBJVERS", "A");
            fnh.executeFunctionNoCheck();
            odso = fnh.getTable("INFOOBJECTS");
            rowCount = odso.getNumRows();
            for (int odsIdx = 0; odsIdx < rowCount; ++odsIdx) {
                odso.setRow(odsIdx);
                data = new SBWODPInfoObjDetails();
                data.setName(odso.getString("INFOOBJECT", false));
                found = true;
                if (this.setInfoObjectDetails(map, data, connection, executionEnvironment)) continue;
                abort = true;
                break;
            }
            if (found) {
                SBWODPInfoObjectItem item = null;
                item = abort ? new SBWODPInfoObjectItem("Operational Data Store Item", new TreeMap<String, SBWODPInfoObjDetails>()) : new SBWODPInfoObjectItem("Operational Data Store Item", map);
                this.cubeMD.put(srchKey, item);
                boolean sapType = true;
                return sapType;
            }
        }
        catch (JBapiSAPException be) {
            SBWODPLog.getLogger("Metadata").log(LogLevel.ERROR, BAPI_EXCP_ODSO_DETAIL, (Throwable)be);
        }
        catch (JBapiException be) {
            SBWODPLog.getLogger("Metadata").log(LogLevel.ERROR, BAPI_EXCP_ODSO_DETAIL, (Throwable)be);
        }
        catch (SBWODPException e) {
            SBWODPLog.getLogger("Metadata").log(LogLevel.ERROR, SBWODP_EXCP_ODSO_DETAIL, (Throwable)((Object)e));
        }
        catch (LogonFailureException lfe) {
            SBWODPLog.getLogger("Metadata").log(LogLevel.ERROR, LOGON_EXCP_ODSO_DETAIL, (Throwable)lfe);
        }
        finally {
            if (odso != null) {
                odso.release();
            }
            if (fnh != null) {
                this.provider.removeCancelListener(fnh, executionEnvironment);
                fnh.release();
            }
        }
        try {
            found = false;
            fnh = new SBWODPMetadataHandler(this.provider, connection, "BAPI_ISET_GETDETAIL");
            this.provider.addCancelListener(fnh, executionEnvironment);
            fnh.setImportParameter("INFOSET", srchKey.getName());
            fnh.setImportParameter("OBJVERS", "A");
            fnh.executeFunctionNoCheck();
            fObj = fnh.getTable("FIELDOBJECTS");
            tObj = fnh.getTable("TABLEOBJECTS");
            String talias = "";
            int rowCount2 = fObj.getNumRows();
            for (int fIdx = 0; fIdx < rowCount2; ++fIdx) {
                fObj.setRow(fIdx);
                data = new SBWODPInfoObjDetails();
                data.setName(fObj.getString("INTIOBJNM", false));
                talias = fObj.getString("TALIAS", false);
                int rowCount22 = tObj.getNumRows();
                for (int tIdx = 0; tIdx < rowCount22; ++tIdx) {
                    tObj.setRow(tIdx);
                    if (!talias.equals(tObj.getString("TALIAS", false))) continue;
                    data.setDimGroup(tObj.getString("TEXTLONG"));
                }
                found = true;
                if (this.setInfoObjectDetails(map, data, connection, executionEnvironment)) continue;
                abort = true;
                break;
            }
            if (found) {
                SBWODPInfoObjectItem item = null;
                item = abort ? new SBWODPInfoObjectItem("Infoset", new TreeMap<String, SBWODPInfoObjDetails>()) : new SBWODPInfoObjectItem("Infoset", map);
                this.cubeMD.put(srchKey, item);
                boolean bl = true;
                return bl;
            }
        }
        catch (JBapiSAPException be) {
            SBWODPLog.getLogger("Metadata").log(LogLevel.ERROR, BAPI_EXCP_ISET_DETAIL, (Throwable)be);
        }
        catch (JBapiException be) {
            SBWODPLog.getLogger("Metadata").log(LogLevel.ERROR, BAPI_EXCP_ISET_DETAIL, (Throwable)be);
        }
        catch (SBWODPException e) {
            SBWODPLog.getLogger("Metadata").log(LogLevel.ERROR, SBWODP_EXCP_ISET_DETAIL, (Throwable)((Object)e));
        }
        catch (LogonFailureException lfe) {
            SBWODPLog.getLogger("Metadata").log(LogLevel.ERROR, LOGON_EXCP_ISET_DETAIL, (Throwable)lfe);
        }
        finally {
            if (fObj != null) {
                fObj.release();
            }
            if (tObj != null) {
                tObj.release();
            }
            if (fnh != null) {
                this.provider.removeCancelListener(fnh, executionEnvironment);
                fnh.release();
            }
        }
        try {
            found = false;
            fnh = new SBWODPMetadataHandler(this.provider, connection, "BAPI_IOBJ_GETDETAIL");
            this.provider.addCancelListener(fnh, executionEnvironment);
            fnh.setImportParameter("INFOOBJECT", srchKey.getName());
            fnh.setImportParameter("VERSION", "A");
            fnh.executeFunctionNoCheck();
            iobj = fnh.getTable(ATTRIBUTES);
            int rowCount3 = iobj.getNumRows();
            for (int iobjIdx = 0; iobjIdx < rowCount3; ++iobjIdx) {
                iobj.setRow(iobjIdx);
                data = new SBWODPInfoObjDetails();
                data.setName(iobj.getString(ATTRINM, false));
                found = true;
                if (!this.setInfoObjectDetails(map, data, connection, executionEnvironment)) {
                    abort = true;
                    break;
                }
                map.put(data.getName(), data);
            }
            if (found) {
                SBWODPInfoObjectItem item = null;
                item = abort ? new SBWODPInfoObjectItem("Unknown Cube Type", new TreeMap<String, SBWODPInfoObjDetails>()) : new SBWODPInfoObjectItem("Unknown Cube Type", map);
                this.cubeMD.put(srchKey, item);
                boolean bl = true;
                return bl;
            }
            this.cubeMD.put(srchKey, STR_NOT_FOUND);
            boolean bl = false;
            return bl;
        }
        catch (JBapiSAPException be) {
            found = false;
            this.cubeMD.put(srchKey, STR_NOT_FOUND);
            SBWODPLog.getLogger("Metadata").log(LogLevel.ERROR, BAPI_EXCP_IOBJ_DETAIL, (Throwable)be);
        }
        catch (JBapiException be) {
            found = false;
            this.cubeMD.put(srchKey, STR_NOT_FOUND);
            SBWODPLog.getLogger("Metadata").log(LogLevel.ERROR, BAPI_EXCP_IOBJ_DETAIL, (Throwable)be);
        }
        catch (SBWODPException e) {
            found = false;
            this.cubeMD.put(srchKey, STR_NOT_FOUND);
            SBWODPLog.getLogger("Metadata").log(LogLevel.ERROR, SBWODP_EXCP_IOBJ_DETAIL, (Throwable)((Object)e));
        }
        catch (LogonFailureException lfe) {
            found = false;
            this.cubeMD.put(srchKey, STR_NOT_FOUND);
            SBWODPLog.getLogger("Metadata").log(LogLevel.ERROR, LOGON_EXCP_IOBJ_DETAIL, (Throwable)lfe);
        }
        finally {
            if (iobj != null) {
                iobj.release();
            }
            if (fnh != null) {
                this.provider.removeCancelListener(fnh, executionEnvironment);
                fnh.release();
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TreeMap<String, SBWODPInfoObjDetails> loadDimensionMetadata(SBWODPConnection connection, SBWODPInfoObjectKey srchKey, String objName, TreeMap<String, SBWODPInfoObjDetails> map, ExecutionEnvironment executionEnvironment) {
        int rowCount;
        SBWODPInfoObjDetails data = null;
        SBWODPMetadataHandler fnh = null;
        JBapiTable infoObj = null;
        JBapiTable dio = null;
        JBapiTable dims = null;
        JBapiTable odso = null;
        JBapiTable iobj = null;
        JBapiTable fObj = null;
        JBapiTable tObj = null;
        if (SBWODPLog.isOn("Metadata", LogLevel.TRACE).booleanValue()) {
            SBWODPLog.getLogger("Metadata").log(LogLevel.TRACE, "Loading dimension metadata");
        }
        boolean found = false;
        boolean abort = false;
        try {
            fnh = new SBWODPMetadataHandler(this.provider, connection, "BAPI_CUBE_GETDETAIL");
            this.provider.addCancelListener(fnh, executionEnvironment);
            fnh.setImportParameter("INFOCUBE", srchKey.getName());
            fnh.setImportParameter("OBJVERS", "A");
            fnh.executeFunctionNoCheck();
            infoObj = fnh.getTable("INFOOBJECTS");
            dio = fnh.getTable("DIMENSIONINFOOBJECTS");
            dims = fnh.getTable("DIMENSIONS");
            rowCount = infoObj.getNumRows();
            for (int ioIdx = 0; ioIdx < rowCount; ++ioIdx) {
                String ioName = "";
                String dimName = "";
                String dimText = "";
                data = new SBWODPInfoObjDetails();
                infoObj.setRow(ioIdx);
                ioName = infoObj.getString(3, false);
                if (infoObj.getString(5, false).equals("X")) {
                    ioName = SBWODPUtility.SBWODPNameUtils.extractIObjFromNavAttrName(ioName);
                }
                if (!ioName.equals(objName)) continue;
                int rowCount2 = dio.getNumRows();
                for (int dioIdx = 0; dioIdx < rowCount2; ++dioIdx) {
                    dio.setRow(dioIdx);
                    String dioName = dio.getString(4, false);
                    if (!ioName.equals(dioName) && !ioName.equals(SBWODPUtility.SBWODPNameUtils.extractIObjFromNavAttrName(dioName))) continue;
                    dimName = dio.getString(2, false);
                    break;
                }
                data.setName(ioName);
                if (!dimName.equals("")) {
                    rowCount2 = dims.getNumRows();
                    for (int dIdx = 0; dIdx < rowCount2; ++dIdx) {
                        dims.setRow(dIdx);
                        if (!dimName.equals(dims.getString(2, false))) continue;
                        dimText = dims.getString(3);
                        data.setOlapType(dims.getString(4, false));
                        break;
                    }
                }
                data.setDimGroup(dimName);
                data.setDimGroupDescription(dimText);
                if (this.setInfoObjectDetails(map, data, connection, executionEnvironment)) {
                    found = true;
                } else {
                    abort = true;
                }
                break;
            }
        }
        catch (JBapiSAPException se) {
            SBWODPLog.getLogger("Metadata").log(LogLevel.ERROR, SBWODP_EXCP_CUBE_DETAIL, (Throwable)se);
            found = false;
        }
        catch (JBapiException be) {
            found = false;
            SBWODPLog.getLogger("Metadata").log(LogLevel.ERROR, BAPI_EXCP_CUBE_DETAIL, (Throwable)be);
        }
        catch (SBWODPException e) {
            found = false;
            SBWODPLog.getLogger("Metadata").log(LogLevel.ERROR, SBWODP_EXCP_CUBE_DETAIL, (Throwable)((Object)e));
        }
        catch (LogonFailureException lfe) {
            found = false;
            SBWODPLog.getLogger("Metadata").log(LogLevel.ERROR, LOGON_EXCP_CUBE_DETAIL, (Throwable)lfe);
        }
        finally {
            if (infoObj != null) {
                infoObj.release();
            }
            if (dio != null) {
                dio.release();
            }
            if (dims != null) {
                dims.release();
            }
            if (fnh != null) {
                this.provider.removeCancelListener(fnh, executionEnvironment);
                fnh.release();
            }
        }
        if (!found && !abort) {
            try {
                fnh = new SBWODPMetadataHandler(this.provider, connection, "BAPI_ODSO_GETDETAIL");
                this.provider.addCancelListener(fnh, executionEnvironment);
                fnh.setImportParameter("ODSOBJECT", srchKey.getName());
                fnh.setImportParameter("OBJVERS", "A");
                fnh.executeFunctionNoCheck();
                odso = fnh.getTable("INFOOBJECTS");
                rowCount = odso.getNumRows();
                for (int odsIdx = 0; odsIdx < rowCount; ++odsIdx) {
                    odso.setRow(odsIdx);
                    data = new SBWODPInfoObjDetails();
                    data.setName(odso.getString("INFOOBJECT", false));
                    if (!this.setInfoObjectDetails(map, data, connection, executionEnvironment)) {
                        abort = true;
                        break;
                    }
                    found = true;
                }
            }
            catch (JBapiSAPException se) {
                SBWODPLog.getLogger("Metadata").log(LogLevel.ERROR, SBWODP_EXCP_ODSO_DETAIL, (Throwable)se);
                found = false;
            }
            catch (JBapiException be) {
                found = false;
                SBWODPLog.getLogger("Metadata").log(LogLevel.ERROR, BAPI_EXCP_ODSO_DETAIL, (Throwable)be);
            }
            catch (SBWODPException e) {
                found = false;
                SBWODPLog.getLogger("Metadata").log(LogLevel.ERROR, SBWODP_EXCP_ODSO_DETAIL, (Throwable)((Object)e));
            }
            catch (LogonFailureException lfe) {
                found = false;
                SBWODPLog.getLogger("Metadata").log(LogLevel.ERROR, LOGON_EXCP_ODSO_DETAIL, (Throwable)lfe);
            }
            finally {
                if (odso != null) {
                    odso.release();
                }
                if (fnh != null) {
                    this.provider.removeCancelListener(fnh, executionEnvironment);
                    fnh.release();
                }
            }
        }
        if (!found && !abort) {
            try {
                fnh = new SBWODPMetadataHandler(this.provider, connection, "BAPI_ISET_GETDETAIL");
                this.provider.addCancelListener(fnh, executionEnvironment);
                fnh.setImportParameter("INFOSET", srchKey.getName());
                fnh.setImportParameter("OBJVERS", "A");
                fnh.executeFunctionNoCheck();
                fObj = fnh.getTable("FIELDOBJECTS");
                tObj = fnh.getTable("TABLEOBJECTS");
                String talias = "";
                int rowCount2 = fObj.getNumRows();
                for (int fIdx = 0; fIdx < rowCount2; ++fIdx) {
                    fObj.setRow(fIdx);
                    data = new SBWODPInfoObjDetails();
                    data.setName(fObj.getString("INTIOBJNM", false));
                    talias = fObj.getString("TALIAS", false);
                    int rowCount22 = tObj.getNumRows();
                    for (int tIdx = 0; tIdx < rowCount22; ++tIdx) {
                        tObj.setRow(tIdx);
                        if (!talias.equals(tObj.getString("TALIAS", false))) continue;
                        data.setDimGroup(tObj.getString("TEXTLONG"));
                    }
                    if (!this.setInfoObjectDetails(map, data, connection, executionEnvironment)) {
                        abort = true;
                        break;
                    }
                    found = true;
                }
            }
            catch (JBapiSAPException se) {
                SBWODPLog.getLogger("Metadata").log(LogLevel.ERROR, SBWODP_EXCP_ISET_DETAIL, (Throwable)se);
                found = false;
            }
            catch (JBapiException be) {
                found = false;
                SBWODPLog.getLogger("Metadata").log(LogLevel.ERROR, BAPI_EXCP_ISET_DETAIL, (Throwable)be);
            }
            catch (SBWODPException e) {
                found = false;
                SBWODPLog.getLogger("Metadata").log(LogLevel.ERROR, SBWODP_EXCP_ISET_DETAIL, (Throwable)((Object)e));
            }
            catch (LogonFailureException lfe) {
                found = false;
                SBWODPLog.getLogger("Metadata").log(LogLevel.ERROR, LOGON_EXCP_ISET_DETAIL, (Throwable)lfe);
            }
            finally {
                if (fObj != null) {
                    fObj.release();
                }
                if (tObj != null) {
                    tObj.release();
                }
                if (fnh != null) {
                    this.provider.removeCancelListener(fnh, executionEnvironment);
                    fnh.release();
                }
            }
        }
        if (!found && !abort) {
            try {
                fnh = new SBWODPMetadataHandler(this.provider, connection, "BAPI_IOBJ_GETDETAIL");
                this.provider.addCancelListener(fnh, executionEnvironment);
                fnh.setImportParameter("INFOOBJECT", srchKey.getName());
                fnh.setImportParameter("VERSION", "A");
                fnh.executeFunctionNoCheck();
                iobj = fnh.getTable(ATTRIBUTES);
                int rowCount3 = iobj.getNumRows();
                for (int iobjIdx = 0; iobjIdx < rowCount3; ++iobjIdx) {
                    iobj.setRow(iobjIdx);
                    data = new SBWODPInfoObjDetails();
                    data.setName(iobj.getString(ATTRINM, false));
                    if (!this.setInfoObjectDetails(map, data, connection, executionEnvironment)) {
                        abort = true;
                        break;
                    }
                    found = true;
                }
            }
            catch (JBapiSAPException se) {
                SBWODPLog.getLogger("Metadata").log(LogLevel.ERROR, BAPI_EXCP_IOBJ_DETAIL, (Throwable)se);
                found = false;
            }
            catch (JBapiException be) {
                found = false;
                SBWODPLog.getLogger("Metadata").log(LogLevel.ERROR, BAPI_EXCP_IOBJ_DETAIL, (Throwable)be);
            }
            catch (SBWODPException e) {
                found = false;
                SBWODPLog.getLogger("Metadata").log(LogLevel.ERROR, SBWODP_EXCP_IOBJ_DETAIL, (Throwable)((Object)e));
            }
            catch (LogonFailureException lfe) {
                found = false;
                SBWODPLog.getLogger("Metadata").log(LogLevel.ERROR, LOGON_EXCP_IOBJ_DETAIL, (Throwable)lfe);
            }
            finally {
                if (iobj != null) {
                    iobj.release();
                }
                if (fnh != null) {
                    this.provider.removeCancelListener(fnh, executionEnvironment);
                    fnh.release();
                }
            }
        }
        if (abort) {
            return new TreeMap<String, SBWODPInfoObjDetails>();
        }
        if (found) {
            return map;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean setInfoObjectDetails(TreeMap<String, SBWODPInfoObjDetails> map, SBWODPInfoObjDetails infoObj, SBWODPConnection connection, ExecutionEnvironment executionEnvironment) {
        if (infoObj.getOlapType().equals(DATA_PACKET_ATTRIBUTE)) {
            return true;
        }
        infoObj.setIsDateType();
        SBWODPMetadataHandler fnh = null;
        JBapiStructure struct = null;
        try {
            fnh = new SBWODPMetadataHandler(this.provider, connection, "BAPI_IOBJ_GETDETAIL");
            this.provider.addCancelListener(fnh, executionEnvironment);
            fnh.setImportParameter("INFOOBJECT", infoObj.getName());
            fnh.setImportParameter("VERSION", "A");
            fnh.executeFunctionNoCheck();
            struct = fnh.getExportStructure("DETAILS");
            String abapType = struct.getString("DATATP");
            infoObj.setAbapType(abapType);
            infoObj.setHasTimeDepText(struct.getString("TXTTIMFL").equals("1"));
            infoObj.setTextTable(struct.getString("TXTTAB"));
            String olapType = infoObj.getOlapType();
            if (olapType == null || olapType.length() == 0) {
                olapType = struct.getString("TYPE");
                infoObj.setOlapType(olapType);
            }
        }
        catch (JBapiSAPException se) {
            SBWODPLog.getLogger("Metadata").log(LogLevel.ERROR, "BAPI SAP Exception while executing getInfoObjectDetails: " + se.getMessage());
            boolean bl = false;
            return bl;
        }
        catch (JBapiException be) {
            SBWODPLog.getLogger("Metadata").log(LogLevel.ERROR, "BAPI Exception while executing getInfoObjectDetails: " + be.getMessage());
            boolean bl = false;
            return bl;
        }
        catch (SBWODPException e) {
            SBWODPLog.getLogger("Metadata").log(LogLevel.ERROR, "Exception while executing getInfoObjectDetails: ", (Throwable)((Object)e));
            boolean bl = false;
            return bl;
        }
        catch (LogonFailureException lfe) {
            SBWODPLog.getLogger("Metadata").log(LogLevel.ERROR, "Logon Failure while executing getInfoObjectDetails: ", (Throwable)lfe);
            boolean bl = false;
            return bl;
        }
        finally {
            if (struct != null) {
                struct.release();
            }
            if (fnh != null) {
                this.provider.removeCancelListener(fnh, executionEnvironment);
                fnh.release();
            }
        }
        map.put(infoObj.getName(), infoObj);
        return true;
    }

    public final class SBWODPInfoObjectItem {
        private final String cubeType;
        private TreeMap<String, SBWODPInfoObjDetails> ioMap = null;

        public SBWODPInfoObjectItem(String type, TreeMap<String, SBWODPInfoObjDetails> map) {
            this.cubeType = type;
            this.ioMap = map;
        }

        public TreeMap<String, SBWODPInfoObjDetails> getInfoObjectMap() {
            return this.ioMap;
        }

        public void setInfoObjectMap(TreeMap<String, SBWODPInfoObjDetails> map) {
            this.ioMap = map;
        }

        public String getCubeType() {
            return this.cubeType;
        }
    }

    public final class SBWODPInfoObjectKey
    implements Comparable<SBWODPInfoObjectKey> {
        private String sysKey;
        private String cube;
        private String language;

        public SBWODPInfoObjectKey(String sys, String c, String lang) {
            this.sysKey = sys;
            this.cube = c;
            this.language = lang;
        }

        @Override
        public int compareTo(SBWODPInfoObjectKey other) {
            int ret = this.sysKey.compareTo(other.sysKey);
            if (ret == 0 && (ret = this.cube.compareTo(other.cube)) == 0) {
                ret = this.language.compareTo(other.language);
            }
            return ret;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.getOuterType().hashCode();
            result = 31 * result + (this.cube == null ? 0 : this.cube.hashCode());
            result = 31 * result + (this.language == null ? 0 : this.language.hashCode());
            result = 31 * result + (this.sysKey == null ? 0 : this.sysKey.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            SBWODPInfoObjectKey other = (SBWODPInfoObjectKey)obj;
            if (!this.getOuterType().equals(other.getOuterType())) {
                return false;
            }
            if (this.cube == null ? other.cube != null : !this.cube.equals(other.cube)) {
                return false;
            }
            if (this.language == null ? other.language != null : !this.language.equals(other.language)) {
                return false;
            }
            return !(this.sysKey == null ? other.sysKey != null : !this.sysKey.equals(other.sysKey));
        }

        public String getName() {
            return this.cube;
        }

        private SBWODPInfoObjectCache getOuterType() {
            return SBWODPInfoObjectCache.this;
        }
    }
}

