/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.data.providers.olap.sbwodp;

import com.cognos.xqe.bibushandler.OperationCanceledException;
import com.cognos.xqe.data.providers.DataProviderBase;
import com.cognos.xqe.data.providers.ProviderResultSetBase;
import com.cognos.xqe.data.providers.olap.MDXQueryArguments;
import com.cognos.xqe.data.providers.olap.sbwodp.SBWODPAxisInfo;
import com.cognos.xqe.data.providers.olap.sbwodp.SBWODPAxisIterator;
import com.cognos.xqe.data.providers.olap.sbwodp.SBWODPCellIterator;
import com.cognos.xqe.data.providers.olap.sbwodp.SBWODPDataProvider;
import com.cognos.xqe.data.providers.olap.sbwodp.SBWODPException;
import com.cognos.xqe.data.providers.olap.sbwodp.SBWODPLog;
import com.cognos.xqe.data.providers.olap.sbwodp.SBWODPMDXHandler;
import com.cognos.xqe.data.providers.olap.sbwodp.SBWODPMessageKeys;
import com.cognos.xqe.data.providers.olap.sbwodp.SBWODPSAPData;
import com.cognos.xqe.metadata.ICube;
import com.cognos.xqe.metadata.IDimension;
import com.cognos.xqe.resultset.interfaces.ICubeResultSet;
import com.cognos.xqe.resultset.interfaces.ITuple;
import com.cognos.xqe.resultsets.md.XCellIterator;
import com.cognos.xqe.runtree.XDataContext;
import com.cognos.xqe.runtree.XIterator;
import com.cognos.xqe.runtree.XScrollableCellIterator;
import com.cognos.xqe.runtree.XScrollableIterator;
import com.cognos.xqe.trace.LogLevel;
import java.util.concurrent.atomic.AtomicInteger;

public class SBWODPResultSet
extends ProviderResultSetBase
implements ICubeResultSet {
    private volatile boolean isReleased = false;
    private static final long serialVersionUID = 1L;
    private ICube mCube = null;
    private final SBWODPAxisInfo[] sapAxes;
    private boolean hasSlicer = false;
    private SBWODPSAPData sapData = null;
    private IDimension[] dimensions = null;
    private SBWODPMDXHandler mdxHandler = null;
    private static AtomicInteger axisIterID = new AtomicInteger(0);
    private static AtomicInteger cellIterID = new AtomicInteger(0);

    public SBWODPResultSet(SBWODPDataProvider provider, XDataContext xDataContext, MDXQueryArguments queryArguments, SBWODPMDXHandler handler, SBWODPSAPData data) throws SBWODPException {
        super((DataProviderBase)provider, xDataContext, queryArguments.getRunLocale());
        if (SBWODPLog.isOn("DataQuery", LogLevel.TRACE).booleanValue()) {
            SBWODPLog.getLogger("DataQuery").log(LogLevel.TRACE, "Constructing result set.");
        }
        this.mCube = queryArguments.getCube();
        this.mdxHandler = handler;
        this.sapData = data;
        try {
            this.sapAxes = SBWODPAxisInfo.getAllAxes(this.sapData, this);
        }
        catch (SBWODPException e) {
            this.release();
            throw e;
        }
    }

    public void setHasSlicer() {
        this.hasSlicer = true;
    }

    public int getNumAxes() {
        if (this.hasSlicer) {
            return this.sapAxes.length - 1;
        }
        return this.sapAxes.length;
    }

    public String getKeyDate() {
        return this.mdxHandler.getKeyDate();
    }

    public XIterator getAxisIterator(int axisKey) throws SBWODPException {
        SBWODPAxisIterator iter = null;
        int id = axisIterID.getAndIncrement();
        try {
            iter = new SBWODPAxisIterator(this, this.getDataContext(), this.mCube, this.sapAxes[axisKey], this.mdxHandler.getNodeID(), id);
        }
        catch (SBWODPException e) {
            throw new SBWODPException(SBWODPMessageKeys.ERR_GET_AXIS_ITER, (Throwable)((Object)e));
        }
        if (SBWODPLog.isOn("DataQuery", LogLevel.TRACE).booleanValue()) {
            SBWODPLog.getLogger("DataQuery").log(LogLevel.TRACE, "Returning AxisIterator for Axis: " + axisKey + " with ID: " + id + " and nodeID: " + this.mdxHandler.getNodeID());
        }
        return iter;
    }

    public ITuple getSlicer() throws SBWODPException {
        return null;
    }

    public boolean isAxisSlicer(int axisno) {
        return this.sapAxes[axisno].isSlicer();
    }

    public XCellIterator getCellIterator() throws SBWODPException {
        SBWODPSAPData cellData = null;
        try {
            cellData = this.mdxHandler.executeGetCellDataFunction(0, 0);
        }
        catch (SBWODPException e) {
            throw new SBWODPException(SBWODPMessageKeys.ERR_GET_CELL_ITER, (Throwable)((Object)e));
        }
        int id = cellIterID.incrementAndGet();
        SBWODPCellIterator iter = new SBWODPCellIterator(this, this.getDataContext(), cellData, this.nodeId, id);
        if (SBWODPLog.isOn("DataQuery", LogLevel.TRACE).booleanValue()) {
            SBWODPLog.getLogger("DataQuery").log(LogLevel.TRACE, "Returning CellIterator with ID: " + id + " and Node ID: " + this.mdxHandler.getNodeID());
        }
        return iter;
    }

    public XScrollableIterator getScrollableAxisIterator(int axisNumber) {
        throw new UnsupportedOperationException();
    }

    public XScrollableCellIterator getScrollableCellIterator() {
        throw new UnsupportedOperationException();
    }

    public IDimension[] getDimensions(int axisNumber) {
        if (this.dimensions == null) {
            this.dimensions = SBWODPAxisInfo.getDimensions(this.sapData, axisNumber, this.sapAxes[axisNumber].getDimensionNum());
        }
        return this.dimensions;
    }

    public int getNumTabularMeasures() {
        return 0;
    }

    public int getNumDataItemForSummary(int rowsetId) {
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getAxisSize(int axisNumber) throws SBWODPException {
        long size = 0L;
        SBWODPSAPData axisData = null;
        try {
            axisData = this.mdxHandler.executeGetAxisDataFunction(this.sapAxes[axisNumber].getAxisKey(), 0, 0);
            if (axisData != null) {
                long rowCount = axisData.getRowCount(2);
                if (rowCount == 0L) {
                    long l = rowCount;
                    return l;
                }
                int dimNum = this.sapAxes[axisNumber].getDimensionNum();
                if (rowCount % (long)dimNum != 0L) {
                    throw new SBWODPException(SBWODPMessageKeys.ERR_GET_AXIS_SIZE);
                }
                size = rowCount / (long)dimNum;
            }
        }
        finally {
            if (axisData != null) {
                axisData.release();
            }
        }
        return size;
    }

    public SBWODPSAPData executeGetAxisDataFunction(int axis, int iStartTuple, int iEndTuple) throws SBWODPException {
        return this.mdxHandler.executeGetAxisDataFunction(axis, iStartTuple, iEndTuple);
    }

    public void checkForCancel() throws OperationCanceledException {
        if (this.mdxHandler.isCanceled()) {
            throw new OperationCanceledException();
        }
    }

    protected synchronized void releaseImpl() {
        try {
            if (SBWODPLog.isOn("DataQuery", LogLevel.TRACE).booleanValue()) {
                SBWODPLog.getLogger("DataQuery").log(LogLevel.TRACE, "Releasing SBWODPResultSet with Node ID: " + this.mdxHandler.getNodeID());
            }
            if (this.isReleased) {
                SBWODPLog.getLogger("DataQuery").log(LogLevel.ERROR, "Attempt to Release previously released SBWODPResultSet.");
                return;
            }
            this.isReleased = true;
            if (this.mdxHandler != null) {
                this.mdxHandler.release();
                this.mdxHandler = null;
            }
            if (this.sapData != null) {
                this.sapData.release();
                this.sapData = null;
            }
        }
        finally {
            super.releaseImpl();
        }
    }
}

