/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.data.providers.olap.sbwodp;

import com.cognos.accman.jcam.crypto.CAMCryptoException;
import com.cognos.accman.jcam.crypto.CAMFactory;
import com.cognos.xqe.data.providers.olap.sbwodp.SBWODPConfig;
import com.cognos.xqe.data.providers.olap.sbwodp.SBWODPException;
import com.cognos.xqe.data.providers.olap.sbwodp.SBWODPLog;
import com.cognos.xqe.data.providers.olap.sbwodp.SBWODPMessageKeys;
import com.cognos.xqe.data.providers.olap.sbwodp.SBWODPSPNEGOScheme;
import com.cognos.xqe.trace.LogLevel;
import com.cognos.xqe.util.SingletonHelper;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.Socket;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.auth.AuthPolicy;
import org.apache.commons.httpclient.auth.AuthScope;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.params.DefaultHttpParams;
import org.apache.commons.httpclient.params.HttpParams;

public final class SBWODPSSOCache {
    private static final String HTTP_SSO_CONFIG = SBWODPConfig.instance().getBapiHTTPSSO();
    private static final String START_REQUEST = "GET ";
    private static final String HOST_PART = " HTTP/1.1\r\nHOST:";
    private static final String REMOTE_USER = " \r\nREMOTE_USER:";
    private static final String END_REQUEST = "\r\nUSER-AGENT:XQEODP\r\nACCEPT:*/*\r\nCONNECTION: keep-alive\r\n\r\n";
    private static final String EQUALS = "=";
    private static final String SEMI_COLON = ";";
    private static final String TICKET = "MYSAPSSO2";
    private static final String SERVICEID = "XQEODP";
    private static final String HTML_TAG = "<html>";
    private static final String FORWARD_SLASH = "/";
    private static final String PREFIX = "SSOCache: ";
    private static final int SIXTY = 60;
    private static final int ONE_THOUSAND = 1000;
    private static final Object LOCK = new Object();
    private int validity = 60;
    private final TicketCache ticketCache = new TicketCache(SBWODPConfig.instance().getBapiSSOCacheSize());
    private final HashMap<String, String> serverMapping = new HashMap();
    private boolean httpssoEnabled = false;
    private CAMFactory camFactory = null;
    private static final String SPNEGO_MECH_NAME = "Negotiate";
    private static final String ONLYSUBJCREDS = "javax.security.auth.useSubjectCredsOnly";
    private static final String USER_AGENT_ID = "User-Agent: Mozilla/4.0 (compatible; MSIE 7.0; Windows NT 6.1; WOW64)";
    private static SingletonHelper<SBWODPSSOCache> singletonHelper = new SingletonHelper<SBWODPSSOCache>(){

        protected SBWODPSSOCache newInstance() {
            return new SBWODPSSOCache();
        }

        protected void initializeImpl(SBWODPSSOCache theInstance) {
            theInstance.initialize();
        }

        protected void releaseImpl(SBWODPSSOCache theInstance) {
            theInstance.release();
        }
    };

    public static SBWODPSSOCache getInstance() {
        return (SBWODPSSOCache)singletonHelper.getInstance();
    }

    public static void releaseInstance() {
        singletonHelper.releaseInstance();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getSSOTicket(String server, String user, boolean isKerberos) throws SBWODPException {
        String key = this.generateCacheKey(server, user);
        String ticket = this.checkCache(key);
        if (ticket != null) {
            SBWODPLog.getLogger("Connection").log(LogLevel.TRACE, "SSOCache: Ticket found in SSO Cache: " + server + FORWARD_SLASH + user);
            return ticket;
        }
        Object object = LOCK;
        synchronized (object) {
            if (isKerberos) {
                if (SBWODPLog.isOn("Connection", LogLevel.TRACE).booleanValue()) {
                    SBWODPLog.getLogger("Connection").log(LogLevel.TRACE, "SSOCache: Kerberos authenticaion: " + server + FORWARD_SLASH + user);
                }
                ticket = this.kerberosAuthentication(this.serverMapping.get(server));
            } else {
                ticket = this.requestTicket(this.serverMapping.get(server), user);
            }
        }
        if (ticket != null) {
            this.addToCache(key, ticket);
        }
        return ticket;
    }

    public boolean isHTTPSSOEnabled() {
        return this.httpssoEnabled;
    }

    private String requestTicket(String j2EEServer, String user) throws SBWODPException {
        String ticket = null;
        try {
            URL j2eeURL = new URL(j2EEServer);
            String host = j2eeURL.getHost();
            String path = j2eeURL.getPath();
            if (host == null || host.isEmpty() || path == null || path.isEmpty()) {
                return ticket;
            }
            StringBuilder sb = new StringBuilder(START_REQUEST);
            sb.append(path);
            sb.append(HOST_PART);
            sb.append(host);
            sb.append(REMOTE_USER);
            sb.append(user);
            sb.append(END_REQUEST);
            Socket socket = this.camFactory.createSocket(j2eeURL);
            PrintWriter printWriter = new PrintWriter(socket.getOutputStream(), true);
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(socket.getInputStream()));
            printWriter.println(sb.toString());
            String responseLine = null;
            while ((responseLine = bufferedReader.readLine()) != null) {
                if (responseLine.contains(TICKET)) {
                    int ticketStarts = responseLine.indexOf(EQUALS) + 1;
                    int ticketEnds = responseLine.indexOf(SEMI_COLON);
                    ticket = responseLine.substring(ticketStarts, ticketEnds);
                    break;
                }
                if (!responseLine.contains(HTML_TAG)) continue;
            }
            printWriter.close();
            bufferedReader.close();
            socket.close();
        }
        catch (Exception e) {
            SBWODPLog.getLogger("Exception").log(LogLevel.ERROR, "SSOCache: Error getting SSO ticket from SAP J2EE Engine:", (Throwable)e);
            throw new SBWODPException(SBWODPMessageKeys.ERR_NO_CRED);
        }
        return ticket;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addToCache(String key, String sso) {
        Object object = LOCK;
        synchronized (object) {
            long currentTime = System.currentTimeMillis();
            SBWODPTicket ticket = new SBWODPTicket(sso, currentTime);
            this.ticketCache.put(key, ticket);
        }
        SBWODPLog.getLogger("Connection").log(LogLevel.TRACE, "SSOCache: SSO Ticket added to cache: " + key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String checkCache(String key) {
        Object object = LOCK;
        synchronized (object) {
            String sso = null;
            SBWODPTicket ticket = (SBWODPTicket)this.ticketCache.get(key);
            if (ticket != null) {
                long elapsedTime = System.currentTimeMillis() - ticket.getCreated();
                if (elapsedTime / 60000L <= (long)this.validity) {
                    sso = ticket.getTicket();
                } else {
                    this.removeFromCache(key);
                    SBWODPLog.getLogger("Connection").log(LogLevel.TRACE, "SSOCache: SSO Ticket has expired and has been removed from the cache for: " + key);
                }
            }
            return sso;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeFromCache(String key) {
        Object object = LOCK;
        synchronized (object) {
            if (key == null) {
                return;
            }
            if (this.ticketCache.containsKey(key)) {
                this.ticketCache.remove(key);
            }
        }
    }

    private void initialize() {
        String[] serverMap;
        if (HTTP_SSO_CONFIG == null || HTTP_SSO_CONFIG.isEmpty()) {
            SBWODPLog.getLogger("Connection").log(LogLevel.TRACE, "SSOCache: bapiHTTPSSO is not configured in xqe.odp.config.xml");
            return;
        }
        try {
            this.camFactory = new CAMFactory(SERVICEID);
        }
        catch (CAMCryptoException e) {
            SBWODPLog.getLogger("Connection").log(LogLevel.TRACE, "SSOCache: Failed to initialize CAM Factory");
            return;
        }
        this.validity = SBWODPConfig.instance().getBapiSSOValidTime();
        for (String mappings : serverMap = HTTP_SSO_CONFIG.split(" ")) {
            String[] oneMapping = mappings.split(EQUALS);
            if (oneMapping.length != 2) {
                SBWODPLog.getLogger("Connection").log(LogLevel.TRACE, "SSOCache: bapiHTTPSSO is not configured correctly in xqe.odp.config.xml");
                return;
            }
            this.serverMapping.put(oneMapping[0], oneMapping[1]);
        }
        this.httpssoEnabled = true;
        SBWODPLog.getLogger("Connection").log(LogLevel.TRACE, "SSOCache: bapiHTTPSSO cache has been instantiated");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void release() {
        SBWODPLog.getLogger("Connection").log(LogLevel.TRACE, "SSOCache: bapiHTTPSSO Cache released");
        Object object = LOCK;
        synchronized (object) {
            if (!this.serverMapping.isEmpty()) {
                this.serverMapping.clear();
            }
            if (!this.ticketCache.isEmpty()) {
                this.ticketCache.clear();
            }
        }
        if (this.camFactory != null) {
            this.camFactory.terminate();
        }
    }

    private String generateCacheKey(String server, String user) {
        StringBuilder sb = new StringBuilder();
        sb.append(server);
        sb.append(user);
        return sb.toString();
    }

    private String kerberosAuthentication(String j2eeServer) {
        String ticket = null;
        String subCreds = System.getProperty(ONLYSUBJCREDS);
        if (null == subCreds || subCreds.equals("")) {
            subCreds = "false";
        }
        System.setProperty(ONLYSUBJCREDS, "true");
        AuthPolicy.registerAuthScheme((String)SPNEGO_MECH_NAME, SBWODPSPNEGOScheme.class);
        ArrayList<String> schemes = new ArrayList<String>();
        schemes.add(SPNEGO_MECH_NAME);
        HttpParams params = DefaultHttpParams.getDefaultParams();
        params.setParameter("http.auth.scheme-priority", schemes);
        params.setParameter("http.useragent", (Object)USER_AGENT_ID);
        GetMethod httpGet = new GetMethod(j2eeServer);
        try {
            Header responseHeader;
            HttpClient http = this.camFactory.createHttpClient();
            Credentials dummyJAASCreds = new Credentials(){};
            http.getState().setCredentials(new AuthScope(null, -1, null), dummyJAASCreds);
            httpGet.setDoAuthentication(true);
            http.executeMethod((HttpMethod)httpGet);
            if (SBWODPLog.isOn("Connection", LogLevel.TRACE).booleanValue()) {
                SBWODPLog.getLogger("Connection").log(LogLevel.TRACE, PREFIX + httpGet.getStatusLine());
            }
            if ((responseHeader = httpGet.getResponseHeader("set-cookie")) == null) {
                String string = ticket;
                return string;
            }
            String cookies = responseHeader.toString();
            int i = cookies.indexOf(TICKET);
            if (i > 0) {
                ticket = cookies.substring(i + TICKET.length() + 1, cookies.indexOf(SEMI_COLON, i));
                if (SBWODPLog.isOn("Connection", LogLevel.TRACE).booleanValue()) {
                    SBWODPLog.getLogger("Connection").log(LogLevel.TRACE, "Kerberos authenticated MYSAPSSO2 cookie found.");
                }
            }
        }
        catch (Exception ex) {
            SBWODPLog.getLogger("Connection").log(LogLevel.ERROR, "SSOCache: Kerberos authentication failed: " + ex.getMessage());
            throw new SBWODPException(SBWODPMessageKeys.ERR_NO_CRED);
        }
        finally {
            httpGet.releaseConnection();
        }
        return ticket;
    }

    private static final class TicketCache
    extends LinkedHashMap<String, SBWODPTicket> {
        private static final long serialVersionUID = 1L;
        private static final float DEFAULT_GROWTH_FACTOR = 1.0f;
        final int mMaxSize;

        TicketCache(int maxSize) {
            super(maxSize, 1.0f, true);
            this.mMaxSize = maxSize;
        }

        @Override
        protected boolean removeEldestEntry(Map.Entry<String, SBWODPTicket> eldest) {
            boolean removeEldest;
            boolean bl = removeEldest = this.size() > this.mMaxSize;
            if (removeEldest) {
                SBWODPLog.getLogger("Connection").log(LogLevel.TRACE, "SSOCache: Cache limit reached, the least recently accessed SSO ticket will be removed: " + eldest.getKey());
            }
            return removeEldest;
        }
    }

    private class SBWODPTicket {
        private String ticket = null;
        private long created = 0L;

        SBWODPTicket(String theTicket, long time) {
            this.ticket = theTicket;
            this.created = time;
        }

        public String getTicket() {
            return this.ticket;
        }

        public long getCreated() {
            return this.created;
        }
    }
}

