/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.data.providers.olap.snwodp;

import com.cognos.xqe.conn.bapi.JBapiException;
import com.cognos.xqe.conn.bapi.JBapiTable;
import com.cognos.xqe.data.providers.olap.snwodp.SNWODPConfig;
import com.cognos.xqe.data.providers.olap.snwodp.SNWODPException;
import com.cognos.xqe.data.providers.olap.snwodp.SNWODPLog;
import com.cognos.xqe.data.providers.olap.snwodp.SNWODPMessageKeys;
import com.cognos.xqe.data.providers.olap.snwodp.SNWODPResultSet;
import com.cognos.xqe.data.providers.olap.snwodp.SNWODPSAPData;
import com.cognos.xqe.metadata.IDimension;
import com.cognos.xqe.metadata.provider.Dimension;
import com.cognos.xqe.trace.LogLevel;
import com.cognos.xqe.util.pool.XQEIntegerPool;
import java.util.ArrayList;

public final class SNWODPAxisInfo {
    private static final String STR_OF = " of ";
    private static final int INT_SLICER_AXIS_NO = 255;
    private int mTotalAxes;
    private int mAxisNum;
    private int mAxisCoord;
    private int mDimensionNums;
    private IDimension[] mDimensions;

    public SNWODPAxisInfo(int axisNum, int totalAxes, int axisCoord, int dimensionNums, IDimension[] dimensions) {
        this.mAxisNum = axisNum;
        this.mTotalAxes = totalAxes;
        this.mAxisCoord = axisCoord;
        this.mDimensionNums = dimensionNums;
        this.mDimensions = dimensions;
        if (SNWODPLog.isOn("DataQuery", LogLevel.TRACE).booleanValue()) {
            SNWODPLog.getLogger("DataQuery").log(LogLevel.TRACE, "Constructing AxisInfo for axis " + this.mAxisNum + STR_OF + this.mTotalAxes);
        }
    }

    public static SNWODPAxisInfo[] getAllAxes(SNWODPSAPData sapData, SNWODPResultSet resultSet) {
        ArrayList<SNWODPAxisInfo> axes;
        if (SNWODPLog.isOn("DataQuery", LogLevel.TRACE).booleanValue()) {
            SNWODPLog.getLogger("DataQuery").log(LogLevel.TRACE, "AxisInfo.getAllAxes called");
        }
        JBapiTable axisTable = sapData.getData(0);
        try {
            if (SNWODPLog.isOn("DataQuery", LogLevel.INFO).booleanValue()) {
                SNWODPLog.getLogger("DataQuery").log(LogLevel.INFO, axisTable.traceToString(SNWODPConfig.instance().getMaxTableDumpRows()));
                SNWODPLog.getLogger("DataQuery").log(LogLevel.INFO, sapData.getData(1).traceToString(SNWODPConfig.instance().getMaxTableDumpRows()));
            }
            int rowCount = axisTable.getNumRows();
            axes = new ArrayList<SNWODPAxisInfo>(rowCount);
            for (int i = 0; i < rowCount; ++i) {
                axisTable.moveTo(i);
                int axisNum = axisTable.getFieldIntByIndex(0);
                int axisCoord = axisTable.getFieldIntByIndex(2);
                int dimensionNums = axisTable.getFieldIntByIndex(1);
                IDimension[] dimensions = SNWODPAxisInfo.getDimensions(sapData, axisNum, dimensionNums);
                SNWODPAxisInfo axis = new SNWODPAxisInfo(axisNum, rowCount, axisCoord, dimensionNums, dimensions);
                axes.add(axis);
                if (!axis.isSlicer()) continue;
                resultSet.setHasSlicer();
            }
        }
        catch (JBapiException e) {
            throw new SNWODPException(SNWODPMessageKeys.ERR_GET_ALL_AXES, e);
        }
        return axes.toArray(new SNWODPAxisInfo[0]);
    }

    public static IDimension[] getDimensions(SNWODPSAPData sapData, int axisNumber, int numDims) {
        ArrayList<Dimension> dims;
        JBapiTable dimTable = sapData.getData(1);
        try {
            int rowCount = dimTable.getNumRows();
            dims = new ArrayList<Dimension>(numDims);
            for (int i = 0; i < rowCount; ++i) {
                dimTable.moveTo(i);
                int axisNum = dimTable.getFieldIntByIndex(0);
                if (axisNumber != axisNum) continue;
                String dimensionName = dimTable.getFieldByIndex(1);
                Dimension dim = new Dimension(dimensionName);
                dim.setUniqueName(dimensionName);
                dim.setProperty("DIM_KEY", (Object)XQEIntegerPool.getInteger((int)dimTable.getFieldIntByIndex(2)));
                dims.add(dim);
            }
        }
        catch (JBapiException e) {
            throw new SNWODPException(SNWODPMessageKeys.ERR_GET_AXIS_DIMS, e);
        }
        return dims.toArray(new IDimension[0]);
    }

    public IDimension getDimension(int dimKey) {
        for (int i = 0; i < this.mDimensions.length; ++i) {
            IDimension dim = this.mDimensions[i];
            Integer dimensionKey = (Integer)dim.getProperty("DIM_KEY");
            if (dimensionKey != dimKey) continue;
            if (SNWODPLog.isOn("DataQuery", LogLevel.TRACE).booleanValue()) {
                SNWODPLog.getLogger("DataQuery").log(LogLevel.TRACE, "AxisInfo.getDimension: Dimension found for key: " + dimKey);
            }
            return dim;
        }
        if (SNWODPLog.isOn("DataQuery", LogLevel.TRACE).booleanValue()) {
            SNWODPLog.getLogger("DataQuery").log(LogLevel.TRACE, "AxisInfo.getDimension: Dimension not found for key: " + dimKey);
        }
        return null;
    }

    public IDimension[] getDimensions() {
        return this.mDimensions;
    }

    public int getDimensionNum() {
        return this.mDimensionNums;
    }

    public boolean isSlicer() {
        return this.mAxisNum == 255;
    }

    public int getAxisCoord() {
        return this.mAxisCoord;
    }

    public int getAxisKey() {
        return this.mAxisNum;
    }

    public int getNumAxes() {
        return this.mTotalAxes;
    }

    public void release() {
        if (SNWODPLog.isOn("DataQuery", LogLevel.TRACE).booleanValue()) {
            SNWODPLog.getLogger("DataQuery").log(LogLevel.TRACE, "Releasing AxisInfo for axis " + this.mAxisNum + STR_OF + this.mTotalAxes);
        }
    }
}

