/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.data.providers.olap.snwodp;

import com.cognos.xqe.data.providers.ProviderCellBase;
import com.cognos.xqe.data.values.DataValueFactory;
import com.cognos.xqe.data.values.IValue;
import com.cognos.xqe.util.pool.XQELongPool;
import com.cognos.xqe.util.xml.XMLWriter;
import java.util.Map;
import java.util.Set;

public class SNWODPCell
extends ProviderCellBase {
    private String formatString;
    private String formattedValue;

    public SNWODPCell() {
        this.value = DataValueFactory.createDoubleValue();
        this.value.setNull();
        this.ordinal = -1L;
        this.formatString = null;
        this.formattedValue = null;
        this.cellProperties = null;
    }

    public String getFormatString() {
        return this.formatString;
    }

    public String getFormattedValue() {
        return this.formattedValue;
    }

    public void setFormattedValue(String s) {
        this.formattedValue = s;
    }

    public void copyFrom(IValue arg0) {
        if (arg0 instanceof SNWODPCell) {
            super.copyFrom(arg0);
            SNWODPCell copyMe = (SNWODPCell)arg0;
            this.formatString = copyMe.formatString;
            this.formattedValue = copyMe.formattedValue;
        } else {
            this.value = arg0;
        }
    }

    public void setProperties(Map<String, Object> properties) {
        Set<String> propertyKeys = properties.keySet();
        for (String property : propertyKeys) {
            Object formatStringProperty;
            if (property.equals("FORMAT_STRING")) {
                formatStringProperty = properties.get(property);
                if (formatStringProperty == null) continue;
                this.formatString = (String)formatStringProperty;
                continue;
            }
            if (property.equals("FORMATTED_VALUE")) {
                formatStringProperty = properties.get(property);
                if (formatStringProperty == null) continue;
                this.formattedValue = (String)formatStringProperty;
                continue;
            }
            this.setCellProperty(property, properties.get(property));
        }
    }

    public Object copy() {
        SNWODPCell result = new SNWODPCell();
        result.copyFrom((IValue)this);
        return result;
    }

    public void toXML(XMLWriter xmlWriter) {
        xmlWriter.beginElement("Cell", -1);
        xmlWriter.attribute("CellOrdinal", (Object)XQELongPool.getLong((long)this.ordinal));
        xmlWriter.beginElement("Value", -1);
        xmlWriter.attribute("dataType", (Object)this.value.getDataType());
        xmlWriter.data(this.value.toString());
        xmlWriter.endElement();
        xmlWriter.endElement();
    }

    public void release() {
        super.release();
        this.formatString = null;
        this.formattedValue = null;
    }
}

