/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.data.providers.olap.snwodp;

import com.cognos.xqe.conn.bapi.JBapiConnect;
import com.cognos.xqe.conn.bapi.JBapiException;
import com.cognos.xqe.conn.bapi.JBapiFunction;
import com.cognos.xqe.conn.bapi.JBapiTable;
import com.cognos.xqe.data.model.LogonFailureException;
import com.cognos.xqe.data.providers.olap.DefaultConnection;
import com.cognos.xqe.data.providers.olap.IOLAPDataProvider;
import com.cognos.xqe.data.providers.olap.snwodp.CodePageParameter;
import com.cognos.xqe.data.providers.olap.snwodp.SNWODPException;
import com.cognos.xqe.data.providers.olap.snwodp.SNWODPLog;
import com.cognos.xqe.data.providers.olap.snwodp.SNWODPLogonInfo;
import com.cognos.xqe.data.providers.olap.snwodp.SNWODPMessageKeys;
import com.cognos.xqe.exception.XQEMessage;
import com.cognos.xqe.pool.connection.ConnectionParameters;
import com.cognos.xqe.trace.LogLevel;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicBoolean;

public final class SNWODPConnection
extends DefaultConnection {
    private static final String STR_FORHANDLE = " for Handle: ";
    private static final String STR_CONNECT_OK = "SAP connection successful.  Handle: ";
    private static final String START_BRACE = "{";
    private static final String END_BRACE = "}";
    private static final String COMMA_SPACE = ", ";
    private static final String UNKNOWN_PROFILE = "UNKNOWN";
    private static final String UTF8 = "UTF-8";
    private static final String SHA1 = "SHA-1";
    private static final String SHA1_ERROR = "Could not find the SHA-1 Algorithm to generate security context checksum";
    private static final String EXPORT_ERROR = "Could not export UTF-8 bytes to generate security context checksum";
    static final String DEF_CODE_PAGE = "4103";
    private static final int SSO_LOG_CHARS = 10;
    public static final String DOUBLE_QUOTE = "\"";
    public static final String EQUALS = "=";
    public static final String SPACE = " ";
    private SNWODPLogonInfo mConnectionInfo = null;
    private JBapiConnect mConnect = null;
    private String systemKey;
    private Object mDatasetID;
    private AtomicBoolean mIsConnected;
    private String effectiveDate;
    private String charSetName = null;
    private Map<String, String> cdPageToCharSetMap;
    private boolean isActiveDataQuery = false;
    private String userProfileHash = "UNKNOWN";
    private static final String LOGON_FAILURE = "LOGON_FAILURE";
    private String uid = "";

    public SNWODPConnection(IOLAPDataProvider dataProvider, ConnectionParameters connectionParameters) throws SNWODPException, JBapiException {
        super(dataProvider);
        String sso;
        this.setupCodePageToCharSetMap();
        this.mIsConnected = new AtomicBoolean();
        this.mDatasetID = null;
        this.effectiveDate = null;
        this.mConnectionInfo = new SNWODPLogonInfo();
        this.charSetName = connectionParameters.contains(CodePageParameter.class) ? this.cdPageToCharSetMap.get(connectionParameters.valueOf(CodePageParameter.class)) : this.cdPageToCharSetMap.get(DEF_CODE_PAGE);
        if (null == this.charSetName) {
            this.charSetName = this.cdPageToCharSetMap.get(DEF_CODE_PAGE);
        }
        this.setConnectionParameters(connectionParameters);
        try {
            this.mConnectionInfo.parseConnectionParams(connectionParameters);
        }
        catch (SNWODPException e) {
            if (SNWODPMessageKeys.ERR_NO_USERID == e.getMessageKey() || SNWODPMessageKeys.ERR_NO_PASSWD == e.getMessageKey() || SNWODPMessageKeys.ERR_NO_CRED == e.getMessageKey()) {
                throw new LogonFailureException(LogonFailureException.SubCodeEnum.INVALID_CREDENTIALS);
            }
            throw new LogonFailureException(LogonFailureException.SubCodeEnum.INVALID_CONN_STRING);
        }
        this.systemKey = this.mConnectionInfo.getProperty("cognos.sap.host") + "_";
        String type = this.mConnectionInfo.getProperty("cognos.sap.serverType");
        this.systemKey = type.equals("applicationServer") ? this.systemKey + this.mConnectionInfo.getProperty("SYSNR") : this.systemKey + this.mConnectionInfo.getProperty("R3NAME");
        this.uid = this.mConnectionInfo.getProperty("USER");
        if ((this.uid == null || this.uid.length() == 0) && (sso = this.mConnectionInfo.getProperty("MYSAPSSO2")) != null && sso.length() != 0) {
            try {
                String utf8 = UTF8;
                MessageDigest digest = MessageDigest.getInstance(SHA1);
                digest.reset();
                byte[] hash = digest.digest(sso.getBytes(UTF8));
                this.uid = this.userProfileHash = new String(hash, UTF8);
            }
            catch (NoSuchAlgorithmException nsae) {
                throw new JBapiException(SHA1_ERROR);
            }
            catch (UnsupportedEncodingException uee) {
                throw new JBapiException(EXPORT_ERROR);
            }
        }
        this.mConnect = new JBapiConnect(this.charSetName);
        this.connect();
    }

    private String buildSAPConnectionString() {
        String sapConnectionString;
        boolean uidHasSpace = false;
        if (this.uid != null && this.uid.contains(SPACE)) {
            uidHasSpace = true;
            this.mConnectionInfo.remove("USER");
        }
        if ((sapConnectionString = this.mConnectionInfo.toString()).startsWith(START_BRACE)) {
            sapConnectionString = sapConnectionString.substring(1);
        }
        if (sapConnectionString.endsWith(END_BRACE)) {
            sapConnectionString = sapConnectionString.substring(0, sapConnectionString.length() - 1);
        }
        String[] connectionParameters = sapConnectionString.split(COMMA_SPACE);
        StringBuilder sb = new StringBuilder();
        for (String param : connectionParameters) {
            String[] kvPair = param.split(EQUALS);
            sb.append(kvPair[0]);
            sb.append(EQUALS);
            sb.append(DOUBLE_QUOTE);
            sb.append(kvPair[1]);
            sb.append(DOUBLE_QUOTE);
            sb.append(SPACE);
        }
        if (uidHasSpace) {
            this.mConnectionInfo.setProperty("USER", this.uid);
        }
        return sb.toString();
    }

    private void setupCodePageToCharSetMap() {
        this.cdPageToCharSetMap = new TreeMap<String, String>();
        this.cdPageToCharSetMap.put("1100", "iso-8859-1");
        this.cdPageToCharSetMap.put("1103", "ibm-850");
        this.cdPageToCharSetMap.put("1127", "macce");
        this.cdPageToCharSetMap.put("1160", "windows-1252");
        this.cdPageToCharSetMap.put("1401", "iso-8859-2");
        this.cdPageToCharSetMap.put("1404", "windows-1250");
        this.cdPageToCharSetMap.put("1500", "iso-8859-5");
        this.cdPageToCharSetMap.put("1504", "windows-1251");
        this.cdPageToCharSetMap.put("1610", "iso-8859-9");
        this.cdPageToCharSetMap.put("1614", "windows-1254");
        this.cdPageToCharSetMap.put("1700", "iso-8859-7");
        this.cdPageToCharSetMap.put("1703", "ibm-869");
        this.cdPageToCharSetMap.put("1704", "windows-1253");
        this.cdPageToCharSetMap.put("1800", "iso-8859-8");
        this.cdPageToCharSetMap.put("8000", "shift_jis");
        this.cdPageToCharSetMap.put("8300", "big5");
        this.cdPageToCharSetMap.put("8400", "gb2312");
        this.cdPageToCharSetMap.put("8500", "ksc5601");
        this.cdPageToCharSetMap.put("8600", "tis-620");
        this.cdPageToCharSetMap.put("4102", "utf-16be");
        this.cdPageToCharSetMap.put("DEF_CODE_PAGE", "utf-16le");
        this.cdPageToCharSetMap.put("4110", "utf-8");
    }

    public synchronized void setActiveDataQuery(boolean active) {
        this.isActiveDataQuery = active;
    }

    public synchronized boolean getActiveDataQuery() {
        return this.isActiveDataQuery;
    }

    public String getSystemKey() {
        return this.systemKey;
    }

    private JBapiConnect connect() throws LogonFailureException, SNWODPException {
        String host = this.mConnectionInfo.getProperty("cognos.sap.host");
        this.mConnectionInfo.remove("cognos.sap.host");
        this.mConnectionInfo.remove("cognos.sap.serverType");
        try {
            if (this.mConnect == null) {
                this.mConnect = new JBapiConnect(this.charSetName);
            }
            if (SNWODPLog.isOn("Connection", LogLevel.INFO).booleanValue()) {
                this.logConnectionString(false);
            }
            this.updateConnectionTime();
            this.mConnect.connect(this.buildSAPConnectionString());
            this.updateConnectionTime();
            this.mIsConnected.compareAndSet(false, true);
        }
        catch (JBapiException se) {
            String message = se.getMessage();
            if (se.getErrorGroup() == 104 || message.contains(LOGON_FAILURE)) {
                if (this.mConnectionInfo.getProperty("MYSAPSSO2") != null) {
                    throw new SNWODPException(SNWODPMessageKeys.ERR_INVALID_SSO_TICKET, this.logConnectionString(false));
                }
                if (this.mConnectionInfo.getProperty("LANG") != null) {
                    this.mConnectionInfo.remove("LANG");
                    if (SNWODPLog.isOn("Connection", LogLevel.INFO).booleanValue()) {
                        this.logConnectionString(true);
                    }
                    try {
                        this.mConnect.connect(this.buildSAPConnectionString());
                        this.mIsConnected.compareAndSet(false, true);
                        this.obfuscateConnectionInfo();
                    }
                    catch (JBapiException jse) {
                        message = jse.getMessage();
                        if (jse.getErrorGroup() == 104 || message.contains(LOGON_FAILURE)) {
                            throw new LogonFailureException(LogonFailureException.SubCodeEnum.INVALID_CREDENTIALS);
                        }
                        throw new SNWODPException(SNWODPMessageKeys.ERR_BAPI_CONNECTION_ERROR, se, host);
                    }
                    if (SNWODPLog.isOn("Connection", LogLevel.INFO).booleanValue()) {
                        SNWODPLog.getLogger("Connection").log(LogLevel.INFO, STR_CONNECT_OK + this.mConnect.getHandle());
                    }
                    JBapiConnect jBapiConnect = this.mConnect;
                    return jBapiConnect;
                }
                throw new LogonFailureException(LogonFailureException.SubCodeEnum.INVALID_CREDENTIALS);
            }
            throw new SNWODPException(SNWODPMessageKeys.ERR_BAPI_CONNECTION_ERROR, se, host);
        }
        finally {
            this.obfuscateConnectionInfo();
        }
        if (SNWODPLog.isOn("Connection", LogLevel.INFO).booleanValue()) {
            SNWODPLog.getLogger("Connection").log(LogLevel.INFO, STR_CONNECT_OK + this.mConnect.getHandle());
        }
        return this.mConnect;
    }

    private void obfuscateConnectionInfo() {
        if (null != this.mConnectionInfo) {
            this.mConnectionInfo.obfuscatePassword();
            this.mConnectionInfo.obfuscateSSO();
            this.mConnectionInfo = null;
        }
    }

    private String logConnectionString(boolean retry) {
        String sso;
        String pwd = this.mConnectionInfo.getProperty("PASSWD");
        if (pwd != null) {
            this.mConnectionInfo.obfuscatePassword();
        }
        if ((sso = this.mConnectionInfo.getProperty("MYSAPSSO2")) != null) {
            this.mConnectionInfo.setProperty("MYSAPSSO2", "..." + sso.substring(sso.length() - 10));
        }
        String logConnectionString = this.buildSAPConnectionString();
        if (retry) {
            SNWODPLog.getLogger("Connection").log(LogLevel.INFO, "Reattempting SAP connection with connection string: " + logConnectionString);
        } else {
            SNWODPLog.getLogger("Connection").log(LogLevel.INFO, "Attempting SAP connection with connection string: " + logConnectionString);
        }
        if (pwd != null) {
            this.mConnectionInfo.setProperty("PASSWD", pwd);
        }
        if (sso != null) {
            this.mConnectionInfo.setProperty("MYSAPSSO2", sso);
        }
        return logConnectionString;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void getUserProfiles() throws JBapiException {
        StringBuilder buff;
        block10: {
            if (SNWODPLog.isOn("Connection", LogLevel.TRACE).booleanValue()) {
                SNWODPLog.getLogger("Connection").log(LogLevel.TRACE, "Get User Profiles");
            }
            if (this.uid == null || this.uid.length() < 1) {
                this.uid = "";
                this.userProfileHash = "";
                return;
            }
            TreeSet<String> sortedProfiles = this.getProfilesSet();
            buff = new StringBuilder("");
            if (sortedProfiles.isEmpty()) {
                String sso;
                if (this.mConnectionInfo == null) {
                    this.mConnectionInfo = new SNWODPLogonInfo();
                    this.mConnectionInfo.parseConnectionParams(this.getConnectionParameters());
                }
                if ((sso = this.mConnectionInfo.getProperty("MYSAPSSO2")) != null && sso.length() != 0) {
                    buff.append(sso);
                    break block10;
                } else {
                    this.userProfileHash = "";
                    return;
                }
            }
            Iterator<String> iter = sortedProfiles.iterator();
            while (iter.hasNext()) {
                buff.append(iter.next());
                buff.append("|");
            }
        }
        try {
            String utf8 = UTF8;
            MessageDigest digest = MessageDigest.getInstance(SHA1);
            digest.reset();
            byte[] hash = digest.digest(buff.toString().getBytes(UTF8));
            this.userProfileHash = new String(hash, UTF8);
            return;
        }
        catch (NoSuchAlgorithmException nsae) {
            throw new JBapiException(SHA1_ERROR);
        }
        catch (UnsupportedEncodingException uee) {
            throw new JBapiException(EXPORT_ERROR);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TreeSet<String> getProfilesSet() {
        JBapiFunction getProfiles = new JBapiFunction("BAPI_USER_GET_DETAIL", this.mConnect);
        getProfiles.setParam("USERNAME", this.uid);
        getProfiles.execute(0, true);
        JBapiTable profiles = getProfiles.getTable("PROFILES");
        TreeSet<String> sortedProfiles = null;
        try {
            int numRows = profiles.getNumRows();
            sortedProfiles = new TreeSet<String>();
            for (int row = 0; row < numRows; ++row) {
                profiles.moveTo(row);
                if (!"A".equals(profiles.getFieldByIndex(3))) continue;
                sortedProfiles.add(profiles.getFieldByIndex(0));
            }
        }
        finally {
            profiles.release();
        }
        return sortedProfiles;
    }

    public String getUserProfileHashCode() {
        if (this.userProfileHash.equals(UNKNOWN_PROFILE)) {
            this.getUserProfiles();
        }
        return this.userProfileHash;
    }

    public String getUserID() {
        return this.uid;
    }

    public JBapiConnect getConnect() {
        return this.mConnect;
    }

    public void disconnect() throws SNWODPException {
        try {
            if (SNWODPLog.isOn("Connection", LogLevel.TRACE).booleanValue()) {
                SNWODPLog.getLogger("Connection").log(LogLevel.TRACE, "Disconnecting from SAP.  Handle: " + this.mConnect.getHandle());
            }
            this.mConnect.disconnect();
            this.mIsConnected.compareAndSet(true, false);
        }
        catch (JBapiException e) {
            throw new SNWODPException(SNWODPMessageKeys.ERR_BAPI_DISCONNECTION_ERROR, e);
        }
    }

    public boolean isConnected() {
        return this.mIsConnected.get();
    }

    public Object getDataSetID() {
        return this.mDatasetID;
    }

    public void setDataSetID(Object dsID) {
        if (SNWODPLog.isOn("DataQuery", LogLevel.TRACE).booleanValue()) {
            if (dsID != null) {
                SNWODPLog.getLogger("DataQuery").log(LogLevel.TRACE, "Setting DataSet ID to " + dsID.toString() + STR_FORHANDLE + this.mConnect.getHandle());
            } else {
                SNWODPLog.getLogger("DataQuery").log(LogLevel.TRACE, "Setting DataSet ID to NULL for Handle: " + this.mConnect.getHandle());
            }
        }
        this.mDatasetID = dsID;
    }

    public String getEffectiveDate() {
        return this.effectiveDate;
    }

    public void setEffectiveDate(String date) {
        if (SNWODPLog.isOn("Connection", LogLevel.TRACE).booleanValue()) {
            SNWODPLog.getLogger("Connection").log(LogLevel.TRACE, "Setting Connection KeyDate to " + date + STR_FORHANDLE + this.mConnect.getHandle());
        }
        this.effectiveDate = date;
    }

    public String getSAPSystemVersion() throws SNWODPException {
        try {
            if (this.mConnect != null && this.mIsConnected.get()) {
                return this.mConnect.getSAPSystemVersion();
            }
        }
        catch (JBapiException e) {
            throw new SNWODPException(SNWODPMessageKeys.ERR_GET_SYS_VER, e);
        }
        throw new SNWODPException(SNWODPMessageKeys.ERR_NO_CONNECT_SYS_VER);
    }

    public String getSAPKernelVersion() throws SNWODPException {
        try {
            if (this.mConnect != null && this.mIsConnected.get()) {
                return this.mConnect.getSAPKernelVersion();
            }
        }
        catch (JBapiException e) {
            throw new SNWODPException(SNWODPMessageKeys.ERR_GET_KERNEL_VER, e);
        }
        throw new SNWODPException(SNWODPMessageKeys.ERR_NO_CONNECT_KERNEL_VER);
    }

    public long getSAPConnectionHandle() {
        if (this.mConnect != null && this.mIsConnected.get()) {
            return this.mConnect.getHandle();
        }
        return 0L;
    }

    public List<XQEMessage> getConnectionDetails() {
        return this.checkAndGetDetails("SAPKernelVersion", this.getSAPKernelVersion(), "SAPSystemVersion", this.getSAPSystemVersion());
    }

    public List<XQEMessage> getConnectionBlackListDetails() {
        return this.checkAndGetBlackListDetails(this.getSAPKernelVersion(), this.getSAPSystemVersion());
    }
}

